/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.text.JTextComponent;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int directoryOpenButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String directoryOpenButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String directoryOpenButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction = new NewFolderAction();
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private JFileChooser filechooser = null;
    private boolean directorySelected = false;
    private File directory = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private BasicDirectoryModel model = null;
    private BasicFileView fileView = new BasicFileView();
    private JPanel accessoryPanel = null;
    private static final TransferHandler defaultTransferHandler = new FileTransferHandler();

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.clearIconCache();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.getModel());
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("FileChooser.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicFileChooserUI.this.getFileChooser().cancelSelection();
            }

            public boolean isEnabled() {
                return BasicFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
        TransferHandler transferHandler = jFileChooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            jFileChooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        Locale locale = jFileChooser.getLocale();
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", locale);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", locale);
        this.saveButtonText = UIManager.getString((Object)"FileChooser.saveButtonText", locale);
        this.openButtonText = UIManager.getString((Object)"FileChooser.openButtonText", locale);
        this.saveDialogTitleText = UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale);
        this.openDialogTitleText = UIManager.getString((Object)"FileChooser.openDialogTitleText", locale);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", locale);
        this.updateButtonText = UIManager.getString((Object)"FileChooser.updateButtonText", locale);
        this.helpButtonText = UIManager.getString((Object)"FileChooser.helpButtonText", locale);
        this.directoryOpenButtonText = UIManager.getString((Object)"FileChooser.directoryOpenButtonText", locale);
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.updateButtonMnemonic = UIManager.getInt("FileChooser.updateButtonMnemonic");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.directoryOpenButtonMnemonic = UIManager.getInt("FileChooser.directoryOpenButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString((Object)"FileChooser.saveButtonToolTipText", locale);
        this.openButtonToolTipText = UIManager.getString((Object)"FileChooser.openButtonToolTipText", locale);
        this.cancelButtonToolTipText = UIManager.getString((Object)"FileChooser.cancelButtonToolTipText", locale);
        this.updateButtonToolTipText = UIManager.getString((Object)"FileChooser.updateButtonToolTipText", locale);
        this.helpButtonToolTipText = UIManager.getString((Object)"FileChooser.helpButtonToolTipText", locale);
        this.directoryOpenButtonToolTipText = UIManager.getString((Object)"FileChooser.directoryOpenButtonToolTipText", locale);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
        if (jFileChooser.getTransferHandler() instanceof UIResource) {
            jFileChooser.setTransferHandler(null);
        }
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.directoryOpenButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = null;
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
    }

    public void setDirectoryName(String string) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean bl) {
        this.directorySelected = bl;
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File file) {
        this.directory = file;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(jFileChooser);
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        int n = jFileChooser.getApproveButtonMnemonic();
        if (n > 0) {
            return n;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return n;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && string.indexOf(42) >= 0 || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    static class FileTransferHandler
    extends TransferHandler
    implements UIResource {
        FileTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            int n;
            Serializable serializable;
            Object object;
            Object[] objectArray = null;
            if (jComponent instanceof JList) {
                objectArray = ((JList)jComponent).getSelectedValues();
            } else if (jComponent instanceof JTable && (object = ((JTable)(serializable = (JTable)jComponent)).getSelectedRows()) != null) {
                objectArray = new Object[((int[])object).length];
                for (n = 0; n < ((Object)object).length; ++n) {
                    objectArray[n] = ((JTable)serializable).getValueAt((int)object[n], 0);
                }
            }
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            serializable = new StringBuffer();
            object = new StringBuffer();
            ((StringBuffer)object).append("<html>\n<body>\n<ul>\n");
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = objectArray[n];
                String string = object2 == null ? "" : object2.toString();
                ((StringBuffer)serializable).append(string + "\n");
                ((StringBuffer)object).append("  <li>" + string + "\n");
            }
            ((StringBuffer)serializable).deleteCharAt(((StringBuffer)serializable).length() - 1);
            ((StringBuffer)object).append("</ul>\n</body>\n</html>");
            return new FileTransferable(((StringBuffer)serializable).toString(), ((StringBuffer)object).toString(), objectArray);
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        static class FileTransferable
        extends BasicTransferable {
            Object[] fileData;

            FileTransferable(String string, String string2, Object[] objectArray) {
                super(string, string2);
                this.fileData = objectArray;
            }

            protected DataFlavor[] getRicherFlavors() {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
                return dataFlavorArray;
            }

            protected Object getRicherData(DataFlavor dataFlavor) {
                if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < this.fileData.length; ++i) {
                        arrayList.add(this.fileData[i]);
                    }
                    return arrayList;
                }
                return null;
            }
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache = new Hashtable();

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public String getName(File file) {
            String string = null;
            if (file != null) {
                string = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(file);
            }
            return string;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getTypeDescription(File file) {
            String string = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(file);
            if (string == null) {
                string = file.isDirectory() ? BasicFileChooserUI.this.directoryDescriptionText : BasicFileChooserUI.this.fileDescriptionText;
            }
            return string;
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = BasicFileChooserUI.this.fileIcon;
            if (file != null) {
                FileSystemView fileSystemView = BasicFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fileSystemView.isFloppyDrive(file)) {
                    icon = BasicFileChooserUI.this.floppyDriveIcon;
                } else if (fileSystemView.isDrive(file)) {
                    icon = BasicFileChooserUI.this.hardDriveIcon;
                } else if (fileSystemView.isComputerNode(file)) {
                    icon = BasicFileChooserUI.this.computerIcon;
                } else if (file.isDirectory()) {
                    icon = BasicFileChooserUI.this.directoryIcon;
                }
            }
            this.cacheIcon(file, icon);
            return icon;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString((Object)"FileChooser.acceptAllFileFilterText", BasicFileChooserUI.this.getFileChooser().getLocale());
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(BasicFileChooserUI.this.getDirectoryName()));
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl = File.separatorChar == '\\';
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            this.globPattern = string;
            if (bl) {
                int n2 = cArray.length;
                if (string.endsWith("*.*")) {
                    n2 -= 2;
                }
                block15: for (int i = 0; i < n2; ++i) {
                    switch (cArray[i]) {
                        case '*': {
                            cArray2[n++] = 46;
                            cArray2[n++] = 42;
                            continue block15;
                        }
                        case '\\': {
                            cArray2[n++] = 92;
                            cArray2[n++] = 92;
                            continue block15;
                        }
                        default: {
                            if ("+()^$.{}[]".indexOf(cArray[i]) >= 0) {
                                cArray2[n++] = 92;
                            }
                            cArray2[n++] = cArray[i];
                        }
                    }
                }
            } else {
                block16: for (int i = 0; i < cArray.length; ++i) {
                    switch (cArray[i]) {
                        case '*': {
                            if (!bl2) {
                                cArray2[n++] = 46;
                            }
                            cArray2[n++] = 42;
                            continue block16;
                        }
                        case '?': {
                            cArray2[n++] = bl2 ? 63 : 46;
                            continue block16;
                        }
                        case '[': {
                            bl2 = true;
                            cArray2[n++] = cArray[i];
                            if (i >= cArray.length - 1) continue block16;
                            switch (cArray[i + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    cArray2[n++] = cArray[++i];
                                }
                            }
                            continue block16;
                        }
                        case ']': {
                            cArray2[n++] = cArray[i];
                            bl2 = false;
                            continue block16;
                        }
                        case '\\': {
                            if (i == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n++] = cArray[++i];
                                continue block16;
                            }
                            cArray2[n++] = 92;
                            if (i < cArray.length - 1 && "*?[]".indexOf(cArray[i + 1]) >= 0) {
                                cArray2[n++] = cArray[++i];
                                continue block16;
                            }
                            cArray2[n++] = 92;
                            continue block16;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[i])) {
                                cArray2[n++] = 92;
                            }
                            cArray2[n++] = cArray[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n), 2);
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (BasicFileChooserUI.this.isDirectorySelected() && (serializable = BasicFileChooserUI.this.getDirectory()) != null) {
                try {
                    serializable = ((File)serializable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BasicFileChooserUI.this.getFileChooser().setCurrentDirectory((File)serializable);
                return;
            }
            serializable = BasicFileChooserUI.this.getFileChooser();
            String string = BasicFileChooserUI.this.getFileName();
            FileSystemView fileSystemView = ((JFileChooser)serializable).getFileSystemView();
            File file = ((JFileChooser)serializable).getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                BasicFileChooserUI.this.resetGlobFilter();
                return;
            }
            File file2 = null;
            File[] fileArray = null;
            if (string != null && !string.equals("")) {
                int n;
                if (File.separatorChar == '/') {
                    if (string.startsWith("~/")) {
                        string = System.getProperty("user.home") + string.substring(1);
                    } else if (string.equals("~")) {
                        string = System.getProperty("user.home");
                    }
                }
                if (string.charAt(0) == '\\' || string.charAt(0) == '/') {
                    boolean bl = false;
                    for (n = 1; n < string.length(); ++n) {
                        if (string.charAt(n) != '\\' && string.charAt(n) != '/') {
                            bl = false;
                            break;
                        }
                        bl = true;
                    }
                    if (bl) {
                        string = "";
                    }
                }
                if (((JFileChooser)serializable).isMultiSelectionEnabled() && string.startsWith("\"")) {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    if ((string = string.substring(1)).endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    Object[] objectArray = null;
                    int n2 = 0;
                    do {
                        String string2;
                        int n3;
                        if ((n3 = string.indexOf("\" \"")) > 0) {
                            string2 = string.substring(0, n3);
                            string = string.substring(n3 + 3);
                        } else {
                            string2 = string;
                            string = "";
                        }
                        Object object = fileSystemView.createFileObject(string2);
                        if (!((File)object).isAbsolute()) {
                            if (objectArray == null) {
                                objectArray = fileSystemView.getFiles(file, false);
                                Arrays.sort(objectArray);
                            }
                            for (int i = 0; i < objectArray.length; ++i) {
                                int n4 = (n2 + i) % objectArray.length;
                                if (!((File)objectArray[n4]).getName().equals(string2)) continue;
                                object = objectArray[n4];
                                n2 = n4 + 1;
                                break;
                            }
                        }
                        arrayList.add((File)object);
                    } while (string.length() > 0);
                    if (arrayList.size() > 0) {
                        fileArray = arrayList.toArray(new File[arrayList.size()]);
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                } else {
                    file2 = fileSystemView.createFileObject(string);
                    if (!file2.isAbsolute()) {
                        file2 = fileSystemView.getChild(file, string);
                    }
                    FileFilter fileFilter = ((JFileChooser)serializable).getFileFilter();
                    if (!file2.exists() && BasicFileChooserUI.isGlobPattern(string)) {
                        if (BasicFileChooserUI.this.globFilter == null) {
                            BasicFileChooserUI.this.globFilter = new GlobFilter();
                        }
                        try {
                            BasicFileChooserUI.this.globFilter.setPattern(string);
                            if (!(fileFilter instanceof GlobFilter)) {
                                BasicFileChooserUI.this.actualFileFilter = fileFilter;
                            }
                            ((JFileChooser)serializable).setFileFilter(null);
                            ((JFileChooser)serializable).setFileFilter(BasicFileChooserUI.this.globFilter);
                            return;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                    n = file2 != null && file2.isDirectory() ? 1 : 0;
                    boolean bl = file2 != null && ((JFileChooser)serializable).isTraversable(file2);
                    boolean bl2 = ((JFileChooser)serializable).isDirectorySelectionEnabled();
                    boolean bl3 = ((JFileChooser)serializable).isFileSelectionEnabled();
                    if (n != 0 && bl && !bl2) {
                        ((JFileChooser)serializable).setCurrentDirectory(file2);
                        return;
                    }
                    if (!(n == 0 && bl3 || n != 0 && bl2 || bl2 && !file2.exists())) {
                        file2 = null;
                    }
                }
            }
            if (fileArray != null || file2 != null) {
                if (fileArray != null) {
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                } else if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(new File[]{file2});
                } else {
                    ((JFileChooser)serializable).setSelectedFile(file2);
                }
                ((JFileChooser)serializable).approveSelection();
            } else {
                if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(null);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(null);
                }
                ((JFileChooser)serializable).cancelSelection();
            }
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null || !(component instanceof JTextComponent)) {
                BasicFileChooserUI.this.getFileChooser().changeToParentDirectory();
            }
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().getHomeDirectory());
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
                if (jFileChooser.isMultiSelectionEnabled()) {
                    jFileChooser.setSelectedFiles(new File[]{file2});
                } else {
                    jFileChooser.setSelectedFile(file2);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, BasicFileChooserUI.this.newFolderErrorText + BasicFileChooserUI.this.newFolderErrorSeparator + iOException, BasicFileChooserUI.this.newFolderErrorText, 0);
                return;
            }
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        /*
         * Unable to fully structure code
         */
        public void valueChanged(ListSelectionEvent var1_1) {
            block7: {
                block8: {
                    block9: {
                        if (var1_1.getValueIsAdjusting()) break block7;
                        var2_2 = BasicFileChooserUI.this.getFileChooser();
                        var3_3 = (JList)var1_1.getSource();
                        if (!var2_2.isMultiSelectionEnabled()) break block8;
                        var4_4 = null;
                        var5_6 = var3_3.getSelectedValues();
                        if (var5_6 == null) break block9;
                        if (var5_6.length != 1 || !((File)var5_6[0]).isDirectory() || !var2_2.isTraversable((File)var5_6[0])) ** GOTO lbl-1000
                        if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem((File)var5_6[0])) {
                            BasicFileChooserUI.this.setDirectorySelected(true);
                            BasicFileChooserUI.this.setDirectory((File)var5_6[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var6_7 = new ArrayList<File>(var5_6.length);
                            for (var7_8 = 0; var7_8 < var5_6.length; ++var7_8) {
                                var8_9 = (File)var5_6[var7_8];
                                if ((!var2_2.isFileSelectionEnabled() || !var8_9.isFile()) && (!var2_2.isDirectorySelectionEnabled() || !var8_9.isDirectory())) continue;
                                var6_7.add(var8_9);
                            }
                            if (var6_7.size() > 0) {
                                var4_4 = var6_7.toArray(new File[var6_7.size()]);
                            }
                            BasicFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    var2_2.setSelectedFiles(var4_4);
                    break block7;
                }
                var4_5 = (File)var3_3.getSelectedValue();
                if (var4_5 == null || !var4_5.isDirectory() || !var2_2.isTraversable(var4_5)) ** GOTO lbl-1000
                if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem(var4_5)) {
                    BasicFileChooserUI.this.setDirectorySelected(true);
                    BasicFileChooserUI.this.setDirectory(var4_5);
                } else lbl-1000:
                // 2 sources

                {
                    BasicFileChooserUI.this.setDirectorySelected(false);
                    if (var4_5 != null) {
                        var2_2.setSelectedFile(var4_5);
                    }
                }
            }
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TransferHandler transferHandler;
            TransferHandler transferHandler2 = BasicFileChooserUI.this.filechooser.getTransferHandler();
            if (transferHandler2 != (transferHandler = this.list.getTransferHandler())) {
                this.list.setTransferHandler(transferHandler2);
            }
            if (BasicFileChooserUI.this.filechooser.getDragEnabled() != this.list.getDragEnabled()) {
                this.list.setDragEnabled(BasicFileChooserUI.this.filechooser.getDragEnabled());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                    if (BasicFileChooserUI.this.getFileChooser().getFileSelectionMode() == 2 && BasicFileChooserUI.this.getFileChooser().getFileSystemView().isFileSystem(file)) {
                        BasicFileChooserUI.this.setFileName(file.toString());
                    }
                } else {
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }
    }
}

