/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu = null;
    static boolean menuKeyboardHelperInstalled = false;
    static MenuKeyboardHelper menuKeyboardHelper = null;
    private static transient MouseGrabber mouseGrabber = null;
    private transient PopupMenuListener basicPopupMenuListener = null;

    private static boolean checkInvokerEqual(MenuElement menuElement, MenuElement menuElement2) {
        Component component = menuElement.getComponent();
        Component component2 = menuElement2.getComponent();
        if (component instanceof JPopupMenu) {
            component = ((JPopupMenu)component).getInvoker();
        }
        if (component2 instanceof JPopupMenu) {
            component2 = ((JPopupMenu)component2).getInvoker();
        }
        return component == component2;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.popupMenu.setOpaque(true);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    protected void installListeners() {
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (this.basicPopupMenuListener == null) {
            this.basicPopupMenuListener = this.createPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.basicPopupMenuListener);
        boolean bl = false;
        if (!menuKeyboardHelperInstalled) {
            if (menuKeyboardHelper == null) {
                menuKeyboardHelper = new MenuKeyboardHelper();
                bl = true;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(menuKeyboardHelper);
        }
        if (!bl && UIManager.get("PopupMenu.actionMap") == null) {
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", menuKeyboardHelper.menuActionMap);
        }
    }

    protected void installKeyboardActions() {
    }

    static InputMap getInputMap(JPopupMenu jPopupMenu, JComponent jComponent) {
        ComponentInputMap componentInputMap = null;
        Object[] objectArray = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (objectArray != null) {
            Object[] objectArray2;
            componentInputMap = LookAndFeel.makeComponentInputMap(jComponent, objectArray);
            if (!jPopupMenu.getComponentOrientation().isLeftToRight() && (objectArray2 = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft")) != null) {
                ComponentInputMap componentInputMap2 = LookAndFeel.makeComponentInputMap(jComponent, objectArray2);
                ((InputMap)componentInputMap2).setParent(componentInputMap);
                componentInputMap = componentInputMap2;
            }
        }
        return componentInputMap;
    }

    static ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap");
        if (actionMap == null && (actionMap = BasicPopupMenuUI.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", actionMap);
        }
        return actionMap;
    }

    static ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        actionMapUIResource.put("cancel", new CancelAction());
        actionMapUIResource.put("selectNext", new SelectNextItemAction(SelectNextItemAction.FORWARD));
        actionMapUIResource.put("selectPrevious", new SelectNextItemAction(SelectNextItemAction.BACKWARD));
        actionMapUIResource.put("selectParent", new SelectParentChildAction(SelectParentChildAction.PARENT));
        actionMapUIResource.put("selectChild", new SelectParentChildAction(SelectParentChildAction.CHILD));
        actionMapUIResource.put("return", new ReturnAction());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallListeners() {
        if (this.basicPopupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.basicPopupMenuListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private static Window getWindow(Component component) {
        Component component2;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
        }
        return (Window)component2;
    }

    private static MenuElement getFirstPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        MenuElement menuElement = null;
        for (int i = 0; menuElement == null && i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
            menuElement = menuElementArray[i];
        }
        return menuElement;
    }

    private static JPopupMenu getLastPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        JPopupMenu jPopupMenu = null;
        for (int i = menuElementArray.length - 1; jPopupMenu == null && i >= 0; --i) {
            if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
            jPopupMenu = (JPopupMenu)menuElementArray[i];
        }
        return jPopupMenu;
    }

    private static List getPopups() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        ArrayList<JPopupMenu> arrayList = new ArrayList<JPopupMenu>(menuElementArray.length);
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
            arrayList.add((JPopupMenu)menuElementArray[i]);
        }
        return arrayList;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new BasicPopupMenuListener();
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            Component component;
            if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled()) continue;
            return menuElementArray[i];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
        for (int i = n; i >= n2; --i) {
            Component component;
            if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled()) continue;
            return menuElementArray[i];
        }
        return null;
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, int n, boolean bl) {
        MenuElement menuElement = null;
        if (bl) {
            menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, n + 1, menuElementArray.length - 1);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, 0, n - 1);
            }
        } else {
            menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, n - 1, 0);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n + 1);
            }
        }
        return menuElement;
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl) {
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] != menuElement) continue;
            return BasicPopupMenuUI.findEnabledChild(menuElementArray, i, bl);
        }
        return null;
    }

    private static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = BasicPopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;
        private FocusListener rootPaneFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    lastFocused = component;
                }
                focusEvent.getComponent().removeFocusListener(this);
            }
        };

        private MenuKeyboardHelper() {
        }

        void removeItems() {
            if (this.lastFocused != null) {
                Window window;
                if (!this.lastFocused.requestFocusInWindow() && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && "###focusableSwingPopup###".equals(window.getName())) {
                    this.lastFocused.requestFocus();
                }
                this.lastFocused = null;
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(menuKeyboardHelper);
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
                this.invokerRootPane = null;
            }
            this.receivedKeyPressed = false;
        }

        JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            for (int i = menuElementArray.length - 1; i >= 0; --i) {
                MenuElement menuElement = menuElementArray[i];
                if (!(menuElement instanceof JPopupMenu)) continue;
                return (JPopupMenu)menuElement;
            }
            return null;
        }

        void addUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2;
            InputMap inputMap3 = null;
            for (inputMap2 = jComponent.getInputMap(2); inputMap2 != null && !(inputMap2 instanceof UIResource); inputMap2 = inputMap2.getParent()) {
                inputMap3 = inputMap2;
            }
            if (inputMap3 == null) {
                jComponent.setInputMap(2, inputMap);
            } else {
                inputMap3.setParent(inputMap);
            }
            inputMap.setParent(inputMap2);
        }

        void addUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2;
            ActionMap actionMap3 = null;
            for (actionMap2 = jComponent.getActionMap(); actionMap2 != null && !(actionMap2 instanceof UIResource); actionMap2 = actionMap2.getParent()) {
                actionMap3 = actionMap2;
            }
            if (actionMap3 == null) {
                jComponent.setActionMap(actionMap);
            } else {
                actionMap3.setParent(actionMap);
            }
            actionMap.setParent(actionMap2);
        }

        void removeUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            for (InputMap inputMap3 = jComponent.getInputMap(2); inputMap3 != null; inputMap3 = inputMap3.getParent()) {
                if (inputMap3 == inputMap) {
                    if (inputMap2 == null) {
                        jComponent.setInputMap(2, inputMap.getParent());
                        break;
                    }
                    inputMap2.setParent(inputMap.getParent());
                    break;
                }
                inputMap2 = inputMap3;
            }
        }

        void removeUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            for (ActionMap actionMap3 = jComponent.getActionMap(); actionMap3 != null; actionMap3 = actionMap3.getParent()) {
                if (actionMap3 == actionMap) {
                    if (actionMap2 == null) {
                        jComponent.setActionMap(actionMap.getParent());
                        break;
                    }
                    actionMap2.setParent(actionMap.getParent());
                    break;
                }
                actionMap2 = actionMap3;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent changeEvent) {
            if (!(UIManager.getLookAndFeel() instanceof BasicLookAndFeel)) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.removeChangeListener(this);
                menuKeyboardHelperInstalled = false;
                return;
            }
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu != null && !jPopupMenu.isFocusable()) {
                return;
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !BasicPopupMenuUI.checkInvokerEqual(menuElementArray[0], this.lastPathSelected[0])) {
                this.removeItems();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length > 0) {
                void var5_10;
                if (jPopupMenu == null) {
                    if (menuElementArray.length != 2 || !(menuElementArray[0] instanceof JMenuBar) || !(menuElementArray[1] instanceof JMenu)) return;
                    JComponent jComponent = (JComponent)((Object)menuElementArray[1]);
                    jPopupMenu = ((JMenu)jComponent).getPopupMenu();
                } else {
                    Component component = jPopupMenu.getInvoker();
                    if (component instanceof JFrame) {
                        JRootPane jRootPane = ((JFrame)component).getRootPane();
                    } else if (component instanceof JApplet) {
                        JRootPane jRootPane = ((JApplet)component).getRootPane();
                    } else {
                        while (!(component instanceof JComponent)) {
                            if (component == null) {
                                return;
                            }
                            component = component.getParent();
                        }
                        JComponent jComponent = (JComponent)component;
                    }
                }
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane((Component)var5_10);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(menuKeyboardHelper);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = BasicPopupMenuUI.getInputMap(jPopupMenu, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.removeItems();
            } else if (jPopupMenu != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = menuElementArray;
            this.lastPopup = jPopupMenu;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }
    }

    private static class SelectParentChildAction
    extends AbstractAction {
        static boolean PARENT = false;
        static boolean CHILD = true;
        boolean direction;

        SelectParentChildAction(boolean bl) {
            this.direction = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (this.direction == PARENT) {
                int n2 = n - 1;
                if (n > 2 && (menuElementArray[n2] instanceof JPopupMenu || menuElementArray[--n2] instanceof JPopupMenu) && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n2);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n > 0 && menuElementArray[n - 1] instanceof JMenu && !((JMenu)menuElementArray[n - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n + 1];
                } else {
                    menuElementArray3 = new MenuElement[n + 2];
                    menuElementArray3[n + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n);
                menuElementArray3[n] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = BasicPopupMenuUI.findEnabledChild(menuElementArray[0].getSubElements(), menuElement, this.direction);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5 = n == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : new MenuElement[]{menuElementArray[0], menuElement2, ((JMenu)menuElement2).getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        static boolean FORWARD = true;
        static boolean BACKWARD = false;
        boolean direction;

        SelectNextItemAction(boolean bl) {
            this.direction = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (n < 2) {
                MenuElement menuElement;
                MenuElement menuElement2;
                MenuElement[] menuElementArray2;
                if (n == 1 && menuElementArray[0].getComponent() instanceof JPopupMenu && (menuElementArray2 = (menuElement2 = menuElementArray[0]).getSubElements()).length > 0 && (menuElement = BasicPopupMenuUI.findEnabledChild(menuElement2.getSubElements(), -1, this.direction)) != null) {
                    MenuElement[] menuElementArray3 = new MenuElement[]{menuElement2, menuElement};
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                }
                return;
            }
            if (menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu && n == 2) {
                MenuElement[] menuElementArray4;
                JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, SelectNextItemAction.FORWARD);
                if (menuElement != null) {
                    menuElementArray4 = new MenuElement[4];
                    menuElementArray4[3] = menuElement;
                } else {
                    menuElementArray4 = new MenuElement[3];
                }
                System.arraycopy(menuElementArray, 0, menuElementArray4, 0, 2);
                menuElementArray4[2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray4);
            } else if (menuElementArray[n - 1] instanceof JPopupMenu && menuElementArray[n - 2] instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray[n - 2];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, this.direction);
                if (menuElement != null) {
                    MenuElement[] menuElementArray5 = new MenuElement[n + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray5, 0, n);
                    menuElementArray5[n] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                } else if (n > 2 && menuElementArray[n - 3] instanceof JPopupMenu && (menuElement = BasicPopupMenuUI.findEnabledChild((jPopupMenu = (JPopupMenu)menuElementArray[n - 3]).getSubElements(), jMenu, this.direction)) != null && menuElement != jMenu) {
                    MenuElement[] menuElementArray6 = new MenuElement[n - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray6, 0, n - 2);
                    menuElementArray6[n - 2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray6);
                }
            } else {
                MenuElement[] menuElementArray7 = menuElementArray[n - 2].getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray7, menuElementArray[n - 1], this.direction);
                if (menuElement == null) {
                    menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray7, -1, this.direction);
                }
                if (menuElement != null) {
                    menuElementArray[n - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
    }

    private static class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (component != null && !(component instanceof JRootPane)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray;
            JPopupMenu jPopupMenu = BasicPopupMenuUI.getLastPopup();
            if (jPopupMenu != null) {
                jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()).length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class BasicPopupMenuListener
    implements PopupMenuListener {
        private BasicPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Action action;
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            ActionMap actionMap = jPopupMenu.getActionMap();
            if (actionMap != null && (action = actionMap.get("PopupMenu.popupSound")) != null) {
                BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
                basicLookAndFeel.playSound(action);
            }
        }
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    WindowListener,
    WindowFocusListener,
    ComponentListener,
    ChangeListener {
        Vector grabbed = new Vector();
        MenuElement lastGrabbed = null;
        boolean lastGrabbedMenuBarChild = false;
        MenuElement[] lastPathSelected = new MenuElement[0];

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
        }

        private void requestAddGrab(Component component) {
            Window window = BasicPopupMenuUI.getWindow(component);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            Component component2 = null;
            for (int i = 0; component2 == null && i < menuElementArray.length; ++i) {
                if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
                component2 = menuElementArray[i].getComponent();
            }
            this.grabContainer(window, component2);
        }

        private void requestRemoveGrab() {
            this.ungrabContainers();
        }

        void cancelPopupMenu() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = (JPopupMenu)BasicPopupMenuUI.getFirstPopup();
            if (this.lastGrabbed == jPopupMenu) {
                List list = BasicPopupMenuUI.getPopups();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JPopupMenu jPopupMenu2 = (JPopupMenu)iterator.next();
                    jPopupMenu2.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.ungrabContainers();
            } else {
                this.lastGrabbed = jPopupMenu;
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !BasicPopupMenuUI.checkInvokerEqual(menuElementArray[0], this.lastPathSelected[0])) {
                this.requestRemoveGrab();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                Component component = menuElementArray[0].getComponent();
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.requestAddGrab(component);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.requestRemoveGrab();
            }
            if (menuElementArray != null && menuElementArray.length > 2 && menuElementArray[0] instanceof JMenuBar && this.lastGrabbedMenuBarChild && this.lastGrabbed != BasicPopupMenuUI.getFirstPopup()) {
                this.lastGrabbed = BasicPopupMenuUI.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
            this.lastPathSelected = menuElementArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            this.lastGrabbed = BasicPopupMenuUI.getFirstPopup();
            this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            Component component2 = null;
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addWindowFocusListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            } else if (container instanceof JRootPane && ((component2 = ((JRootPane)container).getGlassPane()).getMouseListeners().length > 0 || component2.getMouseMotionListeners().length > 0 || component2.getMouseWheelListeners().length > 0)) {
                component2 = null;
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                for (int i = 0; i < n; ++i) {
                    Component component3 = componentArray[i];
                    if (!component3.isVisible()) continue;
                    if (component3 != component2) {
                        component3.addMouseListener(this);
                        component3.addMouseMotionListener(this);
                        component3.addMouseWheelListener(this);
                        this.grabbed.addElement(component3);
                    }
                    if (!(component3 instanceof Container)) continue;
                    Container container2 = (Container)component3;
                    this.grabContainer(container2, component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ungrabContainers() {
            Vector vector = this.grabbed;
            synchronized (vector) {
                int n = this.grabbed.size();
                for (int i = 0; i < n; ++i) {
                    Component component = (Component)this.grabbed.elementAt(i);
                    if (component instanceof Window) {
                        ((Window)component).removeWindowListener(this);
                        ((Window)component).removeWindowFocusListener(this);
                        ((Window)component).removeComponentListener(this);
                        continue;
                    }
                    component.removeMouseListener(this);
                    component.removeMouseMotionListener(this);
                    component.removeMouseWheelListener(this);
                }
            }
            this.grabbed = new Vector();
            this.lastGrabbed = null;
            this.lastGrabbedMenuBarChild = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.cancelPopupMenu();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }
    }
}

