/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.BufferCapabilities;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WVolatileImage;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.awt.windows.Win32PeerlessImage;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;

public class Win32GraphicsConfig
extends GraphicsConfiguration {
    Win32GraphicsDevice screen;
    int visual;
    RenderLoops solidloops;
    private static BufferCapabilities bufferCaps;
    private static ImageCapabilities imageCaps;
    private static final int DCM_4444_RED_MASK = 3840;
    private static final int DCM_4444_GRN_MASK = 240;
    private static final int DCM_4444_BLU_MASK = 15;
    private static final int DCM_4444_ALP_MASK = 61440;
    static ColorModel translucentCM;

    private static native void initIDs();

    public static Win32GraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        return new Win32GraphicsConfig(win32GraphicsDevice, n);
    }

    public Win32GraphicsConfig(GraphicsDevice graphicsDevice, int n) {
        this.screen = (Win32GraphicsDevice)graphicsDevice;
        this.visual = n;
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
        }
        return this.solidloops;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        int n3 = n * n2;
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        if (Win32PeerlessImage.isValidOpaqueConfig(colorModel, colorModel, n3)) {
            return new Win32PeerlessImage(colorModel, colorModel, writableRaster, colorModel.isAlphaPremultiplied(), 1);
        }
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        return new WVolatileImage(this, n, n2);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        int n4 = n * n2;
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: {
                ColorModel colorModel = this.getColorModel(n3);
                ColorModel colorModel2 = this.getColorModel();
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                if (Win32PeerlessImage.isValidBitmaskConfig(colorModel, colorModel2, n4)) {
                    return new Win32PeerlessImage(colorModel, colorModel2, writableRaster, colorModel.isAlphaPremultiplied(), 2);
                }
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
            case 3: {
                ColorModel colorModel;
                ColorModel colorModel3 = colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                if (Win32PeerlessImage.isValidTranslucentConfig(colorModel, colorModel3, n4)) {
                    return new Win32PeerlessImage(colorModel, colorModel3, writableRaster, colorModel.isAlphaPremultiplied(), 3);
                }
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public synchronized ColorModel getColorModel() {
        return this.screen.getColorModel();
    }

    public ColorModel getDeviceColorModel() {
        return this.screen.getDynamicColorModel();
    }

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return this.getColorModel();
        }
        if (n == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (n == 3) {
            return Win32GraphicsConfig.getTranslucentColorModel();
        }
        return null;
    }

    public static ColorModel getTranslucentColorModel() {
        if (Win32OffScreenSurfaceData.getTextureBpp() == 16) {
            if (translucentCM == null) {
                translucentCM = new DirectColorModel(16, 3840, 240, 15, 61440);
            }
            return translucentCM;
        }
        return ColorModel.getRGBdefault();
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d = this.getXResolution() / 72.0;
        double d2 = this.getYResolution() / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    private double getXResolution() {
        return 72.0;
    }

    private double getYResolution() {
        return 72.0;
    }

    public String toString() {
        return "Win32GraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    private native Rectangle getBounds(int var1);

    public Rectangle getBounds() {
        return this.getBounds(this.screen.getScreen());
    }

    public BufferCapabilities getBufferCapabilities() {
        if (bufferCaps == null) {
            Win32GraphicsConfig win32GraphicsConfig = this;
            bufferCaps = win32GraphicsConfig.screen.isDirectDrawEnabled() ? new DDrawBufferCapabilities(this.getImageCapabilities()) : super.getBufferCapabilities();
        }
        return bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        if (imageCaps == null) {
            Win32GraphicsConfig win32GraphicsConfig = this;
            imageCaps = win32GraphicsConfig.screen.isDirectDrawEnabled() ? new DDrawImageCapabilities() : super.getImageCapabilities();
        }
        return imageCaps;
    }

    static {
        Win32GraphicsConfig.initIDs();
        translucentCM = null;
    }

    private static class DDrawImageCapabilities
    extends ImageCapabilities {
        public DDrawImageCapabilities() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class DDrawBufferCapabilities
    extends BufferCapabilities {
        public DDrawBufferCapabilities(ImageCapabilities imageCapabilities) {
            super(imageCapabilities, imageCapabilities, BufferCapabilities.FlipContents.PRIOR);
        }

        public boolean isFullScreenRequired() {
            return true;
        }

        public boolean isMultiBufferAvailable() {
            return true;
        }
    }
}

