/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.File;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.FontProperties;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.windows.WFontProperties;
import sun.awt.windows.WPrinterJob;
import sun.awt.windows.WToolkit;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.LoadLibraryAction;

public class Win32GraphicsEnvironment
extends SunGraphicsEnvironment
implements DisplayChangedListener {
    SunDisplayChanger displayChanger = new SunDisplayChanger();
    private static boolean displayInitialized;

    private static native void initDisplay();

    public static void initDisplayWrapper() {
        if (!displayInitialized) {
            displayInitialized = true;
            Win32GraphicsEnvironment.initDisplay();
        }
    }

    protected native int getNumScreens();

    protected native int getDefaultScreen();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreen()];
    }

    public void displayChanged() {
        GraphicsDevice[] graphicsDeviceArray = this.resetDisplays();
        WToolkit.resetGC();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (!(graphicsDeviceArray[i] instanceof Win32GraphicsDevice)) continue;
            ((Win32GraphicsDevice)graphicsDeviceArray[i]).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public synchronized GraphicsDevice[] resetDisplays() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        return graphicsDeviceArray;
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    protected void registerFontsWithPlatform(String string) {
        File file = new File(string);
        String[] stringArray = file.list(new SunGraphicsEnvironment.TTFilter(this));
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            this.registerFontWithPlatform(file2.getAbsolutePath());
        }
    }

    protected native void registerFontWithPlatform(String var1);

    protected native void deRegisterFontWithPlatform(String var1);

    protected String getPlatformFontPath(boolean bl) {
        return NativeFontWrapper.getFontPath(bl);
    }

    protected GraphicsDevice makeScreenDevice(int n) {
        return new Win32GraphicsDevice(n);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new WPrinterJob();
    }

    protected FontProperties createFontProperties() {
        return new WFontProperties();
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        Win32GraphicsEnvironment.initDisplayWrapper();
    }
}

