/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.image.OffScreenImage;
import sun.awt.image.RasterListener;
import sun.awt.image.SunWritableRaster;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.security.action.GetPropertyAction;

public abstract class AcceleratedOffScreenImage
extends OffScreenImage
implements RasterListener {
    protected static boolean accelerationEnabled;
    protected SurfaceData surfaceDataSw = this.surfaceData;
    protected SurfaceData surfaceDataHw;
    protected boolean surfaceLossHw;
    protected boolean localAccelerationEnabled = true;
    protected static boolean allowRasterSteal;
    private static int accelerationThreshold;

    public AcceleratedOffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl) {
        super(component, colorModel, writableRaster, bl);
        if (writableRaster instanceof SunWritableRaster) {
            ((SunWritableRaster)writableRaster).setRasterListener(this);
        } else {
            this.localAccelerationEnabled = false;
        }
    }

    public abstract void initAcceleratedBackground(GraphicsConfiguration var1, int var2, int var3);

    protected Color getBackgroundColor() {
        return null;
    }

    protected void copyBackupToAccelerated() {
        try {
            if (this.surfaceDataHw != null && !this.surfaceLossHw) {
                Color color = this.getBackgroundColor();
                if (color == null) {
                    Blit blit = Blit.getFromCache(this.surfaceDataSw.getSurfaceType(), CompositeType.SrcNoEa, this.surfaceDataHw.getSurfaceType());
                    blit.Blit(this.surfaceDataSw, this.surfaceDataHw, AlphaComposite.Src, null, 0, 0, 0, 0, this.getWidth(), this.getHeight());
                } else {
                    BlitBg blitBg = BlitBg.getFromCache(this.surfaceDataSw.getSurfaceType(), CompositeType.SrcNoEa, this.surfaceDataHw.getSurfaceType());
                    blitBg.BlitBg(this.surfaceDataSw, this.surfaceDataHw, AlphaComposite.SrcOver, null, color, 0, 0, 0, 0, this.getWidth(), this.getHeight());
                }
                this.surfaceDataSw.setNeedsBackup(false);
            }
        }
        catch (Exception exception) {
            this.surfaceLossHw = true;
        }
    }

    public void rasterChanged() {
        this.surfaceDataSw.setNeedsBackup(true);
    }

    public void rasterStolen() {
        if (!allowRasterSteal) {
            this.localAccelerationEnabled = false;
        }
    }

    protected abstract boolean destSurfaceAccelerated(SurfaceData var1);

    protected abstract boolean operationSupported(CompositeType var1, Color var2, boolean var3);

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        if (accelerationEnabled && this.localAccelerationEnabled && surfaceData != this.surfaceDataHw && this.destSurfaceAccelerated(surfaceData) && this.operationSupported(compositeType, color, bl) && this.surfaceDataSw.increaseNumCopies() > accelerationThreshold) {
            this.validate(surfaceData.getDeviceConfiguration());
            if (this.surfaceDataHw != null && !this.surfaceLossHw) {
                return this.surfaceDataHw;
            }
        }
        return this.surfaceDataSw;
    }

    public SurfaceData restoreContents() {
        return this.surfaceDataSw;
    }

    protected void restoreSurfaceDataHw() {
    }

    protected abstract boolean isValidHWSD(GraphicsConfiguration var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(GraphicsConfiguration graphicsConfiguration) {
        if (!accelerationEnabled || !this.localAccelerationEnabled) return;
        if (this.surfaceDataHw == null || !this.isValidHWSD(graphicsConfiguration)) {
            this.initAcceleratedBackground(graphicsConfiguration, this.getWidth(), this.getHeight());
            if (this.surfaceDataHw == null) return;
            this.surfaceDataSw.setNeedsBackup(true);
            this.surfaceLossHw = false;
        } else if (this.surfaceLossHw) {
            try {
                this.restoreSurfaceDataHw();
                this.surfaceLossHw = false;
                this.surfaceDataSw.setNeedsBackup(true);
            }
            catch (InvalidPipeException invalidPipeException) {
                return;
            }
        }
        if (!this.surfaceDataSw.needsBackup()) return;
        this.copyBackupToAccelerated();
    }

    public BufferedImage getSnapshot() {
        return this;
    }

    public static int getAccelerationThreshold() {
        return accelerationThreshold;
    }

    static {
        String string;
        accelerationEnabled = true;
        allowRasterSteal = false;
        accelerationThreshold = 1;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.accthreshold"));
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0) {
                    accelerationThreshold = n;
                    System.out.println("New Acceleration Threshold: " + accelerationThreshold);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error setting new threshold:" + numberFormatException);
            }
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.allowrastersteal"))) != null && string.equals("true")) {
            allowRasterSteal = true;
            System.out.println("Raster steal allowed");
        }
    }
}

