/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.NativeLibLoader;
import sun.awt.image.GifFrame;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.PixelStore8;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    PixelStore8 store;
    boolean cancatchup = true;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int global_width;
    int global_height;
    int global_bgpixel;
    GifFrame curframe;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    public GifImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    public synchronized boolean catchupConsumer(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        return this.cancatchup && (this.store == null || this.store.replay(inputStreamImageSource, imageConsumer));
    }

    public void replayConsumer(ImageConsumer imageConsumer) {
        if (this.store != null) {
            this.store.replay(this.source, imageConsumer, false);
        }
    }

    public synchronized void makeStore(int n, int n2) {
        if (this.cancatchup) {
            this.store = new PixelStore8(n, n2);
        }
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    private int readBytes(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            try {
                int n3 = this.input.read(byArray, n, n2);
                if (n3 < 0) break;
                n += n3;
                n2 -= n3;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n2;
    }

    private static final int ExtractByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    private static final int ExtractWord(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readHeader();
            var1_1 = 0;
            var2_2 = 0;
            var3_3 = -1;
            var4_4 = 0;
            var5_5 = -1;
            var6_6 = false;
            var7_7 = false;
            block24: while (!this.aborted) {
                var8_8 = this.input.read();
                switch (var8_8) {
                    case 33: {
                        var8_8 = this.input.read();
                        switch (var8_8) {
                            case 249: {
                                var9_9 = new byte[6];
                                if (this.readBytes(var9_9, 0, 6) != 0) {
                                    return;
                                }
                                if (var9_9[0] != 4 || var9_9[5] != 0) {
                                    return;
                                }
                                var5_5 = GifImageDecoder.ExtractWord(var9_9, 2) * 10;
                                if (var5_5 > 0 && !var7_7) {
                                    var7_7 = true;
                                    this.cancatchup = false;
                                    this.store = null;
                                    ImageFetcher.startingAnimation();
                                }
                                var4_4 = var9_9[1] >> 2 & 7;
                                if ((var9_9[1] & 1) != 0) {
                                    this.trans_pixel = GifImageDecoder.ExtractByte(var9_9, 4);
                                    continue block24;
                                }
                                this.trans_pixel = -1;
                                continue block24;
                            }
                            default: {
                                var9_10 = false;
                                var10_13 = "";
                                while ((var11_14 = this.input.read()) > 0) {
                                    var12_15 = new byte[var11_14];
                                    if (this.readBytes(var12_15, 0, var11_14) != 0) {
                                        return;
                                    }
                                    if (var8_8 == 254) {
                                        var10_13 = var10_13 + new String(var12_15, 0);
                                        continue;
                                    }
                                    if (var8_8 != 255) continue;
                                    if (var9_10) {
                                        if (var11_14 == 3 && var12_15[0] == 1) {
                                            if (var6_6) {
                                                GifImageDecoder.ExtractWord(var12_15, 1);
                                            } else {
                                                var3_3 = GifImageDecoder.ExtractWord(var12_15, 1);
                                                var6_6 = true;
                                            }
                                        } else {
                                            var9_10 = false;
                                        }
                                    }
                                    if (!"NETSCAPE2.0".equals(new String(var12_15, 0))) continue;
                                    var9_10 = true;
                                }
                                if (var8_8 == 254) {
                                    this.props.put("comment", var10_13);
                                }
                                if (!var9_10 || var7_7) continue block24;
                                var7_7 = true;
                                this.cancatchup = false;
                                this.store = null;
                                ImageFetcher.startingAnimation();
                                continue block24;
                            }
                            ** case -1:
lbl68:
                            // 1 sources

                            break;
                        }
                        return;
                    }
                    case 44: {
                        if (!var7_7) {
                            this.input.mark(0);
                        }
                        try {
                            if (!this.readImage(var1_1 == 0, var4_4, var5_5)) {
                                this.cancatchup = false;
                                return;
                            }
                        }
                        catch (Exception var9_11) {
                            return;
                        }
                        ++var2_2;
                        ++var1_1;
                        continue block24;
                    }
                    default: {
                        if (var2_2 != 0) break;
                        return;
                    }
                    case 59: 
                }
                if (var3_3 == 0 || var3_3-- >= 0) {
                    try {
                        if (this.curframe != null) {
                            this.curframe.dispose();
                            this.curframe = null;
                        }
                        this.input.reset();
                        this.saved_image = null;
                        this.saved_model = null;
                        var2_2 = 0;
                        continue;
                    }
                    catch (IOException var9_12) {
                        this.close();
                        return;
                    }
                }
                if (this.store != null) {
                    this.store.imageComplete();
                    if (this.store.getBitState() != 2) {
                        this.source.setPixelStore(this, this.store);
                    }
                }
                this.imageComplete(3, true);
                return;
            }
        }
        finally {
            this.close();
        }
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] byArray = new byte[13];
        if (this.readBytes(byArray, 0, 13) != 0) {
            throw new IOException();
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(byArray, 6);
        this.global_height = GifImageDecoder.ExtractWord(byArray, 8);
        int n = GifImageDecoder.ExtractByte(byArray, 10);
        if ((n & 0x80) == 0) {
            this.num_global_colors = 2;
            this.global_bgpixel = 0;
            this.global_colormap = new byte[6];
            this.global_colormap[2] = 0;
            this.global_colormap[1] = 0;
            this.global_colormap[0] = 0;
            this.global_colormap[5] = -1;
            this.global_colormap[4] = -1;
            this.global_colormap[3] = -1;
        } else {
            this.num_global_colors = 1 << (n & 7) + 1;
            this.global_bgpixel = GifImageDecoder.ExtractByte(byArray, 11);
            if (byArray[12] != 0) {
                this.props.put("aspectratio", "" + (double)(GifImageDecoder.ExtractByte(byArray, 12) + 15) / 64.0);
            }
            this.global_colormap = new byte[this.num_global_colors * 3];
            if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
                throw new IOException();
            }
        }
        this.input.mark(Integer.MAX_VALUE);
    }

    private static native void initIDs();

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    /*
     * Enabled aggressive block sorting
     */
    private int sendPixels(int n, int n2, int n3, int n4, byte[] byArray, ColorModel colorModel) {
        int n5;
        int n6;
        boolean bl;
        int n7;
        int n8;
        block15: {
            int n9;
            int n10;
            int n11;
            block16: {
                block14: {
                    block12: {
                        block13: {
                            if (n2 < 0) {
                                n4 += n2;
                                n2 = 0;
                            }
                            if (n2 + n4 > this.global_height) {
                                n4 = this.global_height - n2;
                            }
                            if (n4 <= 0) {
                                return 1;
                            }
                            if (n < 0) {
                                n11 = -n;
                                n3 += n;
                                n10 = 0;
                            } else {
                                n11 = 0;
                                n10 = n;
                            }
                            if (n10 + n3 > this.global_width) {
                                n3 = this.global_width - n10;
                            }
                            if (n3 <= 0) {
                                return 1;
                            }
                            n8 = n11 + n3;
                            n7 = n2 * this.global_width + n10;
                            boolean bl2 = bl = this.curframe.disposal_method == 1;
                            if (this.trans_pixel < 0 || this.curframe.initialframe) break block12;
                            if (this.saved_image == null || this.saved_model != colorModel) break block13;
                            break block14;
                        }
                        n6 = -1;
                        n5 = 1;
                        break block15;
                    }
                    if (!bl) break block16;
                    System.arraycopy(byArray, n11, this.saved_image, n7, n3);
                    break block16;
                }
                for (n9 = n11; n9 < n8; ++n9, ++n7) {
                    byte by = byArray[n9];
                    if ((by & 0xFF) == this.trans_pixel) {
                        byArray[n9] = this.saved_image[n7];
                        continue;
                    }
                    if (!bl) continue;
                    this.saved_image[n7] = by;
                }
            }
            n9 = this.setPixels(n10, n2, n3, n4, colorModel, byArray, n11, 0);
            if (this.store == null) return n9;
            if (this.store.setPixels(n10, n2, n3, n4, byArray, n11, 0)) return n9;
            this.store = null;
            return n9;
        }
        for (int i = n11; i < n8; ++i, ++n7) {
            byte by = byArray[i];
            if ((by & 0xFF) == this.trans_pixel) {
                if (n6 >= 0 && (n5 = this.setPixels(n + n6, n2, i - n6, n4, colorModel, byArray, n6, 0)) == 0) break;
                n6 = -1;
                continue;
            }
            if (n6 < 0) {
                n6 = i;
            }
            if (!bl) continue;
            this.saved_image[n7] = by;
        }
        if (n6 < 0) return n5;
        return this.setPixels(n + n6, n2, n8 - n6, n4, colorModel, byArray, n6, 0);
    }

    private boolean readImage(boolean bl, int n, int n2) throws IOException {
        int n3;
        byte[] byArray;
        int n4;
        if (this.curframe != null && !this.curframe.dispose()) {
            this.abort();
            this.store = null;
            return false;
        }
        long l = 0L;
        byte[] byArray2 = new byte[259];
        if (this.readBytes(byArray2, 0, 10) != 0) {
            throw new IOException();
        }
        int n5 = GifImageDecoder.ExtractWord(byArray2, 0);
        int n6 = GifImageDecoder.ExtractWord(byArray2, 2);
        int n7 = GifImageDecoder.ExtractWord(byArray2, 4);
        int n8 = GifImageDecoder.ExtractWord(byArray2, 6);
        boolean bl2 = (byArray2[8] & 0x40) != 0;
        IndexColorModel indexColorModel = this.global_model;
        if ((byArray2[8] & 0x80) != 0) {
            n4 = 1 << (byArray2[8] & 7) + 1;
            byArray = new byte[n4 * 3];
            byArray[0] = byArray2[9];
            if (this.readBytes(byArray, 1, n4 * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(byArray2, 9, 1) != 0) {
                throw new IOException();
            }
            if (this.trans_pixel >= n4) {
                n4 = this.trans_pixel + 1;
                byArray = GifImageDecoder.grow_colormap(byArray, n4);
            }
            indexColorModel = new IndexColorModel(8, n4, byArray, 0, false, this.trans_pixel);
        } else if (indexColorModel == null || this.trans_pixel != indexColorModel.getTransparentPixel()) {
            if (this.trans_pixel >= this.num_global_colors) {
                this.num_global_colors = this.trans_pixel + 1;
                this.global_colormap = GifImageDecoder.grow_colormap(this.global_colormap, this.num_global_colors);
            }
            this.global_model = indexColorModel = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (bl) {
            if (this.global_width == 0) {
                this.global_width = n7;
            }
            if (this.global_height == 0) {
                this.global_height = n8;
            }
            this.makeStore(this.global_width, this.global_height);
            if (this.store != null) {
                this.store.setProperties(this.props);
                this.store.setColorModel(indexColorModel);
            }
            this.setColorModel(indexColorModel);
            this.setDimensions(this.global_width, this.global_height);
            this.setProperties(this.props);
            this.headerComplete();
        } else if (this.store != null && indexColorModel != this.store.getColorModel()) {
            this.cancatchup = false;
            this.store = null;
        }
        if (n == 1 && this.saved_image == null) {
            this.saved_image = new byte[this.global_width * this.global_height];
            if (n8 < this.global_height && indexColorModel != null && (n4 = (int)((byte)indexColorModel.getTransparentPixel())) >= 0) {
                byArray = new byte[this.global_width];
                for (n3 = 0; n3 < this.global_width; n3 += 1) {
                    byArray[n3] = n4;
                }
                this.setPixels(0, 0, this.global_width, n6, (ColorModel)indexColorModel, byArray, 0, 0);
                this.setPixels(0, n6 + n8, this.global_width, this.global_height - n8 - n6, (ColorModel)indexColorModel, byArray, 0, 0);
            }
        }
        n4 = bl2 ? 29 : 30;
        this.setHints(n4);
        if (this.store != null) {
            this.store.setHints(n4);
        }
        this.curframe = new GifFrame(this, n, n2, this.curframe == null, indexColorModel, n5, n6, n7, n8);
        byArray = new byte[n7];
        n3 = this.parseImage(n5, n6, n7, n8, bl2, GifImageDecoder.ExtractByte(byArray2, 9), byArray2, byArray, indexColorModel) ? 1 : 0;
        if (!n3) {
            this.abort();
            this.store = null;
        }
        return n3 != 0;
    }

    public static byte[] grow_colormap(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n * 3];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static {
        NativeLibLoader.loadLibraries();
        GifImageDecoder.initIDs();
    }
}

