/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import sun.awt.EmbeddedFrame;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.windows.WToolkit;

public class WEmbeddedFrame
extends EmbeddedFrame {
    private long handle;
    private int bandWidth = 0;
    private int bandHeight = 0;
    private BufferedImage bandImage = null;
    private static final int MAX_BAND_SIZE = 786432;

    public WEmbeddedFrame() {
        this(0L);
    }

    public WEmbeddedFrame(int n) {
        this((long)n);
    }

    public WEmbeddedFrame(long l) {
        this.handle = l;
        WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
        this.setPeer(wToolkit.createEmbeddedFrame(this));
        this.show();
    }

    void print(int n) {
        int n2 = this.getHeight();
        if (this.bandImage == null) {
            this.bandWidth = this.getWidth();
            if (this.bandWidth % 4 != 0) {
                this.bandWidth += 4 - this.bandWidth % 4;
            }
            if (this.bandWidth <= 0) {
                return;
            }
            this.bandHeight = Math.min(786432 / this.bandWidth, n2);
            this.bandImage = new BufferedImage(this.bandWidth, this.bandHeight, 5);
        }
        Graphics graphics = this.bandImage.getGraphics();
        graphics.setColor(Color.white);
        Graphics graphics2 = this.bandImage.getGraphics();
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)this.bandImage.getRaster();
        byte[] byArray = byteInterleavedRaster.getDataStorage();
        for (int i = 0; i < n2; i += this.bandHeight) {
            graphics.fillRect(0, 0, this.bandWidth, this.bandHeight);
            this.printComponents(graphics2);
            int n3 = this.bandHeight;
            if (i + this.bandHeight > n2) {
                n3 = n2 - i;
            }
            this.printBand(n, byArray, 0, i, this.bandWidth, n3);
            graphics2.translate(0, -this.bandHeight);
        }
    }

    protected native void printBand(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private static native void initIDs();

    static {
        WEmbeddedFrame.initIDs();
    }
}

