/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

public class WFileDialogPeer
extends WWindowPeer
implements FileDialogPeer {
    private long hwnd = 0L;
    private WComponentPeer parent;
    private FilenameFilter fileFilter;

    public void setDirectory(String string) {
    }

    public void setFile(String string) {
    }

    public void setTitle(String string) {
    }

    private static native void setFilterString(String var0);

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.fileFilter = filenameFilter;
    }

    boolean checkFilenameFilter(String string) {
        FileDialog fileDialog = (FileDialog)this.target;
        if (this.fileFilter == null) {
            return true;
        }
        File file = new File(string);
        return this.fileFilter.accept(new File(file.getParent()), file.getName());
    }

    WFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
    }

    void create(WComponentPeer wComponentPeer) {
        this.parent = wComponentPeer;
    }

    void initialize() {
    }

    private native void _dispose();

    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    private native void _show();

    private native void _hide();

    public void show() {
        new Thread(new Runnable(){

            public void run() {
                WFileDialogPeer.this._show();
                WToolkit.getWToolkit().notifyModalityChange(1300);
            }
        }).start();
    }

    public void hide() {
        WToolkit.getWToolkit().notifyModalityChange(1301);
        this._hide();
    }

    void handleSelected(final String string) {
        final FileDialog fileDialog = (FileDialog)this.target;
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                String string2;
                int n = string.lastIndexOf(File.separatorChar);
                if (n == -1) {
                    string2 = "." + File.separator;
                    fileDialog.setFile(string);
                } else {
                    string2 = string.substring(0, n + 1);
                    fileDialog.setFile(string.substring(n + 1));
                }
                fileDialog.setDirectory(string2);
                fileDialog.hide();
            }
        });
    }

    void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                fileDialog.setFile(null);
                fileDialog.hide();
            }
        });
    }

    public void toFront() {
    }

    public void toBack() {
    }

    public void setResizable(boolean bl) {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void reshape(int n, int n2, int n3, int n4) {
    }

    public boolean handleEvent(Event event) {
        return false;
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setFont(Font font) {
    }

    public boolean requestFocus(boolean bl, boolean bl2) {
        return false;
    }

    void start() {
    }

    void invalidate(int n, int n2, int n3, int n4) {
    }

    public void addDropTarget(DropTarget dropTarget) {
    }

    public void removeDropTarget(DropTarget dropTarget) {
    }

    private static native void initIDs();

    static {
        WFileDialogPeer.initIDs();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
            String string = resourceBundle.getString("allFiles");
            WFileDialogPeer.setFilterString(string);
        }
        catch (MissingResourceException missingResourceException) {
            WFileDialogPeer.setFilterString("All Files");
        }
    }
}

