/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.PixelConverter;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.Win32GdiBlitLoops;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.awt.windows.Win32Renderer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.security.action.GetPropertyAction;

public class Win32SurfaceData
extends SurfaceData {
    WComponentPeer peer;
    private Win32GraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    public static final String DESC_GDI = "GDI";
    public static final String DESC_INT_RGB_DD = "Integer RGB DirectDraw";
    public static final String DESC_INT_RGBx_DD = "Integer RGBx DirectDraw";
    public static final String DESC_USHORT_565_RGB_DD = "Short 565 RGB DirectDraw";
    public static final String DESC_USHORT_555_RGBx_DD = "Short 555 RGBx DirectDraw";
    public static final String DESC_USHORT_555_RGB_DD = "Short 555 RGB DirectDraw";
    public static final String DESC_BYTE_INDEXED_OPAQUE_DD = "8-bit Indexed (Opaque) DirectDraw";
    public static final String DESC_BYTE_GRAY_DD = "Byte Gray DirectDraw";
    public static final String DESC_INDEX8_GRAY_DD = "Index8 Gray DirectDraw";
    public static final String DESC_3BYTE_BGR_DD = "3 Byte BGR DirectDraw";
    public static final String DESC_INT_RGB_DD_BM = "Integer RGB DirectDraw with 1 bit transp";
    public static final String DESC_INT_RGBx_DD_BM = "Integer RGBx DirectDraw with 1 bit transp";
    public static final String DESC_USHORT_565_RGB_DD_BM = "Short 565 RGB DirectDraw with 1 bit transp";
    public static final String DESC_USHORT_555_RGBx_DD_BM = "Short 555 RGBx DirectDraw with 1 bit transp";
    public static final String DESC_USHORT_555_RGB_DD_BM = "Short 555 RGB DirectDraw with 1 bit transp";
    public static final String DESC_3BYTE_BGR_DD_BM = "3 Byte BGR DirectDraw with 1 bit transp";
    public static final String DESC_BYTE_INDEXED_DD_BM = "8-bit Indexed DirectDraw with 1 bit transp";
    public static final String DESC_BYTE_GRAY_DD_BM = "Byte Gray DirectDraw with 1 bit transp";
    public static final String DESC_INDEX8_GRAY_DD_BM = "Index8 Gray DirectDraw with 1 bit transp";
    public static final String DESC_INT_ARGB_D3D = "Integer ARGB D3D with translucency";
    public static final String DESC_USHORT_4444_ARGB_D3D = "UShort 4444 ARGB D3D with translucency";
    public static final SurfaceType AnyGdi;
    public static final SurfaceType IntRgbGdi;
    public static final SurfaceType Ushort565RgbGdi;
    public static final SurfaceType Ushort555RgbGdi;
    public static final SurfaceType ThreeByteBgrGdi;
    public static final SurfaceType IntRgbDD;
    public static final SurfaceType IntRgbxDD;
    public static final SurfaceType Ushort565RgbDD;
    public static final SurfaceType Ushort555RgbxDD;
    public static final SurfaceType Ushort555RgbDD;
    public static final SurfaceType ByteIndexedOpaqueDD;
    public static final SurfaceType ByteGrayDD;
    public static final SurfaceType Index8GrayDD;
    public static final SurfaceType ThreeByteBgrDD;
    public static final SurfaceType IntRgbDDscreen;
    public static final SurfaceType Ushort565RgbDDscreen;
    public static final SurfaceType Ushort555RgbDDscreen;
    public static final SurfaceType ThreeByteBgrDDscreen;
    public static final SurfaceType IntRgbxDDscreen;
    public static final SurfaceType Ushort555RgbxDDscreen;
    public static final SurfaceType ByteIndexedOpaqueDDscreen;
    public static final SurfaceType ByteGrayDDscreen;
    public static final SurfaceType Index8GrayDDscreen;
    public static final SurfaceType IntRgbDD_BM;
    public static final SurfaceType IntRgbxDD_BM;
    public static final SurfaceType Ushort565RgbDD_BM;
    public static final SurfaceType Ushort555RgbxDD_BM;
    public static final SurfaceType Ushort555RgbDD_BM;
    public static final SurfaceType ByteIndexedDD_BM;
    public static final SurfaceType ByteGrayDD_BM;
    public static final SurfaceType Index8GrayDD_BM;
    public static final SurfaceType ThreeByteBgrDD_BM;
    public static final SurfaceType IntArgbD3D;
    public static final SurfaceType Ushort4444ArgbD3D;
    protected static Win32Renderer gdiPipe;
    protected static PixelToShapeConverter gdiTxPipe;

    private static native void initDDraw(boolean var0, boolean var1);

    private static native void initIDs(Class var0);

    public static SurfaceType getSurfaceType(ColorModel colorModel) {
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return IntRgbDDscreen;
                    }
                    return IntRgbxDDscreen;
                }
                return ThreeByteBgrDDscreen;
            }
            case 15: {
                return Ushort555RgbDDscreen;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return Ushort555RgbxDDscreen;
                }
                return Ushort565RgbDDscreen;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return ByteGrayDDscreen;
                }
                if (colorModel instanceof IndexColorModel && Win32SurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return Index8GrayDDscreen;
                }
                return ByteIndexedOpaqueDDscreen;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    public static Win32SurfaceData createData(WComponentPeer wComponentPeer, int n) {
        SurfaceType surfaceType = Win32SurfaceData.getSurfaceType(wComponentPeer.getDeviceColorModel());
        return new Win32SurfaceData(wComponentPeer, surfaceType, n);
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        block8: {
            block9: {
                if (sunGraphics2D.antialiasHint == 2) break block8;
                if (sunGraphics2D.paintState != 0) break block8;
                if (sunGraphics2D.compositeState == 0) break block9;
                if (sunGraphics2D.compositeState != 2) break block8;
            }
            if (sunGraphics2D.clipState != 2) {
                sunGraphics2D.imagepipe = imagepipe;
                if (sunGraphics2D.transformState > 1) {
                    sunGraphics2D.drawpipe = gdiTxPipe;
                    sunGraphics2D.fillpipe = gdiTxPipe;
                } else if (sunGraphics2D.strokeState != 0) {
                    sunGraphics2D.drawpipe = gdiTxPipe;
                    sunGraphics2D.fillpipe = gdiPipe;
                } else {
                    sunGraphics2D.drawpipe = gdiPipe;
                    sunGraphics2D.fillpipe = gdiPipe;
                }
                sunGraphics2D.shapepipe = gdiPipe;
                sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint != 2 ? solidTextRenderer : aaTextRenderer;
                sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
                return;
            }
        }
        super.validatePipe(sunGraphics2D);
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(WComponentPeer var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public Win32SurfaceData(WComponentPeer wComponentPeer, SurfaceType surfaceType, int n) {
        super(surfaceType, wComponentPeer.getDeviceColorModel());
        Object object;
        int n2;
        ColorModel colorModel = wComponentPeer.getDeviceColorModel();
        this.peer = wComponentPeer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    n2 = 32;
                    break;
                }
                n2 = 24;
                break;
            }
            default: {
                n2 = colorModel.getPixelSize();
            }
        }
        if (colorModel instanceof DirectColorModel) {
            object = (DirectColorModel)colorModel;
            n3 = ((DirectColorModel)object).getRedMask();
            n4 = ((DirectColorModel)object).getGreenMask();
            n5 = ((DirectColorModel)object).getBlueMask();
        }
        this.graphicsConfig = (Win32GraphicsConfig)wComponentPeer.getGraphicsConfiguration();
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        if (wComponentPeer instanceof WFileDialogPeer || wComponentPeer instanceof WPrintDialogPeer) {
            return;
        }
        object = (Win32GraphicsDevice)this.graphicsConfig.getDevice();
        this.initOps(wComponentPeer, n2, n3, n4, n5, n, ((Win32GraphicsDevice)object).getScreen());
    }

    public SurfaceData getReplacement() {
        return this.peer.getSurfaceData();
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.peer.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle;
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 2) {
            if (sunGraphics2D.clipState != 2 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
                int n7 = (n += sunGraphics2D.transX) + n5;
                int n8 = (n2 += sunGraphics2D.transY) + n6;
                int n9 = n7 + n3;
                int n10 = n8 + n4;
                Region region = sunGraphics2D.getCompClip();
                if (n7 < region.getLoX()) {
                    n7 = region.getLoX();
                }
                if (n8 < region.getLoY()) {
                    n8 = region.getLoY();
                }
                if (n9 > region.getHiX()) {
                    n9 = region.getHiX();
                }
                if (n10 > region.getHiY()) {
                    n10 = region.getHiY();
                }
                if (n7 < n9 && n8 < n10) {
                    gdiPipe.devCopyArea(this, n7 - n5, n8 - n6, n5, n6, n9 - n7, n10 - n8);
                }
                return true;
            }
        }
        return false;
    }

    private native void invalidateSD();

    public void invalidate() {
        if (this.isValid()) {
            this.invalidateSD();
            super.invalidate();
        }
    }

    public native void restoreSurface();

    public native void flip(SurfaceData var1);

    static {
        boolean bl;
        String string;
        AnyGdi = SurfaceType.IntRgb.deriveSubType(DESC_GDI);
        IntRgbGdi = SurfaceType.IntRgb.deriveSubType(DESC_GDI);
        Ushort565RgbGdi = SurfaceType.Ushort565Rgb.deriveSubType(DESC_GDI);
        Ushort555RgbGdi = SurfaceType.Ushort555Rgb.deriveSubType(DESC_GDI);
        ThreeByteBgrGdi = SurfaceType.ThreeByteBgr.deriveSubType(DESC_GDI);
        IntRgbDD = SurfaceType.IntRgb.deriveSubType(DESC_INT_RGB_DD);
        IntRgbxDD = SurfaceType.IntRgbx.deriveSubType(DESC_INT_RGBx_DD);
        Ushort565RgbDD = SurfaceType.Ushort565Rgb.deriveSubType(DESC_USHORT_565_RGB_DD);
        Ushort555RgbxDD = SurfaceType.Ushort555Rgbx.deriveSubType(DESC_USHORT_555_RGBx_DD);
        Ushort555RgbDD = SurfaceType.Ushort555Rgb.deriveSubType(DESC_USHORT_555_RGB_DD);
        ByteIndexedOpaqueDD = SurfaceType.ByteIndexedOpaque.deriveSubType(DESC_BYTE_INDEXED_OPAQUE_DD);
        ByteGrayDD = SurfaceType.ByteGray.deriveSubType(DESC_BYTE_GRAY_DD);
        Index8GrayDD = SurfaceType.Index8Gray.deriveSubType(DESC_INDEX8_GRAY_DD);
        ThreeByteBgrDD = SurfaceType.ThreeByteBgr.deriveSubType(DESC_3BYTE_BGR_DD);
        IntRgbDDscreen = IntRgbGdi.deriveSubType(DESC_INT_RGB_DD);
        Ushort565RgbDDscreen = Ushort565RgbGdi.deriveSubType(DESC_USHORT_565_RGB_DD);
        Ushort555RgbDDscreen = Ushort555RgbGdi.deriveSubType(DESC_USHORT_555_RGB_DD);
        ThreeByteBgrDDscreen = ThreeByteBgrGdi.deriveSubType(DESC_3BYTE_BGR_DD);
        IntRgbxDDscreen = IntRgbxDD;
        Ushort555RgbxDDscreen = Ushort555RgbxDD;
        ByteIndexedOpaqueDDscreen = ByteIndexedOpaqueDD;
        ByteGrayDDscreen = ByteGrayDD;
        Index8GrayDDscreen = Index8GrayDD;
        IntRgbDD_BM = SurfaceType.Custom.deriveSubType(DESC_INT_RGB_DD_BM, PixelConverter.Xrgb.instance);
        IntRgbxDD_BM = SurfaceType.Custom.deriveSubType(DESC_INT_RGBx_DD_BM, PixelConverter.Rgbx.instance);
        Ushort565RgbDD_BM = SurfaceType.Custom.deriveSubType(DESC_USHORT_565_RGB_DD_BM, PixelConverter.Ushort565Rgb.instance);
        Ushort555RgbxDD_BM = SurfaceType.Custom.deriveSubType(DESC_USHORT_555_RGBx_DD_BM, PixelConverter.Ushort555Rgbx.instance);
        Ushort555RgbDD_BM = SurfaceType.Custom.deriveSubType(DESC_USHORT_555_RGB_DD_BM, PixelConverter.Ushort555Rgb.instance);
        ByteIndexedDD_BM = SurfaceType.Custom.deriveSubType(DESC_BYTE_INDEXED_DD_BM);
        ByteGrayDD_BM = SurfaceType.Custom.deriveSubType(DESC_BYTE_GRAY_DD_BM);
        Index8GrayDD_BM = SurfaceType.Custom.deriveSubType(DESC_INDEX8_GRAY_DD_BM);
        ThreeByteBgrDD_BM = SurfaceType.Custom.deriveSubType(DESC_3BYTE_BGR_DD_BM, PixelConverter.Xrgb.instance);
        IntArgbD3D = SurfaceType.IntArgb.deriveSubType(DESC_INT_ARGB_D3D);
        Ushort4444ArgbD3D = SurfaceType.Ushort4444Argb.deriveSubType(DESC_USHORT_4444_ARGB_D3D);
        Win32SurfaceData.initIDs(XORComposite.class);
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.gdiblit"));
        String string4 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddlock"));
        boolean bl2 = false;
        boolean bl3 = false;
        if (string4 != null) {
            if (string4.equals("false") || string4.equals("f")) {
                bl2 = false;
                bl3 = true;
            } else if (string4.equals("true") || string4.equals("t")) {
                bl2 = true;
                bl3 = true;
            }
        }
        Win32OffScreenSurfaceData.initD3D();
        if (!(string2 != null || (string = AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"))) != null && string.equals("true"))) {
            Win32SurfaceData.initDDraw(bl3, bl2);
        }
        boolean bl4 = bl = string3 != null && (string3.equals("false") || string3.equals("f"));
        if (!bl) {
            Win32GdiBlitLoops.register();
        }
        gdiPipe = new Win32Renderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            gdiPipe = gdiPipe.traceWrap();
        }
        gdiTxPipe = new PixelToShapeConverter(gdiPipe);
    }
}

