/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.VolatileImage;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.ScaledBlit;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.SpanIterator;

public class DrawImage
implements DrawImagePipe {
    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color) {
        if (sunGraphics2D.transformState < 2) {
            return this.copyImage(sunGraphics2D, image, n, n2, 0, 0, image.getWidth(null), image.getHeight(null), color);
        }
        this.transformImage(sunGraphics2D, image, n, n2, null, null, color);
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if (sunGraphics2D.transformState < 2) {
            SurfaceData surfaceData = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, false);
            if (surfaceData != null) {
                DrawImage.renderSurfaceData(sunGraphics2D, surfaceData, color, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
                return true;
            }
            return false;
        }
        this.scaleImage(sunGraphics2D, image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, color);
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color) {
        Object object;
        sunGraphics2D.getCompClip();
        if (n3 > 0 && n4 > 0) {
            SurfaceType surfaceType;
            SurfaceType surfaceType2;
            if (sunGraphics2D.transformState < 3 && !DrawImage.isBgOperation((SurfaceData)(object = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, true)), color) && this.scaleSurfaceData(sunGraphics2D, (SurfaceData)object, sunGraphics2D.surfaceData, surfaceType2 = ((SurfaceData)object).getSurfaceType(), surfaceType = sunGraphics2D.surfaceData.getSurfaceType(), n, n2, 0, 0, n3, n4, image.getWidth(null), image.getHeight(null), null)) {
                return true;
            }
        }
        object = this.getTransform(image, n, n2, n3, n4);
        this.transformImage(sunGraphics2D, image, 0, 0, null, (AffineTransform)object, color);
        return true;
    }

    protected AffineTransform getTransform(Image image, int n, int n2, int n3, int n4) {
        AffineTransform affineTransform = null;
        if (n3 != image.getWidth(null) || n4 != image.getHeight(null) || n != 0 || n2 != 0) {
            affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            affineTransform.scale((double)n3 / (double)image.getWidth(null), (double)n4 / (double)image.getHeight(null));
        }
        return affineTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, BufferedImageOp bufferedImageOp, AffineTransform affineTransform, Color color) {
        Object object;
        int n3;
        int n4;
        Object object2;
        Object object3;
        Object object4;
        Region region = sunGraphics2D.getCompClip();
        int n5 = sunGraphics2D.interpolationHint;
        if (bufferedImageOp == null) {
            if (sunGraphics2D.transformState != 3) {
                if (sunGraphics2D.transformState < 2 && (affineTransform == null || affineTransform.isIdentity())) {
                    this.copyImage(sunGraphics2D, image, n, n2, 0, 0, image.getWidth(null), image.getHeight(null), color);
                    return;
                }
                if (!(affineTransform != null && (affineTransform.getType() & 0x78) != 0 || DrawImage.isBgOperation((SurfaceData)(object4 = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, true)), color))) {
                    object3 = ((SurfaceData)object4).getSurfaceType();
                    object2 = sunGraphics2D.surfaceData.getSurfaceType();
                    n4 = n;
                    int n6 = n2;
                    int n7 = image.getWidth(null);
                    n3 = image.getHeight(null);
                    object = null;
                    if (affineTransform != null) {
                        object = new double[]{n4, n6, n4 + n7, n6 + n3};
                        affineTransform.transform((double[])object, 0, (double[])object, 0, 2);
                        n4 = (int)(object[0] + 0.5);
                        n6 = (int)(object[1] + 0.5);
                        n7 = (int)(object[2] + 0.5);
                        n3 = (int)(object[3] + 0.5);
                        n7 -= n4;
                        n3 -= n6;
                    }
                    if (this.scaleSurfaceData(sunGraphics2D, (SurfaceData)object4, sunGraphics2D.surfaceData, (SurfaceType)object3, (SurfaceType)object2, n4, n6, 0, 0, n7, n3, image.getWidth(null), image.getHeight(null), (double[])object)) {
                        return;
                    }
                }
            }
        }
        object4 = this.getBufferedImage(image);
        object3 = null;
        if (bufferedImageOp != null) {
            if (bufferedImageOp instanceof AffineTransformOp) {
                object2 = (AffineTransformOp)bufferedImageOp;
                object3 = ((AffineTransformOp)object2).getTransform();
                n5 = ((AffineTransformOp)object2).getInterpolationType();
            } else {
                object4 = bufferedImageOp.filter((BufferedImage)object4, null);
            }
        }
        int n8 = ((BufferedImage)object4).getWidth();
        n4 = ((BufferedImage)object4).getHeight();
        AffineTransform affineTransform2 = new AffineTransform(sunGraphics2D.transform);
        affineTransform2.translate(n, n2);
        if (affineTransform != null && !affineTransform.isIdentity()) {
            affineTransform2.concatenate(affineTransform);
        }
        if (object3 != null && !((AffineTransform)object3).isIdentity()) {
            affineTransform2.concatenate((AffineTransform)object3);
        }
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0) {
            n = (int)Math.round(dArray[4]);
            Region region2 = Region.getInstanceXYWH(n, n2 = (int)Math.round(dArray[5]), n8, n4);
            if ((region = region.getBoundsIntersection(region2)).isEmpty()) {
                return;
            }
            if (!region.encompasses(region2)) {
                n8 = region.getWidth();
                n4 = region.getHeight();
                object4 = ((BufferedImage)object4).getSubimage(region.getLoX() - n, region.getLoY() - n2, n8, n4);
            }
        } else {
            BufferedImage bufferedImage;
            Object object5;
            n3 = n5;
            if (n5 == -1) {
                int n9 = n3 = sunGraphics2D.renderHint == 2 ? 2 : 1;
            }
            if (n3 != 1 && ((BufferedImage)object4).getColorModel() instanceof IndexColorModel) {
                object = new BufferedImage(((BufferedImage)object4).getWidth(), ((BufferedImage)object4).getHeight(), 3);
                object5 = ((BufferedImage)object).createGraphics();
                try {
                    ((Graphics2D)object5).setComposite(AlphaComposite.Src);
                    ((Graphics)object5).drawImage((Image)object4, 0, 0, null);
                }
                finally {
                    ((Graphics)object5).dispose();
                }
                object4 = object;
            }
            object = this.getTransformColorModel(sunGraphics2D, (BufferedImage)object4, affineTransform2);
            object5 = new AffineTransformOp(affineTransform2, n3);
            Rectangle rectangle = ((AffineTransformOp)object5).getBounds2D((BufferedImage)object4).getBounds();
            if ((region = region.getBoundsIntersection(rectangle)).isEmpty()) {
                return;
            }
            n = region.getLoX();
            n2 = region.getLoY();
            n8 = region.getWidth();
            n4 = region.getHeight();
            if (n != 0 || n2 != 0) {
                affineTransform2.preConcatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)(-n), (double)(-n2)));
                object5 = new AffineTransformOp(affineTransform2, n3);
            }
            if ((object4 = ((AffineTransformOp)object5).filter((BufferedImage)object4, bufferedImage = object == ((BufferedImage)object4).getColorModel() ? new BufferedImage((ColorModel)object, ((BufferedImage)object4).getRaster().createCompatibleWritableRaster(n8, n4), ((ColorModel)object).isAlphaPremultiplied(), null) : new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(n8, n4), ((ColorModel)object).isAlphaPremultiplied(), null))) == null) {
                return;
            }
        }
        SurfaceData surfaceData = object4 instanceof OffScreenImage ? ((OffScreenImage)object4).getSourceSurfaceData(sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, false) : BufImgSurfaceData.createData((BufferedImage)object4);
        DrawImage.renderSurfaceData(sunGraphics2D, surfaceData, color, region.getLoX(), region.getLoY(), 0, 0, region.getWidth(), region.getHeight());
    }

    public static void renderSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Color color, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (true) {
            try {
                SurfaceType surfaceType = surfaceData.getSurfaceType();
                SurfaceType surfaceType2 = sunGraphics2D.surfaceData.getSurfaceType();
                DrawImage.blitSurfaceData(sunGraphics2D, surfaceData, sunGraphics2D.surfaceData, surfaceType, surfaceType2, n3, n4, n, n2, n5, n6, color);
                return;
            }
            catch (NullPointerException nullPointerException) {
                if (sunGraphics2D.surfaceData != null) {
                    throw nullPointerException;
                }
                return;
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = surfaceData.getReplacement();
                sunGraphics2D.getCompClip();
                if (sunGraphics2D.surfaceData != null && surfaceData != null && ++n7 <= 1) continue;
                return;
            }
            break;
        }
    }

    protected boolean scaleBufferedImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, Color color, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        AffineTransform affineTransform = null;
        if (n3 - n != n7 - n5 || n4 - n2 != n8 - n6) {
            affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            double d = (double)(n3 - n) / (double)(n7 - n5);
            double d2 = (double)(n4 - n2) / (double)(n8 - n6);
            affineTransform.scale(d, d2);
            affineTransform.translate(n9 - n5, n10 - n6);
            n12 = 0;
            n11 = 0;
        }
        if (n9 >= 0 && n10 >= 0) {
            int n15 = bufferedImage.getWidth();
            int n16 = bufferedImage.getHeight();
            if (n9 + n13 > n15) {
                n13 = n15 - n9;
            }
            if (n10 + n14 > n16) {
                n14 = n16 - n10;
            }
            bufferedImage = bufferedImage.getSubimage(n9 + bufferedImage.getMinX(), n10 + bufferedImage.getMinY(), n13, n14);
        }
        this.transformImage(sunGraphics2D, bufferedImage, n11, n12, null, affineTransform, color);
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        Object object;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n7 > n5) {
            n16 = n7 - n5;
            n15 = n5;
        } else {
            bl = true;
            n16 = n5 - n7;
            n15 = n7;
        }
        if (n8 > n6) {
            n14 = n8 - n6;
            n13 = n6;
        } else {
            bl2 = true;
            n14 = n6 - n8;
            n13 = n8;
        }
        if (n3 > n) {
            n12 = n3 - n;
            n11 = n;
        } else {
            n12 = n - n3;
            bl3 = true;
            n11 = n3;
        }
        if (n4 > n2) {
            n10 = n4 - n2;
            n9 = n2;
        } else {
            n10 = n2 - n4;
            bl4 = true;
            n9 = n4;
        }
        if (n16 <= 0 || n14 <= 0) {
            return true;
        }
        if (bl == bl3 && bl2 == bl4) {
            SurfaceType surfaceType;
            SurfaceType surfaceType2;
            if (sunGraphics2D.transformState < 3 && !DrawImage.isBgOperation((SurfaceData)(object = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, true)), color) && this.scaleSurfaceData(sunGraphics2D, (SurfaceData)object, sunGraphics2D.surfaceData, surfaceType2 = ((SurfaceData)object).getSurfaceType(), surfaceType = sunGraphics2D.surfaceData.getSurfaceType(), n11, n9, n15, n13, n12, n10, n16, n14, null)) {
                return true;
            }
        }
        object = this.getBufferedImage(image);
        return this.scaleBufferedImage(sunGraphics2D, (BufferedImage)object, color, n, n2, n3, n4, n5, n6, n7, n8, n15, n13, n11, n9, n16, n14);
    }

    protected static boolean isBgOperation(SurfaceData surfaceData, Color color) {
        return surfaceData == null || color != null && surfaceData.getTransparency() != 1;
    }

    protected BufferedImage getBufferedImage(Image image) {
        if (image instanceof AcceleratedOffScreenImage) {
            return ((AcceleratedOffScreenImage)image).getSnapshot();
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ((VolatileImage)image).getSnapshot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorModel getTransformColorModel(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, AffineTransform affineTransform) {
        Object object;
        boolean bl;
        ColorModel colorModel;
        ColorModel colorModel2 = colorModel = bufferedImage.getColorModel();
        if (affineTransform.isIdentity()) {
            return colorModel2;
        }
        int n = affineTransform.getType();
        boolean bl2 = bl = (n & (0x18 | 0x20)) != 0;
        if (!bl) {
            if (n != 1) {
                if (n != 0) {
                    object = new double[4];
                    affineTransform.getMatrix((double[])object);
                    boolean bl3 = bl = object[0] != (double)((int)object[0]) || object[3] != (double)((int)object[3]);
                }
            }
        }
        if (sunGraphics2D.renderHint != 2) {
            if (colorModel instanceof IndexColorModel) {
                object = bufferedImage.getRaster();
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                if (!bl) return colorModel2;
                if (colorModel.getTransparency() != 1) return colorModel2;
                if (object instanceof BytePackedRaster) {
                    return ColorModel.getRGBdefault();
                }
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                if (dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) return colorModel2;
                int n2 = indexColorModel.getMapSize();
                if (n2 >= 256) return ColorModel.getRGBdefault();
                int[] nArray = new int[n2 + 1];
                indexColorModel.getRGBs(nArray);
                nArray[n2] = 0;
                return new IndexColorModel(indexColorModel.getPixelSize(), n2 + 1, nArray, 0, true, n2, 0);
            }
            if (!bl) return colorModel2;
            if (colorModel.getTransparency() != 1) return colorModel2;
            return ColorModel.getRGBdefault();
        }
        if (colorModel instanceof IndexColorModel) return ColorModel.getRGBdefault();
        if (!bl) return colorModel2;
        if (colorModel.getTransparency() != 1) return colorModel2;
        return ColorModel.getRGBdefault();
    }

    protected static void blitSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && (surfaceData.getTransparency() == 1 || color != null)) {
            compositeType = CompositeType.SrcNoEa;
        }
        if (!DrawImage.isBgOperation(surfaceData, color)) {
            Blit blit = Blit.getFromCache(surfaceType, compositeType, surfaceType2);
            blit.Blit(surfaceData, surfaceData2, sunGraphics2D.composite, sunGraphics2D.getCompClip(), n, n2, n3, n4, n5, n6);
        } else {
            BlitBg blitBg = BlitBg.getFromCache(surfaceType, compositeType, surfaceType2);
            blitBg.BlitBg(surfaceData, surfaceData2, sunGraphics2D.composite, sunGraphics2D.getCompClip(), color, n, n2, n3, n4, n5, n6);
        }
    }

    protected boolean areaWithinRect(Rectangle rectangle, int n, int n2, int n3, int n4) {
        return rectangle.x <= n && rectangle.y <= n2 && rectangle.x + rectangle.width >= n + n3 && rectangle.y + rectangle.height >= n2 + n4;
    }

    protected boolean scaleSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        if (sunGraphics2D.interpolationHint != -1 || sunGraphics2D.renderHint == 2) {
            return false;
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && surfaceData.getTransparency() == 1) {
            compositeType = CompositeType.SrcNoEa;
        }
        if (sunGraphics2D.transformState == 1) {
            n += sunGraphics2D.transX;
            n2 += sunGraphics2D.transY;
        } else if (sunGraphics2D.transformState == 2) {
            if (dArray == null) {
                dArray = new double[]{n, n2, n + n5, n2 + n6};
            }
            sunGraphics2D.transform.transform(dArray, 0, dArray, 0, 2);
            n = (int)(dArray[0] + 0.5);
            n2 = (int)(dArray[1] + 0.5);
            n5 = (int)(dArray[2] + 0.5);
            n6 = (int)(dArray[3] + 0.5);
            n5 -= n;
            n6 -= n2;
        }
        ScaledBlit scaledBlit = ScaledBlit.getFromCache(surfaceType, compositeType, surfaceType2);
        if (scaledBlit != null) {
            Region region = sunGraphics2D.getCompClip();
            if (sunGraphics2D.clipState == 2) {
                int[] nArray = new int[]{n, n2, n + n5, n2 + n6};
                SpanIterator spanIterator = region.getSpanIterator(nArray);
                while (spanIterator.nextSpan(nArray)) {
                    scaledBlit.Scale(surfaceData, surfaceData2, sunGraphics2D.composite, n3, n4, n, n2, n7, n8, n5, n6, nArray[0], nArray[1], nArray[2], nArray[3]);
                }
            } else {
                scaledBlit.Scale(surfaceData, surfaceData2, sunGraphics2D.composite, n3, n4, n, n2, n7, n8, n5, n6, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY());
            }
            return true;
        }
        return false;
    }

    protected boolean imageReady(sun.awt.image.Image image, ImageObserver imageObserver) {
        if (image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.copyImage(sunGraphics2D, image, n, n2, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, color, imageObserver);
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.copyImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, n3, n4, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, n7, n8, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            this.transformImage(sunGraphics2D, image, 0, 0, null, affineTransform, null);
            return true;
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, affineTransform, imageObserver);
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.transformImage(sunGraphics2D, bufferedImage, n, n2, bufferedImageOp, null, null);
    }
}

