/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.security.AccessController;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.Win32PrintService;
import sun.security.action.LoadLibraryAction;

public class Win32PrintServiceLookup
extends PrintServiceLookup {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private String[] printers;
    private PrintService[] printServices;

    public PrintService[] getPrintServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.printServices == null) {
            PrintService printService = this.getDefaultPrintService();
            this.printers = this.getAllPrinterNames();
            if (this.printers == null) {
                return null;
            }
            this.printServices = new PrintService[this.printers.length];
            for (int i = 0; i < this.printers.length; ++i) {
                this.printServices[i] = printService != null && this.printers[i].equals(printService.getName()) ? printService : new Win32PrintService(this.printers[i]);
            }
        }
        return this.printServices;
    }

    private synchronized PrintService getPrintServiceByName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.printServices == null) {
            String[] stringArray = this.getAllPrinterNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return new Win32PrintService(string);
            }
            return null;
        }
        for (int i = 0; i < this.printServices.length; ++i) {
            if (!this.printServices[i].getName().equals(string)) continue;
            return this.printServices[i];
        }
        return null;
    }

    boolean matchingService(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        if (printServiceAttributeSet != null) {
            Attribute[] attributeArray = printServiceAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                PrintServiceAttribute printServiceAttribute = printService.getAttribute(attributeArray[i].getCategory());
                if (printServiceAttribute != null && printServiceAttribute.equals(attributeArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        PrinterName printerName;
        PrintService printService;
        Object[] objectArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        AttributeSet attributeSet2 = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            attributeSet2 = new HashPrintServiceAttributeSet();
            objectArray = attributeSet.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add((Attribute)objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof PrintServiceAttribute)) continue;
                attributeSet2.add((Attribute)objectArray[i]);
            }
        }
        objectArray = null;
        objectArray = attributeSet2 != null && attributeSet2.get(PrinterName.class) != null ? ((printService = this.getPrintServiceByName((printerName = (PrinterName)attributeSet2.get(PrinterName.class)).getValue())) == null || !this.matchingService(printService, (PrintServiceAttributeSet)attributeSet2) ? new PrintService[]{} : new PrintService[]{printService}) : this.getPrintServices();
        if (objectArray.length == 0) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i].getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) != null) continue;
                arrayList.add(objectArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        objectArray = new PrintService[arrayList.size()];
        return (PrintService[])arrayList.toArray(objectArray);
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    public PrintService getDefaultPrintService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.defaultPrintService == null) {
            this.defaultPrinter = this.getDefaultPrinterName();
            if (this.defaultPrinter != null) {
                this.defaultPrintService = new Win32PrintService(this.defaultPrinter);
            }
        }
        return this.defaultPrintService;
    }

    private native String getDefaultPrinterName();

    private native String[] getAllPrinterNames();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

