/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.EventSetDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.TclRuntimeError;

class AdaptorGen {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_FieldRef = 9;
    private static final int CONSTANT_MethodRef = 10;
    private static final int CONSTANT_InterfaceMethodRef = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final int ALOAD = 25;
    private static final int ALOAD_0 = 42;
    private static final int ALOAD_1 = 43;
    private static final int ICONST_0 = 3;
    private static final int ICONST_1 = 4;
    private static final int ANEWARRAY = 189;
    private static final int DUP = 89;
    private static final int AASTORE = 83;
    private static final int RETURN = 177;
    private static final int ARETURN = 176;
    private static final int DRETURN = 175;
    private static final int FRETURN = 174;
    private static final int IRETURN = 172;
    private static final int LRETURN = 173;
    private static final int SIPUSH = 17;
    private static final int ASTORE = 58;
    private static final int NEW = 187;
    private static final int ILOAD = 21;
    private static final int LLOAD = 22;
    private static final int FLOAD = 23;
    private static final int DLOAD = 24;
    private static final int INVOKESP = 183;
    private static final int INVOKEVT = 182;
    private static final int WIDE = 196;
    private static final int LDC_W = 19;
    private static final int INSTNCOF = 193;
    private static final int CHKCAST = 192;
    private static final int IFEQ = 153;
    private static final int ATHROW = 191;
    private static final int GOTO_W = 200;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_SUPER = 32;
    private DataOutputStream ostream;
    private Class listenerCls;
    private Method[] methods;
    private String clsName;
    private Class superCls;
    int cpSize;
    Vector constPool;
    Hashtable utf8Tab;
    Hashtable allClasses;
    Hashtable primClasses;
    Hashtable returnTypes;
    Hashtable returnMethodRef;
    Hashtable wrapperConsRef;
    Hashtable clsRef;
    Hashtable stringRef;
    short cp_this_class;
    short cp_super_class;
    short cp_listener_interface;
    short cp_code;
    short cp_super_cons;
    short cp_processEvent;
    short cp_wrongException;
    MethodDesc[] cp_methodDesc;
    MethodDesc cp_consDesc;

    AdaptorGen() {
    }

    byte[] generate(EventSetDescriptor desc, Class superClass, String className) {
        this.superCls = superClass;
        this.clsName = className;
        this.listenerCls = desc.getListenerType();
        this.methods = this.listenerCls.getMethods();
        this.allClasses = new Hashtable();
        this.primClasses = new Hashtable();
        this.returnTypes = new Hashtable();
        this.returnMethodRef = new Hashtable();
        this.wrapperConsRef = new Hashtable();
        this.clsRef = new Hashtable();
        this.stringRef = new Hashtable();
        this.utf8Tab = new Hashtable();
        this.cp_methodDesc = new MethodDesc[this.methods.length];
        this.analyzeListener();
        this.cpSize = 1;
        try {
            DataOutputStream dos;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.ostream = dos = new DataOutputStream(baos);
            this.generateByteCode();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new TclRuntimeError("Unexcepted IOException " + e);
        }
    }

    private void analyzeListener() {
        boolean paramsDefined = false;
        for (int i = 0; i < this.methods.length; ++i) {
            int j;
            Class<?>[] params = this.methods[i].getParameterTypes();
            for (j = 0; j < params.length; ++j) {
                if (params[j].isPrimitive()) {
                    if (params[j] == Void.TYPE) {
                        throw new ClassFormatError("Parameter type cannot be void");
                    }
                    Class wrapper = AdaptorGen.getWrapperClass(params[j]);
                    this.allClasses.put(wrapper, wrapper);
                    this.primClasses.put(params[j], params[j]);
                } else {
                    this.allClasses.put(params[j], params[j]);
                }
                paramsDefined = true;
            }
            Class<?>[] exceptions = this.methods[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                this.allClasses.put(exceptions[j], exceptions[j]);
            }
            Class<?> retType = this.methods[i].getReturnType();
            if (retType == Void.TYPE) continue;
            if (!retType.isPrimitive()) {
                this.allClasses.put(retType, retType);
            }
            this.returnTypes.put(retType, retType);
        }
        if (paramsDefined) {
            this.allClasses.put(Object.class, Object.class);
        }
        this.allClasses.put(Throwable.class, Throwable.class);
    }

    private void generateByteCode() throws IOException {
        this.ostream.writeInt(-889275714);
        this.ostream.writeShort(3);
        this.ostream.writeShort(45);
        this.generateConstantPool();
        this.ostream.writeShort(33);
        this.ostream.writeShort(this.cp_this_class);
        this.ostream.writeShort(this.cp_super_class);
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_listener_interface);
        this.ostream.writeShort(0);
        this.ostream.writeShort(1 + this.methods.length);
        this.generateConstructor();
        for (int i = 0; i < this.methods.length; ++i) {
            this.generateMethod(i);
        }
        this.ostream.writeShort(0);
    }

    private void generateConstantPool() throws IOException {
        short ref;
        this.constPool = new Vector();
        this.cp_this_class = this.cp_putClass(this.clsName);
        this.cp_super_class = this.cp_putClass(this.superCls.getName());
        this.cp_listener_interface = this.cp_putClass(this.listenerCls.getName());
        this.cp_code = this.cp_putUtf8("Code");
        this.cp_super_cons = this.cp_putMethodRef(this.cp_super_class, "<init>", "()V");
        this.cp_processEvent = this.cp_putMethodRef(this.cp_super_class, "_processEvent", "([Ljava/lang/Object;Ljava/lang/String;)V");
        this.cp_wrongException = this.cp_putMethodRef(this.cp_super_class, "_wrongException", "()V");
        Enumeration e = this.returnTypes.keys();
        while (e.hasMoreElements()) {
            Class retType = (Class)e.nextElement();
            if (retType.isPrimitive()) {
                ref = this.cp_putMethodRef(this.cp_super_class, "_return_" + retType.getName(), "()" + AdaptorGen.getTypeDesc(retType));
            } else {
                this.cp_putString(retType.getName());
                ref = this.cp_putMethodRef(this.cp_super_class, "_return_Object", "(Ljava/lang/String;)" + AdaptorGen.getTypeDesc(retType));
            }
            AdaptorGen.hashPutShort(this.returnMethodRef, retType, ref);
        }
        this.cp_consDesc = this.cp_putMethodDesc("<init>", "()V", false);
        for (int i = 0; i < this.methods.length; ++i) {
            this.cp_methodDesc[i] = this.cp_putMethodDesc(this.methods[i].getName(), AdaptorGen.getMethodDescriptor(this.methods[i]), true);
        }
        e = this.allClasses.keys();
        while (e.hasMoreElements()) {
            Class type = (Class)e.nextElement();
            ref = this.cp_putClass(type.getName());
            AdaptorGen.hashPutShort(this.clsRef, type, ref);
        }
        e = this.primClasses.keys();
        while (e.hasMoreElements()) {
            e.nextElement();
        }
        e = this.primClasses.keys();
        while (e.hasMoreElements()) {
            Class primType = (Class)e.nextElement();
            short class_index = this.cp_getClass(AdaptorGen.getWrapperClass(primType));
            short ref2 = this.cp_putMethodRef(class_index, "<init>", "(" + AdaptorGen.getTypeDesc(primType) + ")V");
            AdaptorGen.hashPutShort(this.wrapperConsRef, primType, ref2);
        }
        this.ostream.writeShort(this.constPool.size() + 1);
        for (int i = 0; i < this.constPool.size(); ++i) {
            Object obj = this.constPool.elementAt(i);
            if (obj instanceof ConstUtf) {
                ConstUtf cutf = (ConstUtf)obj;
                this.ostream.writeByte(1);
                this.ostream.writeUTF(cutf.string);
                continue;
            }
            if (obj instanceof ConstString) {
                ConstString cstr = (ConstString)obj;
                this.ostream.writeByte(8);
                this.ostream.writeShort(cstr.string_index);
                continue;
            }
            if (obj instanceof ConstClass) {
                ConstClass ccls = (ConstClass)obj;
                this.ostream.writeByte(7);
                this.ostream.writeShort(ccls.name_index);
                continue;
            }
            if (obj instanceof ConstMethodRef) {
                ConstMethodRef cmref = (ConstMethodRef)obj;
                this.ostream.writeByte(10);
                this.ostream.writeShort(cmref.class_index);
                this.ostream.writeShort(cmref.name_and_type_index);
                continue;
            }
            ConstNameAndType cnat = (ConstNameAndType)obj;
            this.ostream.writeByte(12);
            this.ostream.writeShort(cnat.name_index);
            this.ostream.writeShort(cnat.desc_index);
        }
    }

    void generateConstructor() throws IOException {
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_consDesc.name_index);
        this.ostream.writeShort(this.cp_consDesc.descriptor_index);
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_code);
        this.ostream.writeInt(17);
        this.ostream.writeShort(2);
        this.ostream.writeShort(1);
        this.ostream.writeInt(5);
        this.ostream.writeByte(42);
        this.ostream.writeByte(183);
        this.ostream.writeShort(this.cp_super_cons);
        this.ostream.writeByte(177);
        this.ostream.writeShort(0);
        this.ostream.writeShort(0);
    }

    void generateMethod(int methodIdx) throws IOException {
        int exHandlerPC = 0;
        int max_stacks = 6;
        Class<?>[] paramTypes = this.methods[methodIdx].getParameterTypes();
        int numParams = paramTypes.length;
        int max_locals = 1;
        for (int i = 0; i < numParams; ++i) {
            if (paramTypes[i] == Double.TYPE || paramTypes[i] == Long.TYPE) {
                max_locals += 2;
                continue;
            }
            ++max_locals;
        }
        int paramVarIdx = (max_locals += 2) - 2;
        int exceptionVarIdx = max_locals - 1;
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_methodDesc[methodIdx].name_index);
        this.ostream.writeShort(this.cp_methodDesc[methodIdx].descriptor_index);
        this.ostream.writeShort(1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream code = new DataOutputStream(baos);
        code.writeByte(17);
        code.writeShort(numParams);
        code.writeByte(189);
        code.writeShort(this.cp_getClass(Object.class));
        this.writeLoadStore(code, 58, paramVarIdx);
        int paramIdx = 1;
        for (int i = 0; i < numParams; ++i) {
            this.writeLoadStore(code, 25, paramVarIdx);
            code.writeByte(17);
            code.writeShort(i);
            if (paramTypes[i].isPrimitive()) {
                int numWords;
                int loadOpcode;
                Class<?> prim = paramTypes[i];
                Class wrapper = AdaptorGen.getWrapperClass(paramTypes[i]);
                if (prim == Double.TYPE) {
                    loadOpcode = 24;
                    numWords = 2;
                } else if (prim == Float.TYPE) {
                    loadOpcode = 23;
                    numWords = 1;
                } else if (prim == Long.TYPE) {
                    loadOpcode = 22;
                    numWords = 2;
                } else {
                    loadOpcode = 21;
                    numWords = 1;
                }
                code.writeByte(187);
                code.writeShort(this.cp_getClass(wrapper));
                code.writeByte(89);
                this.writeLoadStore(code, loadOpcode, paramIdx);
                code.writeByte(183);
                code.writeShort(this.cp_getWrapperConstructor(prim));
                paramIdx += numWords;
            } else {
                this.writeLoadStore(code, 25, paramIdx);
                ++paramIdx;
            }
            code.writeByte(83);
        }
        int exStartPC = code.size();
        code.writeByte(42);
        this.writeLoadStore(code, 25, paramVarIdx);
        code.writeByte(19);
        code.writeShort(this.cp_getString(this.methods[methodIdx].getName()));
        code.writeByte(182);
        code.writeShort(this.cp_processEvent);
        int exEndPC = code.size();
        Class<?>[] exceptions = this.methods[methodIdx].getExceptionTypes();
        int offset = 9 + exceptions.length * 18 + 4;
        code.writeByte(200);
        code.writeInt(offset);
        exHandlerPC = code.size();
        code.writeByte(196);
        code.writeByte(58);
        code.writeShort(exceptionVarIdx);
        for (int i = 0; i < exceptions.length; ++i) {
            code.writeByte(196);
            code.writeByte(25);
            code.writeShort(exceptionVarIdx);
            code.writeByte(193);
            code.writeShort(this.cp_getClass(exceptions[i]));
            code.writeByte(153);
            code.writeShort(11);
            code.writeByte(196);
            code.writeByte(25);
            code.writeShort(exceptionVarIdx);
            code.writeByte(192);
            code.writeShort(this.cp_getClass(exceptions[i]));
            code.writeByte(191);
        }
        code.writeByte(42);
        code.writeByte(182);
        code.writeShort(this.cp_wrongException);
        Class<?> retType = this.methods[methodIdx].getReturnType();
        if (retType == Void.TYPE) {
            code.writeByte(177);
        } else if (retType.isPrimitive()) {
            code.writeByte(42);
            code.writeByte(182);
            code.writeShort(this.cp_getReturnMethodRef(retType));
            if (retType == Double.TYPE) {
                code.writeByte(175);
            } else if (retType == Float.TYPE) {
                code.writeByte(174);
            } else if (retType == Long.TYPE) {
                code.writeByte(173);
            } else {
                code.writeByte(172);
            }
        } else {
            code.writeByte(42);
            code.writeByte(19);
            code.writeShort(this.cp_getString(retType.getName()));
            code.writeByte(182);
            code.writeShort(this.cp_getReturnMethodRef(retType));
            code.writeByte(192);
            code.writeShort(this.cp_getClass(retType));
            code.writeByte(176);
        }
        int codeLength = code.size();
        code.writeShort(1);
        code.writeShort(exStartPC);
        code.writeShort(exEndPC);
        code.writeShort(exHandlerPC);
        code.writeShort(this.cp_getClass(Throwable.class));
        code.writeShort(0);
        code.close();
        byte[] codeBytes = baos.toByteArray();
        this.ostream.writeShort(this.cp_code);
        this.ostream.writeInt(codeBytes.length + 8);
        this.ostream.writeShort(max_stacks);
        this.ostream.writeShort(max_locals);
        this.ostream.writeInt(codeLength);
        this.ostream.write(codeBytes);
    }

    private static final String internalClassName(String className) {
        return className.replace('.', '/');
    }

    private static final void hashPutShort(Hashtable hashtable, Object key, short num) {
        Short shortObj = new Short(num);
        hashtable.put(key, shortObj);
    }

    private static final short hashGetShort(Hashtable hashtable, Object key) {
        return (Short)hashtable.get(key);
    }

    private static final Class getWrapperClass(Class primType) {
        if (primType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primType == Byte.TYPE) {
            return Byte.class;
        }
        if (primType == Character.TYPE) {
            return Character.class;
        }
        if (primType == Double.TYPE) {
            return Double.class;
        }
        if (primType == Float.TYPE) {
            return Float.class;
        }
        if (primType == Integer.TYPE) {
            return Integer.class;
        }
        if (primType == Long.TYPE) {
            return Long.class;
        }
        return Short.class;
    }

    private static final String getTypeDesc(Class cls) {
        if (cls.isPrimitive()) {
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            return "V";
        }
        if (cls.isArray()) {
            return "[" + AdaptorGen.getTypeDesc(cls.getComponentType());
        }
        String s = "L" + cls.getName() + ";";
        return s.replace('.', '/');
    }

    private static final String getMethodDescriptor(Method method) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sbuf.append(AdaptorGen.getTypeDesc(params[i]));
        }
        sbuf.append(')');
        sbuf.append(AdaptorGen.getTypeDesc(method.getReturnType()));
        return sbuf.toString();
    }

    void writeLoadStore(DataOutputStream code, int opcode, int address) throws IOException {
        if (address > 255) {
            code.writeByte(196);
            code.writeByte(opcode);
            code.writeShort(address);
        } else {
            code.writeByte(opcode);
            code.writeByte(address);
        }
    }

    short cp_putUtf8(String string) {
        Short shortObj = (Short)this.utf8Tab.get(string);
        if (shortObj != null) {
            return shortObj;
        }
        ConstUtf cutf = new ConstUtf();
        cutf.string = string;
        this.constPool.addElement(cutf);
        short id = (short)this.cpSize++;
        AdaptorGen.hashPutShort(this.utf8Tab, string, id);
        return id;
    }

    private short cp_putString(String string) {
        ConstString cstr = new ConstString();
        cstr.string_index = this.cp_putUtf8(string);
        this.constPool.addElement(cstr);
        short id = (short)this.cpSize++;
        AdaptorGen.hashPutShort(this.stringRef, string, id);
        return id;
    }

    private short cp_putClass(String className) {
        ConstClass ccls = new ConstClass();
        ccls.name_index = this.cp_putUtf8(AdaptorGen.internalClassName(className));
        this.constPool.addElement(ccls);
        return (short)this.cpSize++;
    }

    short cp_putNameAndType(String name, String type) {
        ConstNameAndType cnat = new ConstNameAndType();
        cnat.name_index = this.cp_putUtf8(name);
        cnat.desc_index = this.cp_putUtf8(type);
        this.constPool.addElement(cnat);
        return (short)this.cpSize++;
    }

    short cp_putMethodRef(short class_index, String name, String desc) {
        ConstMethodRef cmref = new ConstMethodRef();
        cmref.class_index = class_index;
        cmref.name_and_type_index = this.cp_putNameAndType(name, desc);
        this.constPool.addElement(cmref);
        return (short)this.cpSize++;
    }

    MethodDesc cp_putMethodDesc(String name, String descriptor, boolean generateID) {
        MethodDesc desc = new MethodDesc();
        desc.name_index = this.cp_putUtf8(name);
        desc.descriptor_index = this.cp_putUtf8(descriptor);
        if (generateID) {
            this.cp_putString(name);
        }
        return desc;
    }

    short cp_getClass(Class cls) {
        return AdaptorGen.hashGetShort(this.clsRef, cls);
    }

    short cp_getString(String string) {
        return AdaptorGen.hashGetShort(this.stringRef, string);
    }

    short cp_getWrapperConstructor(Class primType) {
        return AdaptorGen.hashGetShort(this.wrapperConsRef, primType);
    }

    short cp_getReturnMethodRef(Class retType) {
        if (retType.isPrimitive()) {
            return AdaptorGen.hashGetShort(this.returnMethodRef, retType);
        }
        return AdaptorGen.hashGetShort(this.returnMethodRef, Object.class);
    }

    class MethodDesc {
        short name_index;
        short descriptor_index;

        MethodDesc() {
        }
    }

    class ConstMethodRef {
        short class_index;
        short name_and_type_index;

        ConstMethodRef() {
        }
    }

    class ConstNameAndType {
        short name_index;
        short desc_index;

        ConstNameAndType() {
        }
    }

    class ConstClass {
        short name_index;

        ConstClass() {
        }
    }

    class ConstString {
        short string_index;

        ConstString() {
        }
    }

    class ConstUtf {
        String string;

        ConstUtf() {
        }
    }
}

