/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class FuncSig
implements InternalRep {
    Class targetCls;
    PkgInvoker pkgInvoker;
    Object func;
    static Hashtable instanceMethodTable = new Hashtable();
    static Hashtable staticMethodTable = new Hashtable();

    FuncSig(Class cls, PkgInvoker p, Object f) {
        this.targetCls = cls;
        this.pkgInvoker = p;
        this.func = f;
    }

    public InternalRep duplicate() {
        return new FuncSig(this.targetCls, this.pkgInvoker, this.func);
    }

    public void dispose() {
    }

    static FuncSig get(Interp interp, Class cls, TclObject signature, TclObject[] argv, int startIdx, int count, boolean isStatic) throws TclException {
        Object match;
        boolean isConstructor = cls == null;
        int sigLength = TclList.getLength((Interp)interp, (TclObject)signature);
        String methodName = null;
        if (sigLength == 0) {
            throw new TclException(interp, "bad signature \"" + signature + "\"");
        }
        TclObject class_or_method = sigLength == 1 ? signature : TclList.index((Interp)interp, (TclObject)signature, (int)0);
        if (isConstructor) {
            cls = JavaInvoke.getClassByName(interp, class_or_method.toString());
        } else {
            methodName = class_or_method.toString();
        }
        if ((isConstructor || isStatic) && !PkgInvoker.isAccessible(cls)) {
            throw new TclException(interp, "Class \"" + cls.getName() + "\" is not accessible");
        }
        if (isConstructor && Modifier.isAbstract(cls.getModifiers())) {
            throw new TclException(interp, "Class \"" + cls.getName() + "\" is abstract");
        }
        if (sigLength > 1 || sigLength == 1 && count == 0) {
            int sigNumArgs = sigLength - 1;
            Class[] paramTypes = new Class[sigNumArgs];
            for (int i = 0; i < sigNumArgs; ++i) {
                String clsName = TclList.index((Interp)interp, (TclObject)signature, (int)(i + 1)).toString();
                paramTypes[i] = JavaInvoke.getClassByName(interp, clsName);
            }
            if (isConstructor) {
                try {
                    match = FuncSig.getAccessibleConstructor(cls, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    if (sigLength > 1) {
                        throw new TclException(interp, "no accessible constructor \"" + signature + "\"");
                    }
                    throw new TclException(interp, "can't find accessible constructor with " + count + " argument(s) for class \"" + cls.getName() + "\"");
                }
            } else {
                match = FuncSig.lookupMethod(interp, cls, methodName, paramTypes, signature, isStatic);
            }
        } else {
            match = FuncSig.matchSignature(interp, cls, signature, methodName, isConstructor, argv, startIdx, count, isStatic);
        }
        FuncSig sig = new FuncSig(cls, PkgInvoker.getPkgInvoker(cls), match);
        return sig;
    }

    static Method lookupMethod(Interp interp, Class cls, String methodName, Class[] paramTypes, TclObject signature, boolean isStatic) throws TclException {
        boolean foundSameName = false;
        Method[] methods = isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls);
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            foundSameName = true;
            Class<?>[] pt = methods[i].getParameterTypes();
            if (pt.length != paramTypes.length) continue;
            boolean good = true;
            for (int j = 0; j < pt.length; ++j) {
                if (pt[j] == paramTypes[j]) continue;
                good = false;
                break;
            }
            if (!good) continue;
            return methods[i];
        }
        if (paramTypes.length > 0 || !foundSameName) {
            throw new TclException(interp, "no accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" in class " + cls.getName());
        }
        throw new TclException(interp, "can't find accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" with " + paramTypes.length + " argument(s) for class \"" + cls.getName() + "\"");
    }

    static Object matchSignature(Interp interp, Class cls, TclObject signature, String methodName, boolean isConstructor, TclObject[] argv, int startIdx, int argv_count, boolean isStatic) throws TclException {
        int i;
        boolean foundSameName = false;
        Vector<Executable> match_vector = new Vector<Executable>();
        boolean debug = false;
        Executable[] funcs = isConstructor ? FuncSig.getAccessibleConstructors(cls) : (isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls));
        for (i = 0; i < funcs.length; ++i) {
            Class<?>[] paramTypes;
            if (isConstructor) {
                paramTypes = ((Constructor)funcs[i]).getParameterTypes();
            } else {
                Method method = (Method)funcs[i];
                if (!methodName.equals(method.getName())) continue;
                foundSameName = true;
                paramTypes = method.getParameterTypes();
            }
            if (paramTypes.length != argv_count) continue;
            match_vector.addElement(funcs[i]);
        }
        if (match_vector.size() == 1) {
            return match_vector.elementAt(0);
        }
        if (match_vector.size() > 1) {
            int j;
            Class<?>[] match_classes;
            Class c;
            Class[] argv_classes = new Class[argv_count];
            for (i = 0; i < argv_count; ++i) {
                TclObject tobj = argv[startIdx + i];
                boolean isJavaObj = true;
                c = null;
                try {
                    c = ReflectObject.getClass(interp, tobj);
                }
                catch (TclException e) {
                    isJavaObj = false;
                }
                argv_classes[i] = isJavaObj ? c : String.class;
            }
            for (i = 0; i < match_vector.size(); ++i) {
                match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                boolean exact = true;
                for (j = 0; j < argv_count; ++j) {
                    if (match_classes[j] == argv_classes[j]) continue;
                    exact = false;
                    break;
                }
                if (!exact) continue;
                return match_vector.elementAt(i);
            }
            block6: for (i = match_vector.size() - 1; i >= 0; --i) {
                match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                for (j = 0; j < argv_count; ++j) {
                    if (JavaInvoke.isAssignable(match_classes[j], argv_classes[j])) continue;
                    match_vector.removeElementAt(i);
                    continue block6;
                }
            }
            if (match_vector.size() == 1) {
                return match_vector.elementAt(0);
            }
            if (match_vector.size() > 1) {
                Class[][] argv_classes_lookup = new Class[argv_count][];
                Vector class_vector = new Vector();
                for (i = 0; i < argv_count; ++i) {
                    c = argv_classes[i];
                    if (c == null) continue;
                    for (j = 0; j < i; ++j) {
                        if (c != argv_classes_lookup[j][0]) continue;
                        argv_classes_lookup[i] = argv_classes_lookup[j];
                    }
                    while (c != null) {
                        class_vector.addElement(null);
                        FuncSig.addInterfaces(c, class_vector);
                        c = c.getSuperclass();
                    }
                    class_vector.removeElementAt(0);
                    Object[] classes = new Class[class_vector.size()];
                    class_vector.copyInto(classes);
                    argv_classes_lookup[i] = classes;
                    class_vector.removeAllElements();
                }
                int[] super_steps = new int[match_vector.size()];
                int[] total_steps = new int[match_vector.size()];
                boolean[] trim_matches = new boolean[match_vector.size()];
                for (j = 0; j < argv_count; ++j) {
                    int min_super_step = Integer.MAX_VALUE;
                    int min_total_step = Integer.MAX_VALUE;
                    Class min_class = Object.class;
                    block12: for (i = 0; i < match_vector.size(); ++i) {
                        match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                        Class<?> match_to = match_classes[j];
                        Class[] arg_classes = argv_classes_lookup[j];
                        if (arg_classes == null) {
                            super_steps[i] = Integer.MAX_VALUE;
                            total_steps[i] = Integer.MAX_VALUE;
                            continue;
                        }
                        int super_step = 0;
                        for (int total_step = 0; total_step < arg_classes.length; ++total_step) {
                            Class c2 = arg_classes[total_step];
                            if (c2 == null) {
                                ++super_step;
                                continue;
                            }
                            if (c2 != match_to) continue;
                            super_steps[i] = super_step;
                            total_steps[i] = total_step;
                            if (super_step > min_super_step || c2.isInterface() && min_class != Object.class && !min_class.isInterface()) continue block12;
                            min_class = c2;
                            min_super_step = super_step;
                            if (total_step >= min_total_step) continue block12;
                            min_total_step = total_step;
                            continue block12;
                        }
                    }
                    for (i = match_vector.size() - 1; i >= 0; --i) {
                        if (super_steps[i] <= min_super_step && (super_steps[i] != min_super_step || total_steps[i] <= min_total_step)) continue;
                        trim_matches[i] = true;
                    }
                }
                for (i = match_vector.size() - 1; i >= 0; --i) {
                    if (!trim_matches[i]) continue;
                    match_vector.removeElementAt(i);
                }
            }
            if (match_vector.size() == 1) {
                return match_vector.elementAt(0);
            }
            StringBuffer sb = new StringBuffer(100);
            sb.append("ambiguous ");
            if (isConstructor) {
                sb.append("constructor");
            } else {
                sb.append("method");
            }
            sb.append(" signature");
            if (match_vector.size() == 0) {
                sb.append(", could not choose between ");
                funcs = isConstructor ? FuncSig.getAccessibleConstructors(cls) : (isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls));
                for (i = 0; i < funcs.length; ++i) {
                    Class<?>[] paramTypes;
                    if (isConstructor) {
                        paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                    } else {
                        Method method = (Method)funcs[i];
                        if (!methodName.equals(method.getName())) continue;
                        foundSameName = true;
                        paramTypes = method.getParameterTypes();
                    }
                    if (paramTypes.length != argv_count) continue;
                    match_vector.addElement(funcs[i]);
                }
            } else {
                sb.append(", assignable signatures are ");
            }
            TclObject siglist = TclList.newInstance();
            siglist.preserve();
            for (i = 0; i < match_vector.size(); ++i) {
                TclObject cur_siglist = TclList.newInstance();
                cur_siglist.preserve();
                if (isConstructor) {
                    Constructor con = (Constructor)match_vector.elementAt(i);
                    TclList.append((Interp)interp, (TclObject)cur_siglist, (TclObject)TclString.newInstance(con.getName()));
                    match_classes = con.getParameterTypes();
                } else {
                    Method meth = (Method)match_vector.elementAt(i);
                    TclList.append((Interp)interp, (TclObject)cur_siglist, (TclObject)TclString.newInstance(meth.getName()));
                    match_classes = meth.getParameterTypes();
                }
                for (j = 0; j < argv_count; ++j) {
                    Class<?> c3 = match_classes[j];
                    TclList.append((Interp)interp, (TclObject)cur_siglist, (TclObject)TclString.newInstance(JavaInfoCmd.getNameFromClass(c3)));
                }
                TclList.append((Interp)interp, (TclObject)siglist, (TclObject)cur_siglist);
                cur_siglist.release();
            }
            sb.append(siglist.toString());
            siglist.release();
            throw new TclException(interp, sb.toString());
        }
        if (isConstructor) {
            throw new TclException(interp, "can't find accessible constructor with " + argv_count + " argument(s) for class \"" + cls.getName() + "\"");
        }
        if (!foundSameName) {
            throw new TclException(interp, "no accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" in class " + cls.getName());
        }
        throw new TclException(interp, "can't find accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" with " + argv_count + " argument(s) for class \"" + cls.getName() + "\"");
    }

    private static void addInterfaces(Class cls, Vector v) {
        v.addElement(cls);
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            FuncSig.addInterfaces(interfaces[i], v);
        }
    }

    static Constructor[] getAccessibleConstructors(Class cls) {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getConstructors();
        }
        Object[] constructors = cls.getDeclaredConstructors();
        Vector vec = new Vector();
        boolean skipped_any = false;
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (PkgInvoker.isAccessible(c)) {
                vec.addElement(c);
                continue;
            }
            skipped_any = true;
        }
        if (skipped_any) {
            constructors = new Constructor[vec.size()];
            vec.copyInto(constructors);
        }
        return constructors;
    }

    static Constructor getAccessibleConstructor(Class cls, Class[] parameterTypes) throws NoSuchMethodException {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getConstructor(parameterTypes);
        }
        Constructor constructor = cls.getDeclaredConstructor(parameterTypes);
        if (!PkgInvoker.isAccessible(constructor)) {
            throw new NoSuchMethodException();
        }
        return constructor;
    }

    static Method[] getAccessibleInstanceMethods(Class cls) {
        Object[] methods = (Method[])instanceMethodTable.get(cls);
        if (methods != null) {
            return methods;
        }
        Vector vec = new Vector();
        Class c = cls;
        while (c != null) {
            methods = c.getDeclaredMethods();
            FuncSig.mergeInstanceMethods(c, (Method[])methods, vec);
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                FuncSig.mergeInstanceMethods(interfaces[i], interfaces[i].getMethods(), vec);
            }
            if (c.isInterface()) {
                c = Object.class;
                continue;
            }
            c = c.getSuperclass();
        }
        FuncSig.sortMethods(vec);
        methods = new Method[vec.size()];
        vec.copyInto(methods);
        instanceMethodTable.put(cls, methods);
        return methods;
    }

    static Method[] getAccessibleStaticMethods(Class cls) {
        Object[] methods = (Method[])staticMethodTable.get(cls);
        if (methods != null) {
            return methods;
        }
        methods = cls.getDeclaredMethods();
        Vector<Method> vec = new Vector<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!Modifier.isStatic(m.getModifiers()) || !PkgInvoker.isAccessible(m)) continue;
            vec.addElement(m);
        }
        FuncSig.sortMethods(vec);
        methods = new Method[vec.size()];
        vec.copyInto(methods);
        staticMethodTable.put(cls, methods);
        return methods;
    }

    private static void mergeInstanceMethods(Class c, Method[] methods, Vector vec) {
        for (int i = 0; i < methods.length; ++i) {
            boolean sameSigExists = false;
            Method newMeth = methods[i];
            if (newMeth == null || Modifier.isStatic(newMeth.getModifiers()) || !PkgInvoker.isAccessible(newMeth)) continue;
            for (int j = 0; j < vec.size(); ++j) {
                int oldRank;
                Method oldMeth = (Method)vec.elementAt(j);
                if (!FuncSig.methodSigEqual(oldMeth, newMeth)) continue;
                sameSigExists = true;
                Class<?> oldCls = oldMeth.getDeclaringClass();
                int newRank = FuncSig.getMethodRank(c, newMeth);
                if (newRank <= (oldRank = FuncSig.getMethodRank(oldCls, oldMeth))) break;
                vec.setElementAt(newMeth, j);
                break;
            }
            if (sameSigExists) continue;
            vec.addElement(newMeth);
        }
    }

    private static boolean methodSigEqual(Method method1, Method method2) {
        Class<?>[] param2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] param1 = method1.getParameterTypes();
        if (param1.length != (param2 = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < param1.length; ++i) {
            if (param1[i] == param2[i]) continue;
            return false;
        }
        return true;
    }

    private static void sortMethods(Vector vec) {
        boolean debug = false;
        int insize = vec.size();
        for (int i = 1; i < vec.size(); ++i) {
            Method jm;
            String jms;
            int c = i;
            Method cm = (Method)vec.elementAt(c);
            String cms = FuncSig.getMethodDescription(cm);
            int j = c - 1;
            while (j >= 0 && cms.compareTo(jms = FuncSig.getMethodDescription(jm = (Method)vec.elementAt(j))) <= 0) {
                vec.setElementAt(jm, c);
                vec.setElementAt(cm, j);
                c = j--;
            }
        }
        if (insize != vec.size()) {
            throw new RuntimeException("lost elements");
        }
    }

    private static String getMethodDescription(Method m) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(m.getName());
        Class<?>[] params = m.getParameterTypes();
        sb.append('(');
        for (int i = 0; i < params.length; ++i) {
            sb.append(JavaInfoCmd.getNameFromClass(params[i]));
            if (i >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") returns ");
        Class<?> ret = m.getReturnType();
        sb.append(JavaInfoCmd.getNameFromClass(ret));
        return sb.toString();
    }

    private static int getMethodRank(Class declaringCls, Method method) {
        int methMod = method.getModifiers();
        if (Modifier.isPrivate(methMod)) {
            return 0;
        }
        int clsMod = declaringCls.getModifiers();
        if (Modifier.isPublic(methMod) && Modifier.isPublic(clsMod)) {
            return 2;
        }
        return 0;
    }
}

