/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import tcl.lang.ClassRep;
import tcl.lang.FieldSig;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.JavaImportCmd;
import tcl.lang.JavaInfoCmd;
import tcl.lang.PropertySig;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class JavaInvoke {
    private static Object[] EMPTY_ARGS = new Object[0];

    JavaInvoke() {
    }

    static TclObject newInstance(Interp interp, TclObject signature, TclObject[] argv, int startIdx, int count) throws TclException {
        FuncSig sig = FuncSig.get(interp, null, signature, argv, startIdx, count, false);
        Object javaObj = JavaInvoke.call(interp, sig.pkgInvoker, signature, sig.func, null, argv, startIdx, count);
        return ReflectObject.newInstance(interp, sig.targetCls, javaObj);
    }

    static TclObject callMethod(Interp interp, TclObject reflectObj, TclObject signature, TclObject[] argv, int startIdx, int count, boolean convert) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        Class javaCl = ReflectObject.getClass(interp, reflectObj);
        FuncSig sig = FuncSig.get(interp, javaCl, signature, argv, startIdx, count, false);
        Method method = (Method)sig.func;
        if (!PkgInvoker.isAccessible(method.getReturnType())) {
            throw new TclException(interp, "Return type \"" + method.getReturnType().getName() + "\" is not accessible");
        }
        Object result = JavaInvoke.call(interp, sig.pkgInvoker, signature, method, javaObj, argv, startIdx, count);
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        return JavaInvoke.wrap(interp, method.getReturnType(), result, convert);
    }

    static TclObject callStaticMethod(Interp interp, TclObject classObj, TclObject signature, TclObject[] argv, int startIdx, int count, boolean convert) throws TclException {
        Class cls = ClassRep.get(interp, classObj);
        FuncSig sig = FuncSig.get(interp, cls, signature, argv, startIdx, count, true);
        Method method = (Method)sig.func;
        if (!PkgInvoker.isAccessible(method.getReturnType())) {
            throw new TclException(interp, "Return type \"" + method.getReturnType().getName() + "\" is not accessible");
        }
        Object result = JavaInvoke.call(interp, sig.pkgInvoker, signature, method, null, argv, startIdx, count);
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        return JavaInvoke.wrap(interp, method.getReturnType(), result, convert);
    }

    static Object call(Interp interp, PkgInvoker invoker, TclObject signature, Object func, Object obj, TclObject[] argv, int startIdx, int count) throws TclException {
        Object[] args;
        Class<?>[] paramTypes;
        Constructor cons = null;
        Method method = null;
        boolean isConstructor = func instanceof Constructor;
        if (isConstructor) {
            cons = (Constructor)func;
            paramTypes = cons.getParameterTypes();
        } else {
            method = (Method)func;
            paramTypes = method.getParameterTypes();
        }
        if (count != paramTypes.length) {
            throw new TclException(interp, "wrong # args for calling " + (isConstructor ? "constructor" : "method") + " \"" + signature + "\"");
        }
        if (count == 0) {
            args = EMPTY_ARGS;
        } else {
            args = new Object[count];
            for (int i = 0; i < count; ++i) {
                args[i] = JavaInvoke.convertTclObject(interp, paramTypes[i], argv[i + startIdx]);
            }
        }
        try {
            boolean debug = false;
            Object result = isConstructor ? invoker.invokeConstructor(cons, args) : invoker.invokeMethod(method, obj, args);
            return result;
        }
        catch (InstantiationException e) {
            throw new TclRuntimeError("unexpected abstract class: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected inaccessible ctor or method: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof TclException) {
                interp.setResult(te.getMessage());
                throw (TclException)te;
            }
            throw new ReflectException(interp, te);
        }
    }

    static final TclObject getField(Interp interp, TclObject classOrObj, TclObject signature, boolean convert) throws TclException {
        return JavaInvoke.getsetField(interp, classOrObj, signature, null, convert, true);
    }

    static final void setField(Interp interp, TclObject classOrObj, TclObject signature, TclObject value) throws TclException {
        JavaInvoke.getsetField(interp, classOrObj, signature, value, false, false);
    }

    static TclObject getsetField(Interp interp, TclObject classOrObj, TclObject signature, TclObject value, boolean convert, boolean isget) throws TclException {
        boolean isStatic;
        Object obj;
        Class cls;
        block14: {
            cls = null;
            obj = null;
            isStatic = false;
            try {
                obj = ReflectObject.get(interp, classOrObj);
            }
            catch (TclException e) {
                try {
                    cls = ClassRep.get(interp, classOrObj);
                }
                catch (TclException e1) {
                    throw new TclException(interp, "unknown class or object \"" + classOrObj + "\"");
                }
                isStatic = true;
                if (PkgInvoker.isAccessible(cls)) break block14;
                throw new TclException(interp, "Class \"" + cls.getName() + "\" is not accessible");
            }
        }
        if (!isStatic) {
            if (obj == null) {
                throw new TclException(interp, "can't access fields in a null object reference");
            }
            cls = ReflectObject.getClass(interp, classOrObj);
        }
        if (isStatic && isget && signature.toString().equals("class")) {
            return JavaInvoke.wrap(interp, Class.class, cls, false);
        }
        FieldSig sig = FieldSig.get(interp, signature, cls);
        Field field = sig.field;
        if (isStatic && !Modifier.isStatic(field.getModifiers())) {
            throw new TclException(interp, "can't access an instance field without an object");
        }
        if (!PkgInvoker.isAccessible(field.getType())) {
            throw new TclException(interp, "Field type \"" + field.getType().getName() + "\" is not accessible");
        }
        if (!isget && Modifier.isFinal(field.getModifiers())) {
            throw new TclException(interp, "can't set final field \"" + signature + "\"");
        }
        try {
            if (isget) {
                return JavaInvoke.wrap(interp, field.getType(), sig.pkgInvoker.getField(field, obj), convert);
            }
            Object javaValue = JavaInvoke.convertTclObject(interp, field.getType(), value);
            sig.pkgInvoker.setField(field, obj, javaValue);
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected IllegalAccessException: " + e.getMessage());
        }
    }

    static TclObject getProperty(Interp interp, TclObject reflectObj, TclObject propName, boolean convert) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        if (javaObj == null) {
            throw new TclException(interp, "can't get property from null object");
        }
        Class javaClass = ReflectObject.getClass(interp, reflectObj);
        PropertySig sig = PropertySig.get(interp, javaClass, propName);
        Method readMethod = sig.desc.getReadMethod();
        if (readMethod == null) {
            throw new TclException(interp, "can't get write-only property \"" + propName + "\"");
        }
        try {
            return JavaInvoke.wrap(interp, readMethod.getReturnType(), sig.pkgInvoker.invokeMethod(readMethod, javaObj, EMPTY_ARGS), convert);
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected inaccessible readMethod: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static void setProperty(Interp interp, TclObject reflectObj, TclObject propName, TclObject value) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        if (javaObj == null) {
            throw new TclException(interp, "can't set property in null object");
        }
        Class javaClass = ReflectObject.getClass(interp, reflectObj);
        PropertySig sig = PropertySig.get(interp, javaClass, propName);
        Method writeMethod = sig.desc.getWriteMethod();
        Class<?> type = sig.desc.getPropertyType();
        if (writeMethod == null) {
            throw new TclException(interp, "can't set read-only property \"" + propName + "\"");
        }
        Object[] args = new Object[]{JavaInvoke.convertTclObject(interp, type, value)};
        try {
            sig.pkgInvoker.invokeMethod(writeMethod, javaObj, args);
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected inaccessible writeMethod: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static Class getClassByName(Interp interp, String clsName) throws TclException {
        StringBuffer clsName_buf;
        Class<?> result;
        block30: {
            int clsName_len;
            result = null;
            StringBuffer prefix_buf = new StringBuffer();
            StringBuffer suffix_buf = new StringBuffer();
            clsName_buf = new StringBuffer(clsName);
            int dimension = 0;
            while ((clsName_len = clsName_buf.length()) > 2 && clsName_buf.charAt(clsName_len - 2) == '[' && clsName_buf.charAt(clsName_len - 1) == ']') {
                clsName_buf.setLength(clsName_len - 2);
                prefix_buf.append('[');
                ++dimension;
            }
            try {
                clsName = clsName_buf.toString();
                if (clsName.indexOf(46) == -1) {
                    if (dimension > 0) {
                        if (clsName.equals("int")) {
                            prefix_buf.append('I');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("boolean")) {
                            prefix_buf.append('Z');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("long")) {
                            prefix_buf.append('J');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("float")) {
                            prefix_buf.append('F');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("double")) {
                            prefix_buf.append('D');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("byte")) {
                            prefix_buf.append('B');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("short")) {
                            prefix_buf.append('S');
                            return Class.forName(prefix_buf.toString());
                        }
                        if (clsName.equals("char")) {
                            prefix_buf.append('C');
                            return Class.forName(prefix_buf.toString());
                        }
                        prefix_buf.append('L');
                        suffix_buf.append(';');
                    } else {
                        if (clsName.equals("int")) {
                            return Integer.TYPE;
                        }
                        if (clsName.equals("boolean")) {
                            return Boolean.TYPE;
                        }
                        if (clsName.equals("long")) {
                            return Long.TYPE;
                        }
                        if (clsName.equals("float")) {
                            return Float.TYPE;
                        }
                        if (clsName.equals("double")) {
                            return Double.TYPE;
                        }
                        if (clsName.equals("byte")) {
                            return Byte.TYPE;
                        }
                        if (clsName.equals("short")) {
                            return Short.TYPE;
                        }
                        if (clsName.equals("char")) {
                            return Character.TYPE;
                        }
                    }
                    TclClassLoader tclClassLoader = new TclClassLoader(interp, null);
                    try {
                        result = tclClassLoader.loadClass(prefix_buf + clsName + suffix_buf);
                    }
                    catch (ClassNotFoundException e) {
                        String fullyqualified = JavaImportCmd.getImport(interp, clsName);
                        if (fullyqualified == null) {
                            fullyqualified = "java.lang." + clsName;
                        }
                        try {
                            result = tclClassLoader.loadClass(prefix_buf + fullyqualified + suffix_buf);
                            break block30;
                        }
                        catch (SecurityException e2) {
                            result = null;
                        }
                    }
                    break block30;
                }
                TclClassLoader tclClassLoader = new TclClassLoader(interp, null);
                if (dimension > 0) {
                    clsName = prefix_buf + "L" + clsName + ";";
                }
                result = tclClassLoader.loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                result = null;
            }
            catch (SecurityException e) {
                throw new TclException(interp, "cannot load new class into java or tcl package");
            }
        }
        if (result == null) {
            throw new TclException(interp, "unknown class \"" + clsName_buf + "\"");
        }
        return result;
    }

    static TclObject convertJavaObject(Interp interp, Class cls, Object javaObj) throws TclException {
        if (javaObj == null) {
            if (cls == String.class) {
                return TclString.newInstance("");
            }
            return ReflectObject.newInstance(interp, cls, javaObj);
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return TclInteger.newInstance((Integer)javaObj);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return TclString.newInstance(javaObj.toString());
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return TclInteger.newInstance(((Short)javaObj).intValue());
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return TclInteger.newInstance(((Byte)javaObj).intValue());
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return TclDouble.newInstance((Double)javaObj);
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return TclDouble.newInstance(((Float)javaObj).doubleValue());
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return TclBoolean.newInstance((Boolean)javaObj);
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return TclString.newInstance(((Character)javaObj).toString());
        }
        if (cls == String.class) {
            return TclString.newInstance((String)javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    static final Object convertTclObject(Interp interp, Class type, TclObject tclObj) throws TclException {
        Object javaObj = null;
        Class javaClass = null;
        boolean isReflectObj = false;
        try {
            javaObj = ReflectObject.get(interp, tclObj);
            javaClass = ReflectObject.getClass(interp, tclObj);
            isReflectObj = true;
        }
        catch (TclException e) {
            interp.resetResult();
        }
        if (!isReflectObj) {
            if (type == String.class) {
                return tclObj.toString();
            }
            if (type == Object.class) {
                return tclObj.toString();
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return new Integer(TclInteger.get(interp, tclObj));
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return new Boolean(TclBoolean.get(interp, tclObj));
            }
            if (type == Long.TYPE || type == Long.class) {
                try {
                    return new Long(TclInteger.get(interp, tclObj));
                }
                catch (TclException e1) {
                    try {
                        return new Long(tclObj.toString());
                    }
                    catch (NumberFormatException e2) {
                        throw e1;
                    }
                }
            }
            if (type == Float.TYPE || type == Float.class) {
                return new Float((float)TclDouble.get(interp, tclObj));
            }
            if (type == Double.TYPE || type == Double.class) {
                return new Double(TclDouble.get(interp, tclObj));
            }
            if (type == Byte.TYPE || type == Byte.class) {
                int i = TclInteger.get(interp, tclObj);
                if (i < -128 || i > 127) {
                    throw new TclException(interp, "integer value too large to represent in a byte");
                }
                return new Byte((byte)i);
            }
            if (type == Short.TYPE || type == Short.class) {
                int i = TclInteger.get(interp, tclObj);
                if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
                    throw new TclException(interp, "integer value too large to represent in a short");
                }
                return new Short((short)i);
            }
            if (type == Character.TYPE || type == Character.class) {
                String str = tclObj.toString();
                if (str.length() == 1) {
                    return new Character(str.charAt(0));
                }
                throw new TclException(interp, "expected character but got \"" + tclObj + "\"");
            }
            if (type == TclObject.class) {
                return tclObj;
            }
            throw new TclException(interp, "\"" + tclObj + "\" is not an object handle of class \"" + JavaInfoCmd.getNameFromClass(type) + "\"");
        }
        if (JavaInvoke.isAssignable(type, javaClass)) {
            return javaObj;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                if (javaObj instanceof Boolean) {
                    return javaObj;
                }
            } else if (type == Character.TYPE) {
                if (javaObj instanceof Character) {
                    return javaObj;
                }
            } else if (type == Byte.TYPE) {
                if (javaObj instanceof Byte) {
                    return javaObj;
                }
            } else if (type == Short.TYPE) {
                if (javaObj instanceof Short) {
                    return javaObj;
                }
            } else if (type == Integer.TYPE) {
                if (javaObj instanceof Integer) {
                    return javaObj;
                }
            } else if (type == Long.TYPE) {
                if (javaObj instanceof Long) {
                    return javaObj;
                }
            } else if (type == Float.TYPE) {
                if (javaObj instanceof Float) {
                    return javaObj;
                }
            } else if (type == Double.TYPE) {
                if (javaObj instanceof Double) {
                    return javaObj;
                }
            } else if (type == Void.TYPE) {
                // empty if block
            }
        }
        if (type == TclObject.class) {
            return tclObj;
        }
        throw new TclException(interp, "expected object of type " + JavaInfoCmd.getNameFromClass(type) + " but got \"" + tclObj + "\" (" + (javaClass == null ? "null" : JavaInfoCmd.getNameFromClass(javaClass)) + ")");
    }

    private static final TclObject wrap(Interp interp, Class cls, Object javaObj, boolean convert) throws TclException {
        if (convert) {
            return JavaInvoke.convertJavaObject(interp, cls, javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    static final boolean isAssignable(Class to_cls, Class from_cls) {
        if (from_cls == null) {
            return !to_cls.isPrimitive();
        }
        return to_cls == from_cls || to_cls.isAssignableFrom(from_cls);
    }
}

