/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.ArrayObject;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.reflect.PkgInvoker;

public class ReflectObject
implements InternalRep,
CommandWithDispose {
    Object javaObj;
    Class javaClass;
    Interp ownerInterp;
    String refID;
    private int useCount;
    private boolean isValid;
    Hashtable bindings;
    private static final String NULL_REP = "java0x0";
    protected static final String NOCONVERT = "-noconvert";
    protected static final String CMD_PREFIX = "java0x";
    private static final boolean debug = false;
    private static final boolean dump = false;

    private static ReflectObject makeNullObject(Interp i, Class c) {
        ReflectObject ro = new ReflectObject();
        ro.ownerInterp = i;
        ro.refID = NULL_REP;
        ro.useCount = 1;
        ro.isValid = true;
        ro.javaObj = null;
        ro.javaClass = c;
        return ro;
    }

    private static String getHashString(Class cl, Object obj) {
        StringBuffer buff = new StringBuffer();
        buff.append(JavaInfoCmd.getNameFromClass(cl));
        buff.append('.');
        buff.append(System.identityHashCode(obj));
        return buff.toString();
    }

    private static void addToReflectTable(ReflectObject roRep) {
        Interp interp = roRep.ownerInterp;
        Class cl = roRep.javaClass;
        Object obj = roRep.javaObj;
        String id = roRep.refID;
        String hash = ReflectObject.getHashString(cl, obj);
        ReflectObject found = (ReflectObject)interp.reflectObjTable.get(hash);
        if (found == null) {
            interp.reflectObjTable.put(hash, roRep);
        } else {
            Vector<ReflectObject> conflicts = (Vector<ReflectObject>)interp.reflectConflictTable.get(hash);
            if (conflicts == null) {
                conflicts = new Vector<ReflectObject>();
                interp.reflectConflictTable.put(hash, conflicts);
            }
            conflicts.addElement(roRep);
        }
    }

    private static void removeFromReflectTable(ReflectObject roRep) {
        Interp interp = roRep.ownerInterp;
        Class cl = roRep.javaClass;
        Object obj = roRep.javaObj;
        String id = roRep.refID;
        String hash = ReflectObject.getHashString(cl, obj);
        ReflectObject found = (ReflectObject)interp.reflectObjTable.get(hash);
        if (found == null) {
            throw new TclRuntimeError("reflect table returned null for " + id + " with hash \"" + hash + "\"");
        }
        if (found == roRep) {
            interp.reflectObjTable.remove(hash);
            Vector conflicts = (Vector)interp.reflectConflictTable.get(hash);
            if (conflicts != null) {
                Object first = conflicts.elementAt(0);
                conflicts.removeElementAt(0);
                if (conflicts.isEmpty()) {
                    interp.reflectConflictTable.remove(hash);
                }
                interp.reflectObjTable.put(hash, first);
            }
        } else {
            Vector conflicts = (Vector)interp.reflectConflictTable.get(hash);
            if (conflicts == null) {
                throw new TclRuntimeError("conflict table mapped to null for " + id + " with hash \"" + hash + "\"");
            }
            if (!conflicts.removeElement(roRep)) {
                throw new TclRuntimeError("no entry in conflict table for " + id + " with hash \"" + hash + "\"");
            }
            if (conflicts.isEmpty()) {
                interp.reflectConflictTable.remove(hash);
            }
        }
    }

    private static ReflectObject findInConflictTable(Interp interp, Object obj, String hash) {
        Vector conflicts = (Vector)interp.reflectConflictTable.get(hash);
        if (conflicts == null) {
            return null;
        }
        Enumeration e = conflicts.elements();
        while (e.hasMoreElements()) {
            ReflectObject found = (ReflectObject)e.nextElement();
            if (found.javaObj != obj) continue;
            return found;
        }
        return null;
    }

    private static ReflectObject findInReflectTable(Interp interp, Class cl, Object obj) {
        String hash = ReflectObject.getHashString(cl, obj);
        ReflectObject found = (ReflectObject)interp.reflectObjTable.get(hash);
        if (found == null) {
            return null;
        }
        if (found.javaObj == obj) {
            return found;
        }
        return ReflectObject.findInConflictTable(interp, obj, hash);
    }

    public static void dump(Interp interp) {
        try {
            System.out.println("BEGIN DUMP -------------------------------");
            System.out.println("interp.reflectObjCount = " + interp.reflectObjCount);
            System.out.println("interp.reflectObjTable.size() = " + interp.reflectObjTable.size());
            System.out.println("interp.reflectConflictTable.size() = " + interp.reflectConflictTable.size());
            Enumeration keys = interp.reflectObjTable.keys();
            while (keys.hasMoreElements()) {
                String hash2;
                System.out.println();
                String hash = (String)keys.nextElement();
                ReflectObject roRep = (ReflectObject)interp.reflectObjTable.get(hash);
                if (roRep == null) {
                    throw new RuntimeException("Reflect table entry \"" + hash + "\" hashed to null");
                }
                if (roRep.ownerInterp != interp) {
                    throw new RuntimeException("roRep.ownerInterp not the same as current interp");
                }
                if (interp.getCommand(roRep.refID) == null) {
                    System.out.println("could not find command named \"" + roRep.refID + "\"");
                }
                if (!hash.equals(hash2 = ReflectObject.getHashString(roRep.javaClass, roRep.javaObj))) {
                    throw new RuntimeException("hash \"" + hash + "\" is not equal to calculated" + " hash \"" + hash2);
                }
                System.out.println("hash \"" + hash + "\" corresponds to ReflectObject with " + "refID \"" + roRep.refID + "\" useCount = \"" + roRep.useCount + "\" isValid = \"" + roRep.isValid + "\"" + " javaClass = \"" + JavaInfoCmd.getNameFromClass(roRep.javaClass) + "\"" + " System.identityHashCode(javaObj) = \"" + System.identityHashCode(roRep.javaObj) + "\"");
                Vector conflicts = (Vector)interp.reflectConflictTable.get(hash);
                if (conflicts == null) continue;
                System.out.println("Found conflict table for hash " + hash);
                Enumeration e = conflicts.elements();
                while (e.hasMoreElements()) {
                    ReflectObject found = (ReflectObject)e.nextElement();
                    System.out.println("hash conflict for \"" + hash + "\" corresponds to ReflectObject with " + "refID \"" + found.refID + "\"");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    private static ReflectObject makeReflectObject(Interp interp, Class cl, Object obj) throws TclException {
        if (cl != null && !PkgInvoker.isAccessible(cl)) {
            throw new TclException(interp, "Class \"" + cl.getName() + "\" is not accessible");
        }
        if (obj == null) {
            return ReflectObject.makeNullObject(interp, cl);
        }
        if (cl == null) {
            throw new TclException(interp, "non null reflect object with null class is not valid");
        }
        if (cl == Integer.TYPE) {
            cl = Integer.class;
        } else if (cl == Boolean.TYPE) {
            cl = Boolean.class;
        } else if (cl == Long.TYPE) {
            cl = Long.class;
        } else if (cl == Float.TYPE) {
            cl = Float.class;
        } else if (cl == Double.TYPE) {
            cl = Double.class;
        } else if (cl == Byte.TYPE) {
            cl = Byte.class;
        } else if (cl == Short.TYPE) {
            cl = Short.class;
        } else if (cl == Character.TYPE) {
            cl = Character.class;
        } else if (cl == Void.TYPE) {
            throw new TclException(interp, "void object type can not be reflected");
        }
        ReflectObject roRep = ReflectObject.findInReflectTable(interp, cl, obj);
        if (roRep != null) {
            ++roRep.useCount;
            return roRep;
        }
        roRep = cl.isArray() ? new ArrayObject() : new ReflectObject();
        roRep.ownerInterp = interp;
        roRep.javaObj = obj;
        roRep.javaClass = cl;
        Class<?> obj_class = roRep.javaObj.getClass();
        if (!roRep.javaClass.isAssignableFrom(obj_class)) {
            throw new TclException(interp, "object of type " + JavaInfoCmd.getNameFromClass(obj_class) + " can not be referenced as type " + JavaInfoCmd.getNameFromClass(roRep.javaClass));
        }
        ++interp.reflectObjCount;
        roRep.refID = CMD_PREFIX + Long.toHexString(interp.reflectObjCount);
        interp.createCommand(roRep.refID, (Command)roRep);
        ReflectObject.addToReflectTable(roRep);
        roRep.useCount = 1;
        roRep.isValid = true;
        return roRep;
    }

    public void dispose() {
        --this.useCount;
        if (this.useCount == 0 && this.refID != NULL_REP) {
            if (this.isValid) {
                this.ownerInterp.deleteCommand(this.refID);
            }
            ReflectObject.removeFromReflectTable(this);
            this.ownerInterp = null;
            this.javaObj = null;
            this.javaClass = null;
            this.bindings = null;
            this.refID = NULL_REP;
        }
    }

    public InternalRep duplicate() {
        ++this.useCount;
        return this;
    }

    private static void setReflectObjectFromAny(Interp interp, TclObject tobj) throws TclException {
        String s;
        ReflectObject roRep;
        InternalRep rep = tobj.getInternalRep();
        if (rep instanceof ReflectObject) {
            roRep = (ReflectObject)rep;
            if (roRep.isValid && roRep.ownerInterp == interp) {
                return;
            }
        }
        if ((s = tobj.toString()).startsWith(CMD_PREFIX)) {
            if (s.equals(NULL_REP)) {
                tobj.setInternalRep(ReflectObject.makeReflectObject(interp, null, null));
                return;
            }
            Command cmd = interp.getCommand(s);
            if (cmd != null && cmd instanceof ReflectObject && ((ReflectObject)cmd).isValid) {
                roRep = (ReflectObject)cmd;
                ++roRep.useCount;
                tobj.setInternalRep(roRep);
                return;
            }
        }
        throw new TclException(interp, "unknown java object \"" + tobj + "\"");
    }

    public static TclObject newInstance(Interp interp, Class cl, Object obj) throws TclException {
        return new TclObject(ReflectObject.makeReflectObject(interp, cl, obj));
    }

    public static Object get(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        ReflectObject rep = (ReflectObject)tobj.getInternalRep();
        return rep.javaObj;
    }

    public static Class getClass(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        ReflectObject rep = (ReflectObject)tobj.getInternalRep();
        return rep.javaClass;
    }

    static ReflectObject getReflectObject(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        return (ReflectObject)tobj.getInternalRep();
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int sigIdx;
        boolean convert;
        if (!this.isValid) {
            throw new TclException(interp, "reflected object is no longer valid");
        }
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? signature ?arg arg ...?");
        }
        String arg1 = argv[1].toString();
        if (arg1.length() >= 2 && NOCONVERT.startsWith(arg1)) {
            convert = false;
            sigIdx = 2;
        } else {
            convert = true;
            sigIdx = 1;
        }
        if (argv.length < sigIdx + 1) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? signature ?arg arg ...?");
        }
        int startIdx = sigIdx + 1;
        int count = argv.length - startIdx;
        TclObject result = JavaInvoke.callMethod(interp, argv[0], argv[sigIdx], argv, startIdx, count, convert);
        if (result == null) {
            interp.resetResult();
        } else {
            interp.setResult(result);
        }
    }

    public void disposeCmd() {
        this.isValid = false;
    }

    public String toString() {
        return this.refID;
    }
}

