/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class TclClassLoader
extends ClassLoader {
    private static Hashtable classes = new Hashtable();
    private String[] classpath;
    private String[] loadpath;
    private String lastSearchedClassFile = null;
    private String lastSearchedJarFile = null;

    TclClassLoader(Interp interp, TclObject pathList) {
        try {
            int i;
            TclObject[] elem;
            if (pathList != null) {
                elem = TclList.getElements((Interp)interp, (TclObject)pathList);
                this.classpath = new String[elem.length];
                for (i = 0; i < elem.length; ++i) {
                    this.classpath[i] = TclClassLoader.absolutePath(interp, elem[i].toString());
                }
            }
            if ((elem = TclClassLoader.getEnvTclClasspath(interp)) != null) {
                this.loadpath = new String[elem.length];
                for (i = 0; i < elem.length; ++i) {
                    this.loadpath[i] = TclClassLoader.absolutePath(interp, elem[i].toString());
                }
            }
        }
        catch (TclException e) {
            // empty catch block
        }
    }

    protected Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException, SecurityException {
        Class<?> result = (Class<?>)classes.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (NoClassDefFoundError e) {
        }
        catch (IncompatibleClassChangeError e) {
            // empty catch block
        }
        if (className.startsWith("java.") || className.startsWith("tcl.")) {
            throw new SecurityException("Java loader failed to load the class and the Tcl Java loader is not permitted to load classes in the tcl or java package at runtime, check your CLASSPATH.");
        }
        byte[] classData = this.getClassFromPath(this.classpath, className);
        if (classData == null) {
            classData = this.getClassFromPath(this.loadpath, className);
        }
        if (classData == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            result = this.defineClass(className, classData, 0, classData.length);
        }
        catch (NoClassDefFoundError err) {
            throw new ClassFormatError();
        }
        catch (ClassFormatError err) {
            StringBuffer buf = new StringBuffer(50);
            buf.append(err.getMessage());
            buf.append(". ");
            if (this.lastSearchedClassFile != null) {
                buf.append(this.lastSearchedClassFile);
            } else {
                buf.append(className);
            }
            if (this.lastSearchedJarFile != null) {
                buf.append(" loaded from ");
                buf.append(this.lastSearchedJarFile);
            }
            buf.append(": class name does not match");
            buf.append(" the name defined in the classfile");
            throw new ClassFormatError(buf.toString());
        }
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        classes.put(className, result);
        return result;
    }

    Class defineClass(String className, byte[] classData) {
        Class<?> result = null;
        try {
            result = this.defineClass(null, classData, 0, classData.length);
        }
        catch (ClassFormatError e) {
            // empty catch block
        }
        if (result != null) {
            if (className == null) {
                className = result.getName();
            }
            classes.put(className, result);
        }
        return result;
    }

    private byte[] getClassFromPath(String[] paths, String className) {
        int i = 0;
        byte[] classData = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (paths != null) {
            String curDir;
            className = className.replace('.', '/') + ".class";
            for (i = 0; i < paths.length; ++i) {
                curDir = paths[i].toString();
                try {
                    if (curDir.endsWith(".jar") || curDir.endsWith(".zip")) {
                        classData = this.extractClassFromJar(curDir, className);
                        if (classData == null) continue;
                        return classData;
                    }
                    File file = new File(curDir, className);
                    if (!file.exists()) continue;
                    FileInputStream fi = new FileInputStream(file);
                    classData = new byte[fi.available()];
                    for (int total = fi.read(classData); total != classData.length; total += fi.read(classData, total, classData.length - total)) {
                    }
                    this.lastSearchedClassFile = file.toString();
                    return classData;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (i = 0; i < paths.length; ++i) {
                curDir = paths[i].toString();
                try {
                    classData = this.getClassFromJar(curDir, className);
                    if (classData == null) continue;
                    return classData;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private byte[] getClassFromJar(String curDir, String className) throws IOException {
        byte[] result = null;
        JarFilenameFilter jarFilter = new JarFilenameFilter();
        String[] jarFiles = new File(curDir).list(jarFilter);
        for (int i = 0; i < jarFiles.length && (result = this.extractClassFromJar(curDir + File.separatorChar + jarFiles[i], className)) == null; ++i) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractClassFromJar(String jarName, String className) throws IOException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(jarName));
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (!className.equals(entry.getName())) continue;
                int size = this.getEntrySize(jarName, className);
                byte[] result = new byte[size];
                for (int total = zin.read(result); total != size; total += zin.read(result, total, size - total)) {
                }
                this.lastSearchedClassFile = className;
                this.lastSearchedJarFile = jarName;
                byte[] byArray = result;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zin.close();
        }
    }

    private int getEntrySize(String jarName, String className) throws IOException {
        ZipFile zip = new ZipFile(jarName);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!className.equals(entry.getName())) continue;
            zip.close();
            return (int)entry.getSize();
        }
        return -1;
    }

    private static TclObject[] getEnvTclClasspath(Interp interp) throws TclException {
        try {
            return TclList.getElements((Interp)interp, (TclObject)interp.getVar("env", "TCL_CLASSPATH", 1));
        }
        catch (TclException e) {
            interp.resetResult();
            return null;
        }
    }

    private static String absolutePath(Interp interp, String dirName) throws TclException {
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            String newName = interp.getWorkingDir().toString() + System.getProperty("file.separator") + dirName;
            dir = new File(newName);
        }
        return dir.toString();
    }

    void removeCache(String className) {
        classes.remove(className);
    }
}

