/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletContext;

public class JnlpResource {
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String JAR_MIME_TYPE = "application/x-java-archive";
    private static final String JNLP_EXTENSION = ".jnlp";
    private static final String JAR_EXTENSION = ".jar";
    private static String _jnlpExtension = ".jnlp";
    private static String _jarExtension = ".jar";
    private String _name;
    private String _versionId;
    private String[] _osList;
    private String[] _archList;
    private String[] _localeList;
    private String _path;
    private URL _resource;
    private long _lastModified;
    private String _mimeType;
    private String _returnVersionId;

    public static void setDefaultExtensions(String string, String string2) {
        if (string != null && string.length() > 0) {
            if (!string.startsWith(".")) {
                string = "." + string;
            }
            _jnlpExtension = string;
        }
        if (string2 != null && string2.length() > 0) {
            if (!string2.startsWith(".")) {
                string2 = "." + string2;
            }
            _jarExtension = string2;
        }
    }

    public JnlpResource(ServletContext servletContext, String string) {
        this(servletContext, null, null, null, null, null, string, null);
    }

    public JnlpResource(ServletContext servletContext, String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, String string4) {
        this._name = string;
        this._versionId = string2;
        this._osList = stringArray;
        this._archList = stringArray2;
        this._localeList = stringArray3;
        this._path = string3.trim();
        this._returnVersionId = string4;
        try {
            this._resource = servletContext.getResource(string3);
            if (this._resource != null) {
                String string5;
                this._mimeType = this.getMimeType(servletContext, string3);
                URLConnection uRLConnection = this._resource.openConnection();
                this._lastModified = uRLConnection.getLastModified();
                if (this._lastModified == 0L && (string5 = servletContext.getRealPath(string3)) != null) {
                    File file = new File(string5);
                    if (file.exists()) {
                        this._lastModified = file.lastModified();
                    } else {
                        this._resource = null;
                    }
                }
            }
        }
        catch (IOException iOException) {
            this._resource = null;
        }
    }

    public String getPath() {
        return this._path;
    }

    public URL getResource() {
        return this._resource;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public boolean exists() {
        return this._resource != null;
    }

    public boolean isJnlpFile() {
        return this._path.endsWith(_jnlpExtension);
    }

    public boolean isJarFile() {
        return this._path.endsWith(_jarExtension);
    }

    public String getName() {
        return this._name;
    }

    public String getVersionId() {
        return this._versionId;
    }

    public String[] getOSList() {
        return this._osList;
    }

    public String[] getArchList() {
        return this._archList;
    }

    public String[] getLocaleList() {
        return this._localeList;
    }

    public String getReturnVersionId() {
        return this._returnVersionId;
    }

    private String getMimeType(ServletContext servletContext, String string) {
        String string2 = servletContext.getMimeType(string);
        if (string2 != null) {
            return string2;
        }
        if (string.endsWith(_jnlpExtension)) {
            return JNLP_MIME_TYPE;
        }
        if (string.endsWith(_jarExtension)) {
            return JAR_MIME_TYPE;
        }
        return "application/unknown";
    }

    public String toString() {
        return "JnlpResource[WAR Path: " + this._path + this.showEntry(" versionId=", this._versionId) + this.showEntry(" name=", this._name) + " lastModified=" + new Date(this._lastModified) + this.showEntry(" osList=", this._osList) + this.showEntry(" archList=", this._archList) + this.showEntry(" localeList=", this._localeList) + "]" + this.showEntry(" returnVersionId=", this._returnVersionId) + "]";
    }

    private String showEntry(String string, String string2) {
        if (string2 == null) {
            return "";
        }
        return string + string2;
    }

    private String showEntry(String string, String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        return string + Arrays.asList(stringArray).toString();
    }
}

