/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.cmp.CertRepMessage;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class PkCertRepEvent
extends PkRepEvent {
    private static final long serialVersionUID = 7268145541632707758L;
    private Certificate cert;
    private Object message = null;

    public PkCertRepEvent(Object source, Object msg, PkReqEvent req, Certificate cert) {
        super(source, msg, req);
        this.cert = cert;
        this.message = msg;
    }

    public Certificate getCert() {
        return this.cert;
    }

    public X509Certificate[] getCertificateChain() {
        Object pkiBody;
        X509Certificate[] caPubs = null;
        X509Certificate[] certificateChain = null;
        X509Certificate targetCertificate = null;
        if (this.message != null && this.message instanceof PKIMessage && (pkiBody = ((PKIMessage)this.message).getBody()) != null && pkiBody instanceof CertRepMessage) {
            caPubs = (X509Certificate[])((CertRepMessage)pkiBody).getCAPubs();
            caPubs = this.sortSignerCerts(caPubs);
            targetCertificate = (X509Certificate)this.getCert();
            if (caPubs != null && targetCertificate != null) {
                certificateChain = new X509Certificate[caPubs.length + 1];
                System.arraycopy(caPubs, 0, certificateChain, 1, caPubs.length);
                certificateChain[0] = targetCertificate;
            }
        }
        return certificateChain;
    }

    private X509Certificate[] sortSignerCerts(X509Certificate[] signerCerts) {
        Principal issuerDN;
        if (signerCerts.length <= 1) {
            return signerCerts;
        }
        Principal subjectDN = signerCerts[signerCerts.length - 1].getSubjectDN();
        if (((Object)subjectDN).equals(issuerDN = signerCerts[signerCerts.length - 1].getIssuerDN())) {
            return signerCerts;
        }
        X509Certificate[] newSignerCerts = new X509Certificate[signerCerts.length];
        int j = signerCerts.length - 1;
        for (int i = 0; i < signerCerts.length; ++i) {
            newSignerCerts[i] = signerCerts[j];
            --j;
        }
        return newSignerCerts;
    }

    public String getSubjectDn() {
        return this.getSubjectX500Name().toString();
    }

    private X500Name getSubjectX500Name() {
        return (X500Name)((X509CertImpl)this.cert).getSubjectDN();
    }

    public BigInteger getSerialNumber() {
        return ((X509CertImpl)this.cert).getSerialNumber();
    }

    public byte[] getEncodedCert() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    public void write(PkEventFormatter formatter, OutputStream outputStream) throws IOException, PkException {
        formatter.writeCertRep(this, outputStream);
    }

    public String toString() {
        if (this.cert != null) {
            return super.toString() + "\n" + this.cert.toString();
        }
        return super.toString() + "\n" + "Either no cert present or encrypted cert could not be decrypted";
    }
}

