/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkConfRepEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.base.PkRevoRepEvent;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.util.PkNormalize;
import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.X500Name;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public class PkEeXMgr
extends PkPipe
implements PkConstants {
    private static final String sccsid = "@(#) 84 1.11.1.1    com/tivoli/pki/beans/PkEeXMgr.java, PkBeans, javapki2, 09172003 9/17/03 10:27:51";
    private static BigInteger BIG_ONE = BigInteger.valueOf(1L);

    public PkInitRepEvent doInitReq(PkInitReqEvent req) throws PkException {
        boolean isUpdate = false;
        Object tmpHeader = null;
        PkInitRepEvent ret = null;
        Object obj = req.getAttrs().getValue("x509.info.subject", null);
        String subject = null;
        try {
            subject = new PkNormalize().normalize(req.getAttrs().getValue("x509.info.subject").toString());
        }
        catch (Exception e) {
            subject = req.getAttrs().getValue("x509.info.subject").toString();
        }
        ret = this.propagate(req);
        BigInteger serial = ret.getSerialNumber();
        return ret;
    }

    public PkSecnRepEvent doSecnReq(PkSecnReqEvent req) throws PkException {
        PkSecnRepEvent ret = null;
        try {
            ret = this.propagate(req);
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        return ret;
    }

    public PkConfRepEvent doConfReq(PkConfReqEvent req) throws PkException {
        PkConfRepEvent rep = null;
        InfoTypeAndValue[] itva = null;
        itva = (InfoTypeAndValue[])req.getAttrs().getValue("cert.oper.certRevocationPassphrase", null);
        PKIHeader hdr = (PKIHeader)req.getAttrs().getValue("TMP_MSG_HDR");
        if (hdr == null) {
            throw new PkException(PkNLSConstants.MISSING_MESSAGE_HEADER);
        }
        try {
            PrivateKey pKey = (PrivateKey)req.getAttrs().getValue("cert.oper.messageProtectionKey", null);
            if (pKey == null) {
                String initPwd = (String)req.getAttrs().getValue("x509.info.init_pwd", null);
                PkAttrs newAttrs = req.getAttrs();
                KeyIdentifier senderKid = (KeyIdentifier)req.getAttrs().getValue("cert.oper.SenderKeyIdentifier");
                PKIMessage msg1 = this.getConfMessage(hdr, senderKid, initPwd, itva);
                PkConfReqEvent req1 = new PkConfReqEvent(req.getSource(), msg1, newAttrs);
                rep = (PkConfRepEvent)this.propagate(req1);
            } else {
                PKIMessage msg1 = this.getConfMessageForCr(hdr, req.getAttrs());
                PkConfReqEvent req1 = new PkConfReqEvent(req.getSource(), msg1, req.getAttrs());
                rep = (PkConfRepEvent)this.propagate(req1);
            }
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        return rep;
    }

    public PkRevoRepEvent doRevoReq(PkRevoReqEvent req) throws PkException {
        Object rep = null;
        PKIHeader hdr = null;
        try {
            hdr = this.createHeader(req.getAttrs());
            req.getAttrs().add("TMP_MSG_HDR", 2, hdr);
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        return this.propagate(new PkRevoReqEvent(this, null, req.getAttrs()));
    }

    private PKIHeader createHeader(PkAttrs attrs) throws Exception {
        boolean hasPublicKey = false;
        if (attrs.getValue("x509.info.certrevopublickey", null) != null) {
            hasPublicKey = true;
        }
        GeneralName sender = null;
        GeneralName recipient = null;
        KeyIdentifier senderKid = null;
        KeyIdentifier recipKid = null;
        if (!hasPublicKey) {
            sender = new GeneralName((GeneralNameInterface)((X500Name)attrs.getValue("x509.info.subject")));
            recipient = (GeneralName)attrs.getValue("cert.oper.RECIPIENT_DN");
            senderKid = (KeyIdentifier)attrs.getValue("cert.oper.SenderKeyIdentifier", null);
            recipKid = null;
        } else {
            sender = new GeneralName((GeneralNameInterface)new X500Name("o=JavaPki,c=US"));
            recipient = new GeneralName((GeneralNameInterface)new X500Name("o=JavaPki,c=US"));
            senderKid = new KeyIdentifier(new String("JavaPki").getBytes());
            recipKid = new KeyIdentifier(new String("JavaPki").getBytes());
        }
        byte[] senderNonce = new Date().toString().getBytes();
        byte[] recipNonce = null;
        byte[] tx_id = new Long(new Date().getTime()).toString().getBytes();
        byte[] salt = "this is a salt".getBytes();
        AlgorithmId owf = new AlgorithmId(AlgorithmId.SHA_oid);
        int iterationCount = 1001;
        AlgorithmId mac = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pbmspec = new PBMParameterSpec(salt, owf, iterationCount, mac);
        AlgorithmParameters pbmparam = null;
        InfoTypeAndValue[] itva = (InfoTypeAndValue[])attrs.getValue("cert.oper.certRevocationPassphrase", null);
        try {
            pbmparam = AlgorithmParameters.getInstance("PasswordBasedMac", PkEeFactory.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (NoSuchProviderException ee) {
            throw ee;
        }
        pbmparam.init((AlgorithmParameterSpec)pbmspec);
        AlgorithmId pbmalgid = null;
        pbmalgid = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, pbmparam.getEncoded());
        PKIHeader head = new PKIHeader(BIG_ONE, sender, recipient, new Date(), pbmalgid, senderKid, recipKid, tx_id, senderNonce, recipNonce, null, itva);
        return head;
    }

    private PKIHeader createHeader1(PkAttrs attrs) throws Exception {
        GeneralName sender = new GeneralName((GeneralNameInterface)((X500Name)attrs.getValue("x509.info.subject")));
        GeneralName recipient = (GeneralName)attrs.getValue("cert.oper.RECIPIENT_DN", null);
        KeyIdentifier senderKid = (KeyIdentifier)attrs.getValue("cert.oper.SenderKeyIdentifier");
        Object recipKid = null;
        byte[] senderNonce = new Date().toString().getBytes();
        InfoTypeAndValue[] itva = (InfoTypeAndValue[])attrs.getValue("cert.oper.certRevocationPassphrase", null);
        PKIHeader head = new PKIHeader(BIG_ONE, sender, recipient, null, null, senderKid, null, null, senderNonce, null, null, itva);
        return head;
    }

    private PKIMessage getConfMessage(PKIHeader head, KeyIdentifier senderKid1, String initPwd, InfoTypeAndValue[] itva) throws Exception {
        GeneralName sender1 = head.getRecipient();
        GeneralName recepient1 = head.getSender();
        KeyIdentifier recipKid1 = null;
        byte[] senderNonce1 = head.getRecipNonce();
        byte[] recipNonce1 = head.getSenderNonce();
        byte[] tx_id = head.getTransactionID();
        byte[] salt = "this is a salt".getBytes();
        AlgorithmId owf = new AlgorithmId(AlgorithmId.SHA_oid);
        int iterationCount = 1001;
        AlgorithmId mac = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pbmspec = new PBMParameterSpec(salt, owf, iterationCount, mac);
        AlgorithmParameters pbmparam = null;
        try {
            pbmparam = AlgorithmParameters.getInstance("PasswordBasedMac", PkEeFactory.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (NoSuchProviderException ee) {
            throw ee;
        }
        pbmparam.init((AlgorithmParameterSpec)pbmspec);
        AlgorithmId pbmalgid = null;
        pbmalgid = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, pbmparam.getEncoded());
        PKIHeader head1 = new PKIHeader(BIG_ONE, sender1, recepient1, new Date(), pbmalgid, senderKid1, recipKid1, tx_id, senderNonce1, recipNonce1, null, itva);
        PKIMessage pkiMessage1 = new PKIMessage(head1, 19, null, null, null);
        PKIMessage pkiMessage2 = null;
        try {
            if (initPwd == null) {
                throw new PkRejectionException(PkNLSConstants.MSG_CANNOT_BE_PROTECTED);
            }
            pkiMessage2 = pkiMessage1.protect(initPwd.getBytes());
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        return pkiMessage2;
    }

    private PKIMessage getConfMessageForCr(PKIHeader head, PkAttrs attrSet) throws Exception {
        GeneralName sender1 = head.getRecipient();
        GeneralName recepient1 = head.getSender();
        KeyIdentifier senderKid1 = (KeyIdentifier)attrSet.getValue("cert.oper.SenderKeyIdentifier");
        KeyIdentifier recipKid1 = null;
        byte[] senderNonce1 = head.getRecipNonce();
        byte[] recipNonce1 = head.getSenderNonce();
        byte[] tx_id = head.getTransactionID();
        boolean isDigitalSig = true;
        AlgorithmId algId = (AlgorithmId)attrSet.getValue("x509.info.algorithmID");
        Object msgProtAlgId = null;
        InfoTypeAndValue[] itva = null;
        itva = (InfoTypeAndValue[])attrSet.getValue("cert.oper.certRevocationPassphrase", null);
        PKIHeader head1 = new PKIHeader(BIG_ONE, sender1, recepient1, new Date(), algId, senderKid1, recipKid1, tx_id, senderNonce1, recipNonce1, null, itva);
        DerOutputStream dos = new DerOutputStream();
        head1.encode((OutputStream)dos);
        DerOutputStream derOut = new DerOutputStream();
        derOut.write((byte)48, dos);
        byte[] ba = derOut.toByteArray();
        byte[] ba1 = null;
        try {
            String providerName = (String)attrSet.getValue("cert.oper.PROVIDER");
            PrivateKey pKey = (PrivateKey)attrSet.getValue("cert.oper.messageProtectionKey");
            String algorithmName = pKey instanceof RSAPrivateKey ? "SHA1withRSA" : "SHA1withDSA";
            Signature sig = Signature.getInstance(algorithmName, providerName);
            sig.initSign(pKey);
            sig.update(ba);
            ba1 = sig.sign();
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        PKIMessage pkiMessage1 = new PKIMessage(head1, 19, null, ba1, null);
        return pkiMessage1;
    }
}

