/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.Pk10Certificate;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Enumeration;

public final class Pk10CertFactory {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.certclient.Pk10CertFactory";

    private Pk10CertFactory() {
        throw new UnsupportedOperationException();
    }

    public static Pk10Certificate newCert(String pkcs10CertRequestFile, Date notBeforeDate, int validityPeriod, X509Certificate signingCert, PrivateKey signingCertPrivateKey) throws PkRejectionException {
        Pk10CertImpl myPk10CertImpl = new Pk10CertImpl(pkcs10CertRequestFile, notBeforeDate, validityPeriod, signingCert, signingCertPrivateKey);
        return myPk10CertImpl;
    }

    public static Pk10Certificate newCert(byte[] pkcs10CertRequestDER, Date notBeforeDate, int validityPeriod, X509Certificate signingCert, PrivateKey signingCertPrivateKey) throws PkRejectionException {
        Pk10CertImpl myPk10CertImpl = new Pk10CertImpl(pkcs10CertRequestDER, notBeforeDate, validityPeriod, signingCert, signingCertPrivateKey);
        return myPk10CertImpl;
    }

    private static final class Pk10CertImpl
    implements Pk10Certificate,
    PkConstants {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private static final Object className = "com.ibm.security.certclient.Pk10CertImpl";
        private X509Certificate newCert;
        private CertificationRequest cr;
        private PrivateKey signingKey;
        X500Name subjectName;
        X500Name issuerName;
        int version;
        BigInteger serial_number;
        private PublicKey publicKey;
        private int newCertValidityPeriod;
        Date notAfterDate;
        AlgorithmId algId;
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        KeyUsageExtension keyUsageExtension = null;
        ExtKeyUsageExtension extKeyUsageExtension = null;

        Pk10CertImpl(String pkcs10CertRequestFile, Date notBeforeDate, int validityPeriod, X509Certificate signingCert, PrivateKey signingCertPrivateKey) throws PkRejectionException {
            this.signingKey = signingCertPrivateKey;
            if (this.signingKey == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  Null signingKey received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            if (signingCert == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  Null signingCert received");
                }
                throw new PkRejectionException("signingCert is null");
            }
            if (validityPeriod <= 0) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The validityPeriod argument is <= 0 days");
                }
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            if (notBeforeDate == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The notBeforeDate is null.");
                }
                throw new PkRejectionException("notBeforeDate is null.");
            }
            if (pkcs10CertRequestFile == null || pkcs10CertRequestFile.length() <= 0) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  Null PKCS10CertificateRequest file name received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_INITIAL_CERT_REQUEST_MISSING);
            }
            this.cr = null;
            try {
                this.cr = new CertificationRequest(pkcs10CertRequestFile, true);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The input PKCS10 certificate request is: \n" + this.cr.toString() + "\n");
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The following exception was thrown:");
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
                throw new PkRejectionException(PkNLSConstants.FILE_IO_FAILED, e);
            }
            this.newCert = this.buildX509Cert(this.cr, notBeforeDate, validityPeriod, signingCert, signingCertPrivateKey);
            if (debug != null) {
                System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The generated certificate is: \n" + this.newCert.toString() + "\n");
            }
        }

        Pk10CertImpl(byte[] pkcs10CertRequestDER, Date notBeforeDate, int validityPeriod, X509Certificate signingCert, PrivateKey signingCertPrivateKey) throws PkRejectionException {
            this.signingKey = signingCertPrivateKey;
            if (this.signingKey == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  Null signingKey received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            if (signingCert == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  Null signingCert received");
                }
                throw new PkRejectionException("signingCert is null");
            }
            if (validityPeriod <= 0) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The validityPeriod argument is <= 0 days");
                }
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            if (notBeforeDate == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(String, PrivateKey):  The notBeforeDate is null.");
                }
                throw new PkRejectionException("notBeforeDate is null.");
            }
            if (pkcs10CertRequestDER == null) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  Null PKCS10CertificateRequest received");
                }
                throw new PkRejectionException(PkNLSConstants.EE_INITIAL_CERT_REQUEST_MISSING);
            }
            this.cr = null;
            try {
                this.cr = new CertificationRequest(pkcs10CertRequestDER);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The input PKCS10 certificate request is: \n" + this.cr.toString() + "\n");
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The following exception was thrown:");
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
                throw new PkRejectionException(PkNLSConstants.FILE_IO_FAILED, e);
            }
            this.newCert = this.buildX509Cert(this.cr, notBeforeDate, validityPeriod, signingCert, signingCertPrivateKey);
            if (debug != null) {
                System.out.println("Pk10CertFactory.java:  Pk10CertImpl(byte[], PrivateKey):  The generated certificate is: \n" + this.newCert.toString() + "\n");
            }
        }

        private X509CertImpl buildX509Cert(CertificationRequest cr, Date notBeforeDate, int validityPeriod, X509Certificate signingCert, PrivateKey signingKey) throws PkRejectionException {
            if (debug != null) {
                System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  METHOD ENTRY");
            }
            boolean isRSAKeyType = signingKey instanceof RSAPrivateKey;
            X509CertInfo x509CertInfo = new X509CertInfo();
            CertificationRequestInfo cri = cr.getCertRequestInfo();
            try {
                this.version = 2;
                x509CertInfo.set("version", (Object)new CertificateVersion(this.version));
                this.subjectName = cri.getSubjectName();
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The subjectName taken from the CertificationRequest is:  " + this.subjectName);
                }
                x509CertInfo.set("subject", (Object)new CertificateSubjectName(this.subjectName));
                this.publicKey = cri.getSubjectPublicKeyInfo();
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The PublicKey taken from the CertificationRequest is:  " + this.publicKey.toString());
                }
                x509CertInfo.set("key", (Object)new CertificateX509Key(this.publicKey));
                this.issuerName = new X500Name(signingCert.getSubjectDN().getName());
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The issuerName which will be used is:  " + this.issuerName);
                }
                x509CertInfo.set("issuer", (Object)new CertificateIssuerName(this.issuerName));
                this.notAfterDate = new Date();
                this.newCertValidityPeriod = validityPeriod;
                this.notAfterDate.setTime(notBeforeDate.getTime() + (long)(validityPeriod * 24 * 60 * 60) * 1000L);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  notBeforeDate = " + notBeforeDate.toString());
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  notAfterDate  = " + this.notAfterDate.toString());
                }
                CertificateValidity certValidity = new CertificateValidity(notBeforeDate, this.notAfterDate);
                x509CertInfo.set("validity", (Object)certValidity);
                this.serial_number = BigInteger.valueOf(System.nanoTime());
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The serial number which will be used is:  " + this.serial_number);
                }
                x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber(this.serial_number));
                this.algId = null;
                this.algId = isRSAKeyType ? new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid) : new AlgorithmId(AlgorithmId.sha1WithDSA_oid);
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The name of the signing algorithmId which will be used is:  " + this.algId.getName());
                }
                x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(this.algId));
                PKCSAttribute[] attrs = cri.getAttributes().getAttributes();
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Entering loop to process all PKCSAttributes within the CertificateRequestInfo.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The number of PKCSAttributes is:  " + attrs.length);
                }
                this.subjectAlternativeNameExtension = null;
                this.subjectKeyIdentifierExtension = null;
                this.keyUsageExtension = null;
                this.extKeyUsageExtension = null;
                for (int i = 0; i < attrs.length; ++i) {
                    String name;
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The next PKCSAttibute to be processed is:");
                        System.out.println(attrs[i].toString() + "\n\n");
                    }
                    ObjectIdentifier oid = attrs[i].getAttributeId();
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The OID of this PKCSAttribute above is:  " + oid.toString());
                    }
                    if ((name = PKCS9.getName((ObjectIdentifier)oid)) != "ExtensionRequest" && oid.toString() != "1.2.840.113549.1.9.14") continue;
                    if (debug != null) {
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The PKCSAttribute above is an 'ExtensionRequest'.");
                    }
                    CertificateExtensions certExts = (CertificateExtensions)attrs[i].getAttributeValue();
                    Enumeration enumeration = certExts.getElements();
                    while (enumeration.hasMoreElements()) {
                        String extName;
                        Object obj = enumeration.nextElement();
                        if (debug != null) {
                            System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  The next object retrieved from the ExtensionRequest is:  ");
                            System.out.println(obj.toString());
                        }
                        if (!(obj instanceof CertAttrSet)) {
                            extName = ((Extension)obj).getExtensionId().toString();
                            if (debug != null) {
                                System.out.println("Pk10CertFactory.java:  buildX509Cert():  This is an extension whose name isn't recognized.");
                            }
                        } else {
                            extName = "x509.info.extensions." + ((CertAttrSet)obj).getName();
                            if (debug != null) {
                                System.out.println("Pk10CertFactory.java:  buildX509Cert():  This is an extension whose name is recognized.  Its name is:  " + extName);
                            }
                        }
                        if (obj instanceof SubjectAlternativeNameExtension) {
                            this.subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)obj;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a SubjectAlternativeNameExtension.");
                            continue;
                        }
                        if (obj instanceof SubjectKeyIdentifierExtension) {
                            this.subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)obj;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a SubjectKeyIdentifierExtension.");
                            continue;
                        }
                        if (obj instanceof KeyUsageExtension) {
                            this.keyUsageExtension = (KeyUsageExtension)obj;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a KeyUsageExtension.");
                            continue;
                        }
                        if (obj instanceof ExtKeyUsageExtension) {
                            this.extKeyUsageExtension = (ExtKeyUsageExtension)obj;
                            if (debug == null) continue;
                            System.out.println("Pk10CertFactory.java:  buildX509Cert():  It is a ExtKeyUsageExtension.");
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("Pk10CertFactory.java:  buildX509Cert():  The following extension lifted from the ExtensionRequest was not recognized or processed:");
                        System.out.println(obj.toString());
                    }
                }
                CertificateExtensions exts = new CertificateExtensions();
                if (this.subjectAlternativeNameExtension != null) {
                    exts.set("x509.info.extensions.SubjectAlternativeName", (Object)this.subjectAlternativeNameExtension);
                }
                if (this.subjectKeyIdentifierExtension != null) {
                    exts.set("x509.info.extensions.SubjectKeyIdentifier", (Object)this.subjectKeyIdentifierExtension);
                }
                if (this.keyUsageExtension != null) {
                    exts.set("x509.info.extensions.KeyUsage", (Object)this.keyUsageExtension);
                }
                if (this.extKeyUsageExtension != null) {
                    exts.set("x509.info.extensions.ExtKeyUsage", (Object)this.extKeyUsageExtension);
                }
                x509CertInfo.set("extensions", (Object)exts);
                if (debug != null) {
                    System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  The X509CertInfo built from the CertificationRequest is:");
                    System.out.println(x509CertInfo.toString());
                }
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Exception thrown while building X509CertInfo object.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The exception is:  " + ex.toString());
                }
                ex.printStackTrace();
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ex);
            }
            X509CertImpl cert = null;
            try {
                cert = new X509CertImpl(x509CertInfo);
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Exception thrown while creating X509CertImpl object from the X509CertInfo object.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The exception is:  " + ex.toString());
                }
                ex.printStackTrace();
                throw new PkRejectionException("Exception thrown while creating the X509CertImpl object from the X509CertInfo object.", ex);
            }
            try {
                if (isRSAKeyType) {
                    if (debug != null) {
                        System.out.println("\nPk10CertFactory.java:  buildX509Cert():  The signingKey is an RSA key.");
                    }
                    cert.sign(signingKey, "SHA1withRSA");
                } else {
                    if (debug != null) {
                        System.out.println("\nPk10CertFactory.java:  buildX509Cert():  The signingKey is a  DSA key.");
                    }
                    cert.sign(signingKey, "SHA1withDSA");
                }
            }
            catch (Exception ex) {
                if (debug != null) {
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  Exception thrown while signing the X509CertImpl object.");
                    System.out.println("Pk10CertFactory.java:  buildX509Cert():  The exception is:  " + ex.toString());
                }
                ex.printStackTrace();
                throw new PkRejectionException("Exception thrown while signing the X509CertImpl object.", ex);
            }
            if (debug != null) {
                System.out.println("\n\nPk10CertFactory.java:  buildX509Cert():  The signed X509CertImpl object being returned (after signing) is:");
                System.out.println(cert.toString());
                System.out.println("Pk10CertFactory.java:  buildX509Cert():  METHOD EXIT \n\n");
            }
            return cert;
        }

        public X509Certificate getCertificate() {
            return this.newCert;
        }

        public PublicKey getPublicKey() {
            return this.newCert.getPublicKey();
        }

        public String getSubjectName() {
            return this.newCert.getSubjectDN().getName();
        }

        public String getSigAlg() {
            return this.newCert.getSigAlgName();
        }

        public byte[] getSubjectKeyIdentifier() {
            return this.subjectKeyIdentifierExtension.getExtensionValue();
        }
    }
}

