/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.debug.DebugPlugin;
import org.eclipse.help.debug.GUIDebugger;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.debug.Debugger;
import org.eclipse.help.internal.toc.TocFile;

public class DebuggerImp
implements Debugger {
    public void debug(List tocs) {
        String books = DebugPlugin.getConfig("bookName");
        String[] bookNames = books.split(",");
        int len = 0;
        if (bookNames != null) {
            len = bookNames.length;
        }
        List allBooks = this.getAllActiveBook();
        if ("on".equalsIgnoreCase(DebugPlugin.getConfig("tocDebugFlag"))) {
            if ("gui".equalsIgnoreCase(DebugPlugin.getConfig("type"))) {
                int i = 0;
                while (i < len) {
                    if (!allBooks.contains(bookNames[i])) {
                        HelpPlugin.logError((String)("Invalid book name " + bookNames[i]), null);
                    }
                    ++i;
                }
                new GUIDebugger(tocs);
            } else {
                HelpPlugin.logError((String)"Invalid debugger type, should be 'GUI'", null);
            }
        } else if (!"off".equalsIgnoreCase(DebugPlugin.getConfig("tocDebugFlag"))) {
            HelpPlugin.logError((String)"Invalid value of tocDebugFlag, should be 'on' or 'off' ", null);
        }
    }

    protected Collection getContributedTocFiles(String locale) {
        ArrayList<TocFile> contributedTocFiles = new ArrayList<TocFile>();
        Collection ignored = this.getIgnoredTocs();
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.help", "toc");
        if (xpt == null) {
            return contributedTocFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            String pluginId = extensions[i].getNamespace();
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String href;
                if (configElements[j].getName().equals("toc") && (href = configElements[j].getAttribute("file")) != null && !ignored.contains("/" + pluginId + "/" + href)) {
                    boolean isPrimary = "true".equals(configElements[j].getAttribute("primary"));
                    String extraDir = configElements[j].getAttribute("extradir");
                    contributedTocFiles.add(new TocFile(pluginId, href, isPrimary, locale, extraDir));
                }
                ++j;
            }
            ++i;
        }
        return contributedTocFiles;
    }

    private Collection getIgnoredTocs() {
        HashSet<Object> ignored = new HashSet<Object>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String preferredTocs = pref.getString("ignoredTOCS");
            if (preferredTocs != null) {
                StringTokenizer suggestdOrderedInfosets = new StringTokenizer(preferredTocs, " ;,");
                while (suggestdOrderedInfosets.hasMoreElements()) {
                    ignored.add(suggestdOrderedInfosets.nextElement());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError((String)"Problems occurred reading plug-in preferences.", (Throwable)e);
        }
        return ignored;
    }

    private List getAllActiveBook() {
        ArrayList<String> books = new ArrayList<String>(10);
        Collection allBooks = this.getContributedTocFiles(HelpPlugin.getDefault().getBundle().getLocation());
        Iterator book = allBooks.iterator();
        while (book.hasNext()) {
            books.add(((TocFile)book.next()).getPluginID());
        }
        return books;
    }
}

