/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.debug;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.help.IFilterableResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.debug.DebugPlugin;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.INavigationElement;
import org.eclipse.help.internal.model.ITopicElement;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.Topic;

public class GUIDebugger {
    Toc currentToc;
    private static final String USER_HOME = "user.home";
    private static final String LINE_SEPARATOR = "line.separator";
    private static final String REPORT_FILE = "/debug_report.html";
    String userhome = System.getProperty("user.home");
    String newline = System.getProperty("line.separator");
    StringBuffer result = new StringBuffer();
    StringBuffer message = new StringBuffer();

    private GUIDebugger() {
    }

    GUIDebugger(List tocs) {
        String books = DebugPlugin.getConfig("bookName");
        String[] bookNames = books.split(",");
        Iterator it = tocs.iterator();
        while (it.hasNext()) {
            Toc toc;
            this.currentToc = toc = (Toc)it.next();
            String bookName = toc.getTocFile().getPluginID();
            if (!this.contains(bookNames, bookName)) continue;
            this.checkToc(toc);
        }
        try {
            FileWriter fw = new FileWriter(String.valueOf(this.userhome) + REPORT_FILE);
            fw.write("<html><body>");
            fw.write(this.result.toString());
            fw.write("</html></body>");
            fw.close();
        }
        catch (IOException e) {
            HelpPlugin.logError((String)"error in toc debugger ", (Throwable)e);
        }
    }

    private void checkToc(Toc toc) {
        ITopicElement[] topics = this.getSubtopics((INavigationElement)toc);
        StringBuffer should = new StringBuffer();
        should.append("<font color='#3333FF'>");
        this.getShould(toc, should);
        should.append("</font>");
        this.result.append("<ul><li>" + toc.getLabel() + this.getCriterias((IFilterableResource)toc) + should.toString() + "<ul>");
        this.result.append(this.newline);
        int i = 0;
        while (i < topics.length) {
            this.checkTopic(topics[i]);
            ++i;
        }
        this.result.append("</ul></li></ul>");
    }

    private boolean checkTopic(ITopicElement topic) {
        ITopicElement[] topics = this.getSubtopics((INavigationElement)topic);
        boolean hasNodes = topics.length > 0;
        boolean error = false;
        if (hasNodes) {
            StringBuffer should = new StringBuffer();
            should.append("<font color='#3333FF'>");
            error = this.getShould((Topic)topic, should);
            should.append("</font>");
            this.result.append("<li> " + topic.getLabel() + this.getCriterias((IFilterableResource)topic) + should.toString() + "<ul>");
            int i = 0;
            while (i < topics.length) {
                if (this.checkTopic(topics[i])) {
                    error = true;
                }
                ++i;
            }
            this.result.append("</ul></li>");
        }
        return error;
    }

    private List getSubtopicList(INavigationElement navigationElement) {
        List children = navigationElement.getChildren();
        ArrayList<INavigationElement> childTopics = new ArrayList<INavigationElement>(children.size());
        Iterator childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            INavigationElement c = (INavigationElement)childrenIt.next();
            if (c instanceof ITopicElement) {
                if ((((ITopicElement)c).getHref() == null || ((ITopicElement)c).getHref().length() <= 0) && this.getSubtopicList(c).size() <= 0) continue;
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(this.getSubtopicList(c));
        }
        return childTopics;
    }

    private ITopicElement[] getSubtopics(INavigationElement navigationElement) {
        List topics = this.getSubtopicList(navigationElement);
        return topics.toArray(new ITopicElement[topics.size()]);
    }

    private String getCriterias(IFilterableResource topic) {
        StringBuffer criterias = new StringBuffer();
        criterias.append("&nbsp;&nbsp;<font color='#FF0000'><strong>CRITERIA&nbsp;</strong></font> ");
        HashMap criteria = topic.getCriteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            criterias.append(": ").append(key).append("=");
            Iterator values = ((List)criteria.get(key)).iterator();
            while (values.hasNext()) {
                criterias.append(values.next()).append(",");
            }
        }
        return criterias.toString();
    }

    private boolean criteriaMapToString(StringBuffer message, HashMap criterias) {
        boolean hasCriteria = false;
        Iterator criteria = criterias.keySet().iterator();
        while (criteria.hasNext()) {
            String key = (String)criteria.next();
            message.append("<strong>").append(key).append("</strong>").append("=");
            List values = (List)criterias.get(key);
            Iterator value = values.iterator();
            while (value.hasNext()) {
                message.append(value.next());
                message.append(",");
            }
            hasCriteria = true;
        }
        return hasCriteria;
    }

    private boolean getShould(Topic topic, StringBuffer message) {
        HashMap allCriteria = new HashMap();
        ArrayList childs = new ArrayList(10);
        this.getAllChilds(topic.getChildTopics(), childs);
        this.initCriteria(allCriteria, childs, topic.getCriteria());
        Set self = this.copy(topic.getCriteria().keySet());
        ITopic[] parent = topic.getPathInToc((IToc)this.currentToc);
        int len = parent.length;
        int i = 0;
        while (i < len) {
            Topic temp = (Topic)parent[i];
            self.addAll(temp.getCriteria().keySet());
            ++i;
        }
        self.addAll(this.currentToc.getCriteria().keySet());
        allCriteria.keySet().retainAll(self);
        return this.criteriaMapToString(message, allCriteria);
    }

    private boolean getShould(Toc topic, StringBuffer message) {
        HashMap allCriteria = new HashMap(5);
        ArrayList childs = new ArrayList(10);
        this.getAllChilds(topic.getChildTopics(), childs);
        this.initCriteria(allCriteria, childs, topic.getCriteria());
        allCriteria.keySet().retainAll(topic.getCriteria().keySet());
        return this.criteriaMapToString(message, allCriteria);
    }

    private void initCriteria(HashMap allCriteria, List childs, HashMap selfCriteria) {
        Iterator child = childs.iterator();
        while (child.hasNext()) {
            Topic temp = (Topic)child.next();
            HashMap criteria = temp.getCriteria();
            this.trimHashMap(allCriteria, criteria);
        }
        Iterator keys = selfCriteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List allValues = (List)allCriteria.get(key);
            List parentValues = (List)selfCriteria.get(key);
            if (allValues == null) continue;
            allValues.removeAll(parentValues);
            if (allValues.size() == 0) {
                allCriteria.remove(key);
                continue;
            }
            allCriteria.put(key, allValues);
        }
    }

    private void trimHashMap(HashMap allCriteria, HashMap criteria) {
        Iterator childCr = criteria.keySet().iterator();
        while (childCr.hasNext()) {
            String key = (String)childCr.next();
            List parentList = (List)allCriteria.get(key);
            List childList = this.copy((List)criteria.get(key));
            if (parentList != null) {
                childList.removeAll(parentList);
                parentList.addAll(childList);
            } else {
                parentList = childList;
            }
            allCriteria.put(key, parentList);
        }
    }

    private void getAllChilds(List childs, List allChilds) {
        if (childs != null) {
            Iterator child = childs.iterator();
            while (child.hasNext()) {
                Topic temp = (Topic)child.next();
                allChilds.add(temp);
                List childTopics = temp.getChildTopics();
                this.getAllChilds(childTopics, allChilds);
            }
        }
    }

    private List copy(List s) {
        int len = s.size();
        ArrayList<String> r = new ArrayList<String>(len);
        int i = 0;
        while (i < len) {
            r.add((String)s.get(i));
            ++i;
        }
        return r;
    }

    private Set copy(Set s) {
        int len = s.size();
        HashSet<String> r = new HashSet<String>(len);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            r.add((String)it.next());
        }
        return r;
    }

    protected String getError(Topic topic) {
        StringBuffer message = new StringBuffer();
        message.append("<font color='#FF0000'>");
        HashMap criteria = topic.getCriteria();
        HashMap errorMap = new HashMap();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List values = (List)criteria.get(key);
            ITopic[] parent = topic.getPathInToc((IToc)this.currentToc);
            int len = parent.length;
            int i = 0;
            while (i < len) {
                Topic temp = (Topic)parent[i];
                HashMap parentCriteria = temp.getCriteria();
                List parentValue = (List)parentCriteria.get(key);
                if (parentValue != null) {
                    List copy = this.copy(values);
                    copy.removeAll(parentValue);
                    if (copy.size() > 0) {
                        this.addToCriteria(errorMap, key, copy);
                    }
                }
                ++i;
            }
            HashMap parentCriteria = this.currentToc.getCriteria();
            List parentValue = (List)parentCriteria.get(key);
            if (parentValue == null) continue;
            List copy = this.copy(values);
            copy.removeAll(parentValue);
            if (copy.size() <= 0) continue;
            this.addToCriteria(errorMap, key, copy);
        }
        if (this.criteriaMapToString(message, errorMap)) {
            message.append("</font>");
            return message.toString();
        }
        return "";
    }

    private void addToCriteria(HashMap criteria, String key, List values) {
        ArrayList value = (ArrayList)criteria.get(key);
        if (value == null) {
            value = new ArrayList(3);
        }
        values.removeAll(value);
        value.addAll(values);
        criteria.put(key, value);
    }

    private boolean contains(String[] books, String book) {
        int i = 0;
        while (i < books.length) {
            if (books[i].equalsIgnoreCase(book)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

