/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;
    private int c;
    private static final byte[] d;
    private static String[] z;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        int n2;
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException(z[8]);
        }
        byte[] byArray = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        if (byArray != null) {
            if (byArray.length != 8) {
                throw new InvalidParameterSpecException(z[1]);
            }
            this.a = (byte[])byArray.clone();
        }
        if ((n2 = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()) < 1 || n2 > 1024) {
            throw new InvalidParameterSpecException(z[7]);
        }
        this.c = n2;
        this.b = n2 >= 256 ? n2 : this.a(n2);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        byte[] byArray2;
        block8: {
            byArray2 = null;
            try {
                DerValue derValue = new DerValue(byArray);
                if (derValue.getTag() == 4) {
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(z[4]);
                    }
                    this.b = this.a(32);
                    this.c = 32;
                    break block8;
                }
                if (derValue.getTag() == 48) {
                    int n2 = derValue.getData().getInteger().intValue();
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(z[6]);
                    }
                    if (n2 < 1 || n2 > 1024) {
                        throw new IOException(z[0]);
                    }
                    this.c = n2 >= 256 ? n2 : this.b(n2);
                    this.b = n2;
                    break block8;
                }
                throw new IOException(z[2] + derValue.getTag() + z[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(z[5]);
            }
        }
        if (byArray2.length != 8) {
            throw new IOException(z[1]);
        }
        this.a = byArray2;
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName(z[12]);
            if (clazz2.isAssignableFrom(clazz)) {
                if (this.a == null) {
                    return new RC2ParameterSpec(this.c);
                }
                return new RC2ParameterSpec(this.c, this.a);
            }
            throw new InvalidParameterSpecException(z[8]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[13] + classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.c == 32) {
            derOutputStream.putOctetString(this.a);
        } else {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.putOctetString(this.a);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = z[10];
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.a);
        string = string + "]";
        return z[11] + BigInteger.valueOf(this.c).toString() + "\n" + string;
    }

    private int a(int n2) {
        byte by = d[n2];
        if (by >= 0) {
            return by;
        }
        return by + 256;
    }

    private int b(int n2) throws IOException {
        int n3;
        for (n3 = 1; n3 < 256; ++n3) {
            int n4;
            int n5 = d[n3];
            int n6 = n4 = n5 >= 0 ? n5 : n5 + 256;
            if (n2 == n4) break;
        }
        if (n3 < 256) {
            return n3;
        }
        throw new IOException(z[9]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block153: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block152: {
                char[] cArray3;
                Object var0;
                block151: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block150: {
                        char[] cArray5;
                        block149: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block148: {
                                char[] cArray7;
                                block147: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block146: {
                                        char[] cArray9;
                                        block145: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block144: {
                                                char[] cArray11;
                                                block143: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block142: {
                                                        char[] cArray13;
                                                        block141: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block140: {
                                                                char[] cArray15;
                                                                block139: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block138: {
                                                                        char[] cArray17;
                                                                        block137: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block136: {
                                                                                char[] cArray19;
                                                                                block135: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block134: {
                                                                                        char[] cArray21;
                                                                                        block133: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block132: {
                                                                                                char[] cArray23;
                                                                                                block131: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block130: {
                                                                                                        char[] cArray25;
                                                                                                        block129: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block128: {
                                                                                                                char[] cArray27;
                                                                                                                block127: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block126: {
                                                                                                                        stringArray = new String[14];
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray29 = "9KfH\n\u0019{=q\u0001Ka'>\u0001\u0004|tw\u0001K|<{O\u0019i:y\nKg2>^K%t/_Y<z".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n31 = cArray29.length;
                                                                                                                        cArray28 = cArray29;
                                                                                                                        n30 = n31;
                                                                                                                        if (n31 <= 1) break block126;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block127;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray30 = cArray28;
                                                                                                                        char[] cArray31 = cArray28;
                                                                                                                        int n32 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n33;
                                                                                                                            char c2 = cArray30[n32];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n33 = 107;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n33 = 8;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n33 = 84;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n33 = 30;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n33 = 111;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray30[n32] = (char)(c2 ^ n33);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray31;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray31 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n32 = n30;
                                                                                                                            cArray30 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[0] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray32 = "\"^tp\u0000\u001f(l>\r\u0012|1mO\u0007g:y".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n34 = cArray32.length;
                                                                                                                cArray26 = cArray32;
                                                                                                                n28 = n34;
                                                                                                                if (n34 <= 1) break block128;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block129;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray33 = cArray26;
                                                                                                                char[] cArray34 = cArray26;
                                                                                                                int n35 = n4;
                                                                                                                while (true) {
                                                                                                                    int n36;
                                                                                                                    char c3 = cArray33[n35];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n36 = 107;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n36 = 8;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n36 = 84;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n36 = 30;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n36 = 111;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray33[n35] = (char)(c3 ^ n36);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray34;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray34 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n35 = n28;
                                                                                                                    cArray33 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[1] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray35 = "9Kf>?\nz5s\n\u001fm&mO\u001bi&m\u0006\u0005ot{\u001d\u0019g&$O\u001fi3>".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n37 = cArray35.length;
                                                                                                        cArray24 = cArray35;
                                                                                                        n26 = n37;
                                                                                                        if (n37 <= 1) break block130;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block131;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray36 = cArray24;
                                                                                                        char[] cArray37 = cArray24;
                                                                                                        int n38 = n4;
                                                                                                        while (true) {
                                                                                                            int n39;
                                                                                                            char c4 = cArray36[n38];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n39 = 107;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n39 = 8;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n39 = 84;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n39 = 30;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n39 = 111;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray36[n38] = (char)(c4 ^ n39);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray37;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray37 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n38 = n26;
                                                                                                            cArray36 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[2] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray38 = "Kf;jO\u0018}$n\u0000\u0019|1z".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n40 = cArray38.length;
                                                                                                cArray22 = cArray38;
                                                                                                n24 = n40;
                                                                                                if (n40 <= 1) break block132;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block133;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray39 = cArray22;
                                                                                                char[] cArray40 = cArray22;
                                                                                                int n41 = n4;
                                                                                                while (true) {
                                                                                                    int n42;
                                                                                                    char c5 = cArray39[n41];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n42 = 107;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n42 = 8;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n42 = 84;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n42 = 30;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n42 = 111;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray39[n41] = (char)(c5 ^ n42);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray40;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray40 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n41 = n24;
                                                                                                    cArray39 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[3] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray41 = "\"^tn\u000e\u0019{=p\bKm&l\u0000\u00192t{\u0017\u001fz5>\u000b\n|5".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n43 = cArray41.length;
                                                                                        cArray20 = cArray41;
                                                                                        n22 = n43;
                                                                                        if (n43 <= 1) break block134;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block135;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray42 = cArray20;
                                                                                        char[] cArray43 = cArray20;
                                                                                        int n44 = n4;
                                                                                        while (true) {
                                                                                            int n45;
                                                                                            char c6 = cArray42[n44];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n45 = 107;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n45 = 8;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n45 = 84;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n45 = 30;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n45 = 111;
                                                                                                }
                                                                                            }
                                                                                            cArray42[n44] = (char)(c6 ^ n45);
                                                                                            ++n4;
                                                                                            cArray20 = cArray43;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray43 = cArray20;
                                                                                            n21 = n22;
                                                                                            n44 = n22;
                                                                                            cArray42 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[4] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray44 = "9KfH\n\u0019{=q\u0001Kd1p\b\u001f`tj\u0000\u0004(6w\b".toCharArray();
                                                                                n4 = 0;
                                                                                int n46 = cArray44.length;
                                                                                cArray18 = cArray44;
                                                                                n20 = n46;
                                                                                if (n46 <= 1) break block136;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block137;
                                                                            }
                                                                            do {
                                                                                char[] cArray45 = cArray18;
                                                                                char[] cArray46 = cArray18;
                                                                                int n47 = n4;
                                                                                while (true) {
                                                                                    int n48;
                                                                                    char c7 = cArray45[n47];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n48 = 107;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n48 = 8;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n48 = 84;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n48 = 30;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n48 = 111;
                                                                                        }
                                                                                    }
                                                                                    cArray45[n47] = (char)(c7 ^ n48);
                                                                                    ++n4;
                                                                                    cArray18 = cArray46;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray46 = cArray18;
                                                                                    n19 = n20;
                                                                                    n47 = n20;
                                                                                    cArray45 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[5] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray47 = "9Kf>?\nz5s\n\u001fm&mO\u001bi&m\u0006\u0005ot{\u001d\u0019g&$O.p l\u000eKl5j\u000e".toCharArray();
                                                                        n4 = 0;
                                                                        int n49 = cArray47.length;
                                                                        cArray16 = cArray47;
                                                                        n18 = n49;
                                                                        if (n49 <= 1) break block138;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block139;
                                                                    }
                                                                    do {
                                                                        char[] cArray48 = cArray16;
                                                                        char[] cArray49 = cArray16;
                                                                        int n50 = n4;
                                                                        while (true) {
                                                                            int n51;
                                                                            char c8 = cArray48[n50];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n51 = 107;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n51 = 8;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n51 = 84;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n51 = 30;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n51 = 111;
                                                                                }
                                                                            }
                                                                            cArray48[n50] = (char)(c8 ^ n51);
                                                                            ++n4;
                                                                            cArray16 = cArray49;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray49 = cArray16;
                                                                            n17 = n18;
                                                                            n50 = n18;
                                                                            cArray48 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[6] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray50 = ".n2{\f\u001fa\"{O\u0000m->\u001c\u0002r1>\u0006\u0018(:q\u001bKa:>\u001b\u0003mtl\u000e\u0005o1>\u0000\r(e>BK9d,[Kj=j\u001cE".toCharArray();
                                                                n4 = 0;
                                                                int n52 = cArray50.length;
                                                                cArray14 = cArray50;
                                                                n16 = n52;
                                                                if (n52 <= 1) break block140;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block141;
                                                            }
                                                            do {
                                                                char[] cArray51 = cArray14;
                                                                char[] cArray52 = cArray14;
                                                                int n53 = n4;
                                                                while (true) {
                                                                    int n54;
                                                                    char c9 = cArray51[n53];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n54 = 107;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n54 = 8;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n54 = 84;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n54 = 30;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n54 = 111;
                                                                        }
                                                                    }
                                                                    cArray51[n53] = (char)(c9 ^ n54);
                                                                    ++n4;
                                                                    cArray14 = cArray52;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray52 = cArray14;
                                                                    n15 = n16;
                                                                    n53 = n16;
                                                                    cArray51 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[7] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray53 = "\"f5n\u001f\u0019g$l\u0006\n|1>\u001f\nz5s\n\u001fm&>\u001c\u001bm7w\t\u0002k5j\u0006\u0004f".toCharArray();
                                                        n4 = 0;
                                                        int n55 = cArray53.length;
                                                        cArray12 = cArray53;
                                                        n14 = n55;
                                                        if (n55 <= 1) break block142;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block143;
                                                    }
                                                    do {
                                                        char[] cArray54 = cArray12;
                                                        char[] cArray55 = cArray12;
                                                        int n56 = n4;
                                                        while (true) {
                                                            int n57;
                                                            char c10 = cArray54[n56];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n57 = 107;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n57 = 8;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n57 = 84;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n57 = 30;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n57 = 111;
                                                                }
                                                            }
                                                            cArray54[n56] = (char)(c10 ^ n57);
                                                            ++n4;
                                                            cArray12 = cArray55;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray55 = cArray12;
                                                            n13 = n14;
                                                            n56 = n14;
                                                            cArray54 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[8] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray56 = "9KfH\n\u0019{=q\u0001Kk5p\u0001\u0004|t|\nKn;k\u0001\u000f(=pO\u001f`1>\u001b\u0019i:m\u0003\n|=q\u0001K|5|\u0003\u000e&".toCharArray();
                                                n4 = 0;
                                                int n58 = cArray56.length;
                                                cArray10 = cArray56;
                                                n12 = n58;
                                                if (n58 <= 1) break block144;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block145;
                                            }
                                            do {
                                                char[] cArray57 = cArray10;
                                                char[] cArray58 = cArray10;
                                                int n59 = n4;
                                                while (true) {
                                                    int n60;
                                                    char c11 = cArray57[n59];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n60 = 107;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n60 = 8;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n60 = 84;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n60 = 30;
                                                            break;
                                                        }
                                                        default: {
                                                            n60 = 111;
                                                        }
                                                    }
                                                    cArray57[n59] = (char)(c11 ^ n60);
                                                    ++n4;
                                                    cArray10 = cArray58;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray58 = cArray10;
                                                    n11 = n12;
                                                    n59 = n12;
                                                    cArray57 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[9] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray59 = "a(t>O\"^n\u00144".toCharArray();
                                        n4 = 0;
                                        int n61 = cArray59.length;
                                        cArray8 = cArray59;
                                        n10 = n61;
                                        if (n61 <= 1) break block146;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block147;
                                    }
                                    do {
                                        char[] cArray60 = cArray8;
                                        char[] cArray61 = cArray8;
                                        int n62 = n4;
                                        while (true) {
                                            int n63;
                                            char c12 = cArray60[n62];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n63 = 107;
                                                    break;
                                                }
                                                case 1: {
                                                    n63 = 8;
                                                    break;
                                                }
                                                case 2: {
                                                    n63 = 84;
                                                    break;
                                                }
                                                case 3: {
                                                    n63 = 30;
                                                    break;
                                                }
                                                default: {
                                                    n63 = 111;
                                                }
                                            }
                                            cArray60[n62] = (char)(c12 ^ n63);
                                            ++n4;
                                            cArray8 = cArray61;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray61 = cArray8;
                                            n9 = n10;
                                            n62 = n10;
                                            cArray60 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[10] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray62 = ".n2{\f\u001fa\"{O\u0000m->\r\u0002|'$e".toCharArray();
                                n4 = 0;
                                int n64 = cArray62.length;
                                cArray6 = cArray62;
                                n8 = n64;
                                if (n64 <= 1) break block148;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block149;
                            }
                            do {
                                char[] cArray63 = cArray6;
                                char[] cArray64 = cArray6;
                                int n65 = n4;
                                while (true) {
                                    int n66;
                                    char c13 = cArray63[n65];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n66 = 107;
                                            break;
                                        }
                                        case 1: {
                                            n66 = 8;
                                            break;
                                        }
                                        case 2: {
                                            n66 = 84;
                                            break;
                                        }
                                        case 3: {
                                            n66 = 30;
                                            break;
                                        }
                                        default: {
                                            n66 = 111;
                                        }
                                    }
                                    cArray63[n65] = (char)(c13 ^ n66);
                                    ++n4;
                                    cArray6 = cArray64;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray64 = cArray6;
                                    n7 = n8;
                                    n65 = n8;
                                    cArray63 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[11] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray65 = "\u0001i\"\u007f\u0017Ek&g\u001f\u001fgzm\u001f\u000ekzL,YX5l\u000e\u0006m {\u001d8x1}".toCharArray();
                        n4 = 0;
                        int n67 = cArray65.length;
                        cArray4 = cArray65;
                        n6 = n67;
                        if (n67 <= 1) break block150;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block151;
                    }
                    do {
                        char[] cArray66 = cArray4;
                        char[] cArray67 = cArray4;
                        int n68 = n4;
                        while (true) {
                            int n69;
                            char c14 = cArray66[n68];
                            switch (n4 % 5) {
                                case 0: {
                                    n69 = 107;
                                    break;
                                }
                                case 1: {
                                    n69 = 8;
                                    break;
                                }
                                case 2: {
                                    n69 = 84;
                                    break;
                                }
                                case 3: {
                                    n69 = 30;
                                    break;
                                }
                                default: {
                                    n69 = 111;
                                }
                            }
                            cArray66[n68] = (char)(c14 ^ n69);
                            ++n4;
                            cArray4 = cArray67;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray67 = cArray4;
                            n5 = n6;
                            n68 = n6;
                            cArray66 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[12] = new String(cArray3).intern();
                var0 = null;
                char[] cArray68 = ">f'k\u001f\u001bg&j\n\u000f($\u007f\u001d\ne1j\n\u0019('n\n\ba2w\f\n|=q\u0001Q(".toCharArray();
                n4 = 0;
                int n70 = cArray68.length;
                cArray2 = cArray68;
                n3 = n70;
                if (n70 <= 1) break block152;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block153;
            }
            do {
                char[] cArray69 = cArray2;
                char[] cArray70 = cArray2;
                int n71 = n4;
                while (true) {
                    int n72;
                    char c15 = cArray69[n71];
                    switch (n4 % 5) {
                        case 0: {
                            n72 = 107;
                            break;
                        }
                        case 1: {
                            n72 = 8;
                            break;
                        }
                        case 2: {
                            n72 = 84;
                            break;
                        }
                        case 3: {
                            n72 = 30;
                            break;
                        }
                        default: {
                            n72 = 111;
                        }
                    }
                    cArray69[n71] = (char)(c15 ^ n72);
                    ++n4;
                    cArray2 = cArray70;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray70 = cArray2;
                    n2 = n3;
                    n71 = n3;
                    cArray69 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[13] = new String(cArray).intern();
        z = stringArray;
        d = new byte[]{-67, 86, -22, -14, -94, -15, -84, 42, -80, -109, -47, -100, 27, 51, -3, -48, 48, 4, -74, -36, 125, -33, 50, 75, -9, -53, 69, -101, 49, -69, 33, 90, 65, -97, -31, -39, 74, 77, -98, -38, -96, 104, 44, -61, 39, 95, -128, 54, 62, -18, -5, -107, 26, -2, -50, -88, 52, -87, 19, -16, -90, 63, -40, 12, 120, 36, -81, 35, 82, -63, 103, 23, -11, 102, -112, -25, -24, 7, -72, 96, 72, -26, 30, 83, -13, -110, -92, 114, -116, 8, 21, 110, -122, 0, -124, -6, -12, 127, -118, 66, 25, -10, -37, -51, 20, -115, 80, 18, -70, 60, 6, 78, -20, -77, 53, 17, -95, -120, -114, 43, -108, -103, -73, 113, 116, -45, -28, -65, 58, -34, -106, 14, -68, 10, -19, 119, -4, 55, 107, 3, 121, -119, 98, -58, -41, -64, -46, 124, 106, -117, 34, -93, 91, 5, 93, 2, 117, -43, 97, -29, 24, -113, 85, 81, -83, 31, 11, 94, -123, -27, -62, 87, 99, -54, 61, 108, -76, -59, -52, 112, -78, -111, 89, 13, 71, 32, -56, 79, 88, -32, 1, -30, 22, 56, -60, 111, 59, 15, 101, 70, -66, 126, 45, 123, -126, -7, 64, -75, 29, 115, -8, -21, 38, -57, -121, -105, 37, 84, -79, 40, -86, -104, -99, -91, 100, 109, 122, -44, 16, -127, 68, -17, 73, -42, -82, 46, -35, 118, 92, 47, -89, 28, -55, 9, 105, -102, -125, -49, 41, 57, -71, -23, 76, -1, 67, -85};
    }
}

