/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.SecureRandom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomSpi;

public final class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    static final long serialVersionUID = -3888978670357092251L;
    private transient MessageDigest sha1;
    private SecureRandom seedGenerator;
    private BigInteger P64;
    private int[] syms = new int[16];
    private byte[] sbuf = new byte[256];
    private byte[] rngTestBuf = null;
    private long accu = 0L;
    private boolean firstTrng = true;
    private long rngTest = 0L;
    private int bits = 0;
    private int nsam = 64;
    private static final short[] logtab;
    byte[] state = new byte[85];
    private static String[] z;

    public SHA1PRNG() {
        this.a(null);
    }

    public SHA1PRNG(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        try {
            this.sha1 = MessageDigest.getInstance(z[3], z[0]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[2]);
        }
        byArray2[0] = 1;
        byArray2[8] = 13;
        this.P64 = new BigInteger(1, byArray2);
        SHA1PRNG.a(128, this.state, 49);
        SHA1PRNG.a(30, this.state, 53);
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public boolean isFipsApproved() {
        return true;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.b(byArray);
    }

    protected synchronized void b(byte[] byArray) {
        if (byArray != null) {
            int n2 = 0;
            int n3 = byArray.length;
            if (n3 > 40) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance(z[3], z[0]);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InternalError(z[1]);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new InternalError(z[2]);
                }
                byte[] byArray2 = new byte[20];
                messageDigest.update(byArray);
                byArray2 = messageDigest.digest();
                n3 = 20;
                byArray = this.state;
                n2 = 65;
                System.arraycopy(byArray2, 0, this.state, 65, n3);
            }
            while (--n3 >= 0) {
                int n4 = 25 + n3 % 20;
                this.state[n4] = (byte)(this.state[n4] ^ byArray[n2 + n3]);
            }
            if (this.state[0] == 0) {
                this.state[0] = 25;
            }
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.c(byArray);
    }

    protected synchronized void c(byte[] byArray) {
        this.b(byArray, 0, byArray.length);
    }

    public byte[] engineGenerateSeed(int n2) {
        return this.a(n2);
    }

    protected byte[] a(int n2) {
        byte[] byArray = new byte[n2];
        this.b(byArray, 0, byArray.length);
        return byArray;
    }

    private int a() {
        int n2;
        while (this.bits == 0) {
            BigInteger bigInteger;
            long l2;
            this.accu = 0L;
            int n3 = 0;
            do {
                this.syms[n3] = 0;
            } while (++n3 < 16);
            int n4 = this.sbuf.length - 1;
            int n5 = 0;
            n2 = 0;
            int n6 = 0;
            int n7 = 0;
            while (true) {
                int n8 = 0;
                do {
                    l2 = System.currentTimeMillis();
                    while (l2 == System.currentTimeMillis()) {
                        ++n8;
                    }
                } while (n8 == 0);
                this.sbuf[n4] = (byte)(this.sbuf[n4] << 4 | n8 % 16);
                n4 -= n5;
                n5 ^= 1;
                if ((n7 - n8) * (n7 - n8) != 1) {
                    n7 = n8;
                }
                int n9 = n7 % 16;
                this.syms[n9] = this.syms[n9] + n2;
                n2 |= 1;
                if (n4 < 0) {
                    bigInteger = new BigInteger(1, this.sbuf);
                    this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue();
                    n4 += this.sbuf.length;
                    n2 = 0;
                }
                if (++n6 < this.nsam) continue;
                n3 = 0;
                int n10 = 0;
                int n11 = SHA1PRNG.b(n6);
                do {
                    n2 = this.syms[n3];
                    n10 += n2 * (n11 - SHA1PRNG.b(n2));
                } while (++n3 < 16);
                this.nsam = 96000 * n6 / n10;
                if (this.nsam <= n6) break;
                this.nsam = n10 > n6 ? this.nsam + 3 : n6 + 32;
                n2 = 0;
            }
            bigInteger = new BigInteger(1, this.sbuf);
            this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue() ^ l2;
            this.bits = 64;
            if (!this.firstTrng) continue;
            this.accu = 0L;
            this.bits = 0;
            this.firstTrng = false;
        }
        n2 = (int)(this.accu & 0xFFL);
        this.accu >>>= 8;
        this.bits -= 8;
        return n2;
    }

    private void a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.state;
        while (--n3 >= 0) {
            int n4 = 25 + n3 % 20;
            byArray2[n4] = (byte)(byArray2[n4] ^ this.a());
        }
        long l2 = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
        SHA1PRNG.a((int)(l2 >>> 32), byArray2, 57);
        SHA1PRNG.a((int)l2, byArray2, 61);
        if (byArray2[0] == 0) {
            byArray2[0] = 25;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void b(byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[45];
        byte[] byArray4 = null;
        while ((n4 = byArray2[0]) == 0) {
            this.a(null, 0, 20);
        }
        while (true) {
            if (--n3 < 0) {
                byArray2[0] = (byte)n4;
                return;
            }
            while (n4 == 25 || this.rngTestBuf == null) {
                int n5 = SHA1PRNG.a(byArray2, 49);
                if (n5 > 0) {
                    long l2 = ((long)SHA1PRNG.a(byArray2, 57) << 32) + ((long)SHA1PRNG.a(byArray2, 61) & 0xFFFFFFFFL);
                    int n6 = SHA1PRNG.a(byArray2, 45);
                    int n7 = n6 + 20;
                    if (n7 < n6) {
                        n6 = 0;
                        n7 = 0 + 20;
                    }
                    SHA1PRNG.a(n7, byArray2, 45);
                    n6 += n5 - n6 % n5;
                    while (n6 < n7) {
                        byte[] byArray5 = this.sbuf;
                        // MONITORENTER : this.sbuf
                        if (this.bits > 0 || System.currentTimeMillis() >= l2) {
                            int n8 = 25 + n6 / n5 % 20;
                            byArray2[n8] = (byte)(byArray2[n8] ^ this.a());
                            l2 = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
                            SHA1PRNG.a((int)(l2 >>> 32), byArray2, 57);
                            SHA1PRNG.a((int)l2, byArray2, 61);
                        }
                        // MONITOREXIT : byArray5
                        n6 += n5;
                    }
                }
                System.arraycopy(byArray2, 5, byArray3, 0, 45);
                this.sha1.update(byArray3, 0, byArray3.length);
                byArray4 = this.sha1.digest();
                System.arraycopy(byArray4, 0, byArray2, 5, 20);
                if (this.rngTestBuf != null) {
                    n4 = 5;
                    continue;
                }
                this.rngTestBuf = new byte[20];
                n4 = 25;
            }
            byArray[n2++] = byArray2[n4++];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.sha1 = MessageDigest.getInstance(z[3], z[0]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[2]);
        }
    }

    private static final int b(int n2) {
        int n3 = 6;
        if (n2 == 0) {
            return 0;
        }
        while (n2 < 64) {
            n2 <<= 1;
            --n3;
        }
        while (n2 >= 128) {
            n2 >>= 1;
            ++n3;
        }
        return n3 * 1000 + logtab[n2 & 0x3F];
    }

    static final int a(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block43: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block42: {
                char[] cArray3;
                Object var0;
                block41: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block40: {
                        char[] cArray5;
                        block39: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block38: {
                                char[] cArray7;
                                block37: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block36: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray9 = "ow\u0014E\u001ec".toCharArray();
                                        n4 = 0;
                                        int n11 = cArray9.length;
                                        cArray8 = cArray9;
                                        n10 = n11;
                                        if (n11 <= 1) break block36;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block37;
                                    }
                                    do {
                                        char[] cArray10 = cArray8;
                                        char[] cArray11 = cArray8;
                                        int n12 = n4;
                                        while (true) {
                                            int n13;
                                            char c2 = cArray10[n12];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n13 = 38;
                                                    break;
                                                }
                                                case 1: {
                                                    n13 = 53;
                                                    break;
                                                }
                                                case 2: {
                                                    n13 = 89;
                                                    break;
                                                }
                                                case 3: {
                                                    n13 = 15;
                                                    break;
                                                }
                                                default: {
                                                    n13 = 93;
                                                }
                                            }
                                            cArray10[n12] = (char)(c2 ^ n13);
                                            ++n4;
                                            cArray8 = cArray11;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray11 = cArray8;
                                            n9 = n10;
                                            n12 = n10;
                                            cArray10 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[0] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray12 = "ow\u0014E\u001ec\u0015\nG\u001c\u0017\u00150|}HZ-/<PT0c<DY<".toCharArray();
                                n4 = 0;
                                int n14 = cArray12.length;
                                cArray6 = cArray12;
                                n8 = n14;
                                if (n14 <= 1) break block38;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block39;
                            }
                            do {
                                char[] cArray13 = cArray6;
                                char[] cArray14 = cArray6;
                                int n15 = n4;
                                while (true) {
                                    int n16;
                                    char c3 = cArray13[n15];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n16 = 38;
                                            break;
                                        }
                                        case 1: {
                                            n16 = 53;
                                            break;
                                        }
                                        case 2: {
                                            n16 = 89;
                                            break;
                                        }
                                        case 3: {
                                            n16 = 15;
                                            break;
                                        }
                                        default: {
                                            n16 = 93;
                                        }
                                    }
                                    cArray13[n15] = (char)(c3 ^ n16);
                                    ++n4;
                                    cArray6 = cArray14;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray14 = cArray6;
                                    n7 = n8;
                                    n15 = n8;
                                    cArray13 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[1] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray15 = "ow\u0014E\u001ec\u00150|}HZ-/<PT0c<DY<".toCharArray();
                        n4 = 0;
                        int n17 = cArray15.length;
                        cArray4 = cArray15;
                        n6 = n17;
                        if (n17 <= 1) break block40;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block41;
                    }
                    do {
                        char[] cArray16 = cArray4;
                        char[] cArray17 = cArray4;
                        int n18 = n4;
                        while (true) {
                            int n19;
                            char c4 = cArray16[n18];
                            switch (n4 % 5) {
                                case 0: {
                                    n19 = 38;
                                    break;
                                }
                                case 1: {
                                    n19 = 53;
                                    break;
                                }
                                case 2: {
                                    n19 = 89;
                                    break;
                                }
                                case 3: {
                                    n19 = 15;
                                    break;
                                }
                                default: {
                                    n19 = 93;
                                }
                            }
                            cArray16[n18] = (char)(c4 ^ n19);
                            ++n4;
                            cArray4 = cArray17;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray17 = cArray4;
                            n5 = n6;
                            n18 = n6;
                            cArray16 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[2] = new String(cArray3).intern();
                var0 = null;
                char[] cArray18 = "u}\u0018>".toCharArray();
                n4 = 0;
                int n20 = cArray18.length;
                cArray2 = cArray18;
                n3 = n20;
                if (n20 <= 1) break block42;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block43;
            }
            do {
                char[] cArray19 = cArray2;
                char[] cArray20 = cArray2;
                int n21 = n4;
                while (true) {
                    int n22;
                    char c5 = cArray19[n21];
                    switch (n4 % 5) {
                        case 0: {
                            n22 = 38;
                            break;
                        }
                        case 1: {
                            n22 = 53;
                            break;
                        }
                        case 2: {
                            n22 = 89;
                            break;
                        }
                        case 3: {
                            n22 = 15;
                            break;
                        }
                        default: {
                            n22 = 93;
                        }
                    }
                    cArray19[n21] = (char)(c5 ^ n22);
                    ++n4;
                    cArray2 = cArray20;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray20 = cArray2;
                    n2 = n3;
                    n21 = n3;
                    cArray19 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
        logtab = new short[]{0, 22, 44, 66, 87, 109, 129, 150, 170, 190, 209, 229, 248, 267, 285, 304, 322, 340, 358, 375, 392, 409, 426, 443, 459, 476, 492, 508, 524, 539, 555, 570, 585, 600, 615, 629, 644, 658, 672, 687, 700, 714, 728, 741, 755, 768, 781, 794, 807, 820, 833, 845, 858, 870, 883, 895, 907, 919, 931, 943, 954, 966, 977, 989};
    }
}

