/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.constExpr;

import com.ibm.idl.Util;
import com.ibm.idl.constExpr.BinaryExpr;
import com.ibm.idl.constExpr.EvaluationException;
import com.ibm.idl.constExpr.Expression;
import java.math.BigInteger;

public class ShiftRight
extends BinaryExpr {
    protected ShiftRight(Expression expression, Expression expression2) {
        super(">>", expression, expression2);
    }

    public Object evaluate() throws EvaluationException {
        try {
            Number number = (Number)this.left().evaluate();
            Number number2 = (Number)this.right().evaluate();
            if (number instanceof Float || number instanceof Double || number2 instanceof Float || number2 instanceof Double) {
                String[] stringArray = new String[]{Util.getMessage("EvaluationException.right"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.1", stringArray));
            }
            BigInteger bigInteger = (BigInteger)this.coerceToTarget((BigInteger)number);
            BigInteger bigInteger2 = (BigInteger)number2;
            if (bigInteger.signum() == -1) {
                if (this.type().equals("short")) {
                    bigInteger = bigInteger.add(twoPow16);
                } else if (this.type().equals("long")) {
                    bigInteger = bigInteger.add(twoPow32);
                } else if (this.type().equals("long long")) {
                    bigInteger = bigInteger.add(twoPow64);
                }
            }
            this.value(bigInteger.shiftRight(bigInteger2.intValue()));
        }
        catch (ClassCastException classCastException) {
            String[] stringArray = new String[]{Util.getMessage("EvaluationException.right"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.1", stringArray));
        }
        return this.value();
    }
}

