/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.tools.rmic.iiop.Constants;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.DirectoryLoader;
import com.ibm.tools.rmic.iiop.NameContext;
import com.ibm.tools.rmic.iiop.Type;
import com.ibm.tools.rmic.iiop.Version;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import sun.rmi.rmic.Main;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;

public class BatchEnvironment
extends sun.rmi.rmic.BatchEnvironment
implements Constants {
    private boolean parseNonConforming = false;
    HashSet alreadyChecked = new HashSet();
    Hashtable allTypes = new Hashtable(3001, 0.5f);
    Hashtable invalidTypes = new Hashtable(256, 0.5f);
    DirectoryLoader loader = null;
    Hashtable nameContexts = null;
    Hashtable namesCache = new Hashtable();
    NameContext modulesContext = new NameContext(false);
    ClassDefinition defRemote = null;
    ClassDefinition defError = null;
    ClassDefinition defException = null;
    ClassDefinition defRemoteException = null;
    ClassDefinition defCorbaObject = null;
    ClassDefinition defSerializable = null;
    ClassDefinition defExternalizable = null;
    ClassDefinition defThrowable = null;
    ClassDefinition defRuntimeException = null;
    ClassDefinition defIDLEntity = null;
    ClassDefinition defValueBase = null;
    sun.tools.java.Type typeRemoteException = null;
    sun.tools.java.Type typeIOException = null;
    sun.tools.java.Type typeException = null;
    sun.tools.java.Type typeThrowable = null;
    ContextStack contextStack = null;
    ClassPath cachedClassPath = null;

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, Main main) {
        super(outputStream, classPath, main);
        if (this.runtimeIsLoadable()) {
            this.initDefs();
        }
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, ClassPath classPath2, Main main) {
        this(outputStream, classPath2, main);
    }

    private void initDefs() {
        try {
            this.defRemote = this.getClassDefinition(idRemote);
            this.defError = this.getClassDefinition(idJavaLangError);
            this.defException = this.getClassDefinition(idJavaLangException);
            this.defRemoteException = this.getClassDefinition(idRemoteException);
            this.defCorbaObject = this.getClassDefinition(idCorbaObject);
            this.defSerializable = this.getClassDefinition(idJavaIoSerializable);
            this.defRuntimeException = this.getClassDefinition(idJavaLangRuntimeException);
            this.defExternalizable = this.getClassDefinition(idJavaIoExternalizable);
            this.defThrowable = this.getClassDefinition(idJavaLangThrowable);
            this.defIDLEntity = this.getClassDefinition(idIDLEntity);
            this.defValueBase = this.getClassDefinition(idValueBase);
            this.typeRemoteException = this.defRemoteException.getType();
            this.typeException = this.defException.getType();
            this.typeIOException = this.getClassDefinition(idJavaIoIOException).getType();
            this.typeThrowable = this.getClassDefinition(idJavaLangThrowable).getType();
        }
        catch (ClassNotFound classNotFound) {
            this.error(0L, "rmic.class.not.found", classNotFound.name);
            throw new Error();
        }
    }

    public boolean getParseNonConforming() {
        return this.parseNonConforming;
    }

    public void setParseNonConforming(boolean bl) {
        if (bl && !this.parseNonConforming) {
            this.reset();
        }
        this.parseNonConforming = bl;
    }

    public void reset() {
        Object object2;
        Enumeration enumeration = this.allTypes.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Type)enumeration.nextElement();
            ((Type)object2).destroy();
        }
        enumeration = this.invalidTypes.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (Type)enumeration.nextElement();
            ((Type)object2).destroy();
        }
        for (Object object2 : this.alreadyChecked) {
            ((Type)object2).destroy();
        }
        if (this.contextStack != null) {
            this.contextStack.clear();
        }
        if (this.nameContexts != null) {
            enumeration = this.nameContexts.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (NameContext)enumeration.nextElement();
                ((NameContext)object2).clear();
            }
            this.nameContexts.clear();
        }
        this.allTypes.clear();
        this.invalidTypes.clear();
        this.alreadyChecked.clear();
        this.namesCache.clear();
        this.modulesContext.clear();
        if (this.loader != null) {
            this.loader.destroy();
            this.loader = null;
        }
        this.parseNonConforming = false;
    }

    public void shutdown() {
        if (this.alreadyChecked != null) {
            this.reset();
            this.alreadyChecked = null;
            this.allTypes = null;
            this.invalidTypes = null;
            this.nameContexts = null;
            this.namesCache = null;
            this.modulesContext = null;
            this.defRemote = null;
            this.defError = null;
            this.defException = null;
            this.defRemoteException = null;
            this.defCorbaObject = null;
            this.defSerializable = null;
            this.defExternalizable = null;
            this.defThrowable = null;
            this.defRuntimeException = null;
            this.defIDLEntity = null;
            this.defValueBase = null;
            this.typeRemoteException = null;
            this.typeIOException = null;
            this.typeException = null;
            this.typeThrowable = null;
            super.shutdown();
        }
    }

    private boolean runtimeIsLoadable() {
        if (!Version.runtimeIsLoadable()) {
            this.error(0L, "rmic.cannot.load.runtime");
            return false;
        }
        if (!Version.runtimeAndToolsAreCompatible()) {
            short s = Version.getRuntimeVersionMajor();
            this.error(0L, "rmic.runtime.wrong.version", "0x" + Integer.toHexString(Version.getVersionMajor()), s > 0 ? "0x" + Integer.toHexString(s) : "(unknown)");
            return false;
        }
        return true;
    }

    public ClassPath tryToGetClassPath() {
        if (this.cachedClassPath != null) {
            return this.cachedClassPath;
        }
        try {
            Class[] classArray = new Class[]{};
            try {
                Method method = this.getClass().getMethod("getClassPath", classArray);
                this.cachedClassPath = (ClassPath)method.invoke((Object)this, (Object[])classArray);
                return this.cachedClassPath;
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Method method = this.getClass().getMethod("getSourcePath", classArray);
            Method method2 = this.getClass().getMethod("getBinaryPath", classArray);
            ClassPath classPath = (ClassPath)method.invoke((Object)this, (Object[])classArray);
            ClassPath classPath2 = (ClassPath)method2.invoke((Object)this, (Object[])classArray);
            String string = classPath + File.pathSeparator + classPath2;
            this.cachedClassPath = new ClassPath(string);
            return this.cachedClassPath;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new Error("Error using BatchEnvironment - check which tools jar is being used.", throwable);
        }
    }
}

