/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.comp;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class PrintAP
implements AnnotationProcessor {
    AnnotationProcessorEnvironment env;

    PrintAP(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.env = annotationProcessorEnvironment;
    }

    public void process() {
        Collection collection = this.env.getSpecifiedTypeDeclarations();
        for (TypeDeclaration typeDeclaration : collection) {
            typeDeclaration.accept(new PrintingVisitors(this.env).getPrintingVisitor());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrintingVisitors {
        int indentation = 0;
        AnnotationProcessorEnvironment env;
        Messager out;
        Declaration java_lang_Object;
        Declaration java_lang_annotation_Annotation;
        static String[] spaces = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  ", "                    "};

        PrintingVisitors(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
            this.env = annotationProcessorEnvironment;
            this.out = annotationProcessorEnvironment.getMessager();
            this.java_lang_Object = annotationProcessorEnvironment.getTypeDeclaration("java.lang.Object");
            this.java_lang_annotation_Annotation = annotationProcessorEnvironment.getTypeDeclaration("java.lang.annotation.Annotation");
        }

        String indent() {
            int n = this.indentation;
            if (n < 0) {
                return "";
            }
            if (n <= 10) {
                return spaces[n];
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (n > 10) {
                stringBuilder.append(spaces[n]);
                n -= 10;
            }
            stringBuilder.append(spaces[n]);
            return stringBuilder.toString();
        }

        private void printAnnotations(Collection<AnnotationMirror> collection) {
            for (AnnotationMirror annotationMirror : collection) {
                System.out.print(this.indent());
                System.out.print(annotationMirror.toString());
                System.out.println();
            }
        }

        private void printAnnotationsInline(Collection<AnnotationMirror> collection) {
            for (AnnotationMirror annotationMirror : collection) {
                System.out.print(annotationMirror);
                System.out.print(" ");
            }
        }

        private void printParameters(ExecutableDeclaration executableDeclaration) {
            Collection collection = executableDeclaration.getParameters();
            int n = collection.size();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    for (ParameterDeclaration parameterDeclaration : collection) {
                        this.printModifiers(parameterDeclaration);
                        if (executableDeclaration.isVarArgs()) {
                            System.out.print(((ArrayType)parameterDeclaration.getType()).getComponentType());
                            System.out.print("...");
                        } else {
                            System.out.print(parameterDeclaration.getType());
                        }
                        System.out.print(" " + parameterDeclaration.getSimpleName());
                    }
                    break;
                }
                default: {
                    int n2 = 1;
                    for (ParameterDeclaration parameterDeclaration : collection) {
                        if (n2 == 2) {
                            ++this.indentation;
                        }
                        if (n2 > 1) {
                            System.out.print(this.indent());
                        }
                        this.printModifiers(parameterDeclaration);
                        if (n2 == n && executableDeclaration.isVarArgs()) {
                            System.out.print(((ArrayType)parameterDeclaration.getType()).getComponentType());
                            System.out.print("...");
                        } else {
                            System.out.print(parameterDeclaration.getType());
                        }
                        System.out.print(" " + parameterDeclaration.getSimpleName());
                        if (n2 < n) {
                            System.out.println(",");
                        }
                        ++n2;
                    }
                    if (collection.size() < 2) break;
                    --this.indentation;
                }
            }
        }

        private void printDocComment(Declaration declaration) {
            String string = declaration.getDocComment();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
                System.out.print(this.indent());
                System.out.println("/**");
                while (stringTokenizer.hasMoreTokens()) {
                    System.out.print(this.indent());
                    System.out.print(" *");
                    System.out.println(stringTokenizer.nextToken());
                }
                System.out.print(this.indent());
                System.out.println(" */");
            }
        }

        private void printModifiers(Declaration declaration) {
            this.printAnnotations(declaration.getAnnotationMirrors());
            System.out.print(this.indent());
            Collection collection = declaration.getModifiers();
            for (Modifier modifier : collection) {
                System.out.print(modifier.toString() + " ");
            }
        }

        private void printModifiers(ParameterDeclaration parameterDeclaration) {
            this.printAnnotationsInline(parameterDeclaration.getAnnotationMirrors());
            Collection collection = parameterDeclaration.getModifiers();
            for (Modifier modifier : collection) {
                System.out.print(modifier.toString() + " ");
            }
        }

        private void printFormalTypeParameters(ExecutableDeclaration executableDeclaration) {
            this.printFormalTypeParameterSet(executableDeclaration.getFormalTypeParameters(), true);
        }

        private void printFormalTypeParameters(TypeDeclaration typeDeclaration) {
            this.printFormalTypeParameterSet(typeDeclaration.getFormalTypeParameters(), false);
        }

        private void printFormalTypeParameterSet(Collection<TypeParameterDeclaration> collection, boolean bl) {
            if (collection.size() != 0) {
                System.out.print("<");
                boolean bl2 = true;
                for (TypeParameterDeclaration typeParameterDeclaration : collection) {
                    if (!bl2) {
                        System.out.print(", ");
                    }
                    System.out.print(typeParameterDeclaration.toString());
                }
                System.out.print(">");
                if (bl) {
                    System.out.print(" ");
                }
            }
        }

        private void printInterfaceSet(Collection<InterfaceType> collection, boolean bl) {
            if (collection.size() != 0) {
                System.out.print(bl ? " implements" : " extends");
                boolean bl2 = true;
                for (InterfaceType interfaceType : collection) {
                    if (!bl2) {
                        System.out.print(",");
                    }
                    System.out.print(" ");
                    System.out.print(interfaceType.toString());
                    bl2 = false;
                }
            }
        }

        private void printInterfaces(TypeDeclaration typeDeclaration) {
            this.printInterfaceSet(typeDeclaration.getSuperinterfaces(), typeDeclaration instanceof ClassDeclaration);
        }

        private void printInterfaces(AnnotationTypeDeclaration annotationTypeDeclaration) {
            HashSet<InterfaceType> hashSet = new HashSet<InterfaceType>(annotationTypeDeclaration.getSuperinterfaces());
            for (InterfaceType interfaceType : hashSet) {
                if (!this.java_lang_annotation_Annotation.equals(interfaceType.getDeclaration())) continue;
                hashSet.remove(interfaceType);
            }
            this.printInterfaceSet(hashSet, annotationTypeDeclaration instanceof ClassDeclaration);
        }

        private void printThrows(ExecutableDeclaration executableDeclaration) {
            Collection collection = executableDeclaration.getThrownTypes();
            int n = collection.size();
            if (n != 0) {
                System.out.print(" throws");
                int n2 = 1;
                for (ReferenceType referenceType : collection) {
                    if (n2 == 1) {
                        System.out.print(" ");
                    }
                    if (n2 == 2) {
                        ++this.indentation;
                    }
                    if (n2 >= 2) {
                        System.out.print(this.indent());
                    }
                    System.out.print(referenceType.toString());
                    if (n2 != n) {
                        System.out.println(", ");
                    }
                    ++n2;
                }
                if (n >= 2) {
                    --this.indentation;
                }
            }
        }

        DeclarationVisitor getPrintingVisitor() {
            return DeclarationVisitors.getSourceOrderDeclarationScanner((DeclarationVisitor)new PrePrinting(), (DeclarationVisitor)new PostPrinting());
        }

        class PostPrinting
        extends SimpleDeclarationVisitor {
            PostPrinting() {
            }

            public void visitTypeDeclaration(TypeDeclaration typeDeclaration) {
                --PrintingVisitors.this.indentation;
                System.out.print(PrintingVisitors.this.indent());
                System.out.println("}");
            }
        }

        class PrePrinting
        extends SimpleDeclarationVisitor {
            Map<EnumDeclaration, Integer> enumCardinality = new HashMap<EnumDeclaration, Integer>();
            Map<EnumDeclaration, Integer> enumConstVisited = new HashMap<EnumDeclaration, Integer>();

            PrePrinting() {
            }

            public void visitClassDeclaration(ClassDeclaration classDeclaration) {
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)classDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)classDeclaration);
                System.out.print("class " + classDeclaration.getSimpleName());
                PrintingVisitors.this.printFormalTypeParameters((TypeDeclaration)classDeclaration);
                ClassType classType = classDeclaration.getSuperclass();
                if (classType != null && !PrintingVisitors.this.java_lang_Object.equals(classType.getDeclaration())) {
                    System.out.print(" extends " + classType.toString());
                }
                PrintingVisitors.this.printInterfaces((TypeDeclaration)classDeclaration);
                System.out.println(" {");
                ++PrintingVisitors.this.indentation;
            }

            public void visitEnumDeclaration(EnumDeclaration enumDeclaration) {
                this.enumCardinality.put(enumDeclaration, enumDeclaration.getEnumConstants().size());
                this.enumConstVisited.put(enumDeclaration, 1);
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)enumDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)enumDeclaration);
                System.out.print("enum " + enumDeclaration.getSimpleName());
                PrintingVisitors.this.printFormalTypeParameters((TypeDeclaration)enumDeclaration);
                PrintingVisitors.this.printInterfaces((TypeDeclaration)enumDeclaration);
                System.out.println(" {");
                ++PrintingVisitors.this.indentation;
            }

            public void visitInterfaceDeclaration(InterfaceDeclaration interfaceDeclaration) {
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)interfaceDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)interfaceDeclaration);
                System.out.print("interface " + interfaceDeclaration.getSimpleName());
                PrintingVisitors.this.printFormalTypeParameters((TypeDeclaration)interfaceDeclaration);
                PrintingVisitors.this.printInterfaces((TypeDeclaration)interfaceDeclaration);
                System.out.println(" {");
                ++PrintingVisitors.this.indentation;
            }

            public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration annotationTypeDeclaration) {
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)annotationTypeDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)annotationTypeDeclaration);
                System.out.print("@interface " + annotationTypeDeclaration.getSimpleName());
                PrintingVisitors.this.printFormalTypeParameters((TypeDeclaration)annotationTypeDeclaration);
                PrintingVisitors.this.printInterfaces(annotationTypeDeclaration);
                System.out.println(" {");
                ++PrintingVisitors.this.indentation;
            }

            public void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)fieldDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)fieldDeclaration);
                System.out.print(fieldDeclaration.getType().toString() + " " + fieldDeclaration.getSimpleName());
                String string = fieldDeclaration.getConstantExpression();
                if (string != null) {
                    System.out.print(" = " + string);
                }
                System.out.println(";");
            }

            public void visitEnumConstantDeclaration(EnumConstantDeclaration enumConstantDeclaration) {
                EnumDeclaration enumDeclaration = enumConstantDeclaration.getDeclaringType();
                int n = this.enumCardinality.get(enumDeclaration);
                int n2 = this.enumConstVisited.get(enumDeclaration);
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)enumConstantDeclaration);
                System.out.print(PrintingVisitors.this.indent());
                System.out.print(enumConstantDeclaration.getSimpleName());
                System.out.println(n2 < n ? "," : ";");
                this.enumConstVisited.put(enumDeclaration, n2 + 1);
            }

            public void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)methodDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)methodDeclaration);
                PrintingVisitors.this.printFormalTypeParameters((ExecutableDeclaration)methodDeclaration);
                System.out.print(methodDeclaration.getReturnType().toString() + " ");
                System.out.print(methodDeclaration.getSimpleName() + "(");
                PrintingVisitors.this.printParameters((ExecutableDeclaration)methodDeclaration);
                System.out.print(")");
                PrintingVisitors.this.printThrows((ExecutableDeclaration)methodDeclaration);
                System.out.println(";");
            }

            public void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
                System.out.println();
                PrintingVisitors.this.printDocComment((Declaration)constructorDeclaration);
                PrintingVisitors.this.printModifiers((Declaration)constructorDeclaration);
                PrintingVisitors.this.printFormalTypeParameters((ExecutableDeclaration)constructorDeclaration);
                System.out.print(constructorDeclaration.getSimpleName() + "(");
                PrintingVisitors.this.printParameters((ExecutableDeclaration)constructorDeclaration);
                System.out.print(")");
                PrintingVisitors.this.printThrows((ExecutableDeclaration)constructorDeclaration);
                System.out.println(";");
            }
        }
    }
}

