/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.tools.doclets.formats.html.AbstractMemberWriter;
import com.sun.tools.doclets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.ConstructorWriterImpl;
import com.sun.tools.doclets.formats.html.EnumConstantWriterImpl;
import com.sun.tools.doclets.formats.html.FieldWriterImpl;
import com.sun.tools.doclets.formats.html.MethodWriterImpl;
import com.sun.tools.doclets.formats.html.NestedClassWriterImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.internal.toolkit.util.DeprecatedAPIListBuilder;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class DeprecatedListWriter
extends SubWriterHolderWriter {
    private static final String[] ANCHORS = new String[]{"interface", "class", "enum", "exception", "error", "annotation_type", "field", "method", "constructor", "enum_constant", "annotation_type_member"};
    private static final String[] HEADING_KEYS = new String[]{"doclet.Deprecated_Interfaces", "doclet.Deprecated_Classes", "doclet.Deprecated_Enums", "doclet.Deprecated_Exceptions", "doclet.Deprecated_Errors", "doclet.Deprecated_Annotation_Types", "doclet.Deprecated_Fields", "doclet.Deprecated_Methods", "doclet.Deprecated_Constructors", "doclet.Deprecated_Enum_Constants", "doclet.Deprecated_Annotation_Type_Members"};
    private AbstractMemberWriter[] writers;
    private ConfigurationImpl configuration;

    public DeprecatedListWriter(ConfigurationImpl configurationImpl, String string) throws IOException {
        super(configurationImpl, string);
        this.configuration = configurationImpl;
        NestedClassWriterImpl nestedClassWriterImpl = new NestedClassWriterImpl(this);
        this.writers = new AbstractMemberWriter[]{nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, new FieldWriterImpl(this), new MethodWriterImpl(this), new ConstructorWriterImpl(this), new EnumConstantWriterImpl(this), new AnnotationTypeOptionalMemberWriterImpl((SubWriterHolderWriter)this, null)};
    }

    public static void generate(ConfigurationImpl configurationImpl) {
        String string = "deprecated-list.html";
        try {
            DeprecatedListWriter deprecatedListWriter = new DeprecatedListWriter(configurationImpl, string);
            deprecatedListWriter.generateDeprecatedListFile(new DeprecatedAPIListBuilder(configurationImpl.root));
            deprecatedListWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateDeprecatedListFile(DeprecatedAPIListBuilder deprecatedAPIListBuilder) throws IOException {
        int n;
        this.writeHeader();
        this.bold(this.configuration.getText("doclet.Contents"));
        this.ul();
        for (n = 0; n < 11; ++n) {
            this.writeIndexLink(deprecatedAPIListBuilder, n);
        }
        this.ulEnd();
        this.println();
        for (n = 0; n < 11; ++n) {
            if (!deprecatedAPIListBuilder.hasDocumentation(n)) continue;
            this.writeAnchor(deprecatedAPIListBuilder, n);
            this.writers[n].printDeprecatedAPI(deprecatedAPIListBuilder.getList(n), HEADING_KEYS[n]);
        }
        this.printDeprecatedFooter();
    }

    private void writeIndexLink(DeprecatedAPIListBuilder deprecatedAPIListBuilder, int n) {
        if (deprecatedAPIListBuilder.hasDocumentation(n)) {
            this.li();
            this.printHyperLink("#" + ANCHORS[n], this.configuration.getText(HEADING_KEYS[n]));
            this.println();
        }
    }

    private void writeAnchor(DeprecatedAPIListBuilder deprecatedAPIListBuilder, int n) {
        if (deprecatedAPIListBuilder.hasDocumentation(n)) {
            this.anchor(ANCHORS[n]);
        }
    }

    protected void writeHeader() {
        this.printHtmlHeader(this.configuration.getText("doclet.Window_Deprecated_List"), null, true);
        this.navLinks(true);
        this.hr();
        this.aName("main");
        this.aEnd();
        this.println("");
        this.center();
        this.h2();
        this.boldText("doclet.Deprecated_API");
        this.h2End();
        this.centerEnd();
        this.hr(4, "noshade");
    }

    protected void printDeprecatedFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkDeprecated() {
        this.navCellRevStart();
        this.printHyperLink("#main", "", this.configuration.getText("doclet.navDeprecated"), true, "NavBarFont1Rev");
        this.navCellEnd();
    }
}

