/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;

public abstract class Gen {
    RootDoc root;
    protected ClassDoc[] classes;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    protected String outDir;
    protected String outFile;
    protected boolean force = false;

    public Gen(RootDoc rootDoc) {
        this.root = rootDoc;
    }

    protected abstract void write(OutputStream var1, ClassDoc var2) throws ClassNotFoundException;

    protected abstract String getIncludes();

    public void setOutDir(String string) {
        if (string != null) {
            this.outDir = string + System.getProperty("file.separator");
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                Util.error("cant.create.dir", file.toString());
            }
        }
    }

    public void setOutFile(String string) {
        this.outFile = string;
    }

    public void setClasses(ClassDoc[] classDocArray) {
        this.classes = classDocArray;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    protected PrintWriter wrapWriter(OutputStream outputStream) {
        return new PrintWriter((Writer)new OutputStreamWriter(outputStream), true);
    }

    public void run() throws IOException, ClassNotFoundException {
        int n = 0;
        if (this.outFile != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            this.writeFileTop(byteArrayOutputStream);
            for (n = 0; n < this.classes.length; ++n) {
                this.write(byteArrayOutputStream, this.classes[n]);
            }
            this.writeIfChanged(byteArrayOutputStream.toByteArray(), this.outFile);
        } else {
            for (n = 0; n < this.classes.length; ++n) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                this.writeFileTop(byteArrayOutputStream);
                ClassDoc classDoc = this.classes[n];
                this.write(byteArrayOutputStream, classDoc);
                this.writeIfChanged(byteArrayOutputStream.toByteArray(), this.getFileName(classDoc.qualifiedName()));
            }
        }
    }

    private void writeIfChanged(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        boolean bl = false;
        String string2 = "[No need to update file ";
        if (this.force) {
            bl = true;
            string2 = "[Forcefully writing file ";
        } else if (!file.exists()) {
            bl = true;
            string2 = "[Creating file ";
        } else {
            int n = (int)file.length();
            if (byArray.length != n) {
                bl = true;
                string2 = "[Overwriting file ";
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray2 = new byte[n];
                if (fileInputStream.read(byArray2) != n) {
                    fileInputStream.close();
                    Util.error("not.enough.bytes", Integer.toString(n), file.toString());
                }
                fileInputStream.close();
                while (--n >= 0) {
                    if (byArray2[n] == byArray[n]) continue;
                    bl = true;
                    string2 = "[Overwriting file ";
                }
            }
        }
        if (Util.verbose) {
            Util.log(string2 + string + "]");
        }
        if (bl) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
    }

    protected String defineForStatic(ClassDoc classDoc, FieldDoc fieldDoc) {
        String string = classDoc.qualifiedName();
        String string2 = fieldDoc.name();
        String string3 = Mangle.mangle(string, 1);
        String string4 = Mangle.mangle(string2, 2);
        if (!fieldDoc.isStatic()) {
            Util.bug("tried.to.define.non.static");
        }
        if (fieldDoc.isFinal()) {
            Object object = null;
            object = fieldDoc.constantValue();
            if (object != null) {
                String string5 = null;
                if (object instanceof Integer || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Boolean) {
                    string5 = object instanceof Boolean ? (object.toString() == "true" ? "1L" : "0L") : object.toString() + "L";
                } else if (object instanceof Long) {
                    string5 = isWindows ? object.toString() + "i64" : object.toString() + "LL";
                } else if (object instanceof Float) {
                    float f = ((Float)object).floatValue();
                    string5 = Float.isInfinite(f) ? (f < 0.0f ? "-" : "") + "Inff" : object.toString() + "f";
                } else if (object instanceof Double) {
                    double d = (Double)object;
                    string5 = Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "InfD" : object.toString();
                }
                if (string5 != null) {
                    StringBuffer stringBuffer = new StringBuffer("#undef ");
                    stringBuffer.append(string3);
                    stringBuffer.append("_");
                    stringBuffer.append(string4);
                    stringBuffer.append("\n#define ");
                    stringBuffer.append(string3);
                    stringBuffer.append("_");
                    stringBuffer.append(string4);
                    stringBuffer.append(" ");
                    stringBuffer.append(string5);
                    return stringBuffer.toString();
                }
            }
        }
        return null;
    }

    protected String cppGuardBegin() {
        return "#ifdef __cplusplus\nextern \"C\" {\n#endif";
    }

    protected String cppGuardEnd() {
        return "#ifdef __cplusplus\n}\n#endif";
    }

    protected String guardBegin(String string) {
        return "/* Header for class " + string + " */\n\n" + "#ifndef _Included_" + string + "\n" + "#define _Included_" + string;
    }

    protected String guardEnd(String string) {
        return "#endif";
    }

    protected void writeFileTop(OutputStream outputStream) {
        PrintWriter printWriter = this.wrapWriter(outputStream);
        printWriter.println("/* DO NOT EDIT THIS FILE - it is machine generated */\n" + this.getIncludes());
    }

    protected String baseFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(Mangle.mangle(string, 1));
        if (this.outDir != null) {
            stringBuffer.insert(0, this.outDir);
        }
        return stringBuffer.toString();
    }

    protected String getFileName(String string) {
        return this.baseFileName(string) + this.getFileSuffix();
    }

    protected String getFileSuffix() {
        return ".h";
    }

    FieldDoc[] getAllFields(ClassDoc classDoc) throws ClassNotFoundException {
        Vector<FieldDoc> vector = new Vector<FieldDoc>();
        ClassDoc classDoc2 = null;
        Stack<ClassDoc> stack = new Stack<ClassDoc>();
        classDoc2 = classDoc;
        while (true) {
            stack.push(classDoc2);
            ClassDoc classDoc3 = classDoc2.superclass();
            if (classDoc3 == null) break;
            classDoc2 = classDoc3;
        }
        while (!stack.empty()) {
            classDoc2 = (ClassDoc)stack.pop();
            vector.addAll(Arrays.asList(classDoc2.fields()));
        }
        return vector.toArray(new FieldDoc[vector.size()]);
    }
}

