/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import java.util.ArrayList;
import java.util.List;

public class JNITypeParser {
    static final char SIGNATURE_ENDCLASS = ';';
    static final char SIGNATURE_FUNC = '(';
    static final char SIGNATURE_ENDFUNC = ')';
    private String signature;
    private List typeNameList;
    private List signatureList;
    private int currentIndex;

    JNITypeParser(String string) {
        this.signature = string;
    }

    static String typeNameToSignature(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n = string.indexOf(91);
        while (n2 != -1) {
            stringBuffer.append('[');
            n2 = string.indexOf(91, n2 + 1);
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.equals("boolean")) {
            stringBuffer.append('Z');
        } else if (string.equals("byte")) {
            stringBuffer.append('B');
        } else if (string.equals("char")) {
            stringBuffer.append('C');
        } else if (string.equals("short")) {
            stringBuffer.append('S');
        } else if (string.equals("int")) {
            stringBuffer.append('I');
        } else if (string.equals("long")) {
            stringBuffer.append('J');
        } else if (string.equals("float")) {
            stringBuffer.append('F');
        } else if (string.equals("double")) {
            stringBuffer.append('D');
        } else {
            stringBuffer.append('L');
            stringBuffer.append(string.replace('.', '/'));
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    String typeName() {
        return (String)this.typeNameList().get(this.typeNameList().size() - 1);
    }

    List argumentTypeNames() {
        return this.typeNameList().subList(0, this.typeNameList().size() - 1);
    }

    String signature() {
        return (String)this.signatureList().get(this.signatureList().size() - 1);
    }

    List argumentSignatures() {
        return this.signatureList().subList(0, this.signatureList().size() - 1);
    }

    int dimensionCount() {
        int n = 0;
        String string = this.signature();
        while (string.charAt(n) == '[') {
            ++n;
        }
        return n;
    }

    String componentSignature(int n) {
        return this.signature().substring(n);
    }

    private synchronized List signatureList() {
        if (this.signatureList == null) {
            this.signatureList = new ArrayList(10);
            this.currentIndex = 0;
            while (this.currentIndex < this.signature.length()) {
                String string = this.nextSignature();
                this.signatureList.add(string);
            }
            if (this.signatureList.size() == 0) {
                throw new IllegalArgumentException("Invalid JNI signature '" + this.signature + "'");
            }
        }
        return this.signatureList;
    }

    private synchronized List typeNameList() {
        if (this.typeNameList == null) {
            this.typeNameList = new ArrayList(10);
            this.currentIndex = 0;
            while (this.currentIndex < this.signature.length()) {
                String string = this.nextTypeName();
                this.typeNameList.add(string);
            }
            if (this.typeNameList.size() == 0) {
                throw new IllegalArgumentException("Invalid JNI signature '" + this.signature + "'");
            }
        }
        return this.typeNameList;
    }

    private String nextSignature() {
        char c = this.signature.charAt(this.currentIndex++);
        switch (c) {
            case '[': {
                return c + this.nextSignature();
            }
            case 'L': {
                int n = this.signature.indexOf(59, this.currentIndex);
                String string = this.signature.substring(this.currentIndex - 1, n + 1);
                this.currentIndex = n + 1;
                return string;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return String.valueOf(c);
            }
            case '(': 
            case ')': {
                return this.nextSignature();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + c + "'");
    }

    private String nextTypeName() {
        char c = this.signature.charAt(this.currentIndex++);
        switch (c) {
            case '[': {
                return this.nextTypeName() + "[]";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'L': {
                int n = this.signature.indexOf(59, this.currentIndex);
                String string = this.signature.substring(this.currentIndex, n);
                string = string.replace('/', '.');
                this.currentIndex = n + 1;
                return string;
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case '(': 
            case ')': {
                return this.nextTypeName();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + c + "'");
    }
}

