/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.AbstractLauncher;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.SocketTransportService;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunCommandLineLauncher
extends AbstractLauncher
implements LaunchingConnector {
    private static final String ARG_HOME = "home";
    private static final String ARG_OPTIONS = "options";
    private static final String ARG_MAIN = "main";
    private static final String ARG_INIT_SUSPEND = "suspend";
    private static final String ARG_QUOTE = "quote";
    private static final String ARG_VM_EXEC = "vmexec";
    TransportService transportService;
    Transport transport;
    boolean usingSharedMemory = false;

    TransportService transportService() {
        return this.transportService;
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    public SunCommandLineLauncher() {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.jdi.SharedMemoryTransportService");
            this.transportService = (TransportService)clazz.newInstance();
            this.transport = new Transport(){

                public String name() {
                    return "dt_shmem";
                }
            };
            this.usingSharedMemory = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (this.transportService == null) {
            this.transportService = new SocketTransportService();
            this.transport = new Transport(){

                public String name() {
                    return "dt_socket";
                }
            };
        }
        this.addStringArgument(ARG_HOME, this.getString("sun.home.label"), this.getString("sun.home"), System.getProperty("java.home"), false);
        this.addStringArgument(ARG_OPTIONS, this.getString("sun.options.label"), this.getString("sun.options"), "", false);
        this.addStringArgument(ARG_MAIN, this.getString("sun.main.label"), this.getString("sun.main"), "", true);
        this.addBooleanArgument(ARG_INIT_SUSPEND, this.getString("sun.init_suspend.label"), this.getString("sun.init_suspend"), true, false);
        this.addStringArgument(ARG_QUOTE, this.getString("sun.quote.label"), this.getString("sun.quote"), "\"", true);
        this.addStringArgument(ARG_VM_EXEC, this.getString("sun.vm_exec.label"), this.getString("sun.vm_exec"), "java", true);
    }

    static boolean hasWhitespace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachine launch(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachine virtualMachine;
        TransportService.ListenKey listenKey;
        String string;
        Object object;
        String string2;
        String string3;
        String string4;
        boolean bl;
        String string5;
        String string6;
        String string7;
        block11: {
            string7 = this.argument(ARG_HOME, map).value();
            string6 = this.argument(ARG_OPTIONS, map).value();
            string5 = this.argument(ARG_MAIN, map).value();
            bl = ((ConnectorImpl.BooleanArgumentImpl)this.argument(ARG_INIT_SUSPEND, map)).booleanValue();
            string4 = this.argument(ARG_QUOTE, map).value();
            string3 = this.argument(ARG_VM_EXEC, map).value();
            string2 = null;
            if (string4.length() > 1) {
                throw new IllegalConnectorArgumentsException("Invalid length", ARG_QUOTE);
            }
            if (string6.indexOf("-Djava.compiler=") != -1 && string6.toLowerCase().indexOf("-djava.compiler=none") == -1) {
                throw new IllegalConnectorArgumentsException("Cannot debug with a JIT compiler", ARG_OPTIONS);
            }
            if (this.usingSharedMemory) {
                object = new Random();
                int n = 0;
                while (true) {
                    try {
                        string = "javadebug" + String.valueOf(((Random)object).nextInt(100000));
                        listenKey = this.transportService().startListening(string);
                        break block11;
                    }
                    catch (IOException iOException) {
                        if (++n <= 5) continue;
                        throw iOException;
                    }
                    break;
                }
            }
            listenKey = this.transportService().startListening();
        }
        object = listenKey.address();
        try {
            String string8;
            string2 = string7.length() > 0 ? string7 + File.separator + "bin" + File.separator + string3 : string3;
            if (SunCommandLineLauncher.hasWhitespace(string3)) {
                string2 = string4 + string2 + string4;
            }
            if (SunCommandLineLauncher.hasWhitespace(string8 = "transport=" + this.transport().name() + ",address=" + (String)object + ",suspend=" + (bl ? (char)'y' : 'n'))) {
                string8 = string4 + string8 + string4;
            }
            string = string2 + ' ' + string6 + ' ' + "-Xdebug " + "-Xrunjdwp:" + string8 + ' ' + string5;
            virtualMachine = this.launch(this.tokenizeCommand(string, string4.charAt(0)), (String)object, listenKey, this.transportService());
        }
        finally {
            this.transportService().stopListening(listenKey);
        }
        return virtualMachine;
    }

    @Override
    public String name() {
        return "com.sun.jdi.CommandLineLaunch";
    }

    @Override
    public String description() {
        return this.getString("sun.description");
    }
}

