/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodSet;
import sun.tools.java.Type;
import sun.tools.javac.SourceClass;
import sun.tools.javac.SourceMember;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.Vset;

public class ClassDefinition
implements Constants {
    protected Object source;
    protected long where;
    protected int modifiers;
    protected Identifier localName;
    protected ClassDeclaration declaration;
    protected IdentifierToken superClassId;
    protected IdentifierToken[] interfaceIds;
    protected ClassDeclaration superClass;
    protected ClassDeclaration[] interfaces;
    protected ClassDefinition outerClass;
    protected MemberDefinition outerMember;
    protected MemberDefinition innerClassMember;
    protected MemberDefinition firstMember;
    protected MemberDefinition lastMember;
    protected boolean resolved;
    protected String documentation;
    protected boolean error;
    protected boolean nestError;
    protected UplevelReference references;
    protected boolean referencesFrozen;
    private Hashtable fieldHash = new Hashtable(31);
    private int abstr;
    private Hashtable localClasses = null;
    private final int LOCAL_CLASSES_SIZE = 31;
    protected Context classContext;
    protected boolean supersCheckStarted = !(this instanceof SourceClass);
    MethodSet allMethods = null;
    private List permanentlyAbstractMethods = new ArrayList();
    protected static boolean doInheritanceChecks = true;

    public Context getClassContext() {
        return this.classContext;
    }

    protected ClassDefinition(Object object, long l, ClassDeclaration classDeclaration, int n, IdentifierToken identifierToken, IdentifierToken[] identifierTokenArray) {
        this.source = object;
        this.where = l;
        this.declaration = classDeclaration;
        this.modifiers = n;
        this.superClassId = identifierToken;
        this.interfaceIds = identifierTokenArray;
    }

    public final Object getSource() {
        return this.source;
    }

    public final boolean getError() {
        return this.error;
    }

    public final void setError() {
        this.error = true;
        this.setNestError();
    }

    public final boolean getNestError() {
        return this.nestError || this.outerClass != null && this.outerClass.getNestError();
    }

    public final void setNestError() {
        this.nestError = true;
        if (this.outerClass != null) {
            this.outerClass.setNestError();
        }
    }

    public final long getWhere() {
        return this.where;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.declaration;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void subModifiers(int n) {
        this.modifiers &= ~n;
    }

    public final void addModifiers(int n) {
        this.modifiers |= n;
    }

    public final ClassDeclaration getSuperClass() {
        if (!this.supersCheckStarted) {
            throw new CompilerError("unresolved super");
        }
        return this.superClass;
    }

    public ClassDeclaration getSuperClass(Environment environment) {
        return this.getSuperClass();
    }

    public final ClassDeclaration[] getInterfaces() {
        if (this.interfaces == null) {
            throw new CompilerError("getInterfaces");
        }
        return this.interfaces;
    }

    public final ClassDefinition getOuterClass() {
        return this.outerClass;
    }

    protected final void setOuterClass(ClassDefinition classDefinition) {
        if (this.outerClass != null) {
            throw new CompilerError("setOuterClass");
        }
        this.outerClass = classDefinition;
    }

    protected final void setOuterMember(MemberDefinition memberDefinition) {
        if (this.isStatic() || !this.isInnerClass()) {
            throw new CompilerError("setOuterField");
        }
        if (this.outerMember != null) {
            throw new CompilerError("setOuterField");
        }
        this.outerMember = memberDefinition;
    }

    public final boolean isInnerClass() {
        return this.outerClass != null;
    }

    public final boolean isMember() {
        return this.outerClass != null && !this.isLocal();
    }

    public final boolean isTopLevel() {
        return this.outerClass == null || this.isStatic() || this.isInterface();
    }

    public final boolean isInsideLocal() {
        return this.isLocal() || this.outerClass != null && this.outerClass.isInsideLocal();
    }

    public final boolean isInsideLocalOrAnonymous() {
        return this.isLocal() || this.isAnonymous() || this.outerClass != null && this.outerClass.isInsideLocalOrAnonymous();
    }

    public Identifier getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        return this.getName().getFlatName().getName();
    }

    public void setLocalName(Identifier identifier) {
        if (this.isLocal()) {
            this.localName = identifier;
        }
    }

    public final MemberDefinition getInnerClassMember() {
        if (this.outerClass == null) {
            return null;
        }
        if (this.innerClassMember == null) {
            Identifier identifier = this.getName().getFlatName().getName();
            for (MemberDefinition memberDefinition = this.outerClass.getFirstMatch(identifier); memberDefinition != null; memberDefinition = memberDefinition.getNextMatch()) {
                if (!memberDefinition.isInnerClass()) continue;
                this.innerClassMember = memberDefinition;
                break;
            }
            if (this.innerClassMember == null) {
                throw new CompilerError("getInnerClassField");
            }
        }
        return this.innerClassMember;
    }

    public final MemberDefinition findOuterMember() {
        return this.outerMember;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final ClassDefinition getTopClass() {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2 = this;
        while ((classDefinition = classDefinition2.outerClass) != null) {
            classDefinition2 = classDefinition;
        }
        return classDefinition2;
    }

    public final MemberDefinition getFirstMember() {
        return this.firstMember;
    }

    public final MemberDefinition getFirstMatch(Identifier identifier) {
        return (MemberDefinition)this.fieldHash.get(identifier);
    }

    public final Identifier getName() {
        return this.declaration.getName();
    }

    public final Type getType() {
        return this.declaration.getType();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public static boolean containsDeprecated(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while ((n = string.indexOf("@deprecated", n)) >= 0) {
            block5: {
                char c;
                int n2;
                for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n' && c != '\r'; --n2) {
                    if (Character.isSpace(c)) {
                        continue;
                    }
                    break block5;
                }
                n2 = n + "@deprecated".length();
                if (n2 >= string.length() || (c = string.charAt(n2)) == '\n' || c == '\r' || Character.isSpace(c)) {
                    return true;
                }
            }
            n += "@deprecated".length();
        }
        return false;
    }

    public final boolean inSamePackage(ClassDeclaration classDeclaration) {
        return this.inSamePackage(classDeclaration.getName().getQualifier());
    }

    public final boolean inSamePackage(ClassDefinition classDefinition) {
        return this.inSamePackage(classDefinition.getName().getQualifier());
    }

    public final boolean inSamePackage(Identifier identifier) {
        return this.getName().getQualifier().equals(identifier);
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final boolean isClass() {
        return (this.getModifiers() & 0x200) == 0;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public final boolean isSynthetic() {
        return (this.getModifiers() & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.getModifiers() & 0x40000) != 0;
    }

    public final boolean isAnonymous() {
        return (this.getModifiers() & 0x10000) != 0;
    }

    public final boolean isLocal() {
        return (this.getModifiers() & 0x20000) != 0;
    }

    public final boolean hasConstructor() {
        return this.getFirstMatch(idInit) != null;
    }

    public final boolean mustBeAbstract(Environment environment) {
        if (this.isAbstract()) {
            return true;
        }
        this.collectInheritedMethods(environment);
        Iterator iterator = this.getMethods();
        while (iterator.hasNext()) {
            MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
            if (!memberDefinition.isAbstract()) continue;
            return true;
        }
        return this.getPermanentlyAbstractMethods().hasNext();
    }

    public boolean superClassOf(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        while (classDeclaration != null) {
            if (this.getClassDeclaration().equals(classDeclaration)) {
                return true;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public boolean enclosingClassOf(ClassDefinition classDefinition) {
        while ((classDefinition = classDefinition.getOuterClass()) != null) {
            if (this != classDefinition) continue;
            return true;
        }
        return false;
    }

    public boolean subClassOf(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        ClassDeclaration classDeclaration2 = this.getClassDeclaration();
        while (classDeclaration2 != null) {
            if (classDeclaration2.equals(classDeclaration)) {
                return true;
            }
            classDeclaration2 = classDeclaration2.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public boolean implementedBy(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        while (classDeclaration != null) {
            if (this.getClassDeclaration().equals(classDeclaration)) {
                return true;
            }
            ClassDeclaration[] classDeclarationArray = classDeclaration.getClassDefinition(environment).getInterfaces();
            for (int i = 0; i < classDeclarationArray.length; ++i) {
                if (!this.implementedBy(environment, classDeclarationArray[i])) continue;
                return true;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return false;
    }

    public boolean couldImplement(ClassDefinition classDefinition) {
        if (!doInheritanceChecks) {
            throw new CompilerError("couldImplement: no checks");
        }
        if (!this.isInterface() || !classDefinition.isInterface()) {
            throw new CompilerError("couldImplement: not interface");
        }
        if (this.allMethods == null) {
            throw new CompilerError("couldImplement: called early");
        }
        Iterator iterator = classDefinition.getMethods();
        while (iterator.hasNext()) {
            Type type;
            MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
            Identifier identifier = memberDefinition.getName();
            MemberDefinition memberDefinition2 = this.allMethods.lookupSig(identifier, type = memberDefinition.getType());
            if (memberDefinition2 == null || memberDefinition2.sameReturnType(memberDefinition)) continue;
            return false;
        }
        return true;
    }

    public boolean extendsCanAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        if (this.outerClass != null) {
            return this.outerClass.canAccess(environment, classDeclaration);
        }
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
        if (classDefinition.isLocal()) {
            throw new CompilerError("top local");
        }
        if (classDefinition.isInnerClass()) {
            MemberDefinition memberDefinition = classDefinition.getInnerClassMember();
            if (memberDefinition.isPublic()) {
                return true;
            }
            if (memberDefinition.isPrivate()) {
                return this.getClassDeclaration().equals(memberDefinition.getTopClass().getClassDeclaration());
            }
            return this.getName().getQualifier().equals(memberDefinition.getClassDeclaration().getName().getQualifier());
        }
        if (classDefinition.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(classDeclaration.getName().getQualifier());
    }

    public boolean canAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
        if (classDefinition.isLocal()) {
            return true;
        }
        if (classDefinition.isInnerClass()) {
            return this.canAccess(environment, classDefinition.getInnerClassMember());
        }
        if (classDefinition.isPublic()) {
            return true;
        }
        return this.getName().getQualifier().equals(classDeclaration.getName().getQualifier());
    }

    public boolean canAccess(Environment environment, MemberDefinition memberDefinition) throws ClassNotFound {
        if (memberDefinition.isPublic()) {
            return true;
        }
        if (memberDefinition.isProtected() && this.subClassOf(environment, memberDefinition.getClassDeclaration())) {
            return true;
        }
        if (memberDefinition.isPrivate()) {
            return this.getTopClass().getClassDeclaration().equals(memberDefinition.getTopClass().getClassDeclaration());
        }
        return this.getName().getQualifier().equals(memberDefinition.getClassDeclaration().getName().getQualifier());
    }

    public boolean permitInlinedAccess(Environment environment, ClassDeclaration classDeclaration) throws ClassNotFound {
        return environment.opt() && classDeclaration.equals(this.declaration) || environment.opt_interclass() && this.canAccess(environment, classDeclaration);
    }

    public boolean permitInlinedAccess(Environment environment, MemberDefinition memberDefinition) throws ClassNotFound {
        return environment.opt() && memberDefinition.clazz.getClassDeclaration().equals(this.declaration) || environment.opt_interclass() && this.canAccess(environment, memberDefinition);
    }

    public boolean protectedAccess(Environment environment, MemberDefinition memberDefinition, Type type) throws ClassNotFound {
        return memberDefinition.isStatic() || type.isType(9) && memberDefinition.getName() == idClone && memberDefinition.getType().getArgumentTypes().length == 0 || type.isType(10) && environment.getClassDefinition(type.getClassName()).subClassOf(environment, this.getClassDeclaration()) || this.getName().getQualifier().equals(memberDefinition.getClassDeclaration().getName().getQualifier());
    }

    public MemberDefinition getAccessMember(Environment environment, Context context, MemberDefinition memberDefinition, boolean bl) {
        throw new CompilerError("binary getAccessMember");
    }

    public MemberDefinition getUpdateMember(Environment environment, Context context, MemberDefinition memberDefinition, boolean bl) {
        throw new CompilerError("binary getUpdateMember");
    }

    public MemberDefinition getVariable(Environment environment, Identifier identifier, ClassDefinition classDefinition) throws AmbiguousMember, ClassNotFound {
        return this.getVariable0(environment, identifier, classDefinition, true, true);
    }

    private MemberDefinition getVariable0(Environment environment, Identifier identifier, ClassDefinition classDefinition, boolean bl, boolean bl2) throws AmbiguousMember, ClassNotFound {
        Constants constants;
        for (constants = this.getFirstMatch(identifier); constants != null; constants = ((MemberDefinition)constants).getNextMatch()) {
            if (!((MemberDefinition)constants).isVariable()) continue;
            if (!(!bl && ((MemberDefinition)constants).isPrivate() || !bl2 && ((MemberDefinition)constants).isPackagePrivate())) {
                return constants;
            }
            return null;
        }
        constants = this.getSuperClass();
        MemberDefinition memberDefinition = null;
        if (constants != null) {
            memberDefinition = ((ClassDeclaration)constants).getClassDefinition(environment).getVariable0(environment, identifier, classDefinition, false, bl2 && this.inSamePackage((ClassDeclaration)constants));
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            MemberDefinition memberDefinition2 = this.interfaces[i].getClassDefinition(environment).getVariable0(environment, identifier, classDefinition, true, true);
            if (memberDefinition2 == null) continue;
            if (memberDefinition != null && classDefinition.canAccess(environment, memberDefinition) && memberDefinition2 != memberDefinition) {
                throw new AmbiguousMember(memberDefinition2, memberDefinition);
            }
            memberDefinition = memberDefinition2;
        }
        return memberDefinition;
    }

    public boolean reportDeprecated(Environment environment) {
        return this.isDeprecated() || this.outerClass != null && this.outerClass.reportDeprecated(environment);
    }

    public void noteUsedBy(ClassDefinition classDefinition, long l, Environment environment) {
        if (this.reportDeprecated(environment)) {
            environment.error(l, "warn.class.is.deprecated", this);
        }
    }

    public MemberDefinition getInnerClass(Environment environment, Identifier identifier) throws ClassNotFound {
        Constants constants;
        for (constants = this.getFirstMatch(identifier); constants != null; constants = ((MemberDefinition)constants).getNextMatch()) {
            if (!((MemberDefinition)constants).isInnerClass() || ((MemberDefinition)constants).getInnerClass().isLocal()) continue;
            return constants;
        }
        constants = this.getSuperClass(environment);
        if (constants != null) {
            return ((ClassDeclaration)constants).getClassDefinition(environment).getInnerClass(environment, identifier);
        }
        return null;
    }

    private MemberDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier, Type[] typeArray, boolean bl, Identifier identifier2) throws AmbiguousMember, ClassNotFound {
        if (this.allMethods == null || !this.allMethods.isFrozen()) {
            throw new CompilerError("matchMethod called early");
        }
        MemberDefinition memberDefinition = null;
        ArrayList<Object> arrayList = null;
        Iterator iterator = this.allMethods.lookupName(identifier);
        while (iterator.hasNext()) {
            MemberDefinition memberDefinition2 = (MemberDefinition)iterator.next();
            if (!environment.isApplicable(memberDefinition2, typeArray) || (classDefinition == null ? bl && (memberDefinition2.isPrivate() || memberDefinition2.isPackagePrivate() && identifier2 != null && !this.inSamePackage(identifier2)) : !classDefinition.canAccess(environment, memberDefinition2))) continue;
            if (memberDefinition == null) {
                memberDefinition = memberDefinition2;
                continue;
            }
            if (environment.isMoreSpecific(memberDefinition2, memberDefinition)) {
                memberDefinition = memberDefinition2;
                continue;
            }
            if (environment.isMoreSpecific(memberDefinition, memberDefinition2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(memberDefinition2);
        }
        if (memberDefinition != null && arrayList != null) {
            for (MemberDefinition memberDefinition3 : arrayList) {
                if (environment.isMoreSpecific(memberDefinition, memberDefinition3)) continue;
                throw new AmbiguousMember(memberDefinition, memberDefinition3);
            }
        }
        return memberDefinition;
    }

    public MemberDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier, Type[] typeArray) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(environment, classDefinition, identifier, typeArray, false, null);
    }

    public MemberDefinition matchMethod(Environment environment, ClassDefinition classDefinition, Identifier identifier) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(environment, classDefinition, identifier, Type.noArgs, false, null);
    }

    public MemberDefinition matchAnonConstructor(Environment environment, Identifier identifier, Type[] typeArray) throws AmbiguousMember, ClassNotFound {
        return this.matchMethod(environment, null, idInit, typeArray, true, identifier);
    }

    public MemberDefinition findMethod(Environment environment, Identifier identifier, Type type) throws ClassNotFound {
        for (MemberDefinition memberDefinition = this.getFirstMatch(identifier); memberDefinition != null; memberDefinition = memberDefinition.getNextMatch()) {
            if (!memberDefinition.getType().equalArguments(type)) continue;
            return memberDefinition;
        }
        if (identifier.equals(idInit)) {
            return null;
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        if (classDeclaration == null) {
            return null;
        }
        return classDeclaration.getClassDefinition(environment).findMethod(environment, identifier, type);
    }

    protected void basicCheck(Environment environment) throws ClassNotFound {
        if (this.outerClass != null) {
            this.outerClass.basicCheck(environment);
        }
    }

    public void check(Environment environment) throws ClassNotFound {
    }

    public Vset checkLocalClass(Environment environment, Context context, Vset vset, ClassDefinition classDefinition, Expression[] expressionArray, Type[] typeArray) throws ClassNotFound {
        throw new CompilerError("checkLocalClass");
    }

    protected Iterator getPermanentlyAbstractMethods() {
        if (this.allMethods == null) {
            throw new CompilerError("isPermanentlyAbstract() called early");
        }
        return this.permanentlyAbstractMethods.iterator();
    }

    public static void turnOffInheritanceChecks() {
        doInheritanceChecks = false;
    }

    private void collectOneClass(Environment environment, ClassDeclaration classDeclaration, MethodSet methodSet, MethodSet methodSet2, MethodSet methodSet3) {
        try {
            ClassDefinition classDefinition = classDeclaration.getClassDefinition(environment);
            Iterator iterator = classDefinition.getMethods(environment);
            while (iterator.hasNext()) {
                MemberDefinition memberDefinition = (MemberDefinition)iterator.next();
                if (memberDefinition.isPrivate() || memberDefinition.isConstructor() || classDefinition.isInterface() && !memberDefinition.isAbstract()) continue;
                Identifier identifier = memberDefinition.getName();
                Type type = memberDefinition.getType();
                MemberDefinition memberDefinition2 = methodSet.lookupSig(identifier, type);
                if (memberDefinition.isPackagePrivate() && !this.inSamePackage(memberDefinition.getClassDeclaration())) {
                    if (memberDefinition2 != null && this instanceof SourceClass) {
                        environment.error(memberDefinition.getWhere(), "warn.no.override.access", memberDefinition2, memberDefinition2.getClassDeclaration(), memberDefinition.getClassDeclaration());
                    }
                    if (!memberDefinition.isAbstract()) continue;
                    this.permanentlyAbstractMethods.add(memberDefinition);
                    continue;
                }
                if (memberDefinition2 != null) {
                    memberDefinition2.checkOverride(environment, memberDefinition);
                    continue;
                }
                MemberDefinition memberDefinition3 = methodSet2.lookupSig(identifier, type);
                if (memberDefinition3 == null) {
                    if (methodSet3 != null && classDefinition.isInterface() && !this.isInterface()) {
                        memberDefinition = new SourceMember(memberDefinition, this, environment);
                        methodSet3.add(memberDefinition);
                    }
                    methodSet2.add(memberDefinition);
                    continue;
                }
                if (this.isInterface() && !memberDefinition3.isAbstract() && memberDefinition.isAbstract()) {
                    methodSet2.replace(memberDefinition);
                    continue;
                }
                if (!memberDefinition3.checkMeet(environment, memberDefinition, this.getClassDeclaration()) || memberDefinition3.couldOverride(environment, memberDefinition)) continue;
                if (memberDefinition.couldOverride(environment, memberDefinition3)) {
                    if (methodSet3 != null && classDefinition.isInterface() && !this.isInterface()) {
                        memberDefinition = new SourceMember(memberDefinition, this, environment);
                        methodSet3.replace(memberDefinition);
                    }
                    methodSet2.replace(memberDefinition);
                    continue;
                }
                environment.error(this.where, "nontrivial.meet", memberDefinition, memberDefinition3.getClassDefinition(), memberDefinition.getClassDeclaration());
            }
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.getWhere(), "class.not.found", classNotFound.name, this);
        }
    }

    protected void collectInheritedMethods(Environment environment) {
        if (this.allMethods != null) {
            if (this.allMethods.isFrozen()) {
                return;
            }
            throw new CompilerError("collectInheritedMethods()");
        }
        MethodSet methodSet = new MethodSet();
        this.allMethods = new MethodSet();
        MethodSet methodSet2 = environment.version12() ? null : new MethodSet();
        Constants constants = this.getFirstMember();
        while (constants != null) {
            if (((MemberDefinition)constants).isMethod() && !((MemberDefinition)constants).isInitializer()) {
                ClassDefinition.methodSetAdd(environment, methodSet, (MemberDefinition)constants);
                ClassDefinition.methodSetAdd(environment, this.allMethods, (MemberDefinition)constants);
            }
            constants = ((MemberDefinition)constants).nextMember;
        }
        constants = this.getSuperClass(environment);
        if (constants != null) {
            this.collectOneClass(environment, (ClassDeclaration)constants, methodSet, this.allMethods, methodSet2);
            ClassDefinition classDefinition = ((ClassDeclaration)constants).getClassDefinition();
            Iterator iterator = classDefinition.getPermanentlyAbstractMethods();
            while (iterator.hasNext()) {
                this.permanentlyAbstractMethods.add(iterator.next());
            }
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.collectOneClass(environment, this.interfaces[i], methodSet, this.allMethods, methodSet2);
        }
        this.allMethods.freeze();
        if (methodSet2 != null && methodSet2.size() > 0) {
            this.addMirandaMethods(environment, methodSet2.iterator());
        }
    }

    private static void methodSetAdd(Environment environment, MethodSet methodSet, MemberDefinition memberDefinition) {
        MemberDefinition memberDefinition2 = methodSet.lookupSig(memberDefinition.getName(), memberDefinition.getType());
        if (memberDefinition2 != null) {
            Type type = memberDefinition2.getType().getReturnType();
            Type type2 = memberDefinition.getType().getReturnType();
            try {
                if (environment.isMoreSpecific(type2, type)) {
                    methodSet.replace(memberDefinition);
                }
            }
            catch (ClassNotFound classNotFound) {}
        } else {
            methodSet.add(memberDefinition);
        }
    }

    public Iterator getMethods(Environment environment) {
        if (this.allMethods == null) {
            this.collectInheritedMethods(environment);
        }
        return this.getMethods();
    }

    public Iterator getMethods() {
        if (this.allMethods == null) {
            throw new CompilerError("getMethods: too early");
        }
        return this.allMethods.iterator();
    }

    protected void addMirandaMethods(Environment environment, Iterator iterator) {
    }

    public void inlineLocalClass(Environment environment) {
    }

    public void resolveTypeStructure(Environment environment) {
    }

    public Identifier resolveName(Environment environment, Identifier identifier) {
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveName(environment, identifier.getHead());
            if (identifier2.hasAmbigPrefix()) {
                return identifier2;
            }
            if (!environment.classExists(identifier2)) {
                return environment.resolvePackageQualifiedName(identifier);
            }
            try {
                return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        int n = -2;
        LocalMember localMember = null;
        if (this.classContext != null && (localMember = this.classContext.getLocalClass(identifier)) != null) {
            n = localMember.getScopeNumber();
        }
        ClassDefinition classDefinition = this;
        while (classDefinition != null) {
            try {
                MemberDefinition memberDefinition = classDefinition.getInnerClass(environment, identifier);
                if (memberDefinition != null && (localMember == null || this.classContext.getScopeNumber(classDefinition) > n)) {
                    return memberDefinition.getInnerClass().getName();
                }
            }
            catch (ClassNotFound classNotFound) {
                // empty catch block
            }
            classDefinition = classDefinition.outerClass;
        }
        if (localMember != null) {
            return localMember.getInnerClass().getName();
        }
        return environment.resolveName(identifier);
    }

    public Identifier resolveInnerClass(Environment environment, Identifier identifier) {
        if (identifier.isInner()) {
            throw new CompilerError("inner");
        }
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveInnerClass(environment, identifier.getHead());
            try {
                return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        try {
            MemberDefinition memberDefinition = this.getInnerClass(environment, identifier);
            if (memberDefinition != null) {
                return memberDefinition.getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        return Identifier.lookupInner(this.getName(), identifier);
    }

    public boolean innerClassExists(Identifier identifier) {
        for (MemberDefinition memberDefinition = this.getFirstMatch(identifier.getHead()); memberDefinition != null; memberDefinition = memberDefinition.getNextMatch()) {
            if (!memberDefinition.isInnerClass() || memberDefinition.getInnerClass().isLocal()) continue;
            return !identifier.isQualified() || memberDefinition.getInnerClass().innerClassExists(identifier.getTail());
        }
        return false;
    }

    public MemberDefinition findAnyMethod(Environment environment, Identifier identifier) throws ClassNotFound {
        for (MemberDefinition memberDefinition = this.getFirstMatch(identifier); memberDefinition != null; memberDefinition = memberDefinition.getNextMatch()) {
            if (!memberDefinition.isMethod()) continue;
            return memberDefinition;
        }
        ClassDeclaration classDeclaration = this.getSuperClass();
        if (classDeclaration == null) {
            return null;
        }
        return classDeclaration.getClassDefinition(environment).findAnyMethod(environment, identifier);
    }

    public int diagnoseMismatch(Environment environment, Identifier identifier, Type[] typeArray, int n, Type[] typeArray2) throws ClassNotFound {
        int[] nArray = new int[typeArray.length];
        Type[] typeArray3 = new Type[typeArray.length];
        if (!this.diagnoseMismatch(environment, identifier, typeArray, n, nArray, typeArray3)) {
            return -2;
        }
        for (int i = n; i < typeArray.length; ++i) {
            if (nArray[i] >= 4) continue;
            typeArray2[0] = typeArray3[i];
            return i << 2 | nArray[i];
        }
        return -1;
    }

    private boolean diagnoseMismatch(Environment environment, Identifier identifier, Type[] typeArray, int n, int[] nArray, Type[] typeArray2) throws ClassNotFound {
        Object object;
        boolean bl = false;
        for (MemberDefinition memberDefinition = this.getFirstMatch(identifier); memberDefinition != null; memberDefinition = memberDefinition.getNextMatch()) {
            if (!memberDefinition.isMethod() || ((Type[])(object = memberDefinition.getType().getArgumentTypes())).length != typeArray.length) continue;
            bl = true;
            for (int i = n; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                Object object2 = object[i];
                if (environment.implicitCast(type, (Type)object2)) {
                    nArray[i] = 4;
                    continue;
                }
                if (nArray[i] <= 2 && environment.explicitCast(type, (Type)object2)) {
                    if (nArray[i] < 2) {
                        typeArray2[i] = null;
                    }
                    nArray[i] = 2;
                } else if (nArray[i] > 0) continue;
                if (typeArray2[i] == null) {
                    typeArray2[i] = object2;
                    continue;
                }
                if (typeArray2[i] == object2) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] | 1;
            }
        }
        if (identifier.equals(idInit)) {
            return bl;
        }
        object = this.getSuperClass();
        if (object != null && ((ClassDeclaration)object).getClassDefinition(environment).diagnoseMismatch(environment, identifier, typeArray, n, nArray, typeArray2)) {
            bl = true;
        }
        return bl;
    }

    public void addMember(MemberDefinition memberDefinition) {
        if (this.firstMember == null) {
            this.firstMember = this.lastMember = memberDefinition;
        } else if (memberDefinition.isSynthetic() && memberDefinition.isFinal() && memberDefinition.isVariable()) {
            memberDefinition.nextMember = this.firstMember;
            this.firstMember = memberDefinition;
            memberDefinition.nextMatch = (MemberDefinition)this.fieldHash.get(memberDefinition.name);
        } else {
            this.lastMember.nextMember = memberDefinition;
            this.lastMember = memberDefinition;
            memberDefinition.nextMatch = (MemberDefinition)this.fieldHash.get(memberDefinition.name);
        }
        this.fieldHash.put(memberDefinition.name, memberDefinition);
    }

    public void addMember(Environment environment, MemberDefinition memberDefinition) {
        this.addMember(memberDefinition);
        if (this.resolved) {
            memberDefinition.resolveTypeStructure(environment);
        }
    }

    public UplevelReference getReference(LocalMember localMember) {
        for (UplevelReference uplevelReference = this.references; uplevelReference != null; uplevelReference = uplevelReference.getNext()) {
            if (uplevelReference.getTarget() != localMember) continue;
            return uplevelReference;
        }
        return this.addReference(localMember);
    }

    protected UplevelReference addReference(LocalMember localMember) {
        if (localMember.getClassDefinition() == this) {
            throw new CompilerError("addReference " + localMember);
        }
        this.referencesMustNotBeFrozen();
        UplevelReference uplevelReference = new UplevelReference(this, localMember);
        this.references = uplevelReference.insertInto(this.references);
        return uplevelReference;
    }

    public UplevelReference getReferences() {
        return this.references;
    }

    public UplevelReference getReferencesFrozen() {
        this.referencesFrozen = true;
        return this.references;
    }

    public final void referencesMustNotBeFrozen() {
        if (this.referencesFrozen) {
            throw new CompilerError("referencesMustNotBeFrozen " + this);
        }
    }

    public MemberDefinition getClassLiteralLookup(long l) {
        throw new CompilerError("binary class");
    }

    public void addDependency(ClassDeclaration classDeclaration) {
        throw new CompilerError("addDependency");
    }

    public ClassDefinition getLocalClass(String string) {
        if (this.localClasses == null) {
            return null;
        }
        return (ClassDefinition)this.localClasses.get(string);
    }

    public void addLocalClass(ClassDefinition classDefinition, String string) {
        if (this.localClasses == null) {
            this.localClasses = new Hashtable(31);
        }
        this.localClasses.put(string, classDefinition);
    }

    public void print(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isInterface()) {
            printStream.print("interface ");
        } else {
            printStream.print("class ");
        }
        printStream.print(this.getName() + " ");
        if (this.getSuperClass() != null) {
            printStream.print("extends " + this.getSuperClass().getName() + " ");
        }
        if (this.interfaces.length > 0) {
            printStream.print("implements ");
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i > 0) {
                    printStream.print(", ");
                }
                printStream.print(this.interfaces[i].getName());
                printStream.print(" ");
            }
        }
        printStream.println("{");
        for (MemberDefinition memberDefinition = this.getFirstMember(); memberDefinition != null; memberDefinition = memberDefinition.getNextMember()) {
            printStream.print("    ");
            memberDefinition.print(printStream);
        }
        printStream.println("}");
    }

    public String toString() {
        return this.getClassDeclaration().toString();
    }

    public void cleanup(Environment environment) {
        if (environment.dump()) {
            environment.output("[cleanup " + this.getName() + "]");
        }
        for (MemberDefinition memberDefinition = this.getFirstMember(); memberDefinition != null; memberDefinition = memberDefinition.getNextMember()) {
            memberDefinition.cleanup(environment);
        }
        this.documentation = null;
    }
}

