/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap.oldjavap;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.javap.oldjavap.JavaPClassPrinter;
import sun.tools.javap.oldjavap.JavaPEnvironment;
import sun.tools.util.ModifierFilter;

public class JavaP {
    private JavaPEnvironment env;
    private Vector classList = new Vector();
    private PrintWriter output;
    private static boolean errorOccurred = false;
    private static final String progname = "javap";

    public JavaP(PrintWriter printWriter) {
        this.output = printWriter;
        this.env = new JavaPEnvironment(printWriter);
    }

    private void error(String string) {
        errorOccurred = true;
        System.err.println(string);
        System.err.flush();
    }

    private void usage() {
        PrintStream printStream = System.out;
        printStream.println("Usage: javap <options> <classes>...");
        printStream.println();
        printStream.println("where options include:");
        printStream.println("   -b                        Backward compatibility with javap in JDK 1.1");
        printStream.println("   -c                        Disassemble the code");
        printStream.println("   -classpath <pathlist>     Specify where to find user class files");
        printStream.println("   -extdirs <dirs>           Override location of installed extensions");
        printStream.println("   -help                     Print this usage message");
        printStream.println("   -J<flag>                  Pass <flag> directly to the runtime system");
        printStream.println("   -l                        Print line number and local variable tables");
        printStream.println("   -public                   Show only public classes and members");
        printStream.println("   -protected                Show protected/public classes and members");
        printStream.println("   -package                  Show package/protected/public classes");
        printStream.println("                             and members (default)");
        printStream.println("   -private                  Show all classes and members");
        printStream.println("   -s                        Print internal type signatures");
        printStream.println("   -bootclasspath <pathlist> Override location of class files loaded");
        printStream.println("                             by the bootstrap class loader");
        printStream.println("   -verbose                  Print stack size, number of locals and args for methods");
        printStream.println("                             If verifying, print reasons for failure");
        printStream.println();
    }

    private boolean parseArguments(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.startsWith("-")) {
                if (string4.equals("-l")) {
                    this.env.showLineAndLocal = true;
                    continue;
                }
                if (string4.equals("-private") || string4.equals("-p")) {
                    this.env.showAccess = new ModifierFilter(-9223372036854775801L);
                    continue;
                }
                if (string4.equals("-package")) {
                    this.env.showAccess = new ModifierFilter(-9223372036854775803L);
                    continue;
                }
                if (string4.equals("-protected")) {
                    this.env.showAccess = new ModifierFilter(5L);
                    continue;
                }
                if (string4.equals("-public")) {
                    this.env.showAccess = new ModifierFilter(1L);
                    continue;
                }
                if (string4.equals("-b")) {
                    this.env.showBackwardCompatible = true;
                    continue;
                }
                if (string4.equals("-c")) {
                    this.env.showDisassembled = true;
                    continue;
                }
                if (string4.equals("-s")) {
                    this.env.showInternalSigs = true;
                    continue;
                }
                if (string4.equals("-verbose")) {
                    this.env.showVerbose = true;
                    continue;
                }
                if (string4.equals("-v")) {
                    this.env.showVerbose = true;
                    continue;
                }
                if (string4.equals("-h")) {
                    this.error("-h is no longer available - use the 'javah' program");
                    return false;
                }
                if (string4.equals("-verify")) {
                    this.error("-verify is no longer available - use 'java -verify'");
                    return false;
                }
                if (string4.equals("-verify-verbose")) {
                    this.error("-verify is no longer available - use 'java -verify'");
                    return false;
                }
                if (string4.equals("-help")) {
                    this.usage();
                    return false;
                }
                if (string4.equals("-classpath")) {
                    if (i + 1 < stringArray.length) {
                        string = stringArray[++i];
                        continue;
                    }
                    this.error("-classpath requires argument");
                    this.usage();
                    return false;
                }
                if (string4.equals("-bootclasspath")) {
                    if (i + 1 < stringArray.length) {
                        string2 = stringArray[++i];
                        continue;
                    }
                    this.error("-bootclasspath requires argument");
                    this.usage();
                    return false;
                }
                if (string4.equals("-extdirs")) {
                    if (i + 1 < stringArray.length) {
                        string3 = stringArray[++i];
                        continue;
                    }
                    this.error("-extdirs requires argument");
                    this.usage();
                    return false;
                }
                this.error("invalid flag: " + string4);
                this.usage();
                return false;
            }
            this.classList.addElement(string4);
            bl = false;
        }
        if (bl) {
            this.usage();
            return false;
        }
        this.env.setPath(string, string2, string3);
        return true;
    }

    private void displayResults() {
        for (int i = 0; i < this.classList.size(); ++i) {
            String string = (String)this.classList.elementAt(i);
            Identifier identifier = Identifier.lookup(string);
            if (!this.env.classExists(identifier = this.env.resolvePackageQualifiedName(identifier))) {
                this.error("Class '" + string + "' not found");
                continue;
            }
            try {
                BinaryClass binaryClass = (BinaryClass)this.env.getClassDefinition(identifier);
                binaryClass.loadNested(this.env);
                JavaPClassPrinter javaPClassPrinter = new JavaPClassPrinter(binaryClass, this.env);
                javaPClassPrinter.print();
                continue;
            }
            catch (ClassNotFound classNotFound) {
                this.error("Class '" + string + "' not found");
                if (!string.endsWith(".class")) continue;
                System.out.println("Note: Remember not to specify the .class extension");
                continue;
            }
            catch (IOException iOException) {
                this.error("I/O Exception - " + iOException.getMessage());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error(illegalArgumentException.getMessage());
            }
        }
    }

    private void perform(String[] stringArray) {
        if (this.parseArguments(stringArray)) {
            this.displayResults();
        }
    }

    public static void main(String[] stringArray) {
        JavaP.entry(stringArray);
        if (errorOccurred) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entry(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        try {
            printWriter.println("");
            printWriter.println("This utility can be used to reverse assemble code. Many program license");
            printWriter.println("agreements do not permit reverse assembly. If you are not the copyright");
            printWriter.println("owner of the code which you want to reverse assemble, please check the");
            printWriter.println("license agreement under which you acquired such code to confirm whether");
            printWriter.println("you are permitted to perform such reverse assembly.");
            printWriter.println("");
            printWriter.flush();
            JavaP javaP = new JavaP(printWriter);
            javaP.perform(stringArray);
        }
        finally {
            printWriter.close();
        }
    }
}

