/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sun.tools.javazic.Main;
import sun.tools.javazic.Time;
import sun.tools.javazic.Zone;
import sun.tools.javazic.ZoneRec;
import sun.tools.javazic.Zoneinfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Mappings {
    private Map<String, String> aliases = new TreeMap<String, String>();
    private List<Integer> rawOffsetsIndex = new LinkedList<Integer>();
    private List<Set<String>> rawOffsetsIndexTable = new LinkedList<Set<String>>();
    private List<String> excludeList;

    Mappings() {
    }

    void add(Zoneinfo zoneinfo) {
        String string;
        Map<String, Zone> map = zoneinfo.getZones();
        for (String object : map.keySet()) {
            int n;
            ZoneRec n2;
            Object object2 = map.get(object);
            string = ((Zone)object2).getName();
            int n3 = ((Zone)object2).get(((Zone)object2).size() - 1).getGmtOffset();
            if (((Zone)object2).size() > 1 && (n2 = ((Zone)object2).get(((Zone)object2).size() - 2)).getGmtOffset() != n3 && n2.getUntilTime(0) > Time.getCurrentTime()) {
                if (this.excludeList == null) {
                    this.excludeList = new ArrayList<String>();
                }
                this.excludeList.add(((Zone)object2).getName());
                continue;
            }
            if (!this.rawOffsetsIndex.contains(new Integer(n3))) {
                int set;
                n = this.rawOffsetsIndex.size();
                for (set = 0; set < n && this.rawOffsetsIndex.get(set) <= n3; ++set) {
                }
                this.rawOffsetsIndex.add(set, n3);
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.add(string);
                this.rawOffsetsIndexTable.add(set, treeSet);
                continue;
            }
            n = this.rawOffsetsIndex.indexOf(new Integer(n3));
            Set<String> set = this.rawOffsetsIndexTable.get(n);
            set.add(string);
        }
        Map<String, String> map2 = zoneinfo.getAliases();
        if (this.excludeList != null) {
            for (Object object2 : map2.keySet()) {
                string = (String)map2.get(object2);
                if (!this.excludeList.contains(string)) continue;
                this.excludeList.add((String)object2);
            }
        }
        this.aliases.putAll(map2);
    }

    void resolve() {
        int n = this.rawOffsetsIndexTable.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.aliases.keySet()) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                Set<String> set = this.rawOffsetsIndexTable.get(i);
                boolean bl3 = bl2 = this.excludeList == null ? false : this.excludeList.contains(string);
                if (!set.contains(this.aliases.get(string)) && !bl2 || !Zone.isTargetZone(string)) continue;
                bl = true;
                if (bl2) break;
                set.add(string);
                Main.info("Alias <" + string + "> added to the list.");
                break;
            }
            if (bl) continue;
            Main.info("Alias <" + string + "> removed from the list.");
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this.aliases.remove(string);
        }
    }

    Map<String, String> getAliases() {
        return this.aliases;
    }

    List<Integer> getRawOffsetsIndex() {
        return this.rawOffsetsIndex;
    }

    List<Set<String>> getRawOffsetsIndexTable() {
        return this.rawOffsetsIndexTable;
    }

    List<String> getExcludeList() {
        return this.excludeList;
    }
}

