/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.util.Locale;
import sun.tools.javazic.Main;
import sun.tools.javazic.Month;
import sun.tools.javazic.RuleDay;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.Gregorian;

class Time {
    static final Gregorian gcal = CalendarSystem.getGregorianCalendar();
    private static final int WALL = 1;
    private static final int STD = 2;
    private static final int UTC = 3;
    private int type;
    private long time;
    private static final long currentTime = System.currentTimeMillis();

    Time() {
        this.time = 0L;
    }

    Time(long l) {
        this.time = l;
    }

    void setType(int n) {
        this.type = n;
    }

    long getTime() {
        return this.time;
    }

    int getType() {
        return this.type;
    }

    static long getCurrentTime() {
        return currentTime;
    }

    boolean isWall() {
        return this.type == 1;
    }

    boolean isSTD() {
        return this.type == 2;
    }

    boolean isUTC() {
        return this.type == 3;
    }

    String getTypeForSimpleTimeZone() {
        String string = "SimpleTimeZone.";
        if (this.isWall()) {
            return string + "WALL_TIME";
        }
        if (this.isSTD()) {
            return string + "STANDARD_TIME";
        }
        if (this.isUTC()) {
            return string + "UTC_TIME";
        }
        return null;
    }

    static long getLocalTime(int n, Month month, RuleDay ruleDay, int n2, int n3, Time time) {
        long l = time.getTime();
        if (time.isSTD()) {
            l = time.getTime() + (long)n2;
        } else if (time.isUTC()) {
            l = time.getTime() + (long)n2 + (long)n3;
        }
        return Time.getLocalTime(n, month, ruleDay, l);
    }

    static long getLocalTime(int n, Month month, int n2, long l) {
        CalendarDate calendarDate = gcal.newCalendarDate(null);
        calendarDate.setDate(n, month.value(), n2);
        long l2 = gcal.getTime(calendarDate);
        return l2 + l;
    }

    static long getLocalTime(int n, Month month, int n2, int n3) {
        return Time.getLocalTime(n, month, n2, (long)n3);
    }

    static long getLocalTime(int n, Month month, RuleDay ruleDay, long l) {
        return Time.getLocalTime(n, month, ruleDay, (int)l);
    }

    static long getLocalTime(int n, Month month, RuleDay ruleDay, int n2) {
        CalendarDate calendarDate = gcal.newCalendarDate(null);
        int n3 = month.value();
        if (ruleDay.isLast()) {
            calendarDate.setDate(n, n3, 1);
            calendarDate.setDayOfMonth(gcal.getMonthLength(calendarDate));
            calendarDate = gcal.getNthDayOfWeek(-1, ruleDay.getDayOfWeekNum(), calendarDate);
        } else if (ruleDay.isLater()) {
            calendarDate.setDate(n, n3, ruleDay.getDay());
            calendarDate = gcal.getNthDayOfWeek(1, ruleDay.getDayOfWeekNum(), calendarDate);
        } else if (ruleDay.isExact()) {
            calendarDate.setDate(n, n3, ruleDay.getDay());
        } else if (ruleDay.isEarlier()) {
            calendarDate.setDate(n, n3, ruleDay.getDay());
            calendarDate = gcal.getNthDayOfWeek(-1, ruleDay.getDayOfWeekNum(), calendarDate);
        } else {
            Main.panic("invalid day type: " + ruleDay);
        }
        return gcal.getTime(calendarDate) + (long)n2;
    }

    static Time parse(String string) {
        char c;
        int n;
        int n2 = 0;
        if (string.charAt(0) == '-') {
            n = -1;
            ++n2;
        } else {
            n = 1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n2 < string.length()) {
            if ((c = string.charAt(n2++)) == ':') {
                n3 = n3 * 60 + n4;
                ++n5;
                n4 = 0;
                continue;
            }
            int n6 = Character.digit(c, 10);
            if (n6 == -1) {
                --n2;
                break;
            }
            n4 = n4 * 10 + n6;
        }
        n3 = n3 * 60 + n4;
        while (n5 < 2) {
            n3 *= 60;
            ++n5;
        }
        Time time = new Time((long)n3 * 1000L * (long)n);
        if (n2 < string.length()) {
            if ((c = string.charAt(n2++)) == 's') {
                time.setType(2);
            } else if (c == 'u' || c == 'g' || c == 'z') {
                time.setType(3);
            } else if (c == 'w') {
                time.setType(1);
            } else {
                Main.panic("unknown time mode: " + c);
            }
        } else {
            time.setType(1);
        }
        return time;
    }

    static String toGMTFormat(String string) {
        char c;
        long l = Long.parseLong(string) / 1000L;
        if (l < 0L) {
            c = '-';
            l = -l;
        } else {
            c = '+';
        }
        return String.format((Locale)null, "%c%02d:%02d", Character.valueOf(c), l / 3600L, l % 3600L / 60L);
    }

    static String toFormedString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (n < 0) {
            stringBuilder.append("-");
            bl = true;
            n = -n;
        } else if (n == 0) {
            return "0";
        }
        int n2 = n / 3600000;
        int n3 = (n %= 3600000) / 60000;
        if (n2 != 0) {
            if (bl && n3 != 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(Integer.toString(n2) + "*ONE_HOUR");
        }
        if (n3 != 0) {
            if (n2 != 0) {
                stringBuilder.append("+");
            }
            stringBuilder.append(Integer.toString(n3) + "*ONE_MINUTE");
            if (bl && n2 != 0) {
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }
}

