/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import sun.management.ConnectorAddressLink;
import sun.tools.jconsole.ConnectDialog;
import sun.tools.jconsole.ConnectionParameters;
import sun.tools.jconsole.CreateMBeanDialog;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.VMInternalFrame;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JConsole
extends JFrame
implements ActionListener,
InternalFrameListener {
    private static final String title = Resources.getText("J2SE 5.0 Monitoring & Management Console", new Object[0]);
    public static final String ROOT_URL = "service:jmx:";
    private static int updateInterval = 4000;
    private boolean mdiCreated = false;
    private JMenuBar menuBar;
    private JMenuItem hotspotMI;
    private JMenuItem connectMI;
    private JMenuItem exitMI;
    private JMenu windowMenu;
    private JMenuItem tileMI;
    private JMenuItem cascadeMI;
    private JMenuItem minimizeAllMI;
    private JMenuItem restoreAllMI;
    private JToolBar toolBar;
    private JButton connectButton;
    private JDesktopPane desktop;
    private JPanel statusPanel;
    private JLabel statusLabel;
    private JDialog connectDialog;
    private CreateMBeanDialog createDialog;
    private ArrayList<VMInternalFrame> windows = new ArrayList();
    private int frameLoc = 5;
    String verboseException = System.getProperty("com.ibm.jconsole.verbose");

    public JConsole(boolean bl) {
        super(title);
        this.setDefaultCloseOperation(3);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(Resources.getText("Connection", new Object[0]));
        jMenu.setMnemonic(67);
        this.menuBar.add(jMenu);
        if (bl) {
            this.hotspotMI = new JMenuItem("Hotspot MBeans...");
            this.hotspotMI.setAccelerator(KeyStroke.getKeyStroke(72, 2));
            this.hotspotMI.setMnemonic(72);
            this.hotspotMI.addActionListener(this);
            jMenu.add(this.hotspotMI);
            jMenu.addSeparator();
        }
        this.connectMI = new JMenuItem(Resources.getText("New Connection...", new Object[0]));
        this.connectMI.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.connectMI.setMnemonic(78);
        this.connectMI.addActionListener(this);
        jMenu.add(this.connectMI);
        jMenu.addSeparator();
        this.exitMI = new JMenuItem(Resources.getText("Exit", new Object[0]));
        this.exitMI.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.exitMI.setMnemonic(88);
        this.exitMI.addActionListener(this);
        jMenu.add(this.exitMI);
        JToolBar jToolBar = new JToolBar();
        this.connectButton = new JButton(Resources.getText("Connect...", new Object[0]));
        this.connectButton.addActionListener(this);
        jToolBar.add(this.connectButton);
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.statusPanel.add(this.statusLabel);
        Container container = this.getContentPane();
        container.add((Component)this.statusPanel, "South");
    }

    public List<VMInternalFrame> getInternalFrames() {
        return this.windows;
    }

    private void createMDI() {
        this.setTitle(title);
        Container container = this.getContentPane();
        Component component = ((BorderLayout)container.getLayout()).getLayoutComponent("Center");
        this.windowMenu = new JMenu(Resources.getText("Window", new Object[0]));
        this.menuBar.add(this.windowMenu);
        this.cascadeMI = new JMenuItem(Resources.getText("Cascade", new Object[0]));
        this.cascadeMI.addActionListener(this);
        this.windowMenu.add(this.cascadeMI);
        this.tileMI = new JMenuItem(Resources.getText("Tile", new Object[0]));
        this.tileMI.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.tileMI.addActionListener(this);
        this.windowMenu.add(this.tileMI);
        this.minimizeAllMI = new JMenuItem(Resources.getText("Minimize All", new Object[0]));
        this.minimizeAllMI.addActionListener(this);
        this.windowMenu.add(this.minimizeAllMI);
        this.restoreAllMI = new JMenuItem(Resources.getText("Restore All", new Object[0]));
        this.restoreAllMI.addActionListener(this);
        this.windowMenu.add(this.restoreAllMI);
        this.windowMenu.addSeparator();
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(new Color(235, 245, 255));
        container.add((Component)this.desktop, "Center");
        if (component instanceof VMPanel) {
            this.addFrame((VMPanel)component);
        }
        this.mdiCreated = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem;
        VMInternalFrame vMInternalFrame;
        Object object = actionEvent.getSource();
        if (object == this.hotspotMI) {
            this.showCreateMBeanDialog();
        }
        if (object == this.connectButton || object == this.connectMI) {
            Object object2;
            VMPanel vMPanel = null;
            if (this.mdiCreated) {
                object2 = this.desktop.getSelectedFrame();
                if (object2 instanceof VMInternalFrame) {
                    vMPanel = ((VMInternalFrame)object2).getVMPanel();
                }
            } else {
                object2 = (BorderLayout)this.getContentPane().getLayout();
                vMPanel = (VMPanel)((BorderLayout)object2).getLayoutComponent("Center");
            }
            object2 = "";
            String string = "";
            if (vMPanel != null) {
                object2 = vMPanel.getHostName();
                if (vMPanel.getUrl() != null) {
                    string = vMPanel.getUrl();
                }
            }
            this.showConnectDialog(string, (String)object2, 0, null, null, null);
        } else if (object == this.tileMI) {
            this.tileWindows();
        } else if (object == this.cascadeMI) {
            this.cascadeWindows();
        } else if (object == this.minimizeAllMI) {
            for (VMInternalFrame vMInternalFrame2 : this.windows) {
                try {
                    vMInternalFrame2.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else if (object == this.restoreAllMI) {
            for (VMInternalFrame vMInternalFrame3 : this.windows) {
                try {
                    vMInternalFrame3.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else if (object == this.exitMI) {
            System.exit(0);
        } else if (object instanceof JMenuItem && (vMInternalFrame = (VMInternalFrame)(jMenuItem = (JMenuItem)object).getClientProperty("JConsole.vmIF")) != null) {
            try {
                vMInternalFrame.setIcon(false);
                vMInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            vMInternalFrame.moveToFront();
        }
    }

    void vmPanelDied(VMPanel vMPanel) {
        block2: {
            block1: {
                if (this.windows.size() != 0) break block1;
                JComponent jComponent = (JComponent)this.getContentPane();
                Component component = ((BorderLayout)jComponent.getLayout()).getLayoutComponent("Center");
                if (component != vMPanel) break block2;
                jComponent.remove(vMPanel);
                jComponent.repaint();
                break block2;
            }
            Iterator<VMInternalFrame> iterator = this.windows.iterator();
            while (iterator.hasNext()) {
                VMInternalFrame vMInternalFrame = iterator.next();
                VMPanel vMPanel2 = vMInternalFrame.getVMPanel();
                if (vMPanel2 != vMPanel) continue;
                this.removeVMInternalFrame(vMInternalFrame);
                iterator.remove();
                break;
            }
        }
        this.showConnectDialog(vMPanel.getUrl(), vMPanel.getHostName(), vMPanel.getPort(), vMPanel.getUserName(), vMPanel.getPassword(), null);
    }

    public void tileWindows() {
        if (!this.mdiCreated) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        for (VMInternalFrame vMInternalFrame : this.windows) {
            if (vMInternalFrame.isIcon()) continue;
            ++n3;
            if (n != -1) continue;
            try {
                vMInternalFrame.setMaximum(true);
                n = vMInternalFrame.getWidth();
                n2 = vMInternalFrame.getHeight();
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if (n3 > 0 && n > 0 && n2 > 0) {
            int n4;
            int n5 = (int)Math.ceil(Math.sqrt(n3));
            if (n5 * (n4 = n3 / n5) < n3) {
                ++n4;
            }
            int n6 = 0;
            int n7 = 0;
            n /= n4;
            n2 /= n5;
            int n8 = 0;
            for (VMInternalFrame vMInternalFrame : this.windows) {
                if (vMInternalFrame.isIcon()) continue;
                try {
                    vMInternalFrame.setMaximum(n3 == 1);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (n3 > 1) {
                    vMInternalFrame.setBounds(n6, n7, n, n2);
                }
                if (n8 < n4 - 1) {
                    ++n8;
                    n6 += n;
                    continue;
                }
                n8 = 0;
                n6 = 0;
                n7 += n2;
            }
        }
    }

    public void cascadeWindows() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (VMInternalFrame vMInternalFrame : this.windows) {
            if (vMInternalFrame.isIcon()) continue;
            try {
                vMInternalFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++n;
            vMInternalFrame.pack();
            if (n2 != -1) continue;
            try {
                n2 = vMInternalFrame.getWidth();
                n3 = vMInternalFrame.getHeight();
                vMInternalFrame.setMaximum(true);
                n2 = vMInternalFrame.getWidth() - n2;
                n3 = vMInternalFrame.getHeight() - n3;
                vMInternalFrame.pack();
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = n > 1 ? n2 / (n - 1) : 0;
        int n7 = n > 1 ? n3 / (n - 1) : 0;
        for (VMInternalFrame vMInternalFrame : this.windows) {
            if (vMInternalFrame.isIcon()) continue;
            vMInternalFrame.setLocation(n4, n5);
            vMInternalFrame.moveToFront();
            n4 += n6;
            n5 += n7;
        }
    }

    void addHost(String string, int n, String string2, String string3) {
        this.addHost(string, n, string2, string3, false);
    }

    void addVmid(int n, ProxyClient proxyClient) {
        this.addVmid(n, proxyClient, false);
    }

    void addVmid(int n, final ProxyClient proxyClient, final boolean bl) {
        new Thread("JConsole.addVmid"){

            public void run() {
                try {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                JConsole.this.addFrame(proxyClient);
                            }
                        });
                        if (bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JConsole.this.tileWindows();
                                }
                            });
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (JConsole.this.verboseException != null) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (SecurityException securityException) {
                    this.failed(securityException);
                }
            }

            private void failed(final Exception exception) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = exception instanceof IOException ? Resources.getText("Connection failed", new Object[0]) : exception.getMessage();
                        System.err.println(string);
                    }
                });
            }
        }.start();
    }

    void addUrl(final JMXServiceURL jMXServiceURL, final Map map, final String string, final String string2, final boolean bl) {
        new Thread("JConsole.addUrl"){

            public void run() {
                try {
                    final ProxyClient proxyClient = ProxyClient.getProxyClient(jMXServiceURL, map);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                JConsole.this.addFrame(proxyClient);
                            }
                        });
                        if (bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JConsole.this.tileWindows();
                                }
                            });
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (JConsole.this.verboseException != null) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (SecurityException securityException) {
                    this.failed(securityException);
                }
                catch (IOException iOException) {
                    this.failed(iOException);
                }
            }

            private void failed(final Exception exception) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = exception instanceof IOException ? Resources.getText("Connection failed", new Object[0]) : exception.getMessage();
                        JConsole.this.showConnectDialog(jMXServiceURL.toString(), null, -1, string, string2, string);
                    }
                });
            }
        }.start();
    }

    void addHost(final String string, final int n, final String string2, final String string3, final boolean bl) {
        new Thread("JConsole.addHost"){

            public void run() {
                try {
                    final ProxyClient proxyClient = ProxyClient.getProxyClient(string, n, string2 != null ? string2 : "", string3 != null ? string3 : "");
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                JConsole.this.addFrame(proxyClient);
                            }
                        });
                        if (bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JConsole.this.tileWindows();
                                }
                            });
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (JConsole.this.verboseException != null) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (SecurityException securityException) {
                    this.failed(securityException);
                }
                catch (IOException iOException) {
                    this.failed(iOException);
                }
            }

            private void failed(final Exception exception) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = exception instanceof IOException ? Resources.getText("Connection failed", new Object[0]) : exception.getMessage();
                        JConsole.this.showConnectDialog(null, string, n, string2, string3, string);
                    }
                });
            }
        }.start();
    }

    private void addFrame(ProxyClient proxyClient) {
        VMPanel vMPanel = new VMPanel(proxyClient, updateInterval);
        if (!this.mdiCreated) {
            JComponent jComponent = (JComponent)this.getContentPane();
            if (((BorderLayout)jComponent.getLayout()).getLayoutComponent("Center") == null) {
                String string = vMPanel.getConnectionName();
                if (string.equals("localhost:0")) {
                    string = Resources.getText("Monitoring Self", string);
                }
                this.setTitle(title + ": " + string);
                jComponent.add((Component)vMPanel, "Center");
                jComponent.revalidate();
                return;
            }
            this.createMDI();
        }
        this.addFrame(vMPanel);
    }

    private void addFrame(VMPanel vMPanel) {
        VMInternalFrame vMInternalFrame = new VMInternalFrame(vMPanel);
        for (VMInternalFrame vMInternalFrame2 : this.windows) {
            try {
                vMInternalFrame2.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.desktop.add(vMInternalFrame);
        vMInternalFrame.setLocation(this.frameLoc, this.frameLoc);
        this.frameLoc += 30;
        vMInternalFrame.setVisible(true);
        this.windows.add(vMInternalFrame);
        if (this.windows.size() == 1) {
            try {
                vMInternalFrame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        vMInternalFrame.addInternalFrameListener(this);
        JMenuItem jMenuItem = new JMenuItem(vMPanel.getConnectionName());
        jMenuItem.putClientProperty("JConsole.vmIF", vMInternalFrame);
        jMenuItem.addActionListener(this);
        vMInternalFrame.putClientProperty("JConsole.menuItem", jMenuItem);
        this.windowMenu.add(jMenuItem);
    }

    private void showConnectDialog(String string, String string2, int n, String string3, String string4, String string5) {
        if (this.connectDialog == null) {
            this.connectDialog = new ConnectDialog(this);
            this.statusLabel.setText("");
        }
        ((ConnectDialog)this.connectDialog).setConnectionParameters(string, string2, n, string3, string4, string5);
        ((ConnectDialog)this.connectDialog).refresh();
        this.connectDialog.setVisible(true);
    }

    private void showCreateMBeanDialog() {
        if (this.createDialog == null) {
            this.createDialog = new CreateMBeanDialog(this);
        }
        this.statusLabel.setText("");
        this.createDialog.setVisible(true);
    }

    private void removeVMInternalFrame(VMInternalFrame vMInternalFrame) {
        JMenuItem jMenuItem = (JMenuItem)vMInternalFrame.getClientProperty("JConsole.menuItem");
        this.windowMenu.remove(jMenuItem);
        jMenuItem.putClientProperty("JConsole.vmIF", null);
        vMInternalFrame.putClientProperty("JConsole.menuItem", null);
        this.desktop.remove(vMInternalFrame);
        this.desktop.repaint();
        vMInternalFrame.getVMPanel().disconnect();
        vMInternalFrame.dispose();
    }

    private boolean isProxyClientUsed(ProxyClient proxyClient) {
        for (VMInternalFrame vMInternalFrame : this.windows) {
            ProxyClient proxyClient2 = vMInternalFrame.getVMPanel().getProxyClient(false);
            if (proxyClient != proxyClient2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        VMInternalFrame vMInternalFrame = (VMInternalFrame)internalFrameEvent.getInternalFrame();
        this.removeVMInternalFrame(vMInternalFrame);
        this.windows.remove(vMInternalFrame);
        ProxyClient proxyClient = vMInternalFrame.getVMPanel().getProxyClient(false);
        if (!this.isProxyClientUsed(proxyClient)) {
            proxyClient.markAsDead();
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    void setTabTransparency(boolean bl) {
        if (this.mdiCreated) {
            for (VMInternalFrame vMInternalFrame : this.windows) {
                vMInternalFrame.getVMPanel().setTransparency(bl);
            }
        } else {
            BorderLayout borderLayout = (BorderLayout)this.getContentPane().getLayout();
            VMPanel vMPanel = (VMPanel)borderLayout.getLayoutComponent("Center");
            if (vMPanel != null) {
                vMPanel.setTransparency(bl);
            }
        }
    }

    private static void usage() {
        System.err.println(Resources.getText("zz usage text", "jconsole"));
        System.exit(1);
    }

    private static void pidNotSupported() {
        System.err.println();
        System.err.println(Resources.getText("The pid option is not supported", "jconsole"));
        System.exit(1);
    }

    private static void mainInit(final List<ConnectionParameters> list, final List<String> list2, final List<Integer> list3, final int n, final ProxyClient proxyClient, final boolean bl, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n2;
                JConsole jConsole = new JConsole(bl2);
                jConsole.setSize(900, 750);
                jConsole.setLocationRelativeTo(null);
                jConsole.setVisible(true);
                if (list2 != null && list2.size() > 1 || list != null && list.size() > 1) {
                    jConsole.createMDI();
                }
                if (list2 != null) {
                    for (n2 = 0; n2 < list2.size(); ++n2) {
                        jConsole.addHost((String)list2.get(n2), (Integer)list3.get(n2), null, null, n2 == list2.size() - 1 ? !bl : false);
                    }
                }
                if (list != null) {
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        ConnectionParameters connectionParameters = (ConnectionParameters)list.get(n2);
                        jConsole.addUrl(connectionParameters.jmxUrl, connectionParameters.map, null, null, n2 == list.size() - 1 ? !bl : false);
                    }
                }
                if (n >= 0) {
                    assert (proxyClient != null);
                    jConsole.addVmid(n, proxyClient, !bl);
                }
                if (n < 0 && list2 == null && list == null) {
                    jConsole.showConnectDialog(null, "localhost", 0, null, null, null);
                }
            }
        });
    }

    static ConnectionParameters createParameters(JMXServiceURL jMXServiceURL) throws Exception {
        ConnectionParameters connectionParameters = new ConnectionParameters();
        connectionParameters.jmxUrl = jMXServiceURL;
        connectionParameters.map = null;
        return connectionParameters;
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = -1;
        ProxyClient proxyClient = null;
        while (stringArray.length - n > 0 && stringArray[n].startsWith("-")) {
            if (((String)(object = stringArray[n++])).equals("-h") || ((String)object).equals("-help") || ((String)object).equals("-?")) {
                JConsole.usage();
                continue;
            }
            if (((String)object).startsWith("-interval=")) {
                try {
                    updateInterval = Integer.parseInt(((String)object).substring(10)) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    JConsole.usage();
                }
                continue;
            }
            if (((String)object).equals("-notile")) {
                bl = true;
                continue;
            }
            if (((String)object).equals("-version")) {
                Version.print(System.err);
                System.exit(0);
                continue;
            }
            if (((String)object).equals("-fullversion")) {
                Version.printFullVersion(System.err);
                System.exit(0);
                continue;
            }
            if (((String)object).equals("-hotspot")) {
                bl2 = true;
                continue;
            }
            JConsole.usage();
        }
        object = null;
        ArrayList<String> arrayList = null;
        ArrayList<Integer> arrayList2 = null;
        int n3 = stringArray.length - n;
        if (n3 == 1) {
            try {
                n2 = Integer.parseInt(stringArray[n]);
                n3 = 0;
                try {
                    String string = ConnectorAddressLink.importFrom((int)n2);
                    if (string == null) {
                        System.err.println(n2 + " is not a managed VM.");
                        System.exit(1);
                    }
                    proxyClient = ProxyClient.getProxyClient(n2, string);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to attach to " + n2 + ": " + iOException.getMessage());
                    System.exit(1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    JConsole.pidNotSupported();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    JConsole.pidNotSupported();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n3 > 0) {
            arrayList = new ArrayList<String>();
            arrayList2 = new ArrayList<Integer>();
            object = new ArrayList();
            int n4 = stringArray.length - n;
            for (int i = 0; i < n4; ++i) {
                String string = stringArray[n + i];
                try {
                    JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
                    ((ArrayList)object).add(JConsole.createParameters(jMXServiceURL));
                    continue;
                }
                catch (Exception exception) {
                    int n5 = string.indexOf(58);
                    if (n5 > 0) {
                        arrayList.add(string.substring(0, n5));
                        try {
                            arrayList2.add(Integer.parseInt(string.substring(n5 + 1)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            JConsole.usage();
                        }
                        continue;
                    }
                    JConsole.usage();
                }
            }
        }
        JConsole.mainInit((List<ConnectionParameters>)object, arrayList, arrayList2, n2, proxyClient, bl, bl2);
    }
}

