/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import sun.tools.jconsole.BorderedComponent;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.Resources;

public class Plotter
extends JComponent
implements ActionListener {
    static final String[] rangeNames = new String[]{Resources.getText(" 1 min", new Object[0]), Resources.getText(" 5 min", new Object[0]), Resources.getText("10 min", new Object[0]), Resources.getText("30 min", new Object[0]), Resources.getText(" 1 hour", new Object[0]), Resources.getText(" 2 hours", new Object[0]), Resources.getText(" 3 hours", new Object[0]), Resources.getText(" 6 hours", new Object[0]), Resources.getText("12 hours", new Object[0]), Resources.getText(" 1 day", new Object[0]), Resources.getText(" 7 days", new Object[0]), Resources.getText(" 1 month", new Object[0]), Resources.getText(" 3 months", new Object[0]), Resources.getText(" 6 months", new Object[0]), Resources.getText(" 1 year", new Object[0]), Resources.getText("All", new Object[0])};
    static final int[] rangeValues = new int[]{1, 5, 10, 30, 60, 120, 180, 360, 720, 1440, 10080, 44640, 133920, 267840, 527040, -1};
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final Color bgColor = new Color(250, 250, 250);
    static final Color defaultColor = Color.blue.darker();
    private ArrayList<Sequence> seqs = new ArrayList();
    private JPopupMenu popupMenu;
    private JRadioButtonMenuItem[] menuRBs;
    private int viewRange = -1;
    private boolean unitsBytes;
    private Border border = null;
    private Rectangle r = new Rectangle(1, 1, 1, 1);
    private Font smallFont = null;
    private int topMargin = 10;
    private int bottomMargin = 45;
    private int leftMargin = 65;
    private int rightMargin = 70;
    private static final String decimalZero = new DecimalFormatSymbols().getDecimalSeparator() + "0";

    public Plotter(boolean bl) {
        this.unitsBytes = bl;
        this.enableEvents(16L);
    }

    public void createSequence(String string, String string2, Color color, boolean bl) {
        Sequence sequence = this.getSequence(string);
        if (sequence == null) {
            sequence = new Sequence(string);
        }
        sequence.name = string2;
        sequence.color = color != null ? color : defaultColor;
        sequence.isPlotted = bl;
        this.seqs.add(sequence);
    }

    public void setIsPlotted(String string, boolean bl) {
        Sequence sequence = this.getSequence(string);
        if (sequence != null) {
            sequence.isPlotted = bl;
        }
    }

    public void addValue(String string, long l) {
        this.addValue(string, System.currentTimeMillis(), l);
    }

    public void addValue(String string, long l, long l2) {
        Sequence sequence = this.getSequence(string);
        if (sequence != null) {
            sequence.add(l, l2);
            this.repaint();
        }
    }

    private Sequence getSequence(String string) {
        for (Sequence sequence : this.seqs) {
            if (!sequence.key.equals(string)) continue;
            return sequence;
        }
        return null;
    }

    public int getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(int n) {
        if (n != this.viewRange) {
            int n2 = this.viewRange;
            this.viewRange = n;
            this.firePropertyChange("viewRange", n2, this.viewRange);
            if (this.popupMenu != null) {
                for (int i = 0; i < this.menuRBs.length; ++i) {
                    if (rangeValues[i] != this.viewRange) continue;
                    this.menuRBs[i].setSelected(true);
                    break;
                }
            }
            this.repaint();
        }
    }

    public JPopupMenu getComponentPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu(Resources.getText("Time Range:", new Object[0]));
            this.menuRBs = new JRadioButtonMenuItem[rangeNames.length];
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < rangeNames.length; ++i) {
                this.menuRBs[i] = new JRadioButtonMenuItem(rangeNames[i]);
                buttonGroup.add(this.menuRBs[i]);
                this.menuRBs[i].addActionListener(this);
                if (this.viewRange == rangeValues[i]) {
                    this.menuRBs[i].setSelected(true);
                }
                this.popupMenu.add(this.menuRBs[i]);
            }
        }
        return this.popupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.popupMenu.getComponentIndex((JComponent)actionEvent.getSource());
        this.setViewRange(rangeValues[n]);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        Serializable serializable;
        super.paintComponent(graphics);
        Container container = this.getParent();
        if (container instanceof BorderedComponent && (serializable = ((BorderedComponent)container).moreOrLessButton) != null) {
            ((JButton)serializable).getAccessibleContext().setAccessibleName("Number of Threads toggle");
            ((JComponent)serializable).setToolTipText("Toggle Number of Threads Display");
            this.rightMargin = Math.max(this.rightMargin, ((JComponent)serializable).getWidth());
        }
        serializable = graphics.getColor();
        Font font = graphics.getFont();
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.smallFont == null) {
            this.smallFont = font.deriveFont(9.0f);
        }
        this.r.x = this.leftMargin - 5;
        this.r.y = this.topMargin - 8;
        this.r.width = this.getWidth() - this.leftMargin - this.rightMargin;
        this.r.height = this.getHeight() - this.topMargin - this.bottomMargin + 16;
        if (this.border == null) {
            this.border = new BevelBorder(1, this.getBackground().brighter().brighter(), this.getBackground().brighter(), this.getBackground().darker().darker(), this.getBackground().darker());
        }
        this.border.paintBorder(this, graphics, this.r.x, this.r.y, this.r.width, this.r.height);
        graphics.setColor(bgColor);
        graphics.fillRect(this.r.x + 2, this.r.y + 2, this.r.width - 4, this.r.height - 4);
        graphics.setColor((Color)serializable);
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = 1L;
        int n6 = this.getWidth() - this.rightMargin - this.leftMargin - 10;
        int n7 = this.getHeight() - this.topMargin - this.bottomMargin;
        for (Sequence sequence : this.seqs) {
            if (sequence.size <= 1) continue;
            l = Math.min(l, sequence.times[0]);
            l2 = Math.max(l2, sequence.times[sequence.size - 1]);
        }
        long l5 = this.viewRange > 0 ? (long)this.viewRange * 60000L : l2 - l;
        for (Sequence sequence : this.seqs) {
            if (sequence.size > 0) {
                for (int i = 0; i < sequence.size; ++i) {
                    if (sequence.size != 1 && sequence.times[i] < l2 - l5) continue;
                    l4 = Math.max(l4, sequence.values[i]);
                    l3 = Math.min(l3, sequence.values[i]);
                }
            } else {
                l3 = 0L;
            }
            if (!this.unitsBytes && sequence.isPlotted) continue;
            break;
        }
        l4 = this.normalizeMax(l4);
        if (l3 > 0L) {
            l3 = l4 / l3 > 4L ? 0L : this.normalizeMin(l3);
        }
        graphics.setColor(Color.black);
        int n8 = this.leftMargin - 18;
        int n9 = this.topMargin;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getSizeString(l3, l4);
        String string2 = this.getSizeString(l4, l4);
        int n10 = n8 - 6 - fontMetrics.stringWidth(string);
        int n11 = n8 - 6 - fontMetrics.stringWidth(string2);
        if (this.checkLeftMargin(n10) || this.checkLeftMargin(n11)) {
            return;
        }
        graphics.drawString(string2, n11, n9 + 4);
        graphics.drawString(string, n10, n9 + n7 + 4);
        graphics.drawLine(n8, n9, n8, n9 + n7);
        graphics.drawLine(n8 - 5, n9, n8 + 5, n9);
        graphics.drawLine(n8 - 5, n9 + n7, n8 + 5, n9 + n7);
        int n12 = 5;
        if (("" + l4).startsWith("2")) {
            n12 = 4;
        } else if (("" + l4).startsWith("3")) {
            n12 = 6;
        } else if (("" + l4).startsWith("4")) {
            n12 = 4;
        } else if (("" + l4).startsWith("6")) {
            n12 = 6;
        } else if (("" + l4).startsWith("7")) {
            n12 = 7;
        } else if (("" + l4).startsWith("8")) {
            n12 = 8;
        } else if (("" + l4).startsWith("9")) {
            n12 = 3;
        }
        for (int i = 0; i < n12; ++i) {
            long l6 = (long)i * l4 / (long)n12;
            if (l6 <= l3) continue;
            n9 = this.topMargin + n7 - (int)((long)n7 * (l6 - l3) / (l4 - l3));
            graphics.drawLine(n8 - 2, n9, n8 + 2, n9);
            object = this.getSizeString(l6, l4);
            int n13 = n8 - 6 - fontMetrics.stringWidth((String)object);
            if (n9 < this.topMargin + n7 - 13) {
                if (this.checkLeftMargin(n13)) {
                    return;
                }
                graphics.drawString((String)object, n13, n9 + 4);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.r.x + 4, n9, this.r.x + this.r.width - 4, n9);
            graphics.setColor(Color.black);
        }
        n8 = this.leftMargin;
        n9 = this.topMargin + n7 + 15;
        graphics.drawLine(n8, n9, n8 + n6, n9);
        if (l2 > 0L) {
            long l7 = Formatter.timeDF.getTimeZone().getOffset(l2);
            long l8 = this.calculateTickInterval(n6, 40, l5);
            if (l8 > 10800000L) {
                l8 = this.calculateTickInterval(n6, 80, l5);
            }
            for (long i = l8 - (l2 - l5 + l7) % l8; i < l5; i += l8) {
                n8 = this.leftMargin + (int)((long)n6 * i / l5);
                graphics.drawLine(n8, n9 - 2, n8, n9 + 2);
                long l9 = l2 - l5 + i;
                String string3 = Formatter.formatClockTime(l9);
                graphics.drawString(string3, n8, n9 + 16);
                if ((l9 + l7) % 86400000L == 0L) {
                    string3 = Formatter.formatDate(l9);
                    graphics.drawString(string3, n8, n9 + 27);
                }
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n8, this.topMargin, n8, this.topMargin + n7);
                graphics.setColor(Color.black);
            }
        }
        int n14 = 0;
        n10 = 0;
        n11 = this.seqs.size();
        if (n11 > 0) {
            n10 = this.seqs.get((int)0).size;
        }
        if (n10 == 0) {
            graphics.setColor((Color)serializable);
            return;
        }
        object = this.seqs.get(0);
        for (n5 = 0; n5 < ((Sequence)object).size; ++n5) {
            if (((Sequence)object).times[n5] < l2 - l5) continue;
            n14 = n5;
            break;
        }
        if ((n4 = (n10 - n14) / n6) < 4) {
            n4 = 1;
        }
        for (n5 = n11 - 1; n5 >= 0; --n5) {
            n3 = this.leftMargin;
            int n15 = this.topMargin + n7 + 1;
            Sequence sequence = this.seqs.get(n5);
            if (!sequence.isPlotted || sequence.size <= 0) continue;
            for (int i = 0; i < 2; ++i) {
                graphics.setColor(i == 0 ? Color.white : sequence.color);
                n2 = -1;
                long l10 = -1L;
                for (int j = n14; j < n10; j += n4) {
                    if (n4 > 1 && j >= n10 - n4) {
                        j = n10 - 1;
                    }
                    n = l5 == 0L ? 0 : (int)((long)n6 * (sequence.times[j] - (l2 - l5)) / l5);
                    long l11 = sequence.values[j];
                    if (l11 >= l3 && l11 <= l4) {
                        int n16 = (int)((long)n7 * (l11 - l3) / (l4 - l3));
                        if (n2 >= 0 && l10 >= l3 && l10 <= l4) {
                            int n17 = (int)((long)n7 * (l10 - l3) / (l4 - l3));
                            if (n17 == n16) {
                                graphics.fillRect(n3 + n2, n15 - n17 - i, n - n2, 1);
                            } else {
                                graphics.drawLine(n3 + n2, n15 - n17 - i, n3 + n, n15 - n16 - i);
                            }
                        } else if (sequence.size == 1) {
                            graphics.fillRect(n3, n15 - n16 - i, n6, 1);
                        }
                    }
                    n2 = n;
                    l10 = l11;
                }
            }
            long l12 = sequence.values[sequence.size - 1];
            if (l12 >= l3 && l12 <= l4) {
                graphics.setColor(sequence.color);
                n8 = this.r.x + this.r.width + 2;
                n9 = this.topMargin + n7 - (int)((long)n7 * (l12 - l3) / (l4 - l3));
                graphics.fillPolygon(new int[]{n8 + 2, n8 + 6, n8 + 6}, new int[]{n9, n9 + 3, n9 - 3}, 3);
            }
            graphics.setColor(Color.black);
        }
        int[] nArray = new int[n11];
        for (n3 = 0; n3 < n11; ++n3) {
            nArray[n3] = -1;
        }
        for (n3 = 0; n3 < n11; ++n3) {
            Sequence sequence = this.seqs.get(n3);
            if (!sequence.isPlotted || sequence.size <= 0) continue;
            long l13 = sequence.values[sequence.size - 1];
            if (l13 >= l3 && l13 <= l4) {
                n8 = this.r.x + this.r.width + 2;
                n9 = this.topMargin + n7 - (int)((long)n7 * (l13 - l3) / (l4 - l3));
                n2 = this.getValueStringSlot(nArray, n9, 20, n3);
                graphics.setFont(this.smallFont);
                graphics.setColor(sequence.color);
                String string4 = String.format("%,d", l13);
                int n18 = fontMetrics.stringWidth(string4);
                String string5 = sequence.name;
                n = fontMetrics.stringWidth(string5);
                if (this.checkRightMargin(n18) || this.checkRightMargin(n)) {
                    return;
                }
                graphics.drawString(string5, n8 + 17, Math.min(this.topMargin + n7, n2 + 3 - 10));
                graphics.drawString(string4, n8 + 17, Math.min(this.topMargin + n7 + 10, n2 + 3));
                if (n2 > n9 + 3) {
                    graphics.drawLine(n8 + 9, n9 + 2, n8 + 14, n2);
                } else if (n2 < n9 - 3) {
                    graphics.drawLine(n8 + 9, n9 - 2, n8 + 14, n2);
                }
            }
            graphics.setFont(font);
            graphics.setColor(Color.black);
        }
        graphics.setColor((Color)serializable);
    }

    private boolean checkLeftMargin(int n) {
        if (n < 2) {
            this.leftMargin += 2 - n;
            this.repaint();
            return true;
        }
        return false;
    }

    private boolean checkRightMargin(int n) {
        if (n + 2 > this.rightMargin) {
            this.rightMargin = n + 2;
            this.repaint();
            return true;
        }
        return false;
    }

    private int getValueStringSlot(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n && nArray[i] < n + n2) {
                if (nArray[i] > n2) {
                    return this.getValueStringSlot(nArray, nArray[i] - n2, n2, n3);
                }
                return this.getValueStringSlot(nArray, nArray[i] + n2, n2, n3);
            }
            if (n < n2 || nArray[i] <= n - n2 || nArray[i] >= n) continue;
            return this.getValueStringSlot(nArray, nArray[i] + n2, n2, n3);
        }
        nArray[n3] = n;
        return n;
    }

    private long calculateTickInterval(int n, int n2, long l) {
        long l2 = l * (long)n2 / (long)n;
        l2 = l2 < 60000L ? 60000L : (l2 < 300000L ? 300000L : (l2 < 600000L ? 600000L : (l2 < 1800000L ? 1800000L : (l2 < 3600000L ? 3600000L : (l2 < 10800000L ? 10800000L : (l2 < 21600000L ? 21600000L : (l2 < 43200000L ? 43200000L : (l2 < 86400000L ? 86400000L : this.normalizeMax(l2 / 86400000L) * 86400000L))))))));
        return l2;
    }

    private long normalizeMin(long l) {
        int n = (int)Math.log10(l);
        long l2 = (long)Math.pow(10.0, n);
        int n2 = (int)(l / l2);
        return (long)n2 * l2;
    }

    private long normalizeMax(long l) {
        int n = (int)Math.log10(l);
        long l2 = (long)Math.pow(10.0, n);
        int n2 = (int)(l / l2);
        l = (long)(n2 + 1) * l2;
        return l;
    }

    private String trimDouble(double d) {
        String string = String.format("%.1f", d);
        if (string.length() > 3 && string.endsWith(decimalZero)) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private String getSizeString(long l, long l2) {
        int n;
        String string = this.unitsBytes ? ((n = (int)Math.log10(l2)) < 3 ? Resources.getText("Size Bytes", l) : (n < 6 ? Resources.getText("Size Kb", this.trimDouble((double)l / Math.pow(10.0, 3.0))) : (n < 9 ? Resources.getText("Size Mb", this.trimDouble((double)l / Math.pow(10.0, 6.0))) : Resources.getText("Size Gb", this.trimDouble((double)l / Math.pow(10.0, 9.0)))))) : String.format("%,d", l);
        return string;
    }

    private static long[] getLongArray(long[] lArray) {
        if (lArray == null) {
            return new long[1024];
        }
        long[] lArray2 = new long[lArray.length * 2];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    long getValue() {
        return 0L;
    }

    long getLastTimeStamp() {
        Sequence sequence = this.seqs.get(0);
        return sequence.times[sequence.size - 1];
    }

    long getLastValue(String string) {
        Sequence sequence = this.getSequence(string);
        return sequence != null && sequence.size > 0 ? sequence.values[sequence.size - 1] : 0L;
    }

    private static class Sequence {
        String key;
        String name;
        Color color;
        boolean isPlotted;
        long[] times;
        long[] values;
        int size = 0;

        Sequence(String string) {
            this.key = string;
            this.times = Plotter.getLongArray(null);
            this.values = Plotter.getLongArray(null);
        }

        private void add(long l, long l2) {
            if (this.times.length == this.size) {
                this.times = Plotter.getLongArray(this.times);
                this.values = Plotter.getLongArray(this.values);
            }
            this.times[this.size] = l;
            this.values[this.size] = l2;
            ++this.size;
        }
    }
}

