/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.IOExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8EncodingSupport
implements EncodingSupport {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};
    private static final EncodingSupport fgSingleton = new UTF8EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public boolean isASCIITransparent() {
        return true;
    }

    public boolean isSingleByte() {
        return false;
    }

    public static void normalizeCharsToBytes(char[] cArray, int n, int n2, byte[][] byArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        char c;
        byte[] byArray2 = byArray[0];
        int n3 = nArray[0];
        int n4 = byArray2.length;
        boolean bl = blArray[0];
        int n5 = nArray2[0];
        if (n5 != -1) {
            if (n == n2) {
                CharConversionError.missingSecondHalfOfSurrogatePair();
            }
            nArray2[0] = -1;
            if ((c = cArray[n++]) >= '\udc00' && c < '\ue000') {
                n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
            } else {
                CharConversionError.invalidSecondHalfOfSurrogatePair();
            }
            if (n3 + 4 > n4) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
                n4 <<= 1;
            }
            byArray2[n3++] = (byte)(0xF0 | n5 >> 18);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n5 >> 12);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n5 >> 6);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n5);
        }
        while (n < n2) {
            n5 = cArray[n++];
            if (bl) {
                bl = false;
                if (n5 == 10) continue;
            }
            if (n5 < 128) {
                if (n5 == 13) {
                    n5 = 10;
                    bl = true;
                }
                if (n3 == n4) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n4 <<= 1;
                }
                byArray2[n3++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                if (n3 + 2 > n4) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n4 <<= 1;
                }
                byArray2[n3++] = (byte)(0xC0 | n5 >> 6);
                byArray2[n3++] = (byte)(0x80 | 0x3F & n5);
                continue;
            }
            if (n5 < 55296) {
                if (n3 + 3 > n4) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n4 <<= 1;
                }
                byArray2[n3++] = (byte)(0xE0 | n5 >> 12);
                byArray2[n3++] = (byte)(0x80 | 0x3F & n5 >> 6);
                byArray2[n3++] = (byte)(0x80 | 0x3F & n5);
                continue;
            }
            if (n5 < 56320) {
                if (n == n2) {
                    nArray2[0] = n5;
                    break;
                }
                if ((c = cArray[n++]) >= '\udc00' && c < '\ue000') {
                    n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
                } else {
                    CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                if (n3 + 4 > n4) {
                    byArray2 = UTF8EncodingSupport.resize(byArray2);
                    byArray[0] = byArray2;
                    n4 <<= 1;
                }
                byArray2[n3++] = (byte)(0xF0 | n5 >> 18);
                byArray2[n3++] = (byte)(0x80 | 0x3F & n5 >> 12);
                byArray2[n3++] = (byte)(0x80 | 0x3F & n5 >> 6);
                byArray2[n3++] = (byte)(0x80 | 0x3F & n5);
                continue;
            }
            if (n5 < 57344) {
                CharConversionError.invalidFirstHalfOfSurrogatePair();
                continue;
            }
            if (n3 + 3 > n4) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
                n4 <<= 1;
            }
            byArray2[n3++] = (byte)(0xE0 | n5 >> 12);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n5 >> 6);
            byArray2[n3++] = (byte)(0x80 | 0x3F & n5);
        }
        nArray[0] = n3;
        blArray[0] = bl;
    }

    /*
     * Unable to fully structure code
     */
    public void convertCharsToBytes(char[] var1_1, int var2_2, int var3_3, byte[][] var4_4, int[] var5_5) {
        var6_6 = var1_1;
        var8_8 = var3_3;
        var7_7 = var2_2;
        var9_9 = var4_4[0];
        var11_11 = var9_9.length;
        var10_10 = var5_5[0];
        var12_12 = var11_11 - var10_10;
        var13_13 = var8_8 - var7_7 <= var12_12 ? var8_8 : var7_7 + var12_12;
        while (var7_7 < var13_13) {
            if ((var14_14 = var6_6[var7_7++]) < 128) {
                var9_9[var10_10++] = (byte)var14_14;
                continue;
            }
            --var7_7;
            break;
        }
        if (var7_7 != var8_8) ** GOTO lbl68
        var5_5[0] = var10_10;
        return;
lbl-1000:
        // 1 sources

        {
            if ((var14_14 = var6_6[var7_7++]) < 128) {
                if (var10_10 == var11_11) {
                    var9_9 = UTF8EncodingSupport.resize(var9_9);
                    var4_4[0] = var9_9;
                    var11_11 <<= 1;
                }
                var9_9[var10_10++] = (byte)var14_14;
                continue;
            }
            if (var14_14 < 2048) {
                if (var10_10 + 2 > var11_11) {
                    var9_9 = UTF8EncodingSupport.resize(var9_9);
                    var4_4[0] = var9_9;
                    var11_11 <<= 1;
                }
                var9_9[var10_10++] = (byte)(192 | var14_14 >> 6);
                var9_9[var10_10++] = (byte)(128 | 63 & var14_14);
                continue;
            }
            if (var14_14 < 55296) {
                if (var10_10 + 3 > var11_11) {
                    var9_9 = UTF8EncodingSupport.resize(var9_9);
                    var4_4[0] = var9_9;
                    var11_11 <<= 1;
                }
                var9_9[var10_10++] = (byte)(224 | var14_14 >> 12);
                var9_9[var10_10++] = (byte)(128 | 63 & var14_14 >> 6);
                var9_9[var10_10++] = (byte)(128 | 63 & var14_14);
                continue;
            }
            if (var14_14 < 56320) {
                if (var7_7 == var8_8) {
                    CharConversionError.missingSecondHalfOfSurrogatePair();
                }
                if ((var15_15 = var6_6[var7_7++]) >= '\udc00' && var15_15 < '\ue000') {
                    var14_14 = 65536 + (var14_14 - 55296 << 10) + (var15_15 - 56320);
                } else {
                    CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                if (var10_10 + 4 > var11_11) {
                    var9_9 = UTF8EncodingSupport.resize(var9_9);
                    var4_4[0] = var9_9;
                    var11_11 <<= 1;
                }
                var9_9[var10_10++] = (byte)(240 | var14_14 >> 18);
                var9_9[var10_10++] = (byte)(128 | 63 & var14_14 >> 12);
                var9_9[var10_10++] = (byte)(128 | 63 & var14_14 >> 6);
                var9_9[var10_10++] = (byte)(128 | 63 & var14_14);
                continue;
            }
            if (var14_14 < 57344) {
                CharConversionError.invalidFirstHalfOfSurrogatePair();
                continue;
            }
            if (var10_10 + 3 > var11_11) {
                var9_9 = UTF8EncodingSupport.resize(var9_9);
                var4_4[0] = var9_9;
                var11_11 <<= 1;
            }
            var9_9[var10_10++] = (byte)(224 | var14_14 >> 12);
            var9_9[var10_10++] = (byte)(128 | 63 & var14_14 >> 6);
            var9_9[var10_10++] = (byte)(128 | 63 & var14_14);
lbl68:
            // 7 sources

            ** while (var7_7 < var8_8)
        }
lbl69:
        // 1 sources

        var5_5[0] = var10_10;
    }

    public int encodeCharacter(int n, byte[][] byArray, int n2) {
        byte[] byArray2 = byArray[0];
        int n3 = byArray2.length;
        if (n < 128) {
            if (n2 == n3) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2++] = (byte)n;
        } else if (n < 2048) {
            if (n2 + 2 > n3) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2++] = (byte)(0xC0 | n >> 6);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n);
        } else if (n < 65536) {
            if (n2 + 3 > n3) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2++] = (byte)(0xE0 | n >> 12);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n >> 6);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n);
        } else {
            if (n2 + 4 > n3) {
                byArray2 = UTF8EncodingSupport.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2++] = (byte)(0xF0 | n >> 18);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n >> 12);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n >> 6);
            byArray2[n2++] = (byte)(0x80 | 0x3F & n);
        }
        return n2;
    }

    public int normalizeLineBreaks(byte[] byArray, int n, int n2, boolean[] blArray) {
        int n3;
        byte[] byArray2 = byArray;
        int n4 = n;
        int n5 = n2;
        boolean bl = blArray[0];
        if (!bl && n4 < n5) {
            while ((n3 = byArray2[n4]) != 13 && ++n4 < n5) {
            }
            if (n4 == n5) {
                return n4;
            }
            bl = true;
            byArray2[n4++] = 10;
        }
        int n6 = n4;
        while (n6 < n5) {
            n3 = byArray2[n6++];
            if (bl) {
                bl = false;
                if (n3 == 10) continue;
            }
            if (n3 == 13) {
                n3 = 10;
                bl = true;
            }
            byArray2[n4++] = n3;
        }
        blArray[0] = bl;
        return n4;
    }

    public void readCharacters(InputStream inputStream, char[][] cArray, int[] nArray, boolean[] blArray, byte[] byArray, boolean bl) {
        int n = 0;
        try {
            int n2;
            boolean bl2 = false;
            int n3 = n2 = bl ? UTF8EncodingSupport.checkUTF8BOM(inputStream, byArray) : 0;
            if (n2 < 0) {
                n2 += 3;
                bl2 = true;
            }
            do {
                int n4;
                if ((n = n2 - (n4 = blArray != null ? this.normalizeBytesToChars(byArray, 0, n2, cArray, nArray, blArray) : this.convertBytesToCharsPartial(byArray, 0, n2 += n, cArray, nArray))) <= 0) continue;
                int n5 = 0;
                do {
                    byArray[n5++] = byArray[n4++];
                } while (n5 < n);
            } while (!bl2 && (n2 = inputStream.read(byArray, n, byArray.length - n)) >= 0);
            if (n != 0) {
                CharConversionError.partialMultiPartCharacterSequence();
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    private static int checkUTF8BOM(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 == 239) {
            n2 = inputStream.read();
            if (n2 == 187) {
                n2 = inputStream.read();
                if (n2 == 191) {
                    return 0;
                }
                byArray[n++] = -17;
                byArray[n++] = -69;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            } else {
                byArray[n++] = -17;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (n2 != -1) {
            byArray[n++] = (byte)n2;
            return n;
        }
        return n - 3;
    }

    public int lengthAsCharacters(byte[] byArray, int n, int n2) {
        byte[] byArray2 = byArray;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        while (n3 < n4) {
            int n6 = byArray2[n3++];
            ++n5;
            if (n6 >= 0) continue;
            switch (fgMultiByteLength[(n6 &= 0xFF) >> 3]) {
                default: {
                    this.charConversionFailure(1, n6, 0, 0, 0);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ++n3;
                    break;
                }
                case 3: {
                    n3 += 2;
                    break;
                }
                case 4: {
                    n3 += 3;
                }
            }
        }
        return n5;
    }

    public void convertBytesToChars(byte[] byArray, int n, int n2, char[][] cArray, int[] nArray) {
        int n3 = this.convertBytesToCharsPartial(byArray, n, n2, cArray, nArray);
        if (n3 != n2) {
            CharConversionError.partialMultiPartCharacterSequence();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int convertBytesToCharsPartial(byte[] var1_1, int var2_2, int var3_3, char[][] var4_4, int[] var5_5) {
        var6_6 = var1_1;
        var8_8 = var3_3;
        var7_7 = var2_2;
        var9_9 = var4_4[0];
        var11_11 = var9_9.length;
        var10_10 = var5_5[0];
        var12_12 = var11_11 - var10_10;
        var13_13 = var8_8 - var7_7 <= var12_12 ? var8_8 : var7_7 + var12_12;
        while (var7_7 < var13_13) {
            if ((var14_14 = var6_6[var7_7++]) >= 0) {
                var9_9[var10_10++] = (char)var14_14;
                continue;
            }
            --var7_7;
            break;
        }
        if (var7_7 != var8_8) ** GOTO lbl59
        var5_5[0] = var10_10;
        return var7_7;
lbl-1000:
        // 2 sources

        {
            if (var10_10 == var11_11) {
                var9_9 = UTF8EncodingSupport.resize(var9_9);
                var4_4[0] = var9_9;
                var11_11 <<= 1;
            }
            if ((var16_16 = var6_6[var7_7++]) >= 0) {
                var9_9[var10_10++] = (char)var16_16;
                if (var7_7 != var8_8) continue;
                var5_5[0] = var10_10;
                return var7_7;
            }
            var14_14 = UTF8EncodingSupport.fgMultiByteLength[(var16_16 &= 255) >> 3];
            if (var14_14 == 0) {
                this.charConversionFailure(1, var16_16, 0, 0, 0);
            }
            if (var7_7 - 1 + var14_14 > var8_8) {
                var5_5[0] = var10_10;
                return var7_7 - 1;
            }
            var15_15 = var16_16 & UTF8EncodingSupport.fgFirstByteValueMask[var14_14];
            if ((192 & (var17_17 = var6_6[var7_7++] & 255)) != 128) {
                this.charConversionFailure(2, var16_16, var17_17, 0, 0);
            }
            if (var14_14 == 2) {
                var15_15 = (var15_15 << 6) + (63 & var17_17);
                var9_9[var10_10++] = (char)var15_15;
            } else {
                if ((192 & (var18_18 = var6_6[var7_7++] & 255)) != 128) {
                    this.charConversionFailure(3, var16_16, var17_17, var18_18, 0);
                }
                if (var14_14 == 3) {
                    var15_15 = (var15_15 << 12) + ((63 & var17_17) << 6) + (63 & var18_18);
                    var9_9[var10_10++] = (char)var15_15;
                } else {
                    if ((192 & (var19_19 = var6_6[var7_7++] & 255)) != 128) {
                        this.charConversionFailure(4, var16_16, var17_17, var18_18, var19_19);
                    }
                    if ((var20_20 = (var15_15 << 8) + ((48 & var17_17) << 2)) > 1024 || var20_20 == 0) {
                        CharConversionError.invalidUTF8SurrogateEncoding();
                    }
                    var21_21 = var20_20 - 64;
                    var22_22 = 55296 + var21_21 + ((15 & var17_17) << 2) + ((48 & var18_18) >> 4);
                    var23_23 = 56320 + ((15 & var18_18) << 6) + (63 & var19_19);
                    var9_9[var10_10++] = (char)var22_22;
                    if (var10_10 == var11_11) {
                        var9_9 = UTF8EncodingSupport.resize(var9_9);
                        var4_4[0] = var9_9;
                        var11_11 <<= 1;
                    }
                    var9_9[var10_10++] = (char)var23_23;
                }
            }
lbl59:
            // 4 sources

            if (var7_7 >= var8_8) break;
            ** while (true)
        }
        var5_5[0] = var10_10;
        return var7_7;
    }

    public int decodeCharacter(byte[] byArray, int n, int n2, int[] nArray) {
        if (n < n2) {
            int n3;
            if ((n3 = byArray[n++]) >= 0) {
                if (nArray != null) {
                    nArray[0] = 1;
                }
                return n3;
            }
            int n4 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            if (n4 > 0) {
                int n5;
                int n6;
                int n7;
                if (nArray != null) {
                    nArray[0] = n4;
                }
                if (n - 1 + n4 > n2) {
                    CharConversionError.insufficientInputToDecodeCharacter();
                }
                int n8 = n3 & fgFirstByteValueMask[n4];
                if ((0xC0 & (n7 = byArray[n++] & 0xFF)) != 128) {
                    this.charConversionFailure(2, n3, n7, 0, 0);
                }
                if (n4 == 2) {
                    n8 = (n8 << 6) + (0x3F & n7);
                    return n8;
                }
                if ((0xC0 & (n6 = byArray[n++] & 0xFF)) != 128) {
                    this.charConversionFailure(3, n3, n7, n6, 0);
                }
                if (n4 == 3) {
                    n8 = (n8 << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                    return n8;
                }
                if ((0xC0 & (n5 = byArray[n++] & 0xFF)) != 128) {
                    this.charConversionFailure(4, n3, n7, n6, n5);
                }
                n8 = (n8 << 18) + ((0x3F & n7) << 12) + ((0x3F & n6) << 6) + (0x3F & n5);
                return n8;
            }
            this.charConversionFailure(1, n3, 0, 0, 0);
            return -1;
        }
        CharConversionError.insufficientInputToDecodeCharacter();
        return -1;
    }

    private UTF8EncodingSupport() {
    }

    private static byte[] resize(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n << 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static char[] resize(char[] cArray) {
        int n = cArray.length;
        char[] cArray2 = new char[n << 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private void charConversionFailure(int n, int n2, int n3, int n4, int n5) {
        CharConversionError.invalidUTF8CharacterEncoding(n, n2, n3, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    private int normalizeBytesToChars(byte[] var1_1, int var2_2, int var3_3, char[][] var4_4, int[] var5_5, boolean[] var6_6) {
        var7_7 = var1_1;
        var8_8 = var2_2;
        var9_9 = var3_3;
        var10_10 = var4_4[0];
        var11_11 = var5_5[0];
        var12_12 = var10_10.length;
        var13_13 = var12_12 - var11_11;
        var14_14 = var6_6[0];
        var15_15 = var9_9 - var8_8 <= var13_13 ? var9_9 : var8_8 + var13_13;
        while (var8_8 < var15_15) {
            var16_16 = var7_7[var8_8++];
            if (!var14_14) {
                if (var16_16 >= 0) {
                    if (var16_16 != 13) {
                        var10_10[var11_11++] = (char)var16_16;
                        continue;
                    }
                    var14_14 = true;
                    var10_10[var11_11++] = 10;
                    continue;
                }
                --var8_8;
                break;
            }
            var14_14 = false;
            if (var16_16 == 10) continue;
            if (var16_16 >= 0) {
                if (var16_16 == 13) {
                    var16_16 = 10;
                    var14_14 = true;
                }
                var10_10[var11_11++] = (char)var16_16;
                continue;
            }
            --var8_8;
            break;
        }
        if (var8_8 != var9_9) ** GOTO lbl88
        var5_5[0] = var11_11;
        var6_6[0] = var14_14;
        return var8_8;
lbl-1000:
        // 2 sources

        {
            block24: {
                block26: {
                    block25: {
                        if (var11_11 == var12_12) {
                            var10_10 = UTF8EncodingSupport.resize(var10_10);
                            var4_4[0] = var10_10;
                            var12_12 <<= 1;
                        }
                        if ((var18_18 = var7_7[var8_8++]) < 0) break block24;
                        if (!var14_14) break block25;
                        var14_14 = false;
                        if (var18_18 == 10) break block26;
                    }
                    if (var18_18 == 13) {
                        var18_18 = 10;
                        var14_14 = true;
                    }
                    var10_10[var11_11++] = (char)var18_18;
                }
                if (var8_8 != var9_9) continue;
                var5_5[0] = var11_11;
                var6_6[0] = var14_14;
                return var8_8;
            }
            var16_16 = UTF8EncodingSupport.fgMultiByteLength[(var18_18 &= 255) >> 3];
            if (var16_16 == 0) {
                this.charConversionFailure(1, var18_18, 0, 0, 0);
            }
            if (var8_8 - 1 + var16_16 > var9_9) {
                --var8_8;
                break;
            }
            var17_17 = var18_18 & UTF8EncodingSupport.fgFirstByteValueMask[var16_16];
            if ((192 & (var19_19 = var7_7[var8_8++] & 255)) != 128) {
                this.charConversionFailure(2, var18_18, var19_19, 0, 0);
            }
            if (var16_16 == 2) {
                var17_17 = (var17_17 << 6) + (63 & var19_19);
                var10_10[var11_11++] = (char)var17_17;
            } else {
                if ((192 & (var20_20 = var7_7[var8_8++] & 255)) != 128) {
                    this.charConversionFailure(3, var18_18, var19_19, var20_20, 0);
                }
                if (var16_16 == 3) {
                    if ((var17_17 = (var17_17 << 12) + ((63 & var19_19) << 6) + (63 & var20_20)) >= 55296 && var17_17 < 57344) {
                        this.charConversionFailure(1, var18_18, var19_19, var20_20, 0);
                    }
                    var10_10[var11_11++] = (char)var17_17;
                } else {
                    if ((192 & (var21_21 = var7_7[var8_8++] & 255)) != 128) {
                        this.charConversionFailure(4, var18_18, var19_19, var20_20, var21_21);
                    }
                    if ((var22_22 = (var17_17 << 8) + ((48 & var19_19) << 2)) > 1024 || var22_22 == 0) {
                        CharConversionError.invalidUTF8SurrogateEncoding();
                    }
                    var23_23 = var22_22 - 64;
                    var24_24 = 55296 + var23_23 + ((15 & var19_19) << 2) + ((48 & var20_20) >> 4);
                    var25_25 = 56320 + ((15 & var20_20) << 6) + (63 & var21_21);
                    var10_10[var11_11++] = (char)var24_24;
                    if (var11_11 == var12_12) {
                        var10_10 = UTF8EncodingSupport.resize(var10_10);
                        var4_4[0] = var10_10;
                        var12_12 <<= 1;
                    }
                    var10_10[var11_11++] = (char)var25_25;
                }
            }
lbl88:
            // 4 sources

            if (var8_8 >= var9_9) break;
            ** while (true)
        }
        var5_5[0] = var11_11;
        var6_6[0] = var14_14;
        return var8_8;
    }
}

