/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.SecuritySupport;
import org.apache.xml.utils.WrappedRuntimeException;

public final class Encodings {
    private static final String ENCODINGS_FILE = "org/apache/xml/serializer/Encodings.properties";
    private static final String ENCODINGS_PROP = "org.apache.xalan.serialize.encodings";
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    public static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].name.equalsIgnoreCase(encoding)) {
                try {
                    return new OutputStreamWriter(output, Encodings._encodings[i].javaName);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (UnsupportedEncodingException usee) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            return new OutputStreamWriter(output, encoding);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    static EncodingInfo getEncodingInfo(String encoding) {
        String normalizedEncoding = Encodings.toUpperCaseFast(encoding);
        EncodingInfo ei = (EncodingInfo)_encodingTableKeyJava.get(normalizedEncoding);
        if (ei == null) {
            ei = (EncodingInfo)_encodingTableKeyMime.get(normalizedEncoding);
        }
        if (ei == null) {
            ei = new EncodingInfo(null, null);
        }
        return ei;
    }

    public static boolean isRecognizedEncoding(String encoding) {
        String normalizedEncoding = encoding.toUpperCase();
        EncodingInfo ei = (EncodingInfo)_encodingTableKeyJava.get(normalizedEncoding);
        if (ei == null) {
            ei = (EncodingInfo)_encodingTableKeyMime.get(normalizedEncoding);
        }
        return ei != null;
    }

    private static String toUpperCaseFast(String s) {
        boolean different = false;
        int mx = s.length();
        char[] chars = new char[mx];
        int i = 0;
        while (i < mx) {
            char ch = s.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                ch = (char)(ch + -32);
                different = true;
            }
            chars[i] = ch;
            ++i;
        }
        String upper = different ? String.valueOf(chars) : s;
        return upper;
    }

    public static String getMimeEncoding(String encoding) {
        block5: {
            if (null == encoding) {
                try {
                    encoding = System.getProperty("file.encoding", "UTF8");
                    if (null != encoding) {
                        String jencoding = encoding.equalsIgnoreCase("Cp1252") || encoding.equalsIgnoreCase("ISO8859_1") || encoding.equalsIgnoreCase("8859_1") || encoding.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(encoding);
                        encoding = null != jencoding ? jencoding : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    encoding = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException se) {
                    encoding = DEFAULT_MIME_ENCODING;
                }
            } else {
                encoding = Encodings.convertJava2MimeEncoding(encoding);
            }
        }
        return encoding;
    }

    public static String convertJava2MimeEncoding(String encoding) {
        EncodingInfo enc = (EncodingInfo)_encodingTableKeyJava.get(Encodings.toUpperCaseFast(encoding));
        if (null != enc) {
            return enc.name;
        }
        return encoding;
    }

    public static String convertMime2JavaEncoding(String encoding) {
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].name.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i].javaName;
            }
            ++i;
        }
        return encoding;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL url = null;
        try {
            String urlString = null;
            InputStream is = null;
            try {
                urlString = System.getProperty(ENCODINGS_PROP, "");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (urlString != null && urlString.length() > 0) {
                url = new URL(urlString);
                is = url.openStream();
            }
            if (is == null) {
                SecuritySupport ss = SecuritySupport.getInstance();
                is = ss.getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            }
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                is.close();
            }
            int totalEntries = ((Hashtable)props).size();
            int totalMimeNames = 0;
            Enumeration keys = ((Hashtable)props).keys();
            int i = 0;
            while (i < totalEntries) {
                String javaName = (String)keys.nextElement();
                String val = props.getProperty(javaName);
                ++totalMimeNames;
                int pos = val.indexOf(32);
                int j = 0;
                while (j < pos) {
                    if (val.charAt(j) == ',') {
                        ++totalMimeNames;
                    }
                    ++j;
                }
                ++i;
            }
            EncodingInfo[] ret = new EncodingInfo[totalMimeNames];
            int j = 0;
            keys = ((Hashtable)props).keys();
            int i2 = 0;
            while (i2 < totalEntries) {
                String mimeName;
                String javaName = (String)keys.nextElement();
                String val = props.getProperty(javaName);
                int pos = val.indexOf(32);
                if (pos < 0) {
                    mimeName = val;
                } else {
                    StringTokenizer st = new StringTokenizer(val.substring(0, pos), ",");
                    boolean first = true;
                    while (st.hasMoreTokens()) {
                        mimeName = st.nextToken();
                        ret[j] = new EncodingInfo(mimeName, javaName);
                        _encodingTableKeyMime.put(Encodings.toUpperCaseFast(mimeName), ret[j]);
                        if (first) {
                            _encodingTableKeyJava.put(javaName.toUpperCase(), ret[j]);
                        }
                        ++j;
                        first = false;
                    }
                }
                ++i2;
            }
            return ret;
        }
        catch (MalformedURLException mue) {
            throw new WrappedRuntimeException(mue);
        }
        catch (IOException ioe) {
            throw new WrappedRuntimeException(ioe);
        }
    }

    static boolean isHighUTF16Surrogate(char ch) {
        return '\ud800' <= ch && ch <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char ch) {
        return '\udc00' <= ch && ch <= '\udfff';
    }

    static int toCodePoint(char highSurrogate, char lowSurrogate) {
        int codePoint = (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
        return codePoint;
    }

    static int toCodePoint(char ch) {
        char codePoint = ch;
        return codePoint;
    }
}

