/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAProfileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class BackupSupport {
    public static final boolean DEBUG = false;
    public static final int BCK_FILE_NOT_FOUND = 1;
    public static final int NEW_FILE_NOT_FOUND = 2;

    public static int mergePropertiesFiles(String bckFileName, String newFileName, String oldProductVersion, String newProductVersion, String[] propertiesToIgnore, String[][] additionalProperties) throws IOException {
        if (bckFileName == null || bckFileName.trim().length() == 0 || !new File(bckFileName).exists()) {
            return 1;
        }
        Properties oldProperties = new Properties();
        oldProperties.load(new FileInputStream(new File(bckFileName)));
        if (propertiesToIgnore != null && propertiesToIgnore.length > 0) {
            int k = 0;
            while (k < propertiesToIgnore.length) {
                if (oldProperties.containsKey(propertiesToIgnore[k])) {
                    oldProperties.remove(propertiesToIgnore[k]);
                }
                ++k;
            }
        }
        Properties newProperties = new Properties();
        if (newFileName != null && new File(newFileName).exists()) {
            newProperties.load(new FileInputStream(new File(newFileName)));
        }
        Enumeration<Object> oldKeys = oldProperties.keys();
        while (oldKeys.hasMoreElements()) {
            String installedKey = (String)oldKeys.nextElement();
            newProperties.put(installedKey, oldProperties.getProperty(installedKey));
        }
        if (additionalProperties != null && additionalProperties.length > 0) {
            int i = 0;
            while (i < additionalProperties.length) {
                String key = additionalProperties[i][0];
                String value = additionalProperties[i][1];
                newProperties.put(key, value);
                ++i;
            }
        }
        ICAProfileParser parser = new ICAProfileParser();
        parser.setUncommentInsteadOfInsert(2);
        Enumeration<Object> newKeys = newProperties.keys();
        while (newKeys.hasMoreElements()) {
            String currentKey = (String)newKeys.nextElement();
            parser.setProfileString(newFileName, null, currentKey, newProperties.getProperty(currentKey));
        }
        return 0;
    }

    public static Properties mergeProperties(String bckFileName, String newFileName, String oldProductVersion, String newProductVersion, String[] propertiesToIgnore) throws IOException {
        Properties oldProperties = new Properties();
        oldProperties.load(new FileInputStream(new File(bckFileName)));
        if (propertiesToIgnore != null && propertiesToIgnore.length > 0) {
            int k = 0;
            while (k < propertiesToIgnore.length) {
                if (oldProperties.containsKey(propertiesToIgnore[k])) {
                    oldProperties.remove(propertiesToIgnore[k]);
                }
                ++k;
            }
        }
        Properties newProperties = new Properties();
        newProperties.load(new FileInputStream(new File(newFileName)));
        Enumeration<Object> oldKeys = oldProperties.keys();
        while (oldKeys.hasMoreElements()) {
            String installedKey = (String)oldKeys.nextElement();
            newProperties.put(installedKey, oldProperties.getProperty(installedKey));
        }
        ICAProfileParser parser = new ICAProfileParser();
        parser.setUncommentInsteadOfInsert(2);
        Enumeration<Object> newKeys = newProperties.keys();
        while (newKeys.hasMoreElements()) {
            String currentKey = (String)newKeys.nextElement();
            parser.setProfileString(newFileName, null, currentKey, newProperties.getProperty(currentKey));
        }
        return newProperties;
    }
}

