/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.BldUtilPrefixes;
import com.installshield.archive.ArchiveBuilderSupport;
import com.installshield.product.ProductBean;
import com.installshield.util.ClassLocator;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.WizardServices;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class BldUtil {
    protected static String[] defaultPrefixes = new String[]{"", "W2000", "W2003", "WXP", "W32", "LINUX", "AIX", "UNIX"};
    protected static String[] availablePrefixes = null;
    protected static Hashtable replForInstantiate = new Hashtable();
    protected static Hashtable classCache = new Hashtable();
    protected static boolean useDistinctWindowsOSTypes = false;
    static /* synthetic */ Class class$0;

    public BldUtil(ArchiveBuilderSupport support) {
        availablePrefixes = null;
        if (support != null) {
            BldUtil.getAvailablePrefixes(support);
        }
        classCache.clear();
    }

    public BldUtil() {
        availablePrefixes = null;
        classCache.clear();
    }

    public static boolean getUseDistinctWindowsOSTypes() {
        return useDistinctWindowsOSTypes;
    }

    public static void setUseDistinctWindowsOSTypes(boolean useDistinctWindowsOSTypes) {
        BldUtil.useDistinctWindowsOSTypes = useDistinctWindowsOSTypes;
        classCache.clear();
    }

    public static void setReplForInstantiate(String oldClass, String newClass) {
        classCache.clear();
        if (replForInstantiate == null) {
            replForInstantiate = new Hashtable();
        }
        if (oldClass != null) {
            if (newClass != null) {
                replForInstantiate.put(oldClass, newClass);
            } else {
                replForInstantiate.remove(oldClass);
            }
        }
    }

    public static String getReplForInstantiate(String oldClass) {
        if (replForInstantiate == null || oldClass == null) {
            return null;
        }
        return (String)replForInstantiate.get(oldClass);
    }

    public static void remReplForInstantiate(String oldClass) {
        classCache.clear();
        if (replForInstantiate != null && oldClass != null) {
            replForInstantiate.remove(oldClass);
        }
    }

    public static void clrReplForInstantiate() {
        classCache.clear();
        if (replForInstantiate != null) {
            replForInstantiate.clear();
        }
    }

    public static String[] getSearchPrefixes() {
        String[] rez;
        String osName = System.getProperty("os.name", "").toUpperCase();
        if (osName.startsWith("WINDOWS")) {
            if (useDistinctWindowsOSTypes) {
                String osVersion = System.getProperty("os.version", "");
                rez = osName.startsWith("WINDOWS XP") ? new String[]{"WXP", "W32", ""} : (osName.startsWith("WINDOWS 2003") || (osName.startsWith("WINDOWS NT") || osName.startsWith("WINDOWS 2000")) && (osVersion.startsWith("5.2") || osVersion.startsWith("5.02")) ? new String[]{"W2003", "W32", ""} : new String[]{"W2000", "W32", ""});
            } else {
                rez = new String[]{"W32", ""};
            }
        } else {
            rez = osName.startsWith("AIX") ? new String[]{"AIX", "UNIX", ""} : (osName.startsWith("LINUX") ? new String[]{"LINUX", "UNIX", ""} : new String[]{""});
        }
        return rez;
    }

    public static String getPrefix() {
        return BldUtil.getSearchPrefixes()[0];
    }

    private static Object instantiate(String clsName, boolean withReplace) {
        block12: {
            String clsInstanceName;
            String newClsName;
            if (clsName == null) {
                return null;
            }
            if (withReplace && (newClsName = BldUtil.getReplForInstantiate(clsName)) != null) {
                clsName = newClsName;
            }
            if ((clsInstanceName = (String)classCache.get(clsName)) != null) {
                try {
                    return Class.forName(clsInstanceName).newInstance();
                }
                catch (Exception exception) {
                    break block12;
                }
            }
            String[] prefixes = BldUtil.getSearchPrefixes();
            String clsBase = null;
            String pack = null;
            int poz = clsName.lastIndexOf(46);
            if (poz >= 0) {
                pack = clsName.substring(0, poz + 1);
                clsBase = clsName.substring(poz + 1);
            } else {
                pack = "";
                clsBase = clsName;
            }
            try {
                int i = 0;
                while (i < prefixes.length) {
                    try {
                        clsInstanceName = String.valueOf(pack) + prefixes[i] + clsBase;
                        Class<?> cls = Class.forName(clsInstanceName);
                        classCache.put(clsName, clsInstanceName);
                        return cls.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object instantiate(String clsName) {
        return BldUtil.instantiate(clsName, true);
    }

    public static Object instantiateWithoutReplace(String clsName) {
        return BldUtil.instantiate(clsName, false);
    }

    public static String[] getAvailablePrefixes(ArchiveBuilderSupport support) {
        if (availablePrefixes == null) {
            classCache.clear();
            try {
                availablePrefixes = new BldUtilPrefixes().getAvailablePrefixes();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (availablePrefixes == null) {
                availablePrefixes = defaultPrefixes;
            }
            if (support != null) {
                String list = "";
                int i = 0;
                while (i < availablePrefixes.length) {
                    list = String.valueOf(list) + (list.length() == 0 ? "" : ", ") + "\"" + availablePrefixes[i] + "\"";
                    ++i;
                }
                support.logEvent("", "msg1", "BldUtil prefixes = " + list);
            }
        }
        return availablePrefixes;
    }

    public static String[] getAvailablePrefixes() {
        return BldUtil.getAvailablePrefixes(null);
    }

    public static boolean isPrefixAvailable(ArchiveBuilderSupport support, String prefix) {
        String[] prefixes = BldUtil.getAvailablePrefixes(support);
        int i = 0;
        while (i < prefixes.length) {
            if (prefixes[i].equalsIgnoreCase(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrefixAvailable(String prefix) {
        return BldUtil.isPrefixAvailable(null, prefix);
    }

    private static Object[] invokeStaticMethod(Class cls, String methodName) {
        Object[] rez = null;
        try {
            Object obj = cls.getMethod(methodName, null).invoke(null, new Object[0]);
            if (obj != null) {
                rez = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rez;
    }

    private static String getAncestor(Class cls) {
        String rez = null;
        try {
            String rez1;
            Class cls1 = cls.getSuperclass();
            if (cls1 != null && (rez1 = cls1.getName()) != null && rez1.toLowerCase().startsWith("com.ibm.")) {
                rez = rez1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rez;
    }

    public static void putClass(ArchiveBuilderSupport support, String clsName) throws IOException {
        BldUtil.putClass(support, clsName, null);
    }

    public static void putClass(ArchiveBuilderSupport support, String clsName, Vector vect) throws IOException {
        if (support == null || clsName == null || clsName.length() == 0) {
            return;
        }
        if (vect != null) {
            if (vect.contains(clsName)) {
                return;
            }
            vect.addElement(clsName);
        }
        if (availablePrefixes == null) {
            try {
                availablePrefixes = new BldUtilPrefixes().getAvailablePrefixes();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (availablePrefixes == null) {
                availablePrefixes = defaultPrefixes;
            }
            String list = "";
            int i = 0;
            while (i < availablePrefixes.length) {
                list = String.valueOf(list) + (list.length() == 0 ? "" : ", ") + "\"" + availablePrefixes[i] + "\"";
                ++i;
            }
            support.logEvent("", "msg1", "BldUtil prefixes = " + list);
        }
        int maxNr = 4;
        String[] prefix = availablePrefixes;
        String clsBase = null;
        String pack = null;
        int poz = clsName.lastIndexOf(46);
        if (poz >= 0) {
            pack = clsName.substring(0, poz + 1);
            clsBase = clsName.substring(poz + 1);
        } else {
            pack = "";
            clsBase = clsName;
        }
        int i = 0;
        while (i < prefix.length) {
            int j = 0;
            while (j <= maxNr) {
                block60: {
                    try {
                        String clsName1 = String.valueOf(pack) + prefix[i] + clsBase + (j > 0 ? "$" + j : "");
                        support.putClass(clsName1);
                        if (j != 0) break block60;
                        try {
                            String ancestor;
                            Object rez;
                            int k;
                            Class<?> cls = Class.forName(clsName1);
                            Object[] rezArray = null;
                            rezArray = BldUtil.invokeStaticMethod(cls, "involvedClasses");
                            if (rezArray != null) {
                                k = 0;
                                while (k < rezArray.length) {
                                    rez = rezArray[k];
                                    if (rez != null) {
                                        if (rez instanceof Class) {
                                            rez = ((Class)rez).getName();
                                        }
                                        if (rez instanceof String) {
                                            if (vect == null) {
                                                vect = new Vector<String>();
                                                vect.addElement(clsName);
                                            }
                                            try {
                                                BldUtil.putClass(support, (String)rez, vect);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    ++k;
                                }
                            }
                            if ((rezArray = BldUtil.invokeStaticMethod(cls, "involvedServices")) != null) {
                                k = 0;
                                while (k < rezArray.length) {
                                    rez = rezArray[k];
                                    if (rez != null && rez instanceof String) {
                                        try {
                                            if (support instanceof WizardBuilderSupport) {
                                                ((WizardBuilderSupport)support).putRequiredService((String)rez);
                                            } else if (support instanceof ServiceBuilderSupport) {
                                                ((ServiceBuilderSupport)support).putRequiredService((String)rez);
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++k;
                                }
                            }
                            if ((rezArray = BldUtil.invokeStaticMethod(cls, "involvedResources")) != null) {
                                k = 0;
                                while (k < rezArray.length - 1) {
                                    Object rez0 = rezArray[k];
                                    Object rez1 = rezArray[k + 1];
                                    if (rez0 != null && rez1 != null) {
                                        if (rez0 instanceof URL && rez1 instanceof String) {
                                            try {
                                                support.putResource((URL)rez0, (String)rez1);
                                            }
                                            catch (Exception exception) {}
                                        } else if (rez0 instanceof String && rez1 instanceof String) {
                                            try {
                                                support.putResource((String)rez0, (String)rez1);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    k += 2;
                                }
                            }
                            if ((rezArray = BldUtil.invokeStaticMethod(cls, "involvedResourceBundles")) != null) {
                                k = 0;
                                while (k < rezArray.length) {
                                    rez = rezArray[k];
                                    if (rez != null && rez instanceof String) {
                                        try {
                                            support.putResourceBundles((String)rez);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++k;
                                }
                            }
                            if ((rezArray = BldUtil.invokeStaticMethod(cls, "involvedPackages")) != null) {
                                k = 0;
                                while (k < rezArray.length) {
                                    rez = rezArray[k];
                                    if (rez != null && rez instanceof String) {
                                        try {
                                            support.putPackage((String)rez);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++k;
                                }
                            }
                            if ((rezArray = BldUtil.invokeStaticMethod(cls, "involvedPackagesRecursively")) != null) {
                                k = 0;
                                while (k < rezArray.length) {
                                    rez = rezArray[k];
                                    if (rez != null && rez instanceof String) {
                                        try {
                                            support.putPackage((String)rez, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++k;
                                }
                            }
                            if ((ancestor = BldUtil.getAncestor(cls)) == null) break block60;
                            if (vect == null) {
                                vect = new Vector();
                                vect.addElement(clsName);
                            }
                            try {
                                BldUtil.putClass(support, ancestor, vect);
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (IOException ex) {
                        if (i != 0 || j != 0) break block60;
                        throw ex;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static String findCurrentJarFile(Object obj) {
        int p;
        String clsname = null;
        if (obj == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.itcins.ica2.BldUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            obj = clazz;
        }
        clsname = obj instanceof String ? (String)obj : (obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName());
        String fileName = null;
        String cp = System.getProperty("java.class.path");
        ClassLocator classLocator = new ClassLocator(cp);
        fileName = classLocator.findClass(clsname);
        if (fileName != null && (p = fileName.indexOf(33)) >= 0) {
            fileName = fileName.substring(0, p);
        }
        return fileName;
    }

    public static String findCurrentJarDirectory(Object obj) {
        String directoryName = null;
        String fileName = BldUtil.findCurrentJarFile(obj);
        if (fileName != null) {
            File f = new File(new File(fileName).getAbsolutePath());
            directoryName = f.getParent();
        }
        if (directoryName == null) {
            directoryName = "";
        }
        String fs = System.getProperty("file.separator");
        char cfs = fs.charAt(0);
        if ((directoryName = directoryName.trim().replace('/', cfs).replace('\\', cfs)).length() > 0 && !directoryName.endsWith(fs)) {
            directoryName = String.valueOf(directoryName) + fs;
        }
        if (directoryName.endsWith(String.valueOf(fs) + "." + fs)) {
            directoryName = directoryName.substring(0, directoryName.length() - 2);
        }
        return directoryName;
    }

    public static Wizard getWizard(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof WizardBean) {
            return ((WizardBean)obj).getWizard();
        }
        if (obj instanceof Wizard) {
            return (Wizard)obj;
        }
        return null;
    }

    public static WizardServices getServices(Object obj) {
        WizardServices wizardServices = null;
        if (obj != null) {
            if (obj instanceof WizardServices) {
                wizardServices = (WizardServices)obj;
            } else if (obj instanceof WizardBean) {
                wizardServices = ((WizardBean)obj).getWizard().getServices();
            } else if (obj instanceof Wizard) {
                wizardServices = ((Wizard)obj).getServices();
            } else if (obj instanceof AbstractServiceImplementor) {
                wizardServices = ((AbstractServiceImplementor)obj).getServices();
            } else if (obj instanceof WizardBeanCondition) {
                wizardServices = ((WizardBeanCondition)obj).getWizardBean().getWizard().getServices();
            } else if (obj instanceof ProductBean) {
                wizardServices = ((ProductBean)obj).getServices();
            }
        }
        return wizardServices;
    }
}

