/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.CheckExtFile;
import com.installshield.util.FileUtils;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.Wizard;
import java.io.File;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConditionalParser {
    public static final int NRFIELDS = 4;
    private Properties propobj = null;
    private Wizard wizard = null;
    private String oldVersionString = null;
    private String newVersionString = null;
    private String dstDirectory = null;
    private String kitDirectory = null;
    private String kitAltDirectory = null;
    private static final int PARSE_OLDVERIN = 1;
    private static final int PARSE_NEWVERIN = 2;
    private static final int PARSE_EXISTONKIT = 3;
    private static final int PARSE_EXISTONDST = 4;
    private static final int PARSE_EXISTONKITDIF = 5;
    private static final int PARSE_DWNGRADE = 6;
    private static final int PARSE_SAMEVERSION = 7;
    private static final int PARSE_UPGRADE = 8;
    private static final int PARSE_TRUE = 9;
    private static final int PARSE_FALSE = 10;
    private static final int PARSE_OLDVERLT = 11;
    private static final int PARSE_OLDVERLE = 12;
    private static final int PARSE_OLDVEREQ = 13;
    private static final int PARSE_OLDVERGE = 14;
    private static final int PARSE_OLDVERGT = 15;
    private static final int PARSE_EMPTYSTRING = 16;
    private static final int PARSE_IF = 51;
    private static final int PARSE_ELIF = 52;
    private static final int PARSE_ELSE = 53;
    private static final int PARSE_END = 54;
    private static final int PARSE_OLDVER = 101;
    private static final int PARSE_NEWVER = 102;
    static /* synthetic */ Class class$0;

    public ConditionalParser() {
    }

    public static String[] involvedClasses() {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.itcins.ica2.CheckExtFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        return stringArray;
    }

    public ConditionalParser(Properties properties, Wizard wiz, String oldVersion, String newVersion, String dstDir, String kitDir, String kitAltDir) {
        this.propobj = properties;
        this.wizard = wiz;
        this.oldVersionString = oldVersion;
        this.newVersionString = newVersion;
        this.dstDirectory = dstDir;
        this.kitDirectory = kitDir;
        this.kitAltDirectory = kitAltDir;
    }

    public ConditionalParser(Properties properties, Wizard wiz, String oldVersion, String newVersion, String dstDir, String kitDir) {
        this.propobj = properties;
        this.wizard = wiz;
        this.oldVersionString = oldVersion;
        this.newVersionString = newVersion;
        this.dstDirectory = dstDir;
        this.kitDirectory = kitDir;
    }

    public void setProperties(Properties prop) {
        this.propobj = prop;
    }

    public Properties getProperties() {
        return this.propobj;
    }

    public void setWizard(Wizard wiz) {
        this.wizard = wiz;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void setOldVer(String verStr) {
        this.oldVersionString = verStr;
    }

    public void setOldVer(int[] verArray) {
        this.oldVersionString = ConditionalParser.mergeVersion(verArray, 4);
    }

    public String getOldVer() {
        return this.oldVersionString;
    }

    public void setNewVer(String verStr) {
        this.newVersionString = verStr;
    }

    public void setNewVer(int[] verArray) {
        this.newVersionString = ConditionalParser.mergeVersion(verArray, 4);
    }

    public String getNewVer() {
        return this.newVersionString;
    }

    public void setDstDir(String dir) {
        this.dstDirectory = dir;
    }

    public String getDstDir() {
        return this.dstDirectory;
    }

    public void setKitDir(String dir) {
        this.kitDirectory = dir;
    }

    public String getKitDir() {
        return this.kitDirectory;
    }

    public void setKitAltDir(String dir) {
        this.kitAltDirectory = dir;
    }

    public String getKitAltDir() {
        return this.kitAltDirectory;
    }

    public static int[] splitVersion(String version, int lngth, int padWith) throws NumberFormatException {
        int n;
        if (version == null) {
            version = "";
        }
        version = version.trim();
        if (padWith < 0) {
            padWith = Integer.MAX_VALUE;
        }
        if (lngth > (n = 4)) {
            n = lngth;
        }
        int[] wrk = new int[n];
        int i = 0;
        while (i < n) {
            wrk[i] = padWith;
            ++i;
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        i = 0;
        while (st.hasMoreTokens() && i < n) {
            wrk[i] = -1;
            try {
                wrk[i] = Integer.parseInt(st.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (wrk[i] < 0) {
                throw new NumberFormatException("Wrong version format: " + version);
            }
            ++i;
        }
        if (i > lngth) {
            lngth = i;
        }
        int[] result = new int[lngth];
        System.arraycopy(wrk, 0, result, 0, lngth);
        return result;
    }

    public static String mergeVersion(int[] versionArray, int lngth) {
        if (versionArray == null) {
            return null;
        }
        String result = "";
        if (lngth <= 0) {
            lngth = 4;
        }
        int n = versionArray.length;
        while (n > lngth && versionArray[n - 1] == 0) {
            --n;
        }
        if (n < lngth) {
            n = lngth;
        }
        int i = 0;
        while (i < n) {
            result = String.valueOf(result) + (result.length() > 0 ? "." : "") + (i < versionArray.length ? Integer.toString(versionArray[i]) : "0");
            ++i;
        }
        return result;
    }

    public static boolean checkVersionMatch(String version, String validList) throws NumberFormatException {
        if (version == null || version.trim().length() == 0 || validList == null || validList.trim().length() == 0) {
            return true;
        }
        int n = 4;
        int i = 0;
        int[] vers = ConditionalParser.splitVersion(version, n, 0);
        StringTokenizer st = new StringTokenizer(validList.trim(), ",");
        while (st.hasMoreTokens()) {
            String vvv2;
            String vvv1 = st.nextToken().trim();
            int poz = vvv1.indexOf("-");
            if (poz < 0) {
                vvv2 = vvv1;
            } else {
                vvv2 = vvv1.substring(poz + 1).trim();
                vvv1 = vvv1.substring(0, poz).trim();
            }
            int[] vvvL1 = ConditionalParser.splitVersion(vvv1, n, 0);
            int[] vvvL2 = ConditionalParser.splitVersion(vvv2, n, -1);
            boolean match = true;
            i = 0;
            while (i < n) {
                if (vers[i] > vvvL1[i]) break;
                if (vers[i] < vvvL1[i]) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                i = 0;
                while (i < n) {
                    if (vers[i] < vvvL2[i]) break;
                    if (vers[i] > vvvL2[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static int compareVersions(String v1, String v2) throws NumberFormatException {
        int[] v2Array;
        int n2;
        if (v1 == null || v2 == null) {
            return 0;
        }
        int[] v1Array = ConditionalParser.splitVersion(v1, 4, 0);
        int n1 = v1Array.length;
        int n = n1 > (n2 = (v2Array = ConditionalParser.splitVersion(v2, 4, 0)).length) ? n1 : n2;
        int i = 0;
        while (i < n) {
            int v2Field;
            int v1Field = i < n1 ? v1Array[i] : 0;
            int n3 = v2Field = i < n2 ? v2Array[i] : 0;
            if (v1Field < v2Field) {
                return -1;
            }
            if (v1Field > v2Field) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static int compareVersions(String v1, String v2, int nf) throws NumberFormatException {
        int[] v2Array;
        int n2;
        if (v1 == null || v2 == null) {
            return 0;
        }
        int[] v1Array = ConditionalParser.splitVersion(v1, 4, 0);
        int n1 = v1Array.length;
        int n = n1 > (n2 = (v2Array = ConditionalParser.splitVersion(v2, 4, 0)).length) ? n1 : n2;
        n = nf < n ? nf : n;
        int i = 0;
        while (i < n) {
            int v2Field;
            int v1Field = i < n1 ? v1Array[i] : 0;
            int n3 = v2Field = i < n2 ? v2Array[i] : 0;
            if (v1Field < v2Field) {
                return -1;
            }
            if (v1Field > v2Field) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static int locateString(String val, String[] array) {
        int n = array.length;
        int i = 0;
        while (i < n) {
            if (val.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int locateStringIgnoreCase(String val, String[] array) {
        int n = array.length;
        int i = 0;
        while (i < n) {
            if (val.equalsIgnoreCase(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String parseConditionalString(String source, Wizard wiz, String oldVersion, String newVersion, String dstDir, String kitDir, String kitAltDir) throws ParseException {
        int i;
        if (source == null) {
            return null;
        }
        String[] keywords = new String[]{"IF", "ELIF", "ELSE", "END", "ENDIF", "VERIN", "OLDVERIN", "NEWVERIN", "VERLT", "VERLE", "VEREQ", "VERGE", "VERGT", "EMPTYSTRING", "EMPTYSTR", "EXISTONKIT", "EXISTONDST", "EXISTONKITDIF", "DWNGRADE", "SAMEVERSION", "UPGRADE", "TRUE", "FALSE", "OLDVER", "NEWVER"};
        int[] keyvals = new int[]{51, 52, 53, 54, 54, 1, 1, 2, 11, 12, 13, 14, 15, 16, 16, 3, 4, 5, 6, 7, 8, 9, 10, 101, 102};
        StringBuffer result = new StringBuffer();
        int maxcond = 32;
        int[] begkey = new int[maxcond];
        int[] endkey = new int[maxcond];
        int[] keykey = new int[maxcond];
        boolean[] keynot = new boolean[maxcond];
        int[] condkey = new int[maxcond];
        String[] keyname = new String[maxcond];
        String[] condname = new String[maxcond];
        String[] keyparam = new String[maxcond];
        int n = source.length();
        int m = 0;
        int p = 0;
        while (p < n) {
            String strUp;
            int k = source.indexOf("[[", p);
            int l = source.indexOf("]]", p);
            if (k < 0 && l < 0) break;
            if (k >= 0 && l < 0) {
                throw new ParseException("Missing ]] after [[", k);
            }
            if (l >= 0 && (k < 0 || k > l)) {
                throw new ParseException("Encountered ]] without [[", l);
            }
            p = l + 2;
            begkey[m] = k;
            endkey[m] = l + 2;
            String str = source.substring(k + 2, l).trim();
            if (wiz != null) {
                str = wiz.getServices().resolveString(str);
            }
            if ((i = (strUp = str.toUpperCase()).indexOf(" ")) < 0) {
                i = strUp.length();
            }
            String str1Up = strUp.substring(0, i);
            strUp = strUp.substring(i).trim();
            str = str.substring(i).trim();
            i = ConditionalParser.locateString(str1Up, keywords);
            if (i >= 0) {
                i = keyvals[i];
            }
            keykey[m] = i;
            keyname[m] = str1Up;
            keyparam[m] = str;
            block13 : switch (i) {
                case 53: 
                case 54: 
                case 101: 
                case 102: {
                    if (str.length() <= 0) break;
                    throw new ParseException("Invalid syntax for " + str1Up, k);
                }
                case 51: 
                case 52: {
                    keynot[m] = false;
                    int j = strUp.indexOf(" ");
                    if (j < 0) {
                        j = strUp.length();
                    }
                    String str2Up = strUp.substring(0, j);
                    strUp = strUp.substring(j).trim();
                    str = str.substring(j).trim();
                    if (str2Up.equalsIgnoreCase("NOT")) {
                        keynot[m] = true;
                        j = strUp.indexOf(" ");
                        if (j < 0) {
                            j = strUp.length();
                        }
                        str2Up = strUp.substring(0, j);
                        strUp = strUp.substring(j).trim();
                        str = str.substring(j).trim();
                    }
                    if ((j = ConditionalParser.locateString(str2Up, keywords)) >= 0) {
                        j = keyvals[j];
                    }
                    condkey[m] = j;
                    condname[m] = str2Up;
                    keyparam[m] = str;
                    switch (j) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            if (str.length() != 0) break block13;
                            throw new ParseException("Invalid syntax for " + str1Up + (keynot[m] ? " NOT " : " ") + str2Up, k);
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            if (str.length() <= 0) break block13;
                            throw new ParseException("Invalid syntax for " + str1Up + (keynot[m] ? " NOT " : " ") + str2Up, k);
                        }
                        case 9: 
                        case 10: 
                        case 16: {
                            break block13;
                        }
                        default: {
                            throw new ParseException("Invalid key " + str1Up + (keynot[m] ? " NOT " : " ") + str2Up, k);
                        }
                    }
                }
                default: {
                    throw new ParseException("Invalid key " + str1Up, k);
                }
            }
            ++m;
        }
        int level = 0;
        int possrc = 0;
        boolean[] keep = new boolean[16];
        boolean[] wastrue = new boolean[16];
        keep[0] = true;
        wastrue[0] = true;
        boolean latestWasElse = false;
        i = 0;
        while (i < m) {
            if (begkey[i] > possrc && keep[level]) {
                result.append(source.substring(possrc, begkey[i]));
            }
            possrc = endkey[i];
            int key = keykey[i];
            int cond = condkey[i];
            boolean mustnegate = keynot[i];
            if (key >= 101) {
                if (keep[level]) {
                    switch (key) {
                        case 101: {
                            result.append(oldVersion);
                            break;
                        }
                        case 102: {
                            result.append(newVersion);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                if ((key == 52 || key == 53 || key == 54) && level <= 0) {
                    throw new ParseException(String.valueOf(keyname[i]) + " without IF", begkey[i]);
                }
                if ((key == 52 || key == 53) && latestWasElse) {
                    throw new ParseException(String.valueOf(keyname[i]) + " after ELSE", begkey[i]);
                }
                latestWasElse = false;
                if (key == 54) {
                    --level;
                } else if (key == 51 || key == 52) {
                    boolean musteval = true;
                    if (key == 51) {
                        keep[++level] = false;
                        wastrue[level] = false;
                        if (!keep[level - 1]) {
                            musteval = false;
                        }
                    } else if (wastrue[level] || !keep[level - 1]) {
                        musteval = false;
                    }
                    keep[level] = false;
                    if (musteval) {
                        switch (cond) {
                            case 1: {
                                try {
                                    keep[level] = ConditionalParser.checkVersionMatch(oldVersion, keyparam[i]);
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 2: {
                                try {
                                    keep[level] = ConditionalParser.checkVersionMatch(newVersion, keyparam[i]);
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 11: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(oldVersion, keyparam[i]) < 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 12: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(oldVersion, keyparam[i]) <= 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 13: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(oldVersion, keyparam[i]) == 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 14: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(oldVersion, keyparam[i]) >= 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 15: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(oldVersion, keyparam[i]) > 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 16: {
                                keep[level] = keyparam[i].equals("") || keyparam[i].equals("\"\"") || keyparam[i].equals("''");
                                break;
                            }
                            case 9: {
                                keep[level] = true;
                                break;
                            }
                            case 10: {
                                keep[level] = false;
                                break;
                            }
                            case 4: {
                                String filePath;
                                try {
                                    filePath = FileUtils.createFileName(dstDir, keyparam[i]);
                                    keep[level] = filePath != null && filePath.length() > 0 && new File(filePath).exists();
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Exception at " + source.substring(begkey[i], endkey[i]) + " : " + e.toString(), begkey[i]);
                                }
                            }
                            case 3: {
                                String filePath;
                                try {
                                    filePath = null;
                                    if (!(kitAltDir == null || kitAltDir.length() <= 0 || (filePath = FileUtils.createFileName(kitAltDir, keyparam[i])) != null && filePath.length() > 0 && new File(filePath).exists())) {
                                        filePath = null;
                                    }
                                    if (filePath == null) {
                                        filePath = FileUtils.createFileName(kitDir, keyparam[i]);
                                    }
                                    keep[level] = filePath != null && filePath.length() > 0 && new File(filePath).exists();
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Exception at " + source.substring(begkey[i], endkey[i]) + " : " + e.toString(), begkey[i]);
                                }
                            }
                            case 5: {
                                try {
                                    String dstPath;
                                    String srcPath = null;
                                    if (!(kitAltDir == null || kitAltDir.length() <= 0 || (srcPath = FileUtils.createFileName(kitAltDir, keyparam[i])) != null && srcPath.length() > 0 && new File(srcPath).exists())) {
                                        srcPath = null;
                                    }
                                    if (srcPath == null) {
                                        srcPath = FileUtils.createFileName(kitDir, keyparam[i]);
                                    }
                                    keep[level] = (CheckExtFile.checkFilesPresent(srcPath, dstPath = FileUtils.createFileName(dstDir, keyparam[i])) & 0x22) != 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Exception at " + source.substring(begkey[i], endkey[i]) + " : " + e.toString(), begkey[i]);
                                }
                            }
                            case 6: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(newVersion, oldVersion) < 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 7: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(newVersion, oldVersion) == 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            case 8: {
                                try {
                                    keep[level] = ConditionalParser.compareVersions(newVersion, oldVersion) > 0;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ParseException("Invalid version specification: " + source.substring(begkey[i], endkey[i]), begkey[i]);
                                }
                            }
                            default: {
                                throw new ParseException("Unknown keyword: " + keyname[i] + " " + keyparam[i], begkey[i]);
                            }
                        }
                        if (mustnegate) {
                            boolean bl = keep[level] = !keep[level];
                        }
                        if (keep[level]) {
                            wastrue[level] = true;
                        }
                    }
                } else if (key == 53) {
                    latestWasElse = true;
                    boolean bl = keep[level] = keep[level - 1] && !wastrue[level];
                    if (keep[level]) {
                        wastrue[level] = true;
                    }
                }
            }
            ++i;
        }
        if (possrc < n && keep[level]) {
            result.append(source.substring(possrc, n));
        }
        if (level != 0) {
            throw new ParseException("Missing ENDIF", n);
        }
        return result.toString();
    }

    public static String getProperty(String key, Properties properties) {
        if (key != null && properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    public String getProperty(String key) {
        return ConditionalParser.getProperty(key, this.propobj);
    }

    public static String getPropertyParsed(String key, Properties properties, Wizard wiz, String oldVersion, String newVersion, String dstDir, String kitDir, String kitAltDir) throws ParseException {
        String source = ConditionalParser.getProperty(key, properties);
        if (source == null) {
            return null;
        }
        return (source = ConditionalParser.parseConditionalString(source, wiz, oldVersion, newVersion, dstDir, kitDir, kitAltDir)) == null || source.trim().length() == 0 ? null : source;
    }

    public String getPropertyParsed(String key) throws ParseException {
        return ConditionalParser.getPropertyParsed(key, this.propobj, this.wizard, this.oldVersionString, this.newVersionString, this.dstDirectory, this.kitDirectory, this.kitAltDirectory);
    }

    public static String getKeyFromLine(String key, String line) {
        if (line != null && key != null && (line = line.trim()).startsWith(key) && (line = line.substring(key.length()).trim()).startsWith("=")) {
            return line.substring(1).trim();
        }
        return null;
    }

    public static Vector propertyNamesAsVector(Properties properties) {
        if (properties == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            result.add((String)propNames.nextElement());
        }
        return result;
    }

    public Vector propertyNamesAsVector() {
        return ConditionalParser.propertyNamesAsVector(this.propobj);
    }

    public static Vector filterVector(Vector source, String regexp) {
        if (source == null) {
            return null;
        }
        if (regexp == null || regexp.length() == 0) {
            return (Vector)source.clone();
        }
        Vector<String> result = new Vector<String>();
        int n = source.size();
        int i = 0;
        while (i < n) {
            String element = (String)source.elementAt(i);
            try {
                if (Rex.matches(element, regexp)) {
                    result.add(element);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return result;
    }

    public static void sortStringVector(Vector vect) {
        if (vect == null) {
            return;
        }
        int nr = vect.size();
        if (nr <= 1) {
            return;
        }
        int i = 0;
        while (i < nr - 1) {
            String crtVal = (String)vect.elementAt(i);
            int crtPoz = i;
            int j = i + 1;
            while (j < nr) {
                if (crtVal != null && (vect.elementAt(j) == null || crtVal.compareTo((String)vect.elementAt(j)) > 0)) {
                    crtVal = (String)vect.elementAt(j);
                    crtPoz = j;
                }
                ++j;
            }
            if (crtPoz != i) {
                vect.setElementAt(vect.elementAt(i), crtPoz);
                vect.setElementAt(crtVal, i);
            }
            ++i;
        }
    }

    public static Properties copyProperties(Properties sourceProperties, Vector allowedKeys) {
        if (sourceProperties != null) {
            return null;
        }
        if (allowedKeys == null) {
            allowedKeys = ConditionalParser.propertyNamesAsVector(sourceProperties);
        }
        Properties result = new Properties();
        int i = 0;
        while (i < allowedKeys.size()) {
            String value;
            String key = (String)allowedKeys.elementAt(i);
            if (key != null && (value = sourceProperties.getProperty(key)) != null) {
                result.setProperty(key, value);
            }
            ++i;
        }
        return result;
    }

    public Properties parseProperties(Vector allowedKeys) throws ParseException {
        if (this.propobj == null) {
            return null;
        }
        if (allowedKeys == null) {
            allowedKeys = ConditionalParser.propertyNamesAsVector(this.propobj);
        }
        Properties result = new Properties();
        int i = 0;
        while (i < allowedKeys.size()) {
            String value;
            String key = (String)allowedKeys.elementAt(i);
            if (key != null && (value = this.getPropertyParsed(key)) != null) {
                result.setProperty(key, value);
            }
            ++i;
        }
        return result;
    }

    public Properties parseProperties() throws ParseException {
        return this.parseProperties(null);
    }
}

