/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.FileUtils;
import com.installshield.util.StringResolverException;
import com.installshield.util.StringResolverMethod;
import com.installshield.wizard.Wizard;
import java.io.File;

public class DstFileResolverMethod
extends StringResolverMethod {
    private Wizard wizard = null;

    public DstFileResolverMethod() {
        throw new Error("This string resolver method cannot be added at buildtime. It must be added at runtime by the wizard.");
    }

    public DstFileResolverMethod(Wizard wiz) {
        this.wizard = wiz;
    }

    public String getName() {
        return "DSTFILE";
    }

    public String invoke(String[] args) {
        try {
            return this.invokeWithValidation(args);
        }
        catch (StringResolverException ex) {
            return "";
        }
    }

    public String invokeWithValidation(String[] args) throws StringResolverException {
        if (args.length != 1) {
            throw new StringResolverException("ERROR: expected 1 argument for '" + this.getName() + "' method");
        }
        String fileName = args[0];
        String dstDir = null;
        ProductService productservice = null;
        if (!new File(fileName).isAbsolute()) {
            try {
                productservice = (ProductService)this.wizard.getServices().getService("productService");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (productservice == null) {
                throw new StringResolverException("ERROR: ProductService not available");
            }
            try {
                dstDir = (String)productservice.getProductBeanProperty("/product.xml", null, "absoluteInstallLocation");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dstDir == null || dstDir.trim().length() == 0) {
                throw new StringResolverException("ERROR: Cannot find out destination directory for '" + this.getName() + "' method");
            }
        }
        return FileUtils.createFileName(dstDir, fileName);
    }
}

