/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ActionTimeBasedPercentEstimator;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.file.FileService;
import java.io.File;

public class EarWarXmlModify {
    protected String javaBinDir = null;
    protected FileService fileService = null;

    public EarWarXmlModify(FileService fileService, String javaBinDir) {
        this.fileService = fileService;
        this.javaBinDir = ICAStringUtils.removeLastSlash(ICAStringUtils.goodSlashes(javaBinDir));
    }

    public String execute(String earFullPath, String[] warFileName, String xmlFileName, boolean replace, String sourceFullPath, Object[] parameters, ActionTimeBasedPercentEstimator estimator) {
        int sleepInterval = 200;
        ProcUtl proc = new ProcUtl();
        String errorMessage = null;
        String[] extrFileName = null;
        String tempDir = null;
        String jarFullPath = String.valueOf(this.javaBinDir) + File.separator + "jar";
        StringBuffer sb = new StringBuffer();
        String cdCommand = null;
        String command = null;
        String tempDirWithSlash = null;
        int retval = 0;
        boolean cont = true;
        try {
            if (earFullPath != null && new File(earFullPath).exists()) {
                if (warFileName == null) {
                    warFileName = new String[]{};
                }
                extrFileName = new String[warFileName.length + 1];
                System.arraycopy(warFileName, 0, extrFileName, 0, warFileName.length);
                extrFileName[warFileName.length] = xmlFileName;
                tempDir = FileUtils.createTempDir();
                tempDirWithSlash = String.valueOf(ICAStringUtils.removeLastSlash(ICAStringUtils.goodSlashes(tempDir))) + File.separator;
                cdCommand = ICAStringUtils.isWindows() ? "cd /D " + ICAStringUtils.quoteOrUnquote(tempDir) + " && " : "cd " + ICAStringUtils.quoteOrUnquote(tempDir) + " && ";
                command = String.valueOf(cdCommand) + ICAStringUtils.quoteOrUnquote(jarFullPath) + " -xf " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashes(earFullPath)) + " " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashesUnix(extrFileName[0]));
                retval = proc.system(command, false, null, sb, sb);
                if (estimator != null) {
                    while (proc.isProcessRunning()) {
                        estimator.updateOperationState();
                        estimator.sleep(sleepInterval);
                    }
                }
                if ((retval = proc.waitForProcess()) != 0) {
                    errorMessage = sb.toString();
                    cont = false;
                }
                int i = 0;
                while (i < extrFileName.length - 1) {
                    if (errorMessage != null || !new File(String.valueOf(tempDirWithSlash) + extrFileName[i]).exists()) {
                        cont = false;
                        break;
                    }
                    command = String.valueOf(cdCommand) + ICAStringUtils.quoteOrUnquote(jarFullPath) + " -xf " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashes(extrFileName[i])) + " " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashesUnix(extrFileName[i + 1]));
                    retval = proc.system(command, false, null, sb, sb);
                    if (estimator != null) {
                        while (proc.isProcessRunning()) {
                            estimator.updateOperationState();
                            estimator.sleep(sleepInterval);
                        }
                    }
                    if ((retval = proc.waitForProcess()) != 0) {
                        errorMessage = sb.toString();
                    }
                    ++i;
                }
                if (errorMessage == null && cont) {
                    if (estimator != null) {
                        estimator.updateOperationState();
                    }
                    String xmlFileFullPath = String.valueOf(tempDirWithSlash) + ICAStringUtils.goodSlashes(xmlFileName);
                    if (replace && sourceFullPath != null && new File(sourceFullPath).exists()) {
                        errorMessage = this.copyXmlFile(this.fileService, tempDir, xmlFileFullPath, sourceFullPath);
                    }
                    if (errorMessage == null && parameters != null && new File(xmlFileFullPath).exists()) {
                        errorMessage = this.modifyXmlFile(this.fileService, this.javaBinDir, tempDir, xmlFileFullPath, parameters);
                    }
                    if (errorMessage != null || !new File(xmlFileFullPath).exists()) {
                        cont = false;
                    }
                }
                i = extrFileName.length - 2;
                while (i >= 0) {
                    if (errorMessage == null && cont) {
                        command = String.valueOf(cdCommand) + ICAStringUtils.quoteOrUnquote(jarFullPath) + " -uf " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashes(extrFileName[i])) + " " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashesUnix(extrFileName[i + 1]));
                        retval = proc.system(command, false, null, sb, sb);
                        if (estimator != null) {
                            while (proc.isProcessRunning()) {
                                estimator.updateOperationState();
                                estimator.sleep(sleepInterval);
                            }
                        }
                        if ((retval = proc.waitForProcess()) != 0) {
                            errorMessage = sb.toString();
                        }
                    }
                    --i;
                }
                if (errorMessage == null && cont) {
                    command = String.valueOf(cdCommand) + ICAStringUtils.quoteOrUnquote(jarFullPath) + " -uf " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashes(earFullPath)) + " " + ICAStringUtils.quoteOrUnquote(ICAStringUtils.goodSlashesUnix(extrFileName[0]));
                    retval = proc.system(command, true, null, sb, sb);
                    if (estimator != null) {
                        while (proc.isProcessRunning()) {
                            estimator.updateOperationState();
                            estimator.sleep(sleepInterval);
                        }
                    }
                    if ((retval = proc.waitForProcess()) != 0) {
                        errorMessage = sb.toString();
                    } else if (estimator != null) {
                        estimator.updateOperationState();
                    }
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.toString();
        }
        if (tempDir != null) {
            if (extrFileName != null) {
                int i = extrFileName.length - 1;
                while (i >= 0) {
                    try {
                        String toDelete = ICAStringUtils.goodSlashes(extrFileName[i]);
                        while (toDelete != null && toDelete.length() > 0 && new File(String.valueOf(tempDirWithSlash) + toDelete).exists()) {
                            int j;
                            if (new File(String.valueOf(tempDirWithSlash) + toDelete).delete() && (j = toDelete.lastIndexOf(File.separator)) >= 0) {
                                toDelete = toDelete.substring(0, j);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --i;
                }
            }
            FileUtils.deleteTempFile(tempDir);
        }
        if (estimator != null && errorMessage == null) {
            estimator.updateOperationState();
        }
        return errorMessage;
    }

    public String execute(String earFullPath, String[] warFileName, String xmlFileName, Object[] parameters, ActionTimeBasedPercentEstimator estimator) {
        return this.execute(earFullPath, warFileName, xmlFileName, false, null, parameters, estimator);
    }

    public String execute(String earFullPath, String[] warFileName, String xmlFileName, Object[] parameters) {
        return this.execute(earFullPath, warFileName, xmlFileName, parameters, null);
    }

    public String execute(String earFullPath, String warFileName, String xmlFileName, Object[] parameters, ActionTimeBasedPercentEstimator estimator) {
        String[] stringArray;
        if (warFileName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = warFileName;
        } else {
            stringArray = new String[]{};
        }
        return this.execute(earFullPath, stringArray, xmlFileName, parameters, estimator);
    }

    public String execute(String earFullPath, String warFileName, String xmlFileName, Object[] parameters) {
        String[] stringArray;
        if (warFileName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = warFileName;
        } else {
            stringArray = new String[]{};
        }
        return this.execute(earFullPath, stringArray, xmlFileName, parameters);
    }

    public String execute(String earFullPath, String xmlFileName, Object[] parameters) {
        return this.execute(earFullPath, new String[0], xmlFileName, parameters);
    }

    public String replace(String earFullPath, String[] warFileName, String xmlFileName, String sourceFullPath, ActionTimeBasedPercentEstimator estimator) {
        return this.execute(earFullPath, warFileName, xmlFileName, true, sourceFullPath, null, estimator);
    }

    public String replace(String earFullPath, String[] warFileName, String xmlFileName, String sourceFullPath) {
        return this.replace(earFullPath, warFileName, xmlFileName, sourceFullPath, null);
    }

    public String replace(String earFullPath, String warFileName, String xmlFileName, String sourceFullPath, ActionTimeBasedPercentEstimator estimator) {
        String[] stringArray;
        if (warFileName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = warFileName;
        } else {
            stringArray = new String[]{};
        }
        return this.replace(earFullPath, stringArray, xmlFileName, sourceFullPath, estimator);
    }

    public String replace(String earFullPath, String warFileName, String xmlFileName, String sourceFullPath) {
        String[] stringArray;
        if (warFileName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = warFileName;
        } else {
            stringArray = new String[]{};
        }
        return this.replace(earFullPath, stringArray, xmlFileName, sourceFullPath);
    }

    public String replace(String earFullPath, String xmlFileName, String sourceFullPath) {
        return this.replace(earFullPath, new String[0], xmlFileName, sourceFullPath);
    }

    protected String copyXmlFile(FileService fileService, String tempDir, String xmlFile, String sourceFile) {
        try {
            String parent = fileService.getParent(xmlFile);
            if (parent != null && !fileService.fileExists(parent)) {
                fileService.createDirectory(parent);
            }
            fileService.copyFile(sourceFile, xmlFile, true);
        }
        catch (Exception e) {
            return e.toString();
        }
        return null;
    }

    protected String modifyXmlFile(FileService fileService, String javaBinDir, String tempDir, String xmlFile, Object[] params) {
        return null;
    }
}

