/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAStringUtils;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;

public class ICAInstGlobals {
    private static Wizard wizard = null;

    public static void setWizard(Object obj) {
        if (obj != null) {
            if (obj instanceof WizardBean) {
                wizard = ((WizardBean)obj).getWizard();
            } else if (obj instanceof Wizard) {
                wizard = (Wizard)obj;
            }
        }
    }

    public static Wizard getWizard() {
        return wizard;
    }

    public static WizardServices getServices() {
        return ICAInstGlobals.getWizard().getServices();
    }

    public static Service getService(String serviceName) throws ServiceException {
        return ICAInstGlobals.getWizard().getServices().getService(serviceName);
    }

    public static FileService getFileService() {
        try {
            return (FileService)ICAInstGlobals.getService("fileService");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static SystemUtilService getSystemUtilService() {
        try {
            return (SystemUtilService)ICAInstGlobals.getService("systemUtilService");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static void setValue(String key, Object value) {
        ICAInstGlobals.getWizard().getServices().setValue(key, value);
    }

    public static Object getValueNull(String key) {
        return ICAInstGlobals.getWizard().getServices().getValue(key);
    }

    public static Object getValue(String key) {
        Object rez = ICAInstGlobals.getWizard().getServices().getValue(key);
        if (rez == null) {
            throw new NullPointerException("ICAInstGlobals.getValue(" + key + ")");
        }
        return rez;
    }

    public static Object getValue(String key, Object defaultVal) {
        Object obj = ICAInstGlobals.getValueNull(key);
        return obj != null ? obj : defaultVal;
    }

    public static void setString(String key, String value) {
        ICAInstGlobals.setValue(key, value);
    }

    public static void setInt(String key, int value) {
        ICAInstGlobals.setValue(key, new Integer(value));
    }

    public static void setLong(String key, long value) {
        ICAInstGlobals.setValue(key, new Long(value));
    }

    public static void setDouble(String key, double value) {
        ICAInstGlobals.setValue(key, new Double(value));
    }

    public static void setBoolean(String key, boolean value) {
        ICAInstGlobals.setValue(key, new Boolean(value));
    }

    public static String getString(String key) {
        Object obj = ICAInstGlobals.getValue(key);
        return obj instanceof String ? (String)obj : obj.toString();
    }

    public static String getString(String key, String defaultVal) {
        Object obj = ICAInstGlobals.getValueNull(key);
        if (obj == null) {
            return defaultVal;
        }
        return obj instanceof String ? (String)obj : obj.toString();
    }

    public static int getInt(String key) {
        Object obj = ICAInstGlobals.getValue(key);
        return obj instanceof String ? Integer.parseInt((String)obj) : ((Number)obj).intValue();
    }

    public static int getInt(String key, int defaultVal) {
        Object obj = ICAInstGlobals.getValueNull(key);
        if (obj == null) {
            return defaultVal;
        }
        return obj instanceof String ? Integer.parseInt((String)obj) : ((Number)obj).intValue();
    }

    public static long getLong(String key) {
        Object obj = ICAInstGlobals.getValue(key);
        return obj instanceof String ? Long.parseLong((String)obj) : ((Number)obj).longValue();
    }

    public static long getLong(String key, long defaultVal) {
        Object obj = ICAInstGlobals.getValueNull(key);
        if (obj == null) {
            return defaultVal;
        }
        return obj instanceof String ? Long.parseLong((String)obj) : ((Number)obj).longValue();
    }

    public static double getDouble(String key) {
        Object obj = ICAInstGlobals.getValue(key);
        return obj instanceof String ? Double.parseDouble((String)obj) : ((Number)obj).doubleValue();
    }

    public static double getDouble(String key, double defaultVal) {
        Object obj = ICAInstGlobals.getValueNull(key);
        if (obj == null) {
            return defaultVal;
        }
        return obj instanceof String ? Double.parseDouble((String)obj) : ((Number)obj).doubleValue();
    }

    public static boolean getBoolean(String key) {
        Object obj = ICAInstGlobals.getValue(key);
        if (obj instanceof String) {
            String val = (String)obj;
            if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("t") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("1")) {
                return true;
            }
            if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("f") || val.equalsIgnoreCase("n") || val.equalsIgnoreCase("0")) {
                return false;
            }
        }
        return (Boolean)obj;
    }

    public static boolean getBoolean(String key, boolean defaultVal) {
        Object obj = ICAInstGlobals.getValueNull(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof String) {
            String val = (String)obj;
            if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("t") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("1")) {
                return true;
            }
            if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("f") || val.equalsIgnoreCase("n") || val.equalsIgnoreCase("0")) {
                return false;
            }
            return defaultVal;
        }
        return (Boolean)obj;
    }

    public static String replaceDblBSlash(String source) {
        if (source == null) {
            return null;
        }
        int p = source.indexOf("\\\\");
        if (p < 0) {
            return source;
        }
        String rez = source;
        while (p >= 0) {
            if (++p >= (rez = String.valueOf(rez.substring(0, p + 1)) + rez.substring(p + 2)).length()) break;
            p = rez.indexOf("\\\\", p);
        }
        return rez;
    }

    public static String replaceBSlash(String source) {
        if (source == null) {
            return null;
        }
        return source.replace('\\', '/');
    }

    public static String getSearchedFilePath(String fileName) {
        String[] searchDirs = null;
        String instAltDir = ICAInstGlobals.getString("InstallerAltDirectory", "").trim();
        String instDir = ICAInstGlobals.getString("InstallerDirectory", "").trim();
        searchDirs = instAltDir.length() > 0 ? new String[]{instAltDir, instDir} : new String[]{instDir};
        return ICAStringUtils.getSearchedFilePath(fileName, searchDirs);
    }
}

