/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAStringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class ICAProfileParser {
    public static final int BEFOREFIRSTREF = -1;
    public static final int AFTERLASTREF = -2;
    public static final int NOPREFERENCE = -3;
    protected static final int MULTIPLIER = 32768;
    protected boolean caseSensitive = false;
    protected char delimiter = (char)61;
    protected String encoding = null;
    protected boolean equivSlashes = true;
    protected boolean xmlStyleSections = false;
    protected boolean stanzaStyleSections = false;
    protected String[] commentArray = null;
    protected boolean commentInsteadOfDelete = false;
    protected int uncommentInsteadOfInsert = 0;

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean cs) {
        this.caseSensitive = cs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delim) {
        switch (delim) {
            case '\t': 
            case ' ': 
            case ',': 
            case ':': 
            case ';': 
            case '=': {
                this.delimiter = delim;
            }
        }
    }

    public boolean isEquivSlashes() {
        return this.equivSlashes;
    }

    public void setEquivSlashes(boolean eqvSlashes) {
        this.equivSlashes = eqvSlashes;
    }

    public void setXmlStyleSections(boolean xmlStyleSect) {
        this.xmlStyleSections = xmlStyleSect;
    }

    public void setStanzaStyleSections(boolean stanzaStyleSect) {
        this.stanzaStyleSections = stanzaStyleSect;
    }

    public boolean usesNormalStyleSections() {
        return !this.xmlStyleSections && !this.stanzaStyleSections;
    }

    public boolean usesXmlStyleSections() {
        return this.xmlStyleSections;
    }

    public boolean usesStanzaStyleSections() {
        return this.stanzaStyleSections && !this.xmlStyleSections;
    }

    public String[] getCommentArray() {
        return (String[])this.commentArray.clone();
    }

    public void setCommentArray(String[] comArray) {
        int j = 0;
        if (comArray != null && comArray.length > 0) {
            comArray = (String[])comArray.clone();
            int i = 0;
            while (i < comArray.length) {
                if (comArray[i] != null && comArray[i].trim().length() > 0) {
                    comArray[j++] = comArray[i].trim();
                }
                ++i;
            }
        }
        if (j > 0) {
            this.commentArray = new String[j];
            System.arraycopy(comArray, 0, this.commentArray, 0, j);
        } else {
            this.commentArray = null;
        }
    }

    public String getCommentChars() {
        if (this.commentArray != null && this.commentArray.length > 0) {
            return this.commentArray[0];
        }
        return null;
    }

    public void setCommentChars(String com) {
        this.commentArray = com != null && com.trim().length() > 0 ? new String[]{com.trim()} : null;
    }

    public boolean getCommentInsteadOfDelete() {
        return this.commentInsteadOfDelete;
    }

    public void setCommentInsteadOfDelete(boolean useComment) {
        this.commentInsteadOfDelete = useComment;
    }

    public int getUncommentInsteadOfInsert() {
        return this.uncommentInsteadOfInsert;
    }

    public void setUncommentInsteadOfInsert(int useUncomment) {
        if (useUncomment < 0) {
            useUncomment = 0;
        }
        if (useUncomment > 2) {
            useUncomment = 2;
        }
        this.uncommentInsteadOfInsert = useUncomment;
    }

    public boolean isLineCommented(String line, boolean alreadyTrimmed) {
        if (this.commentArray != null && this.commentArray.length > 0 && line != null) {
            if (!alreadyTrimmed) {
                line = line.trim();
            }
            int i = 0;
            while (i < this.commentArray.length) {
                if (line.startsWith(this.commentArray[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isLineCommented(String line) {
        return this.isLineCommented(line, false);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "").toUpperCase().startsWith("WINDOWS");
    }

    public ICAProfileParser() {
        this.caseSensitive = !ICAProfileParser.isWindows();
        this.encoding = null;
        this.delimiter = (char)61;
    }

    public ICAProfileParser(boolean xmlStyleSect, char delim, boolean cs, String enc) {
        this.xmlStyleSections = xmlStyleSect;
        this.caseSensitive = cs;
        this.encoding = enc;
        this.setDelimiter(delim);
    }

    public ICAProfileParser(boolean xmlStyleSect, char delim, String enc) {
        this.xmlStyleSections = xmlStyleSect;
        this.setDelimiter(delim);
        this.encoding = enc;
    }

    public ICAProfileParser(boolean xmlStyleSect, char delim, boolean cs) {
        this.xmlStyleSections = xmlStyleSect;
        this.setDelimiter(delim);
        this.caseSensitive = cs;
    }

    public ICAProfileParser(boolean cs, String enc) {
        this.caseSensitive = cs;
        this.encoding = enc;
        this.delimiter = (char)61;
    }

    public ICAProfileParser(String enc, boolean cs) {
        this.caseSensitive = cs;
        this.encoding = enc;
        this.delimiter = (char)61;
    }

    public ICAProfileParser(boolean xmlStyleSect, char delim) {
        this.xmlStyleSections = xmlStyleSect;
        this.setDelimiter(delim);
    }

    public ICAProfileParser(boolean cs) {
        this.caseSensitive = cs;
        this.encoding = null;
        this.delimiter = (char)61;
    }

    public ICAProfileParser(String enc) {
        this.encoding = enc;
    }

    public static boolean eqvStrings(String str1, String str2, boolean caseSensitive, boolean equivSlashes) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null && str2 == null || str1 == null && str2 != null) {
            return false;
        }
        if (equivSlashes) {
            str1 = str1.replace('\\', '/');
            str2 = str2.replace('\\', '/');
        }
        return caseSensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
    }

    protected boolean eqvStrings(String str1, String str2) {
        return ICAProfileParser.eqvStrings(str1, str2, this.caseSensitive, this.equivSlashes);
    }

    protected boolean eqvStringArrays(String[] strArray1, String[] strArray2) {
        int l2;
        int l1 = strArray1 == null ? 0 : strArray1.length;
        int n = l2 = strArray2 == null ? 0 : strArray2.length;
        if (l1 == 0 && l2 == 0) {
            return true;
        }
        if (l1 != l2) {
            return false;
        }
        int i = 0;
        while (i < l1) {
            if (!this.eqvStrings(strArray1[i], strArray2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean eqvStrings(String[] strArray1, String str2) {
        int l2;
        int l1 = strArray1 == null ? 0 : strArray1.length;
        int n = l2 = str2 == null ? 0 : 1;
        if (l1 == 0 && l2 == 0) {
            return true;
        }
        if (l1 > 0 && l2 == 0 || l1 == 0 && l2 > 0) {
            return false;
        }
        if (l1 == 1) {
            return this.eqvStrings(strArray1[0], str2);
        }
        StringTokenizer sttok = new StringTokenizer(str2);
        if (sttok.countTokens() != l1) {
            return false;
        }
        String[] strArray2 = new String[l1];
        int i = 0;
        while (i < l1) {
            strArray2[i] = sttok.nextToken();
            ++i;
        }
        return this.eqvStringArrays(strArray1, strArray2);
    }

    protected int getProfileLinePoz(String[] source, String section, String key, int startingAt, boolean stopAtFirstMatch) {
        if (source == null || source.length == 0 || section != null && section.trim().length() == 0 || key == null || key.trim().length() == 0) {
            return -1;
        }
        if (section != null) {
            section = section.trim();
        }
        key = key.trim();
        StringTokenizer keyTokenizer = new StringTokenizer(key);
        int nrKeys = keyTokenizer.countTokens();
        String[] keyTokens = new String[nrKeys];
        int j = 0;
        while (keyTokenizer.hasMoreTokens()) {
            keyTokens[j] = keyTokenizer.nextToken();
            ++j;
        }
        String[] crtKeyTokens = new String[nrKeys];
        int nrSect = 0;
        String[] sectTokens = null;
        if (section != null) {
            keyTokenizer = new StringTokenizer(section);
            nrSect = keyTokenizer.countTokens();
            sectTokens = new String[nrSect];
            int j2 = 0;
            while (j2 < nrSect) {
                sectTokens[j2] = keyTokenizer.nextToken();
                ++j2;
            }
        }
        int rez = -1;
        int nr = source.length;
        String crtSect = null;
        int sectLevel = 0;
        boolean goodSect = section == null;
        int i = 0;
        while (i < nr) {
            block30: {
                int pozVal;
                block29: {
                    String line;
                    block32: {
                        int poz;
                        block31: {
                            int lngth;
                            line = source[i];
                            if (line == null || (lngth = (line = line.trim()).length()) == 0) break block30;
                            if (this.isLineCommented(line, true) || !(this.usesNormalStyleSections() && line.startsWith("[") || this.usesXmlStyleSections() && line.startsWith("<")) && (!this.usesStanzaStyleSections() || !line.endsWith(":"))) break block31;
                            poz = this.usesStanzaStyleSections() ? line.length() - 1 : line.indexOf(this.usesXmlStyleSections() ? 62 : 93);
                            if (poz >= 0) {
                                if (section == null && !this.usesXmlStyleSections()) {
                                    return rez;
                                }
                                String tmpString = line.substring(this.usesStanzaStyleSections() ? 0 : 1, poz).trim();
                                if (this.usesXmlStyleSections()) {
                                    if (tmpString.startsWith("/")) {
                                        if (sectLevel > 0) {
                                            --sectLevel;
                                        }
                                        if (sectLevel == 0) {
                                            crtSect = null;
                                        }
                                    } else {
                                        if (sectLevel == 0) {
                                            crtSect = tmpString;
                                        }
                                        ++sectLevel;
                                    }
                                } else {
                                    sectLevel = 1;
                                    crtSect = tmpString;
                                }
                                goodSect = this.eqvStrings(sectTokens, crtSect);
                            }
                            break block30;
                        }
                        if (!goodSect || i < startingAt) break block30;
                        pozVal = -1;
                        if (this.delimiter == ' ' || this.delimiter == '\t') break block32;
                        poz = line.indexOf(this.delimiter);
                        if (poz < 0) break block30;
                        String crtKey = line.substring(0, poz).trim();
                        if (nrKeys == 1) {
                            if (this.eqvStrings(key, crtKey)) {
                                pozVal = poz + 1;
                            }
                        } else {
                            keyTokenizer = new StringTokenizer(crtKey);
                            if (keyTokenizer.countTokens() == nrKeys) {
                                int j3 = 0;
                                while (j3 < nrKeys) {
                                    String crtKeyToken = keyTokenizer.nextToken();
                                    if (this.eqvStrings(keyTokens[j3], crtKeyToken)) {
                                        if (j3 == nrKeys - 1) {
                                            pozVal = poz + 1;
                                        }
                                        ++j3;
                                        continue;
                                    }
                                    break block29;
                                }
                            }
                        }
                        break block29;
                    }
                    keyTokenizer = new StringTokenizer(line);
                    int j4 = 0;
                    while (j4 < nrKeys) {
                        String crtKeyToken;
                        if (!keyTokenizer.hasMoreTokens() || !this.eqvStrings(keyTokens[j4], crtKeyToken = keyTokenizer.nextToken())) break;
                        crtKeyTokens[j4] = crtKeyToken;
                        if (j4 == nrKeys - 1) {
                            pozVal = 0;
                        }
                        ++j4;
                    }
                    if (pozVal >= 0) {
                        j4 = 0;
                        while (j4 < nrKeys) {
                            if ((pozVal = line.indexOf(crtKeyTokens[j4], pozVal)) >= 0) {
                                pozVal += crtKeyTokens[j4].length();
                                ++j4;
                                continue;
                            }
                            break;
                        }
                    }
                }
                if (pozVal >= 0) {
                    rez = i * 32768 + pozVal;
                    if (stopAtFirstMatch) {
                        return rez;
                    }
                }
            }
            ++i;
        }
        return rez;
    }

    public int getProfileLine(String[] source, String section, String key, boolean stopAtFirstMatch) {
        int rez = this.getProfileLinePoz(source, section, key, 0, stopAtFirstMatch);
        return rez < 0 ? -1 : rez / 32768;
    }

    public int getProfileLine(String[] source, String section, String key) {
        return this.getProfileLine(source, section, key, false);
    }

    public String getProfileString(String[] source, String section, String key, String defval) {
        int rez = this.getProfileLinePoz(source, section, key, 0, false);
        if (rez < 0) {
            return defval;
        }
        int lineNr = rez / 32768;
        int pozVal = rez - lineNr * 32768;
        String line = source[lineNr];
        line = line.trim();
        String val = line.substring(pozVal).trim();
        return val;
    }

    protected String[] addElement(String[] source, String section, String key, String val, int latestGood, int iline, boolean goodSect) {
        if (val == null) {
            return source;
        }
        String[] additionalLines = null;
        if (!goodSect && latestGood >= 0) {
            iline = latestGood;
            goodSect = true;
        }
        while (iline > 0 && (source[iline - 1] == null || source[iline - 1].trim().length() == 0)) {
            --iline;
        }
        additionalLines = new String[4];
        int nrAdditional = 0;
        if (section != null && !goodSect) {
            if (iline > 0) {
                additionalLines[nrAdditional++] = "";
            }
            additionalLines[nrAdditional++] = this.usesXmlStyleSections() ? "<" + section + ">" : (this.usesStanzaStyleSections() ? String.valueOf(section) + ":" : "[" + section + "]");
        }
        additionalLines[nrAdditional++] = String.valueOf(key) + this.delimiter + (val.trim().equals(val) ? val : "\"" + val + "\"");
        if (nrAdditional > 1 && this.usesXmlStyleSections()) {
            StringTokenizer sttok = new StringTokenizer(section);
            String sectFirstWord = sttok.nextToken();
            additionalLines[nrAdditional++] = "</" + sectFirstWord + ">";
        }
        String[] rez = new String[source.length + nrAdditional];
        if (iline > 0) {
            System.arraycopy(source, 0, rez, 0, iline);
        }
        System.arraycopy(additionalLines, 0, rez, iline, nrAdditional);
        if (iline < source.length) {
            System.arraycopy(source, iline, rez, iline + nrAdditional, source.length - iline);
        }
        return rez;
    }

    protected String[] removeElement(String[] source, int iline) {
        if (iline < 0 || iline >= source.length) {
            return source;
        }
        if (this.commentInsteadOfDelete && this.commentArray != null && this.commentArray.length > 0) {
            source = (String[])source.clone();
            source[iline] = String.valueOf(this.commentArray[0]) + source[iline];
            return source;
        }
        String[] rez = new String[source.length - 1];
        if (iline > 0) {
            System.arraycopy(source, 0, rez, 0, iline);
        }
        if (iline < source.length - 1) {
            System.arraycopy(source, iline + 1, rez, iline, source.length - iline - 1);
        }
        return rez;
    }

    public String[] setProfileString(String[] source, String section, String key, String val) {
        String lineOrig;
        if (source == null) {
            source = new String[]{};
        }
        if (section != null && section.trim().length() == 0 || key == null || key.trim().length() == 0) {
            return source;
        }
        if (section != null) {
            section = section.trim();
        }
        key = key.trim();
        int lineNr = -1;
        if (val == null) {
            while ((lineNr = this.getProfileLine(source, section, key, true)) >= 0) {
                source = this.removeElement(source, lineNr);
            }
            return source;
        }
        lineNr = this.getProfileLine(source, section, key);
        if (lineNr < 0 && this.uncommentInsteadOfInsert > 0 && this.commentArray != null && this.commentArray.length > 0) {
            int sourceLength = source.length;
            int iiCommArray = -1;
            String unquotedVal = ICAProfileParser.unquote(val);
            int ii = 0;
            while (ii < this.commentArray.length) {
                int jj = 0;
                while (jj < 2) {
                    int locLinePoz;
                    int locLine = -1;
                    String commKey = String.valueOf(this.commentArray[ii]) + (jj == 0 ? "" : " ") + key;
                    while ((locLinePoz = this.getProfileLinePoz(source, section, commKey, locLine + 1, true)) >= 0) {
                        locLine = locLinePoz / 32768;
                        int locPoz = locLinePoz - locLine * 32768;
                        if (ICAProfileParser.unquote(source[locLine].trim().substring(locPoz).trim()).equals(unquotedVal)) {
                            locLine += sourceLength;
                        }
                        if (locLine <= lineNr) continue;
                        lineNr = locLine;
                        iiCommArray = ii;
                    }
                    ++jj;
                }
                ++ii;
            }
            if (this.uncommentInsteadOfInsert == 1 && lineNr >= sourceLength || this.uncommentInsteadOfInsert == 2 && lineNr >= 0) {
                if (lineNr >= sourceLength) {
                    lineNr -= sourceLength;
                }
                source = (String[])source.clone();
                int poz = source[lineNr].indexOf(this.commentArray[iiCommArray]);
                source[lineNr] = String.valueOf(source[lineNr].substring(0, poz)) + source[lineNr].substring(poz + this.commentArray[iiCommArray].length());
            } else {
                lineNr = -1;
            }
        }
        StringTokenizer keyTokenizer = new StringTokenizer(key);
        int nrKeys = keyTokenizer.countTokens();
        String[] keyTokens = new String[nrKeys];
        int j = 0;
        while (keyTokenizer.hasMoreTokens()) {
            keyTokens[j] = keyTokenizer.nextToken();
            ++j;
        }
        String[] crtKeyTokens = new String[nrKeys];
        if (lineNr >= 0 && (lineOrig = source[lineNr]) != null) {
            int poz;
            int lngth = lineOrig.length();
            String line = lineOrig;
            if (lngth > 0 && line.charAt(lngth - 1) == '\n') {
                line = line.substring(0, --lngth);
            }
            if (lngth > 0 && line.charAt(lngth - 1) == '\r') {
                line = line.substring(0, --lngth);
            }
            int lngthLineOrig = lngth;
            line = line.trim();
            lngth = line.length();
            int pozVal = -1;
            if (this.delimiter != ' ' && this.delimiter != '\t') {
                poz = line.indexOf(this.delimiter);
                if (poz >= 0) {
                    String crtKey = line.substring(0, poz).trim();
                    if (nrKeys == 1) {
                        if (this.eqvStrings(key, crtKey)) {
                            pozVal = poz + 1;
                        }
                    } else {
                        keyTokenizer = new StringTokenizer(crtKey);
                        if (keyTokenizer.countTokens() == nrKeys) {
                            int j2 = 0;
                            while (j2 < nrKeys) {
                                String crtKeyToken = keyTokenizer.nextToken();
                                if (this.eqvStrings(keyTokens[j2], crtKeyToken)) {
                                    if (j2 == nrKeys - 1) {
                                        pozVal = poz + 1;
                                    }
                                    ++j2;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
            } else {
                keyTokenizer = new StringTokenizer(line);
                int j3 = 0;
                while (j3 < nrKeys) {
                    String crtKeyToken;
                    if (!keyTokenizer.hasMoreTokens() || !this.eqvStrings(keyTokens[j3], crtKeyToken = keyTokenizer.nextToken())) break;
                    crtKeyTokens[j3] = crtKeyToken;
                    if (j3 == nrKeys - 1) {
                        pozVal = 0;
                    }
                    ++j3;
                }
                if (pozVal >= 0) {
                    j3 = 0;
                    while (j3 < nrKeys) {
                        if ((pozVal = line.indexOf(crtKeyTokens[j3], pozVal)) >= 0) {
                            pozVal += crtKeyTokens[j3].length();
                            ++j3;
                            continue;
                        }
                        break;
                    }
                }
            }
            if (pozVal >= 0) {
                String valOld = line.substring(pozVal).trim();
                if (!val.trim().equals(val)) {
                    val = "\"" + val + "\"";
                }
                if (valOld.equals(val)) {
                    return source;
                }
                String lineFirstPart = line.substring(0, pozVal);
                poz = lineOrig.indexOf(lineFirstPart);
                poz += lineFirstPart.length();
                if (valOld.length() > 0) {
                    poz = lineOrig.indexOf(valOld, poz);
                }
                int lngValOld = lngthLineOrig - poz;
                lineOrig = String.valueOf(lineOrig.substring(0, poz)) + ((this.delimiter == ' ' || this.delimiter == '\t') && valOld.length() == 0 && val.length() > 0 ? String.valueOf(this.delimiter) : "") + val + lineOrig.substring(poz + lngValOld);
                source = (String[])source.clone();
                source[lineNr] = lineOrig;
                return source;
            }
        }
        int nrSect = 0;
        String[] sectTokens = null;
        if (section != null) {
            keyTokenizer = new StringTokenizer(section);
            nrSect = keyTokenizer.countTokens();
            sectTokens = new String[nrSect];
            int j4 = 0;
            while (j4 < nrSect) {
                sectTokens[j4] = keyTokenizer.nextToken();
                ++j4;
            }
        }
        int nr = source.length;
        int latestGood = -1;
        String crtSect = null;
        int sectLevel = 0;
        boolean goodSect = section == null;
        int i = 0;
        while (i < nr) {
            int poz;
            int lngth;
            String line = source[i];
            if (line != null && (lngth = (line = line.trim()).length()) != 0 && !this.isLineCommented(line, true) && (this.usesNormalStyleSections() && line.startsWith("[") || this.usesXmlStyleSections() && line.startsWith("<") || this.usesStanzaStyleSections() && line.endsWith(":")) && (poz = this.usesStanzaStyleSections() ? line.length() - 1 : line.indexOf(this.usesXmlStyleSections() ? 62 : 93)) >= 0) {
                if (section == null && !this.usesXmlStyleSections()) {
                    return this.addElement(source, section, key, val, latestGood, i, goodSect);
                }
                String tmpString = line.substring(this.usesStanzaStyleSections() ? 0 : 1, poz).trim();
                if (this.usesXmlStyleSections()) {
                    if (tmpString.startsWith("/")) {
                        if (sectLevel > 0) {
                            --sectLevel;
                        }
                        if (sectLevel == 0) {
                            crtSect = null;
                        }
                    } else {
                        if (sectLevel == 0) {
                            crtSect = tmpString;
                        }
                        ++sectLevel;
                    }
                } else {
                    sectLevel = 1;
                    crtSect = tmpString;
                }
                if (goodSect) {
                    latestGood = i;
                }
                goodSect = this.eqvStrings(sectTokens, crtSect);
            }
            ++i;
        }
        return this.addElement(source, section, key, val, latestGood, nr, goodSect);
    }

    /*
     * Unable to fully structure code
     */
    public static String[] readAsciiFile(String fileName, boolean ignoreFileNotFound, String enc) throws IOException {
        if (fileName == null) {
            return null;
        }
        fis = null;
        isr = null;
        reader = null;
        line = null;
        vectLines = new Vector<String>(80, 10);
        try {
            fis = new FileInputStream(fileName);
            isr = enc == null || enc.trim().length() == 0 ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, enc);
            reader = new BufferedReader(isr);
            if (true) ** GOTO lbl41
        }
        catch (IOException ex) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException var9_14) {
                // empty catch block
            }
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException var9_15) {
                // empty catch block
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException var9_16) {
                // empty catch block
            }
            if (ignoreFileNotFound && ex instanceof FileNotFoundException) {
                return null;
            }
            throw ex;
        }
        {
            do {
                if ((lngth = line.length()) > 0 && line.charAt(lngth - 1) == '\n') {
                    line = --lngth == 0 ? "" : line.substring(0, lngth);
                }
                if (lngth > 0 && line.charAt(lngth - 1) == '\r') {
                    line = --lngth == 0 ? "" : line.substring(0, lngth);
                }
                vectLines.addElement(line);
lbl41:
                // 2 sources

            } while ((line = reader.readLine()) != null);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (isr != null) {
                isr.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        rez = new String[vectLines.size()];
        vectLines.copyInto(rez);
        return rez;
    }

    public String[] readAsciiFile(String fileName, boolean ignoreFileNotFound) throws IOException {
        return ICAProfileParser.readAsciiFile(fileName, ignoreFileNotFound, this.encoding);
    }

    public static String[] readAsciiFile(String fileName, String enc) throws IOException {
        return ICAProfileParser.readAsciiFile(fileName, false, enc);
    }

    public String[] readAsciiFile(String fileName) throws IOException {
        return ICAProfileParser.readAsciiFile(fileName, false, this.encoding);
    }

    public static int writeAsciiFile(String fileName, String enc, String[] content, boolean stripLastNL) throws IOException {
        if (fileName == null || content == null) {
            return -1;
        }
        int nr = content.length;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        String line = null;
        try {
            File parDir;
            File file = new File(fileName);
            String parent = file.getParent();
            if (parent != null && !(parDir = new File(parent)).isDirectory()) {
                parDir.mkdirs();
            }
            fos = new FileOutputStream(file);
            osw = enc == null || enc.trim().length() == 0 ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, enc);
            writer = new BufferedWriter(osw);
            int i = 0;
            while (i < nr) {
                int lngth;
                line = content[i];
                if (line == null) {
                    line = "";
                }
                if ((lngth = line.length()) > 0 && line.charAt(lngth - 1) == '\n') {
                    --lngth;
                }
                if (lngth > 0 && line.charAt(lngth - 1) == '\r') {
                    --lngth;
                }
                writer.write(line, 0, lngth);
                if (i < nr - 1 || !stripLastNL) {
                    writer.newLine();
                }
                ++i;
            }
            writer.flush();
            writer.close();
            osw.close();
            fos.close();
        }
        catch (IOException ex) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        return nr;
    }

    public static int writeAsciiFile(String fileName, String enc, String[] content) throws IOException {
        return ICAProfileParser.writeAsciiFile(fileName, enc, content, false);
    }

    public int writeAsciiFile(String fileName, String[] content, boolean stripLastNL) throws IOException {
        return ICAProfileParser.writeAsciiFile(fileName, this.encoding, content, stripLastNL);
    }

    public int writeAsciiFile(String fileName, String[] content) throws IOException {
        return ICAProfileParser.writeAsciiFile(fileName, this.encoding, content, false);
    }

    public String getProfileString(String fileName, String section, String key, String defval, boolean ignoreFileNotFound, String enc) throws IOException {
        return this.getProfileString(ICAProfileParser.readAsciiFile(fileName, ignoreFileNotFound, enc), section, key, defval);
    }

    public String getProfileString(String fileName, String section, String key, String defval, boolean ignoreFileNotFound) throws IOException {
        return this.getProfileString(ICAProfileParser.readAsciiFile(fileName, ignoreFileNotFound, this.encoding), section, key, defval);
    }

    public String getProfileString(String fileName, String section, String key, String defval, String enc) throws IOException {
        return this.getProfileString(ICAProfileParser.readAsciiFile(fileName, false, enc), section, key, defval);
    }

    public String getProfileString(String fileName, String section, String key, String defval) throws IOException {
        return this.getProfileString(ICAProfileParser.readAsciiFile(fileName, false, this.encoding), section, key, defval);
    }

    public int setProfileString(String fileName, String section, String key, String val, boolean createIfFileNotExists, String enc) throws IOException {
        String[] source = ICAProfileParser.readAsciiFile(fileName, createIfFileNotExists, enc);
        String[] content = this.setProfileString(source, section, key, val);
        if (content != source) {
            return ICAProfileParser.writeAsciiFile(fileName, enc, content);
        }
        return -1;
    }

    public int setProfileString(String fileName, String section, String key, String val, boolean createIfFileNotExists) throws IOException {
        return this.setProfileString(fileName, section, key, val, createIfFileNotExists, this.encoding);
    }

    public int setProfileString(String fileName, String section, String key, String val, String enc) throws IOException {
        return this.setProfileString(fileName, section, key, val, false, enc);
    }

    public int setProfileString(String fileName, String section, String key, String val) throws IOException {
        return this.setProfileString(fileName, section, key, val, false, this.encoding);
    }

    public static String parseMif(String[] source) {
        if (source == null) {
            return null;
        }
        String[] src = (String[])source.clone();
        int nr = src.length;
        int m = 0;
        int i = 0;
        while (i < nr) {
            String line = src[i].trim().toLowerCase();
            if (line.startsWith("start attribute")) {
                src[i] = "<ATTRIBUTE " + ++m + ">";
            } else if (line.startsWith("end attribute")) {
                src[i] = "</ATTRIBUTE>";
            }
            ++i;
        }
        ICAProfileParser parser = new ICAProfileParser(true, '=');
        String rez1 = parser.getProfileString(src, "ATTRIBUTE 1", "VALUE", null);
        String rez2 = parser.getProfileString(src, "ATTRIBUTE 2", "VALUE", null);
        if (rez1 == null || rez2 == null) {
            return null;
        }
        if (ICAProfileParser.unquote(rez1).equalsIgnoreCase("SUCCESS")) {
            return "SUCCESS";
        }
        return ICAProfileParser.unquote(rez2);
    }

    public String parseMif(String fileName) throws IOException {
        return ICAProfileParser.parseMif(this.readAsciiFile(fileName, true));
    }

    public static String quote(String val) {
        if (val == null) {
            return null;
        }
        if (!(val.length() >= 2 && (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")))) {
            val = "\"" + val + "\"";
        }
        return val;
    }

    public static String unquote(String val) {
        if (val == null) {
            return null;
        }
        if (val.length() >= 2 && (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'"))) {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public String[] setProfileStringWithPreference(String[] source, String section, String key, String val, int preference, String[] refkeyArray) {
        if (source == null) {
            source = new String[]{};
        }
        if (section != null && section.trim().length() == 0 || key == null || key.trim().length() == 0) {
            return source;
        }
        if (section != null) {
            section = section.trim();
        }
        key = key.trim();
        int position = -1;
        if (val != null && this.getProfileLine(source, section, key) < 0 && (this.getUncommentInsteadOfInsert() == 0 || this.setProfileString(source, section, key, val).length != source.length)) {
            if (preference >= 0) {
                if (preference <= source.length) {
                    position = preference;
                }
            } else if (preference == -1 || preference == -2) {
                int foundref = -1;
                if (refkeyArray != null) {
                    int i = 0;
                    while (i < refkeyArray.length) {
                        int j;
                        if (refkeyArray[i] != null && (j = this.getProfileLine(source, section, refkeyArray[i], preference == -1)) >= 0 && (foundref < 0 || preference == -1 && j < foundref || preference == -2 && j > foundref)) {
                            foundref = j;
                        }
                        ++i;
                    }
                }
                if (foundref >= 0) {
                    int n = position = preference == -1 ? foundref : foundref + 1;
                }
            }
        }
        if (position < 0) {
            return this.setProfileString(source, section, key, val);
        }
        String line = String.valueOf(key) + this.delimiter + (val.trim().equals(val) ? val : "\"" + val + "\"");
        String[] rez = new String[source.length + 1];
        if (position > 0) {
            System.arraycopy(source, 0, rez, 0, position);
        }
        rez[position] = line;
        if (position < source.length) {
            System.arraycopy(source, position, rez, position + 1, source.length - position);
        }
        return rez;
    }

    public String[] setProfileStringWithPreference(String[] source, String section, String key, String val, int preference, String refkey) {
        return this.setProfileStringWithPreference(source, section, key, val, preference, new String[]{refkey});
    }

    public static String[] vectToStringArrayRemoveDuplicates(Vector vect, boolean caseSensitive) {
        if (vect == null) {
            return null;
        }
        int n = vect.size();
        int i = 0;
        while (i < n) {
            block16: {
                block15: {
                    int j;
                    String eli = (String)vect.elementAt(i);
                    if (eli == null) break block15;
                    if (caseSensitive) {
                        j = 0;
                        while (j < i) {
                            if (!eli.equals((String)vect.elementAt(j))) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        j = 0;
                        while (j < i) {
                            if (eli.equalsIgnoreCase((String)vect.elementAt(j))) {
                                vect.setElementAt(eli, j);
                                break;
                            }
                            ++j;
                        }
                    }
                    if (j >= i) break block16;
                }
                vect.remove(i);
                --i;
                --n;
            }
            ++i;
        }
        String[] rez = new String[n];
        i = 0;
        while (i < n) {
            rez[i] = (String)vect.elementAt(i);
            ++i;
        }
        return rez;
    }

    public String[] getKeyList(String[] source, String section) {
        if (source == null || section != null && section.trim().length() == 0) {
            return null;
        }
        if (section != null) {
            section = section.trim();
        }
        int nrSect = 0;
        String[] sectTokens = null;
        if (section != null) {
            StringTokenizer keyTokenizer = new StringTokenizer(section);
            nrSect = keyTokenizer.countTokens();
            sectTokens = new String[nrSect];
            int j = 0;
            while (j < nrSect) {
                sectTokens[j] = keyTokenizer.nextToken();
                ++j;
            }
        }
        Vector<String> rezVect = section == null ? new Vector<String>() : null;
        int nr = source.length;
        String crtSect = null;
        int sectLevel = 0;
        boolean goodSect = section == null;
        int i = 0;
        while (i < nr) {
            int lngth;
            String line = source[i];
            if (line != null && (lngth = (line = line.trim()).length()) != 0) {
                int poz;
                if (!this.isLineCommented(line, true) && (this.usesNormalStyleSections() && line.startsWith("[") || this.usesXmlStyleSections() && line.startsWith("<") || this.usesStanzaStyleSections() && line.endsWith(":"))) {
                    poz = this.usesStanzaStyleSections() ? line.length() - 1 : line.indexOf(this.usesXmlStyleSections() ? 62 : 93);
                    if (poz >= 0) {
                        if (section == null && !this.usesXmlStyleSections()) {
                            return ICAProfileParser.vectToStringArrayRemoveDuplicates(rezVect, this.caseSensitive);
                        }
                        String tmpString = line.substring(this.usesStanzaStyleSections() ? 0 : 1, poz).trim();
                        if (this.usesXmlStyleSections()) {
                            if (tmpString.startsWith("/")) {
                                if (sectLevel > 0) {
                                    --sectLevel;
                                }
                                if (sectLevel == 0) {
                                    crtSect = null;
                                }
                            } else {
                                if (sectLevel == 0) {
                                    crtSect = tmpString;
                                }
                                ++sectLevel;
                            }
                        } else {
                            sectLevel = 1;
                            crtSect = tmpString;
                        }
                        if (this.eqvStrings(sectTokens, crtSect)) {
                            goodSect = true;
                            if (rezVect == null) {
                                rezVect = new Vector();
                            }
                        } else {
                            goodSect = false;
                        }
                    }
                } else if (goodSect && (poz = (line = line.trim()).indexOf(this.delimiter)) >= 0) {
                    String crtKey = line.substring(0, poz).trim().replace('\t', ' ');
                    if (crtKey.indexOf(32) >= 0) {
                        int n2;
                        int n1 = crtKey.length();
                        while ((n2 = (crtKey = ICAStringUtils.globalReplace(crtKey, "  ", " ")).length()) != n1) {
                            n1 = n2;
                        }
                    }
                    rezVect.add(crtKey);
                }
            }
            ++i;
        }
        return ICAProfileParser.vectToStringArrayRemoveDuplicates(rezVect, this.caseSensitive);
    }
}

