/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAProfileParser;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.installshield.util.FileAttributes;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class ICAResume {
    public static final int NOTSTARTED = 0;
    public static final int INSTALLING = 1;
    public static final int INSTSUCC = 2;
    public static final int INSTFAILED = 3;
    public static final int CLEANING = 4;
    public static final int CLEANFAILED = 5;
    public static final int CLEANSUCC = 0;
    public static final String CFGSECTION = "Configuration Section";
    public static final String PROGSECTION = "Progress Section";
    private static String resumeFile = null;
    private static ICAProfileParser icaProfileParser = null;

    public static String[] involvedServices() {
        return new String[]{"fileService"};
    }

    private static void ini() {
        if (resumeFile == null) {
            resumeFile = ICAInstGlobals.getString("ResumeFile");
        }
        if (icaProfileParser == null) {
            icaProfileParser = new ICAProfileParser(true);
        }
    }

    public static synchronized boolean exists() {
        ICAResume.ini();
        try {
            String[] content = icaProfileParser.readAsciiFile(resumeFile, false);
            if (ICAStringUtils.locateString("[Configuration Section]", content, 0, -1, false, true, true, 0) >= 0) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static synchronized void deleteFile() throws IOException {
        ICAResume.ini();
        File f = new File(resumeFile);
        File fdel = new File(String.valueOf(resumeFile) + ".del");
        if (ICAResume.exists()) {
            try {
                if (fdel.exists()) {
                    fdel.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.renameTo(fdel);
        } else if (f.exists()) {
            f.delete();
        }
    }

    public static synchronized void createFile(String[] content) throws IOException {
        ICAResume.ini();
        ICAResume.deleteFile();
        if (content == null) {
            content = new String[]{};
        }
        if (content.length == 0 || content[0] == null || !content[0].trim().startsWith(";")) {
            String[] contentOld = content;
            content = new String[contentOld.length + 1];
            content[0] = "; Installation Resume File created on " + DateFormat.getDateTimeInstance().format(new Date());
            if (contentOld.length > 0) {
                System.arraycopy(contentOld, 0, content, 1, contentOld.length);
            }
        }
        icaProfileParser.writeAsciiFile(resumeFile, content);
        ICAResume.setAllFilePermissions(resumeFile);
    }

    public static synchronized void createFile() throws IOException {
        ICAResume.createFile(null);
    }

    public static synchronized String[] readFile() throws IOException {
        ICAResume.ini();
        return icaProfileParser.readAsciiFile(resumeFile, true);
    }

    public static synchronized String getCfg(String key, String defaultVal) throws IOException {
        ICAResume.ini();
        return icaProfileParser.getProfileString(resumeFile, CFGSECTION, key, defaultVal, true);
    }

    public static synchronized String getCfg(String key) throws IOException {
        ICAResume.ini();
        return icaProfileParser.getProfileString(resumeFile, CFGSECTION, key, null, true);
    }

    public static synchronized void setCfg(String key, String val) throws IOException {
        ICAResume.ini();
        icaProfileParser.setProfileString(resumeFile, CFGSECTION, key, val, true);
    }

    public static synchronized void delCfg(String key) throws IOException {
        ICAResume.ini();
        icaProfileParser.setProfileString(resumeFile, CFGSECTION, key, null, true);
    }

    public static synchronized int getProgress(String key) throws IOException {
        ICAResume.ini();
        String val = icaProfileParser.getProfileString(resumeFile, PROGSECTION, key, null, true);
        if (val == null) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public static synchronized void setProgress(String key, int val) throws IOException {
        ICAResume.ini();
        if (val == 0) {
            ICAResume.delProgress(key);
        } else {
            icaProfileParser.setProfileString(resumeFile, PROGSECTION, key, Integer.toString(val), true);
        }
    }

    public static synchronized void delProgress(String key) throws IOException {
        ICAResume.ini();
        icaProfileParser.setProfileString(resumeFile, PROGSECTION, key, null, true);
    }

    public static boolean setAllFilePermissions(String filename) {
        int msk1 = 219;
        int msk2 = 292;
        boolean retVal = false;
        try {
            FileService sfs = ICAInstGlobals.getFileService();
            FileAttributes fileAttributes = sfs.getFileAttributes(filename);
            int fileMsk = fileAttributes.getAttributes();
            if (fileAttributes.getAttributeState(4096) || fileAttributes.getAttributeState(4)) {
                fileAttributes.setAttributes(fileMsk | msk1 | msk2);
            } else {
                fileAttributes.setAttributes(fileMsk | msk1);
            }
            sfs.setFileAttributes(filename, fileAttributes);
            retVal = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static boolean setSomeFilePermissions(String filename) {
        int msk1 = 75;
        int msk2 = 292;
        boolean retVal = false;
        try {
            FileService sfs = ICAInstGlobals.getFileService();
            FileAttributes fileAttributes = sfs.getFileAttributes(filename);
            int fileMsk = fileAttributes.getAttributes();
            if (fileAttributes.getAttributeState(4096) || fileAttributes.getAttributeState(4)) {
                fileAttributes.setAttributes(fileMsk | msk1 | msk2);
            } else {
                fileAttributes.setAttributes(fileMsk | msk1);
            }
            sfs.setFileAttributes(filename, fileAttributes);
            retVal = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }
}

