/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ShowMessage;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.service.product.ProductService;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ICASoftwareObjectUtils {
    public static String getLastInstallPath(String productKey) {
        SoftwareObject[] arraySfObj = null;
        SoftwareObject sfObj = null;
        int latestInst = 0;
        String installLocation = "";
        try {
            RegistryService regServ = (RegistryService)ICAInstGlobals.getService("registryService");
            arraySfObj = regServ.getSoftwareObjects(productKey);
            if (arraySfObj != null && arraySfObj.length > 0) {
                int i = 0;
                while (i < arraySfObj.length) {
                    int crtInst;
                    if (arraySfObj[i] != null && (crtInst = arraySfObj[i].getKey().getInstance()) > latestInst) {
                        latestInst = crtInst;
                        sfObj = arraySfObj[i];
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException srvEx) {
            String text = ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccurred", new String[]{srvEx.toString()}, null);
            ShowMessage.writeLogOutput(text);
        }
        if (latestInst > 0) {
            installLocation = sfObj.getInstallLocation();
        }
        return installLocation.trim();
    }

    public static String[] getProductInstallLocations(String productKey) {
        SoftwareObject[] arraySfObj = null;
        String[] installLocations = null;
        Vector<String> tempInstallLocation = new Vector<String>();
        try {
            RegistryService regServ = (RegistryService)ICAInstGlobals.getService("registryService");
            arraySfObj = regServ.getSoftwareObjects(productKey);
            if (arraySfObj != null && arraySfObj.length > 0) {
                int i = 0;
                while (i < arraySfObj.length) {
                    if (arraySfObj[i] != null && arraySfObj[i].getInstallLocation() != null && arraySfObj[i].getInstallLocation().length() > 0) {
                        tempInstallLocation.add(arraySfObj[i].getInstallLocation());
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException srvEx) {
            ShowMessage.gi("ICAIns").fatalError("", null, "ICAInstall.ServiceExceptionOccurred", new String[]{srvEx.toString()}, null);
        }
        if (tempInstallLocation.size() > 0) {
            installLocations = new String[tempInstallLocation.size()];
            int ii = 0;
            while (ii < tempInstallLocation.size()) {
                installLocations[ii] = ((String)tempInstallLocation.get(ii)).trim();
                ++ii;
            }
        } else {
            installLocations = new String[]{};
        }
        return installLocations;
    }

    public static String getProductVersion(String productKey, String installLocation) {
        SoftwareObject so = null;
        SoftwareVersion sv = null;
        try {
            RegistryService regServ = (RegistryService)ICAInstGlobals.getService("registryService");
            so = regServ.getSoftwareObject(productKey, installLocation);
            if (so != null && !so.equals("")) {
                sv = so.getKey().getVersion();
                return String.valueOf(sv.getMajor()) + "." + sv.getMinor() + "." + sv.getMaintenance() + "." + sv.getUpdate();
            }
        }
        catch (ServiceException srvEx) {
            ShowMessage.gi("ICAIns").fatalError("", null, "ICAInstall.ServiceExceptionOccurred", new String[]{srvEx.toString()}, null);
        }
        return "";
    }

    public static String getStringComponentVersionInstalled(String componentKey) throws ServiceException {
        RegistryService regService = null;
        SoftwareObject so = null;
        SoftwareObjectKey instSok = null;
        String retValue = null;
        regService = (RegistryService)ICAInstGlobals.getService("registryService");
        regService.initializeRegistry();
        so = regService.getNewestSoftwareObject(componentKey);
        if (so == null) {
            retValue = null;
        } else {
            instSok = so.getKey();
            retValue = String.valueOf(instSok.getVersion().getMajor()) + "." + instSok.getVersion().getMinor() + "." + instSok.getVersion().getMaintenance();
        }
        return retValue;
    }

    public static boolean featureExists(String beanID) {
        boolean response = false;
        ProductTree producttree = null;
        try {
            ProductService productservice = (ProductService)ICAInstGlobals.getService("productService");
            producttree = productservice.getSoftwareObjectTree("/product.xml", new String[]{"active"});
            ProductBean productBean = producttree.getBean(beanID);
            response = productBean != null && productBean instanceof ProductFeature;
        }
        catch (ServiceException serviceexception) {
            String errMsg = ShowMessage.gi("ICAIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceexception.getMessage()}, null);
            ShowMessage.gi("ICAIns").fatalError0(null, "", errMsg);
        }
        return response;
    }

    public static boolean featureSelected(String beanID) {
        boolean response = false;
        ProductTree producttree = null;
        try {
            ProductService productservice = (ProductService)ICAInstGlobals.getService("productService");
            producttree = productservice.getSoftwareObjectTree("/product.xml", new String[]{"active"});
            ProductBean productBean = producttree.getBean(beanID);
            if (productBean != null && productBean instanceof ProductFeature) {
                ProductFeature feature = (ProductFeature)productBean;
                response = feature.isActive();
            }
        }
        catch (ServiceException serviceexception) {
            String errMsg = ShowMessage.gi("MDMIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceexception.getMessage()}, null);
            ShowMessage.gi("MDMIns").fatalError0(null, "", errMsg);
        }
        return response;
    }

    public static boolean componentSelected(String beanID) {
        boolean response = false;
        ProductTree producttree = null;
        try {
            ProductService productservice = (ProductService)ICAInstGlobals.getService("productService");
            producttree = productservice.getSoftwareObjectTree("/product.xml", new String[]{"active"});
            ProductBean productBean = producttree.getBean(beanID);
            if (productBean != null && productBean instanceof ProductComponent) {
                ProductComponent component = (ProductComponent)productBean;
                response = component.isActive();
            }
        }
        catch (ServiceException serviceexception) {
            String errMsg = ShowMessage.gi("MDMIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceexception.getMessage()}, null);
            ShowMessage.gi("MDMIns").fatalError0(null, "", errMsg);
        }
        return response;
    }

    public static boolean featureSelectedToUninstall(String beanID) {
        boolean response = false;
        ProductTree producttree = null;
        try {
            ProductService productservice = (ProductService)ICAInstGlobals.getService("productService");
            producttree = productservice.getSoftwareObjectTree("/product.xml", new String[]{"activeForUninstall"});
            ProductBean productBean = producttree.getBean(beanID);
            if (productBean != null && productBean instanceof ProductFeature) {
                ProductFeature feature = (ProductFeature)productBean;
                response = ICASoftwareObjectUtils.isBeanInstalled(feature.getBeanId()) && feature.isActiveForUninstall();
            }
        }
        catch (ServiceException serviceexception) {
            String errMsg = ShowMessage.gi("MDMIns").resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceexception.getMessage()}, null);
            ShowMessage.gi("MDMIns").fatalError0(null, "", errMsg);
        }
        return response;
    }

    public static boolean isProductInstalled(String productKey) {
        SoftwareObject so = null;
        boolean isInstalled = false;
        try {
            RegistryService regService = (RegistryService)ICAInstGlobals.getServices().getService("registryService");
            regService.initializeRegistry();
            so = regService.getNewestSoftwareObject(productKey);
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        if (so != null) {
            isInstalled = true;
        }
        return isInstalled;
    }

    public static boolean isProductInstalled() {
        boolean installed = false;
        try {
            String uid = ICASoftwareObjectUtils.getInstallingProductUID();
            if (uid != null && uid.length() > 0) {
                installed = ICASoftwareObjectUtils.isProductInstalled(uid);
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("Install.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        return installed;
    }

    public static String getFeatureInstPath(String featureKey, String productKey) {
        String retVal = "";
        try {
            String instLoc;
            SoftwareObject okSo;
            SoftwareObjectKey parentSok;
            RegistryService regService = (RegistryService)ICAInstGlobals.getService("registryService");
            regService.initializeRegistry();
            SoftwareObject parentSo = regService.getNewestSoftwareObject(productKey);
            if (parentSo != null && (parentSok = parentSo.getKey()) != null && (okSo = ICASoftwareObjectUtils.getFeatureSoftwareObject(regService, featureKey, parentSok)) != null && (instLoc = okSo.getInstallLocation()) != null && instLoc.trim().length() > 0) {
                retVal = instLoc;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        return retVal;
    }

    public static String[][] getProductChildren(String key) {
        Vector<String[]> info = new Vector<String[]>();
        try {
            SoftwareObjectKey[] children;
            RegistryService regService = (RegistryService)ICAInstGlobals.getServices().getService("registryService");
            regService.initializeRegistry();
            SoftwareObject so = regService.getNewestSoftwareObject(key);
            if (so != null && (children = regService.getSoftwareObjectKeysWithParent(so.getKey())) != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    SoftwareVersion sv;
                    String[] keyInfo;
                    String displayName;
                    SoftwareObject someSo;
                    if (!children[i].getUID().equals(so.getKey().getUID()) && (someSo = regService.getSoftwareObject(children[i])) != null && (displayName = someSo.getDisplayName()) != null && !info.contains(keyInfo = new String[]{displayName, String.valueOf((sv = children[i].getVersion()).getMajor()) + "." + sv.getMinor() + "." + sv.getMaintenance()})) {
                        info.add(keyInfo);
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        String[][] childrenInfo = new String[info.size()][];
        childrenInfo = (String[][])info.toArray((T[])childrenInfo);
        return childrenInfo;
    }

    public static ProductBean resolveKeyAsProductBean(ProductTree prodTree, SoftwareObjectKey sok) {
        if (prodTree == null || sok == null) {
            return null;
        }
        ProductBean pb = null;
        StandardProductTreeIterator standardproducttreeiterator = new StandardProductTreeIterator(prodTree);
        ProductBean productbean1 = standardproducttreeiterator.getNext(standardproducttreeiterator.begin());
        while (productbean1 != standardproducttreeiterator.end()) {
            if (productbean1 instanceof SoftwareObject && ((SoftwareObject)((Object)productbean1)).getKey().equals(sok)) {
                pb = productbean1;
            }
            productbean1 = standardproducttreeiterator.getNext(productbean1);
        }
        return pb;
    }

    public static boolean isProductInVPD(String key, String path) {
        SoftwareObject soo;
        RegistryService regService;
        block3: {
            regService = null;
            soo = null;
            try {
                regService = (RegistryService)ICAInstGlobals.getService("registryService");
                regService.initializeRegistry();
                if (path != null && path.length() != 0) break block3;
                return false;
            }
            catch (ServiceException serviceException) {
                ShowMessage.writeLogOutput(ShowMessage.gi("ICAIns").resolve("WASInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
                return false;
            }
        }
        path = ICAStringUtils.unquote(path);
        soo = regService.getSoftwareObject(key, path);
        return soo != null;
    }

    public static String getFeatureInstPath(String featureKey, String productKey, String pathProduct) {
        String retVal = "";
        try {
            String instLoc;
            SoftwareObject okSo;
            SoftwareObjectKey parentSok;
            RegistryService regService = (RegistryService)ICAInstGlobals.getService("registryService");
            regService.initializeRegistry();
            SoftwareObject parentSo = regService.getSoftwareObject(productKey, pathProduct);
            if (parentSo != null && (parentSok = parentSo.getKey()) != null && (okSo = ICASoftwareObjectUtils.getFeatureSoftwareObject(regService, featureKey, parentSok)) != null && (instLoc = okSo.getInstallLocation()) != null && instLoc.trim().length() > 0) {
                retVal = instLoc;
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
        return retVal;
    }

    private static SoftwareObject getFeatureSoftwareObject(RegistryService regService, String featureKey, SoftwareObjectKey parentSok) throws ServiceException {
        if (parentSok != null) {
            Vector<SoftwareObjectKey> vect = new Vector<SoftwareObjectKey>();
            SoftwareObjectKey[] childSok = regService.getSoftwareObjectKeysWithParent(parentSok);
            if (childSok != null && childSok.length > 0) {
                int k = 0;
                while (k < childSok.length) {
                    vect.addElement(childSok[k]);
                    ++k;
                }
            }
            int n = 0;
            int l = 0;
            SoftwareObjectKey sok = null;
            while ((n = vect.size()) > 0 && l < 16) {
                int i = 0;
                while (i < n) {
                    SoftwareObject okSo;
                    sok = (SoftwareObjectKey)vect.elementAt(i);
                    if (sok.getUID().equals(featureKey) && (okSo = regService.getSoftwareObject(sok)) != null) {
                        return okSo;
                    }
                    ++i;
                }
                Vector<SoftwareObjectKey> work = new Vector<SoftwareObjectKey>();
                int i2 = 0;
                while (i2 < n) {
                    sok = (SoftwareObjectKey)vect.elementAt(i2);
                    childSok = regService.getSoftwareObjectKeysWithParent(sok);
                    if (childSok != null && childSok.length > 0) {
                        int k = 0;
                        while (k < childSok.length) {
                            work.addElement(childSok[k]);
                            ++k;
                        }
                    }
                    ++i2;
                }
                ++l;
                vect = work;
                work = null;
            }
        }
        return null;
    }

    public static String getProductInstallLocation(String key, String path) {
        if (key == null || key.trim().length() == 0 || path == null || path.trim().length() == 0 || !ICASoftwareObjectUtils.isProductInVPD(key, path)) {
            return "";
        }
        return path;
    }

    public static String[] areNamedProductsInVPD(String startsWith, String startsWithException) {
        String[] ret;
        int ii;
        String[] softwareObjectUIDs = null;
        Hashtable<String, Integer> tempRet = new Hashtable<String, Integer>();
        try {
            RegistryService regServ = (RegistryService)ICAInstGlobals.getService("registryService");
            softwareObjectUIDs = regServ.getAllSoftwareObjectUIDs();
            if (softwareObjectUIDs != null && softwareObjectUIDs.length > 0) {
                ii = 0;
                while (ii < softwareObjectUIDs.length) {
                    SoftwareObject[] softwareObjects;
                    if (softwareObjectUIDs[ii] != null && softwareObjectUIDs[ii].startsWith(startsWith) && (startsWithException == null || startsWithException.length() == 0 || !softwareObjectUIDs[ii].startsWith(startsWithException)) && (softwareObjects = regServ.getSoftwareObjects(softwareObjectUIDs[ii])) != null && softwareObjects.length > 0) {
                        int jj = 0;
                        while (jj < softwareObjects.length) {
                            SoftwareObjectKey[] softwareObjectKeys = softwareObjects[jj].getParents();
                            if (softwareObjectKeys == null || softwareObjectKeys.length == 0 || softwareObjectKeys.length == 1 && softwareObjectUIDs[ii].equals(softwareObjectKeys[0].getUID())) {
                                if (softwareObjects[jj].getDisplayName() != null && softwareObjects[jj].getDisplayName().length() > 0) {
                                    tempRet.put(softwareObjects[jj].getDescription(), new Integer(0));
                                } else {
                                    tempRet.put(softwareObjectUIDs[ii], new Integer(0));
                                }
                            }
                            ++jj;
                        }
                    }
                    ++ii;
                }
            }
        }
        catch (ServiceException srvEx) {
            ShowMessage.gi("ICAIns").fatalError("", null, "ICAInstall.ServiceExceptionOccurred", new String[]{srvEx.toString()}, null);
        }
        if (tempRet.size() > 0) {
            ret = new String[tempRet.size()];
            Enumeration keys = tempRet.keys();
            ii = 0;
            while (keys.hasMoreElements()) {
                ret[ii++] = (String)keys.nextElement();
            }
        } else {
            ret = new String[]{};
        }
        return ret;
    }

    public static String[] getProductMissingFeatures(String productKey, String productPath, String[][] requiredFeatures) {
        String[] retStringArray;
        Vector<String> missingFeatures = new Vector<String>();
        int ii = 0;
        while (ii < requiredFeatures.length) {
            if ("".equals(ICASoftwareObjectUtils.getFeatureInstPath(requiredFeatures[ii][0], productKey, productPath))) {
                missingFeatures.add(requiredFeatures[ii][1]);
            }
            ++ii;
        }
        if (missingFeatures.size() == 0) {
            retStringArray = new String[]{};
        } else {
            retStringArray = new String[missingFeatures.size()];
            ii = 0;
            Enumeration elements = missingFeatures.elements();
            while (elements.hasMoreElements()) {
                retStringArray[ii] = (String)elements.nextElement();
                ++ii;
            }
        }
        return retStringArray;
    }

    public static String getUninstallJar(String productKey) {
        String retVal = "";
        try {
            StringTokenizer token;
            String uninstaller;
            RegistryService regServ = (RegistryService)ICAInstGlobals.getService("registryService");
            SoftwareObject soUninst = regServ.getNewestSoftwareObject(productKey);
            if (soUninst != null && (uninstaller = soUninst.getUninstaller()) != null && !(retVal = String.valueOf(ICAStringUtils.unquote((String)(token = new StringTokenizer(uninstaller, " ")).nextElement())) + File.separator + ICAStringUtils.unquote((String)token.nextElement())).endsWith(".jar")) {
                retVal = "";
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return retVal.trim();
    }

    public static void removeProductWithAllChildren(String key, RegistryService regService) {
        try {
            SoftwareObject so = regService.getNewestSoftwareObject(key);
            if (so != null) {
                SoftwareObjectKey[] children = regService.getSoftwareObjectKeysWithParent(so.getKey());
                int i = 0;
                while (i < children.length) {
                    ++i;
                }
                if (children != null && children.length > 0) {
                    i = 0;
                    while (i < children.length) {
                        if (!children[i].getUID().equals(so.getKey().getUID())) {
                            ICASoftwareObjectUtils.removeProductWithAllChildren(children[i].getUID(), regService);
                        }
                        ++i;
                    }
                    regService.removeSoftwareObject(so.getKey());
                } else {
                    regService.removeSoftwareObject(so.getKey());
                }
            }
        }
        catch (ServiceException serviceException) {
            ShowMessage.writeLogOutput(ShowMessage.gi(null).resolve("ICAInstall.ServiceExceptionOccured", new String[]{serviceException.toString()}, null));
        }
    }

    public static boolean isBeanInstalled(String s) throws ServiceException {
        boolean installed = false;
        ProductService productservice = (ProductService)ICAInstGlobals.getService("productService");
        installed = (Boolean)productservice.getProductBeanProperty("/product.xml", s, "installed");
        return installed;
    }

    public static boolean successInstall() {
        boolean success = false;
        int nrerrs = -1;
        Properties props = null;
        try {
            ProductService prodService = (ProductService)ICAInstGlobals.getService("productService");
            props = prodService.getProductSummary("/product.xml", 2, "text");
        }
        catch (ServiceException prodService) {
            // empty catch block
        }
        String nrerrsString = null;
        if (props != null) {
            nrerrsString = props.getProperty("summary.error.count");
        }
        if (nrerrsString != null) {
            try {
                nrerrs = Integer.parseInt(nrerrsString.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (nrerrs >= 0) {
            success = nrerrs == 0;
        } else {
            String translatedMsg;
            String message = props.getProperty("summary.msg");
            if (message != null && (translatedMsg = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "installationError")) != null && translatedMsg.trim().length() > 0) {
                success = !(message = message.trim()).startsWith(translatedMsg = translatedMsg.trim());
            }
        }
        return success;
    }

    public static String getInstallingProductUID(String productKey) throws ServiceException {
        String uid = null;
        if (productKey == null || productKey.length() == 0) {
            return null;
        }
        ProductService productService = (ProductService)ICAInstGlobals.getServices().getService("productService");
        SoftwareObjectKey sok = (SoftwareObjectKey)productService.getProductBeanProperty("/product.xml", productKey, "key");
        if (sok != null) {
            uid = sok.getUID();
        }
        return uid;
    }

    public static String getInstallingProductUID() throws ServiceException {
        return ICASoftwareObjectUtils.getInstallingProductUID("product");
    }

    public static String getComponentVRMF(String componentKey, int depth) throws ServiceException {
        RegistryService regService = null;
        SoftwareObject so = null;
        SoftwareObjectKey instSok = null;
        String retValue = null;
        if (depth < 2) {
            depth = 2;
        }
        if (depth > 4) {
            depth = 4;
        }
        if ((so = (regService = (RegistryService)ICAInstGlobals.getService("registryService")).getNewestSoftwareObject(componentKey)) == null) {
            retValue = null;
        } else {
            instSok = so.getKey();
            switch (depth) {
                case 2: {
                    retValue = String.valueOf(instSok.getVersion().getMajor()) + "." + instSok.getVersion().getMinor();
                    break;
                }
                case 3: {
                    retValue = String.valueOf(instSok.getVersion().getMajor()) + "." + instSok.getVersion().getMinor() + "." + instSok.getVersion().getMaintenance();
                    break;
                }
                default: {
                    retValue = String.valueOf(instSok.getVersion().getMajor()) + "." + instSok.getVersion().getMinor() + "." + instSok.getVersion().getMaintenance() + "." + instSok.getVersion().getUpdate();
                }
            }
        }
        return retValue;
    }

    public static boolean isFeatureOrComponentInstalling(String beanID) throws ServiceException {
        String currentBeanId;
        ProductBean productbean;
        boolean willBeInstalled = false;
        ProductService productService = (ProductService)ICAInstGlobals.getServices().getService("productService");
        ProductTree producttree = productService.getSoftwareObjectTree("/product.xml", null);
        String rootId = producttree.getRoot().getBeanId();
        willBeInstalled = rootId.equalsIgnoreCase(beanID);
        if (!willBeInstalled) {
            ProductTreeIterator componentsproducttreeiterator = ProductTreeIteratorFactory.createProductComponentIterator(producttree.getRoot());
            productbean = componentsproducttreeiterator.getNext(componentsproducttreeiterator.begin());
            while (productbean != componentsproducttreeiterator.end()) {
                currentBeanId = productbean.getBeanId();
                if (currentBeanId.equalsIgnoreCase(beanID)) {
                    willBeInstalled = true;
                    break;
                }
                productbean = componentsproducttreeiterator.getNext(productbean);
            }
        }
        if (!willBeInstalled) {
            ProductTreeIterator featuresproducttreeiterator = ProductTreeIteratorFactory.createFeatureIterator(producttree.getRoot());
            productbean = featuresproducttreeiterator.getNext(featuresproducttreeiterator.begin());
            while (productbean != featuresproducttreeiterator.end()) {
                currentBeanId = productbean.getBeanId();
                if (currentBeanId.equalsIgnoreCase(beanID)) {
                    willBeInstalled = true;
                    break;
                }
                productbean = featuresproducttreeiterator.getNext(productbean);
            }
        }
        return willBeInstalled;
    }

    public static String getInstalledProductDisplayName() throws ServiceException {
        RegistryService regService = (RegistryService)ICAInstGlobals.getServices().getService("registryService");
        SoftwareObject so = regService.getNewestSoftwareObject(ICASoftwareObjectUtils.getInstallingProductUID());
        if (so != null) {
            return so.getDisplayName();
        }
        return "";
    }

    public static String getInstallingProductLastInstallationPath() {
        String productUID = "";
        try {
            productUID = ICASoftwareObjectUtils.getInstallingProductUID();
        }
        catch (ServiceException e) {
            String text = ShowMessage.gi("Ins").resolve("Install.ServiceExceptionOccurred", new String[]{e.toString()}, null);
            ShowMessage.writeLogOutput("wrn", text);
        }
        return ICASoftwareObjectUtils.getLastInstallPath(productUID);
    }
}

