/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.BldUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class ICAStringUtils {
    protected static String[] searchDirectories = null;

    public static String[] getSearchDirectories() {
        return searchDirectories == null ? null : (String[])searchDirectories.clone();
    }

    public static void setSearchDirectories(String[] searchDirs) {
        searchDirectories = searchDirs == null ? null : (String[])searchDirs.clone();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "").toUpperCase().startsWith("WINDOWS");
    }

    public static boolean isWindows2K() {
        String os = System.getProperty("os.name", "").toUpperCase();
        if (os.startsWith("WINDOWS NT") && System.getProperty("os.version", "").startsWith("5")) {
            os = "WINDOWS 2000";
        }
        return os.startsWith("WINDOWS 2000") || os.startsWith("WINDOWS 2003");
    }

    public static boolean isWindowsXP() {
        String os = System.getProperty("os.name", "").toUpperCase().trim();
        return os.startsWith("WINDOWS XP");
    }

    public static boolean isWindows2K8() {
        String os = System.getProperty("os.name", "").toUpperCase();
        if (os.startsWith("WINDOWS NT") && System.getProperty("os.version", "").startsWith("6")) {
            os = "WINDOWS 2008";
        }
        return os.startsWith("WINDOWS 2008");
    }

    public static boolean isWindows2003() {
        String os = System.getProperty("os.name", "").toUpperCase();
        String osVersion = System.getProperty("os.version", "");
        if ((os.startsWith("WINDOWS NT") || os.startsWith("WINDOWS 2000")) && (osVersion.startsWith("5.2") || osVersion.startsWith("5.02"))) {
            os = "WINDOWS 2003";
        }
        return os.startsWith("WINDOWS 2003");
    }

    public static boolean isWindows2000() {
        return ICAStringUtils.isWindows2K() && !ICAStringUtils.isWindows2003();
    }

    public static boolean isUnix() {
        return !ICAStringUtils.isWindows();
    }

    public static String ltrim(String source) {
        if (source == null) {
            return null;
        }
        int n = source.length();
        int i = 0;
        while (i < n) {
            if (!Character.isWhitespace(source.charAt(i))) {
                return source.substring(i);
            }
            ++i;
        }
        return "";
    }

    public static String rtrim(String source) {
        if (source == null) {
            return null;
        }
        int n = source.length();
        int i = n - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(source.charAt(i))) {
                return source.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static String trim(String source) {
        if (source == null) {
            return null;
        }
        return source.trim();
    }

    public static String globalReplace(String source, String str1, String str2, int start, int end) {
        if (source == null) {
            return null;
        }
        int n = source.length();
        if (start < 0) {
            start = 0;
        }
        if (end < 0 || end > n) {
            end = n;
        }
        if (start >= end || str1 == null || str1.length() == 0) {
            return source;
        }
        if (str2 == null) {
            str2 = "";
        }
        int l1 = str1.length();
        int l2 = str2.length();
        int p = start;
        while ((p = source.indexOf(str1, p)) >= 0 && p + l1 <= end) {
            source = String.valueOf(source.substring(0, p)) + str2 + source.substring(p + l1);
            if ((p += l2) < (end += l2 - l1)) continue;
            break;
        }
        return source;
    }

    public static String globalReplace(String source, String str1, String str2, int start) {
        return ICAStringUtils.globalReplace(source, str1, str2, start, -1);
    }

    public static String globalReplace(String source, String str1, String str2) {
        return ICAStringUtils.globalReplace(source, str1, str2, 0, -1);
    }

    public static String replaceDblBSlash(String source) {
        return ICAStringUtils.globalReplace(source, "\\\\", "\\", 0, -1);
    }

    public static String replaceBSlash(String source) {
        if (source == null) {
            return null;
        }
        return source.replace('\\', '/');
    }

    public static String goodSlashesWindows(String source) {
        return ICAStringUtils.globalReplace(source, "/", "\\");
    }

    public static String goodSlashesUnix(String source) {
        return ICAStringUtils.globalReplace(source, "\\", "/");
    }

    public static String goodSlashes(String source) {
        if (source == null) {
            return null;
        }
        if (ICAStringUtils.isWindows()) {
            return ICAStringUtils.goodSlashesWindows(source);
        }
        return ICAStringUtils.goodSlashesUnix(source);
    }

    public static String removeLastSlash(String source) {
        File f;
        String pn;
        if (source == null) {
            return null;
        }
        if ((source.endsWith("\\") || source.endsWith("/")) && (pn = (f = new File(new File(source).getAbsolutePath())).getParent()) != null && !pn.equals(f.getPath())) {
            source = source.substring(0, source.length() - 1);
        }
        return source;
    }

    public static String getDrive(String source) {
        String pn;
        if (source == null) {
            return null;
        }
        File f = new File(new File(source).getAbsolutePath());
        source = f.getPath();
        while ((pn = (f = new File(source)).getParent()) != null && pn.length() > 0 && !pn.equals(source)) {
            source = pn;
        }
        if (source.endsWith("\\") || source.endsWith("/")) {
            source = source.substring(0, source.length() - 1);
        }
        return source;
    }

    public static String removeQuoteChars(String source) {
        return ICAStringUtils.globalReplace(source, "\"", "", 0, -1);
    }

    public static String quote(String source) {
        if (source == null) {
            return null;
        }
        if (source.length() < 2 || !source.startsWith("\"") || !source.endsWith("\"")) {
            source = "\"" + source + "\"";
        }
        return source;
    }

    public static String unquote(String source) {
        if (source == null) {
            return null;
        }
        int n = source.length();
        if (n >= 2 && source.startsWith("\"") && source.endsWith("\"")) {
            source = source.substring(1, n - 1);
        }
        return source;
    }

    public static String quoteOrUnquote(String source) {
        if (source == null) {
            return null;
        }
        if ((source = ICAStringUtils.removeQuoteChars(source)).indexOf(32) >= 0 || source.indexOf(9) >= 0) {
            return ICAStringUtils.quote(source);
        }
        return source;
    }

    public static String quoteOrUnquoteOnlyOnW32(String source) {
        if (source == null) {
            return null;
        }
        if (ICAStringUtils.isUnix()) {
            return source;
        }
        if ((source = ICAStringUtils.removeQuoteChars(source)).indexOf(32) >= 0 || source.indexOf(9) >= 0) {
            return ICAStringUtils.quote(source);
        }
        return source;
    }

    public static String arrayToString(Object[] arg, String separator) {
        int n = 0;
        if (arg != null) {
            n = arg.length;
        }
        if (separator == null) {
            separator = " ";
        }
        String text = "";
        int i = 0;
        while (i < n) {
            text = String.valueOf(text) + (text.length() > 0 ? separator : "") + (arg[i] == null ? "null" : arg[i].toString());
            ++i;
        }
        return text;
    }

    public static String arrayToString(Object[] arg) {
        return ICAStringUtils.arrayToString(arg, " ");
    }

    public static int locateString(String val, String[] array, int beginIndex, int endIndex, boolean ignoreCase, boolean mustEqual, boolean afterTrim, int pozType) {
        block20: {
            if (array == null) break block20;
            int n = array.length;
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            if (endIndex < 0) {
                endIndex = n;
            }
            if (endIndex > n) {
                endIndex = n;
            }
            if (val == null) {
                int i = beginIndex;
                while (i < endIndex) {
                    if (array[i] == null) {
                        return i;
                    }
                    ++i;
                }
            } else {
                if (afterTrim) {
                    val = val.trim();
                }
                if (ignoreCase && !mustEqual) {
                    val = val.toUpperCase();
                }
                int i = beginIndex;
                while (i < endIndex) {
                    boolean match = false;
                    String s = array[i];
                    if (s != null) {
                        if (afterTrim) {
                            s = s.trim();
                        }
                        if (ignoreCase && !mustEqual) {
                            s = s.toUpperCase();
                        }
                        if (mustEqual) {
                            match = ignoreCase ? s.equalsIgnoreCase(val) : s.equals(val);
                        } else {
                            switch (pozType) {
                                case 1: {
                                    match = s.startsWith(val);
                                    break;
                                }
                                case 2: {
                                    match = s.endsWith(val);
                                    break;
                                }
                                default: {
                                    boolean bl = match = s.indexOf(val) >= 0;
                                }
                            }
                        }
                        if (match) {
                            return i;
                        }
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int locateString(String val, String[] array) {
        return ICAStringUtils.locateString(val, array, 0, -1, false, true, false, 0);
    }

    public static String getLocalizedFileName(String fileName, Locale locale, String fileSuffix) {
        String ext;
        String fileNameLessExt;
        int pos;
        String[] searchDir;
        int nrSearchDir = 0;
        if (searchDirectories == null || searchDirectories.length == 0 || new File(fileName).isAbsolute()) {
            searchDir = new String[]{""};
            nrSearchDir = 1;
        } else {
            searchDir = new String[searchDirectories.length];
            int i = 0;
            while (i < searchDirectories.length) {
                String dir = searchDirectories[i];
                if (dir != null) {
                    if ((dir = dir.trim()).length() != 0 && !dir.endsWith("/") && !dir.endsWith("\\")) {
                        dir = String.valueOf(dir) + ICAStringUtils.goodSlashes("/");
                    }
                    searchDir[nrSearchDir++] = dir;
                }
                ++i;
            }
            if (nrSearchDir == 0) {
                searchDir = new String[]{""};
                nrSearchDir = 1;
            }
        }
        if (fileSuffix == null) {
            fileSuffix = "";
        }
        if (fileName.indexOf("/", (pos = fileName.lastIndexOf(46)) + 1) >= 0 || fileName.indexOf("\\", pos + 1) >= 0) {
            pos = -1;
        }
        if (pos >= 0) {
            fileNameLessExt = fileName.substring(0, pos);
            ext = fileName.substring(pos);
        } else {
            fileNameLessExt = fileName;
            ext = "";
        }
        fileNameLessExt = String.valueOf(fileNameLessExt) + fileSuffix;
        Locale[] loc = null;
        loc = locale != null && !locale.toString().equals(Locale.getDefault().toString()) ? new Locale[]{locale, Locale.getDefault()} : new Locale[]{Locale.getDefault()};
        String[] locFil = new String[7];
        int nr = 0;
        int i = 0;
        while (i < loc.length) {
            String l = loc[i].getLanguage();
            String c = loc[i].getCountry();
            String v = loc[i].getVariant();
            String[] locFil1 = new String[3];
            int k = 0;
            if (l != null && l.length() > 0 && c != null && c.length() > 0 && v != null && v.length() > 0) {
                locFil1[k++] = "_" + l + "_" + c + "_" + v;
            }
            if (l != null && l.length() > 0 && c != null && c.length() > 0) {
                locFil1[k++] = "_" + l + "_" + c;
            }
            if (l != null && l.length() > 0) {
                locFil1[k++] = "_" + l;
            }
            int j = 0;
            while (j < k) {
                int jj = 0;
                jj = 0;
                while (jj < nr) {
                    if (locFil1[j].equals(locFil[jj])) break;
                    ++jj;
                }
                if (jj >= nr) {
                    locFil[nr++] = locFil1[j];
                }
                ++j;
            }
            ++i;
        }
        locFil[nr++] = "";
        i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nrSearchDir) {
                String fileNameTest = String.valueOf(searchDir[j]) + fileNameLessExt + locFil[i] + ext;
                if (new File(fileNameTest).exists()) {
                    return fileNameTest;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static String getLocalizedFileName(String fileName, Locale locale) {
        String[] suffixes = new String[8];
        int n = 0;
        String[] fileSuffixes = null;
        String fileSuffix = null;
        try {
            fileSuffixes = BldUtil.getSearchPrefixes();
        }
        catch (Exception e) {
            fileSuffixes = new String[]{BldUtil.getPrefix()};
        }
        int i = 0;
        while (i < fileSuffixes.length) {
            fileSuffix = fileSuffixes[i];
            n = ICAStringUtils.insertSuffix(fileSuffix, suffixes, n);
            if (fileSuffix.equals("W32")) {
                n = ICAStringUtils.insertSuffix("WIN", suffixes, n);
            }
            ++i;
        }
        n = ICAStringUtils.insertSuffix("", suffixes, n);
        i = 0;
        while (i < n) {
            String rez = ICAStringUtils.getLocalizedFileName(fileName, locale, suffixes[i]);
            if (rez != null && rez.length() > 0) {
                return rez;
            }
            ++i;
        }
        return null;
    }

    private static int insertSuffix(String suffix, String[] suffixes, int length) {
        int i = 0;
        while (i < length) {
            if (suffix.equals(suffixes[i])) {
                return length;
            }
            ++i;
        }
        suffixes[length] = suffix;
        return length + 1;
    }

    public static String getSearchedFilePath(String fileName, String[] searchDirs) {
        if (searchDirs == null) {
            searchDirs = searchDirectories;
        }
        if (new File(fileName).isAbsolute()) {
            return fileName;
        }
        String rez = null;
        if (searchDirs != null) {
            int i = 0;
            while (i < searchDirs.length) {
                String dir = searchDirs[i];
                if (dir != null) {
                    if ((dir = dir.trim()).length() != 0 && !dir.endsWith("/") && !dir.endsWith("\\")) {
                        dir = String.valueOf(dir) + ICAStringUtils.goodSlashes("/");
                    }
                    if (new File(rez = String.valueOf(dir) + fileName).exists()) break;
                }
                ++i;
            }
        }
        return rez;
    }

    public static String getSearchedFilePath(String fileName) {
        return ICAStringUtils.getSearchedFilePath(fileName, null);
    }

    public static String[] changeStringArrayLength(String[] source, int newLength, String addedItemValue) {
        if (source == null) {
            return null;
        }
        int oldLength = source.length;
        if (newLength < 0 || newLength == oldLength) {
            return source;
        }
        String[] rez = new String[newLength];
        if (newLength < oldLength) {
            System.arraycopy(source, 0, rez, 0, newLength);
        } else {
            System.arraycopy(source, 0, rez, 0, oldLength);
            int i = oldLength;
            while (i < newLength) {
                rez[i] = addedItemValue;
                ++i;
            }
        }
        return rez;
    }

    public static String[] changeStringArrayLength(String[] source, int newLength) {
        return ICAStringUtils.changeStringArrayLength(source, newLength, "");
    }

    public static String[] truncateStringArray(String[] source, int newLength) {
        if (source == null) {
            return null;
        }
        int oldLength = source.length;
        if (newLength < 0 || newLength >= oldLength) {
            return source;
        }
        String[] rez = new String[newLength];
        System.arraycopy(source, 0, rez, 0, newLength);
        return rez;
    }

    public static Object[] changeObjectArrayLength(Object[] source, int newLength, Object addedItemValue) {
        if (source == null) {
            return null;
        }
        int oldLength = source.length;
        if (newLength < 0 || newLength == oldLength) {
            return source;
        }
        Object[] rez = new Object[newLength];
        if (newLength < oldLength) {
            System.arraycopy(source, 0, rez, 0, newLength);
        } else {
            System.arraycopy(source, 0, rez, 0, oldLength);
            int i = oldLength;
            while (i < newLength) {
                rez[i] = addedItemValue;
                ++i;
            }
        }
        return rez;
    }

    public static Object[] changeObjectArrayLength(Object[] source, int newLength) {
        return ICAStringUtils.changeObjectArrayLength(source, newLength, null);
    }

    public static Object[] truncateObjectArray(Object[] source, int newLength) {
        if (source == null) {
            return null;
        }
        int oldLength = source.length;
        if (newLength < 0 || newLength >= oldLength) {
            return source;
        }
        Object[] rez = new Object[newLength];
        System.arraycopy(source, 0, rez, 0, newLength);
        return rez;
    }

    public static Vector stringArrayToVector(String[] src, Vector dest) {
        if (src == null || src.length == 0) {
            return new Vector();
        }
        if (dest == null) {
            dest = new Vector<String>();
        }
        int i = 0;
        while (i < src.length) {
            if (src[i] != null) {
                dest.add(src[i]);
            }
            ++i;
        }
        return dest;
    }

    public static Vector stringArrayToVector(String[] src) {
        return ICAStringUtils.stringArrayToVector(src, null);
    }

    public static String[] vectorToStringArray(Vector vector) {
        String[] resp = new String[vector.size()];
        Iterator it = vector.iterator();
        int i = 0;
        while (it.hasNext()) {
            String obj = (String)it.next();
            if (obj == null) {
                obj = "";
            }
            resp[i++] = obj;
        }
        return resp;
    }

    public static String vectorToString(Vector src, String separator) {
        if (separator == null) {
            separator = " ";
        }
        String[] list = ICAStringUtils.vectorToStringArray(src);
        String resp = "";
        if (list != null && list.length > 0) {
            int i = 0;
            while (i < list.length) {
                resp = String.valueOf(resp) + list[i] + separator;
                ++i;
            }
        }
        return resp;
    }

    public static String[] concatStringArrays(String[] src1, String[] src2) {
        int j = src1.length;
        int jj = src2.length;
        if (src1 == null || j == 0) {
            if (src2 == null || jj == 0) {
                return new String[0];
            }
            return src2;
        }
        if (src2 == null || jj == 0) {
            if (src1 == null || j == 0) {
                return new String[0];
            }
            return src1;
        }
        String[] resp = new String[j + jj];
        int k = 0;
        while (k < j + jj) {
            resp[k] = k < j ? src1[k] : src2[k - j];
            ++k;
        }
        return resp;
    }

    public static String[] removeNullsFromArray(String[] array) {
        if (array == null) {
            return null;
        }
        int nr = array.length;
        String[] rez = new String[nr];
        int nrFinal = 0;
        int i = 0;
        while (i < nr) {
            if (array[i] != null) {
                rez[nrFinal++] = array[i];
            }
            ++i;
        }
        if (nrFinal == nr) {
            return rez;
        }
        String[] rezFinal = new String[nrFinal];
        System.arraycopy(rez, 0, rezFinal, 0, nrFinal);
        return rezFinal;
    }

    public static void setToNull(String[] target, String[] listToNull) {
        if (target == null || listToNull == null) {
            return;
        }
        int i = 0;
        while (i < listToNull.length) {
            int j = ICAStringUtils.locateString(listToNull[i], target);
            if (j >= 0) {
                target[j] = null;
            }
            ++i;
        }
    }

    public static void sortStringArray(String[] array) {
        if (array == null) {
            return;
        }
        int nr = array.length;
        if (nr <= 1) {
            return;
        }
        int i = 0;
        while (i < nr - 1) {
            String crtVal = array[i];
            int crtPoz = i;
            int j = i + 1;
            while (j < nr) {
                if (crtVal != null && (array[j] == null || crtVal.compareTo(array[j]) > 0)) {
                    crtVal = array[j];
                    crtPoz = j;
                }
                ++j;
            }
            if (crtPoz != i) {
                array[crtPoz] = array[i];
                array[i] = crtVal;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String removeBeginSlash(String source) {
        if (source != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            source = source.substring(1, source.length());
lbl4:
            // 2 sources

            ** while (source.startsWith((String)"\\") || source.startsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return source;
    }
}

