/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.itcins.ica2;

import com.ibm.itcins.ica2.ICAInstGlobals;
import com.ibm.itcins.ica2.ICASoftwareObjectUtils;
import com.ibm.itcins.ica2.ICAStringUtils;
import com.ibm.itcins.ica2.ProcUtl;
import com.ibm.itcins.ica2.ShowMessage;
import com.ibm.itcins.ica2.WizardActionTimeBasedPercentEstimator;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.NTServiceStatus;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ISMPProductUtils {
    public static int uninstallISMPProduct(String productKey, String uninstallLauncherName, String[] arguments, WizardActionTimeBasedPercentEstimator estimator, String[] info) throws ServiceException, IOException {
        if (productKey == null || productKey.length() == 0) {
            return 0;
        }
        if (estimator != null) {
            estimator.updateOperationState();
        }
        if (info == null || info.length == 0) {
            String msg = ShowMessage.gi("Ins").resolve("Install.UninstallISMPProduct", new String[]{productKey, FileUtils.createFileName(ICAInstGlobals.getServices().resolveString("$D(os_main)"), "vpd.properties")}, null);
            ShowMessage.writeLogOutput(msg);
            return 0;
        }
        if (arguments == null) {
            arguments = new String[]{};
        }
        Object[] uninstallCmd = null;
        int i = 0;
        if (uninstallLauncherName != null && uninstallLauncherName.trim().length() > 0) {
            uninstallCmd = new String[2 + arguments.length];
            uninstallCmd[i++] = ICAStringUtils.quoteOrUnquote(info[0]);
            uninstallCmd[i++] = "-silent";
            int j = 0;
            while (j < arguments.length) {
                uninstallCmd[i + j] = arguments[j];
                ++j;
            }
        } else {
            uninstallCmd = new String[5 + arguments.length];
            String javaPath = FileUtils.createFileName(System.getProperty("java.home"), "bin");
            uninstallCmd[i++] = FileUtils.createFileName(javaPath, "java");
            uninstallCmd[i++] = "-cp";
            uninstallCmd[i++] = ICAStringUtils.quote(FileUtils.createFileName(info[0], info[1]));
            uninstallCmd[i++] = "run";
            uninstallCmd[i++] = "-silent";
            int j = 0;
            while (j < arguments.length) {
                uninstallCmd[i + j] = arguments[j];
                ++j;
            }
        }
        ProcUtl proc = new ProcUtl();
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        String cmdExec = ShowMessage.gi("Ins").resolve("Install.CmdToBeExecuted", new String[]{ICAStringUtils.arrayToString(uninstallCmd, " ")}, null);
        ShowMessage.writeLogOutput(cmdExec);
        int rc = proc.execcmd((String[])uninstallCmd, false, null, (Object)stdout, (Object)stderr);
        if (estimator != null) {
            while (proc.isProcessRunning()) {
                estimator.updateOperationState();
                estimator.sleep();
            }
            estimator.updateOperationState();
        }
        proc.waitForProcess();
        String retCode = ShowMessage.gi("Ins").resolve("Install.CmdReturnCode", new String[]{new Integer(rc).toString()}, null);
        ShowMessage.writeLogOutput(retCode);
        String err = stderr.toString().trim();
        if (err.length() > 0) {
            err = ShowMessage.gi("Ins").resolve("Install.CmdReturnErrMsg", new String[]{err}, null);
            ShowMessage.writeLogOutput(err);
        }
        return rc;
    }

    public static int cleanISMPProduct(String productKey, WizardActionTimeBasedPercentEstimator estimator) {
        return 0;
    }

    public static String[] getProductUninstallerInfo(String productKey, String uninstallerLauncherName) throws ServiceException {
        if (productKey == null || productKey.length() == 0) {
            return null;
        }
        String[] uninstallerInfo = null;
        RegistryService registryService = (RegistryService)ICAInstGlobals.getService("registryService");
        SoftwareObject so = registryService.getNewestSoftwareObject(productKey);
        if (so != null) {
            uninstallerInfo = new String[4];
            so.setActiveForUninstall(false);
            String dates = so.getUninstaller();
            StringTokenizer tok = null;
            if (dates != null && dates.length() > 0) {
                tok = new StringTokenizer(dates);
                uninstallerInfo[0] = FileUtils.createFileName(so.getInstallLocation(), ICAStringUtils.unquote((String)tok.nextElement()));
                if (uninstallerLauncherName != null && uninstallerLauncherName.length() > 0) {
                    uninstallerInfo[0] = FileUtils.createFileName(uninstallerInfo[0], uninstallerLauncherName);
                }
            } else {
                uninstallerInfo[0] = "";
            }
            uninstallerInfo[1] = tok != null && tok.hasMoreElements() ? ICAStringUtils.unquote((String)tok.nextElement()) : "";
            uninstallerInfo[2] = tok != null && tok.hasMoreElements() ? ICAStringUtils.unquote((String)tok.nextElement()) : "";
            uninstallerInfo[3] = so.getDisplayName();
        }
        return uninstallerInfo;
    }

    public static String getProductUninstaller(String productKey, String uninstallerLauncherName) throws ServiceException {
        String[] info = ISMPProductUtils.getProductUninstallerInfo(productKey, uninstallerLauncherName);
        String uninstaller = null;
        if (info != null && info.length > 0) {
            uninstaller = info[0];
        }
        return uninstaller;
    }

    public static String getProductDisplayName(String productKey) throws ServiceException {
        String[] info = ISMPProductUtils.getProductUninstallerInfo(productKey, null);
        String dispName = "";
        if (info != null && info.length > 0) {
            dispName = info[3];
        }
        return dispName;
    }

    public static boolean removeSoftwareObjectKeysWithParent(String parentKey) throws ServiceException {
        Vector keys = ISMPProductUtils.getSoftwareObjectKeysWithParent(parentKey, null);
        boolean cleaned = false;
        boolean debug = false;
        if (keys != null) {
            SoftwareObjectKey[] soks = new SoftwareObjectKey[keys.size()];
            soks = keys.toArray(soks);
            RegistryService registryService = (RegistryService)ICAInstGlobals.getService("registryService");
            if (soks != null && soks.length > 0) {
                int i = 0;
                while (i < soks.length) {
                    if (debug) {
                        System.out.println("removing - > " + soks[i].getUID() + " sok from vpd");
                    }
                    registryService.removeSoftwareObject(soks[i]);
                    ++i;
                }
            }
            registryService.initializeRegistry();
            Vector tmpkeys = ISMPProductUtils.getSoftwareObjectKeysWithParent(parentKey, null);
            if (tmpkeys == null || tmpkeys.size() == 0) {
                cleaned = true;
            }
        } else {
            cleaned = true;
        }
        return cleaned;
    }

    public static Vector getSoftwareObjectKeysWithParent(String parentKey) throws ServiceException {
        return ISMPProductUtils.getSoftwareObjectKeysWithParent(parentKey, null);
    }

    private static Vector getSoftwareObjectKeysWithParent(String parentKey, Vector children) throws ServiceException {
        RegistryService registryService;
        SoftwareObject[] parentSOKs;
        boolean prodExists;
        if (parentKey == null || parentKey.length() == 0) {
            return null;
        }
        if (children == null) {
            children = new Vector();
        }
        if ((prodExists = ICASoftwareObjectUtils.isProductInstalled(parentKey)) && (parentSOKs = (registryService = (RegistryService)ICAInstGlobals.getService("registryService")).getSoftwareObjects(parentKey)) != null && parentSOKs.length > 0) {
            int i = 0;
            while (i < parentSOKs.length) {
                SoftwareObjectKey[] childrenSoks = registryService.getSoftwareObjectKeysWithParent(parentSOKs[i].getKey());
                if (childrenSoks != null && childrenSoks.length > 0) {
                    int j = 0;
                    while (j < childrenSoks.length) {
                        if (childrenSoks[j] != null && !childrenSoks[j].equalsWithInstance(parentSOKs[i]) && !children.contains(childrenSoks[j])) {
                            children.add(childrenSoks[j]);
                            children = ISMPProductUtils.getSoftwareObjectKeysWithParent(childrenSoks[j].getUID(), children);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return children;
    }

    public static boolean removeVPDComponents(String productKey) throws ServiceException {
        RegistryService registryService;
        SoftwareObject[] sos;
        boolean cleaned = true;
        if (productKey == null || productKey.length() == 0) {
            return false;
        }
        boolean prodExists = ICASoftwareObjectUtils.isProductInstalled(productKey);
        if (prodExists && (sos = (registryService = (RegistryService)ICAInstGlobals.getService("registryService")).getSoftwareObjects(productKey)) != null && sos.length > 0) {
            int k = 0;
            while (k < sos.length) {
                SoftwareObjectKey[] soks = registryService.getSoftwareObjectKeysWithParent(sos[k].getKey());
                if (soks != null && soks.length > 0) {
                    int j = 0;
                    while (j < soks.length) {
                        registryService.removeSoftwareObject(soks[j]);
                        ++j;
                    }
                }
                ++k;
            }
            registryService.initializeRegistry();
            String[] uidsAfter = registryService.getAllSoftwareObjectUIDs();
            if (uidsAfter != null && uidsAfter.length > 0) {
                int k2 = 0;
                while (k2 < uidsAfter.length) {
                    if (uidsAfter[k2].startsWith(productKey)) {
                        cleaned = false;
                        break;
                    }
                    ++k2;
                }
            }
        }
        return cleaned;
    }

    public static boolean removeSystemProductEntries(String productKey) {
        return false;
    }

    public static String[] getServicesInstalledByProduct(String productKey, boolean ifRunning) throws ServiceException {
        String[] qualifiedSrvs = null;
        if (productKey == null || productKey.length() == 0) {
            return null;
        }
        String[] prodInstLoc = ICASoftwareObjectUtils.getProductInstallLocations(productKey);
        if (prodInstLoc == null || prodInstLoc.length == 0) {
            return null;
        }
        int k = 0;
        while (k < prodInstLoc.length) {
            prodInstLoc[k] = ICAStringUtils.unquote(prodInstLoc[k]);
            ++k;
        }
        Win32Service win32Service = (Win32Service)ICAInstGlobals.getService("win32Service");
        String[] allServices = win32Service.enumNTServiceKeys(48, 3);
        if (allServices == null || allServices.length == 0) {
            return new String[0];
        }
        Vector<String> qualSrv = new Vector<String>();
        int i = 0;
        while (i < allServices.length) {
            int ii = 0;
            while (ii < prodInstLoc.length) {
                NTServiceConfig ntsrvcfg = win32Service.queryNTServiceConfig(allServices[i]);
                if (ntsrvcfg != null && ntsrvcfg.getCommand().startsWith(prodInstLoc[ii])) {
                    if (ifRunning) {
                        NTServiceStatus status = win32Service.queryNTServiceStatus(allServices[i]);
                        if (status.getCurrentState() != 1 && !qualSrv.contains(allServices[i])) {
                            qualSrv.add(allServices[i]);
                        }
                    } else if (!qualSrv.contains(allServices[i])) {
                        qualSrv.add(allServices[i]);
                    }
                }
                ++ii;
            }
            ++i;
        }
        if (!qualSrv.isEmpty()) {
            qualifiedSrvs = new String[qualSrv.size()];
            qualifiedSrvs = qualSrv.toArray(qualifiedSrvs);
        } else {
            qualifiedSrvs = new String[]{};
        }
        return qualifiedSrvs;
    }

    public static String[] getRunningServicesInstalledByProduct(String productKey, boolean ifRunning) throws ServiceException {
        return ISMPProductUtils.getServicesInstalledByProduct(productKey, true);
    }
}

